      SUBROUTINE MMRQMIN(VAR, NVAR, CHISQ, ALAMDA, FSLOT, NSLOTS, 
     &     PMASK, WMASK, VMASK, NPMASK, NWMASK, NVMASK, MXMASK, IFAIL)
C
C     Modified version of NM mrqmin specialised to molly data to allow many 
C     to be fitted simultaneously. Most arguments passed in molly.coms
C
      IMPLICIT NONE
      INCLUDE 'molly.coms'
      INCLUDE 'gsfit.inc'
C
C     Mask arrays
C
      INTEGER MXMASK
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
      INTEGER FSLOT, NSLOTS
C
      INTEGER NVAR,MXVAR, IFAIL
      DOUBLE PRECISION ALAMDA,CHISQ,VAR(NVAR)
      PARAMETER (MXVAR=100)
      INTEGER L,M,OFF
      DOUBLE PRECISION OCHISQ,ATRY(MXVAR),BETA(MXVAR),DA(MXVAR)
      SAVE OCHISQ,ATRY,BETA,DA
*
      IF(NVAR.GT.MXVAR) THEN
         WRITE(*,*) 'Sorry too many parameters compared to MXVAR'
         WRITE(*,*) 'buffer size in mmrqmin.'
         RETURN
      END IF
C
      IF(ALAMDA.LT.0.D0) THEN
C
C     Compute initial chi**2, the alpha matrix and beta vector.
C
         CALL MMRQCOF(VAR, NVAR, 1, BETA, CHISQ, FSLOT, NSLOTS,
     &        PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, IFAIL)
         IF(IFAIL.NE.0) RETURN
         OCHISQ = CHISQ
         ALAMDA = 0.001
      END IF
C
C     Compute modified matrix and set DA to the beta vector.
C
      DO L = 1, NVAR
         OFF = NVAR*(L-1)
         DO M=OFF+1,OFF+NVAR
            DWORK(M,2)  = DWORK(M,1)
         END DO
         DWORK(OFF+L,2) = (1.+ALAMDA)*DWORK(OFF+L,1)
         DA(L) = BETA(L)
      END DO
C
C     Solve matrix equation to determine change needed
C     to variable vector (stored in DA)
C
      CALL GAUSSJ(DWORK(1,2),NVAR,NVAR,DA,1,1,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(ALAMDA.EQ.0.D0) RETURN
C
C     Set next trial variable vector
C
      DO L = 1, NVAR
          ATRY(L) = VAR(L) + DA(L)
      END DO
C
C     Compute chi**2, matrix etc at this new point.
C
      CALL MMRQCOF(ATRY, NVAR, 2, DA, CHISQ, FSLOT, 
     &     NSLOTS, PMASK, WMASK, VMASK, NPMASK, NWMASK,
     &     NVMASK, MXMASK, IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(CHISQ.LT.OCHISQ)THEN
C
C     If chi**2 better than before, accept ATRY as the new variable vector,
C     and reduce ALAMDA.
C

         ALAMDA = 0.1*ALAMDA
         OCHISQ = CHISQ
         DO L = 1, NVAR
            OFF  = NVAR*(L-1)
            DO M = OFF+1, OFF+NVAR
               DWORK(M,1) = DWORK(M,2)
            END DO
            BETA(L) = DA(L)
            VAR(L)  = ATRY(L)
         END DO
      ELSE
C
C     No improvement in chi**2, VAR untouched, increase ALAMDA
C
         ALAMDA = 10.*ALAMDA
         CHISQ  = OCHISQ
      END IF
      IFAIL = 0
      RETURN
      END
      
      SUBROUTINE MMRQCOF( VAR, NVAR, IARR, BETA, CHISQ, FSLOT,
     &     NSLOTS, PMASK, WMASK, VMASK, NPMASK, NWMASK, NVMASK, 
     &     MXMASK, IFAIL)
C     
C     Modified for molly data from mrqcof. This routine computes
C     the alpha matrix and beta vector at position VAR(NVAR).
C     The alpha matrix is stored in DWORK(1,IARR)
C
      IMPLICIT NONE
      INCLUDE 'molly.coms'
C
C     Mask arrays
C
      INTEGER MXMASK, FSLOT, NSLOTS
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C
      INTEGER NVAR,KK,J,L,M,N,IFAIL,OFF,IARR,SLOT,I,K
      DOUBLE PRECISION CHISQ,VAR(NVAR),BETA(NVAR)
      DOUBLE PRECISION X, Y, SIG, VEARTH, ANGST, VFAC
      DOUBLE PRECISION VLIGHT
      REAL GET_FLX, GET_ERF, CGS
      DOUBLE PRECISION DY,SIG2I,WT
      INCLUDE 'gsfit.inc'
C     
C     Initialise
C
      DO J = 1, NVAR
         OFF  = NVAR*(J-1)
         DO K = OFF+1, OFF+J
            DWORK(K,IARR) = 0.D0
         END DO
         BETA(J) = 0.D0
      END DO
      CHISQ  = 0.D0
      VLIGHT = DBLE(CGS('C'))/1.D5
      DO KK = 1, NSLOTS
         SLOT = ISLOT(FSLOT-1+KK,2)
C
C     Setup parameter values and their derivatives with respect
C     to the variables using current variable values.
C
         CALL SETPARS(SLOT, VAR, NVAR, NVAR, IFAIL)
         IF(IFAIL.NE.0) RETURN
         CALL SETDPARS(SLOT, VAR, NVAR, NVAR, IFAIL)
         IF(IFAIL.NE.0) RETURN
C          
C     Search for double precision header item Vearth. If not
C     found, assume = 0
C     
         CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &        NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
         IFAIL = 0
         VFAC  = 1.D0 - VEARTH/VLIGHT
C     
C     Get mask
C     
         CALL APPMASK(LWORK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &        MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &        .FALSE.,VEARTH,IFAIL)
C
C     OK, now start going through pixels.
C
         I = MAXPX*(SLOT-1)
         DO N = 1, NPIX(SLOT) 
            I = I + 1
            IF(LWORK(N,1) .AND. ERRORS(I).GT.0.) THEN
               X   = VFAC*ANGST(REAL(N), NPIX(SLOT), 
     &              NARC(SLOT), ARC(1,SLOT), MXARC)
               Y   = GET_FLX(COUNTS(I), FLUX(I))
               SIG = GET_ERF(COUNTS(I),ERRORS(I), FLUX(I))
C     
               CALL GSFIT(X,NVAR)
               SIG2I= 1.D0/(SIG*SIG)
               DY   = Y-YFIT
               DO L = 1, NVAR
                  WT  = DYDV(L)*SIG2I
                  OFF = NVAR*(L-1)
                  DO M = 1, L
                     OFF = OFF + 1
                     DWORK(OFF,IARR) = DWORK(OFF,IARR)+WT*DYDV(M)
                  END DO
                  BETA(L) = BETA(L) + DY*WT
               END DO
               CHISQ = CHISQ + DY*DY*SIG2I
            END IF
         END DO
      END DO
C     
C     Ensure matrix is symmetric
C
      DO J = 1, NVAR-1
         OFF = NVAR*(J-1)
         DO K = J+1, NVAR
            DWORK(OFF+K,IARR) = DWORK(NVAR*(K-1)+J,IARR)
         END DO
      END DO
      RETURN
      END

      SUBROUTINE GSFIT(X, NVAR)
C
C     Subroutine for Numerical Recipes Marquardt. 
C     non-linear least squares. Most parameters passed by common.
C     In order to run this routine an array of parameters and
C     their derivatives with respect to the NA variables
C     must have been set up beforehand as well as an array of
C     orbital phases for each of the NSBINT trapezoidal
C     integration steps. These come through the gsfit.inc 
C     common blocks. GSFIT computes the predicted y value YFIT and
C     its derivatives with respect to the variable parameters DYDV(NVAR).
C
C     It does this by first computing the derivatives with respect to the
C     parameters which define the model and then performing a matrix
C     multiplication using a matrix set up using EVALDPAR.
C     
      IMPLICIT NONE
      INCLUDE 'molly.coms'
      INCLUDE 'gsfit.inc'
      INTEGER I, J, OFF, N, K, M, NVAR, K0, K1, K2
      INTEGER K3, K4, K5, K6, K7, K8
      DOUBLE PRECISION X, VALUE, BETA, DEPH, C, WGT, EFAC
      DOUBLE PRECISION TWOPI, DIFF, DYDP(MAXPAR), RES, FDASH
      DOUBLE PRECISION SAVE1, SAVE2, SAVE3, SAVE4, SAVE5, SAVE6
      DOUBLE PRECISION SAVE7, TEMP, RSCAL, SMALL
      LOGICAL FIRST, VEPH
      REAL CGS
      SAVE FIRST, C, TWOPI, EFAC
      DATA FIRST/.TRUE./
C
      IF(FIRST) THEN
         FIRST  = .FALSE.
         C      = DBLE(CGS('C'))/1.D5
         TWOPI  = 8.D0*ATAN(1.D0)
         EFAC   = 4.D0*LOG(2.D0)
      END IF
C
C     Polynomial
C
      YFIT = 0.D0
      IF(NPOLY.GT.0) THEN
         DIFF  = X - PIVOT
         VALUE = 1.D0
         DO I = 1, NPOLY-1
            YFIT    = YFIT + PAR(I)*VALUE
            DYDP(I) = VALUE
            VALUE   = VALUE*DIFF
         END DO
         YFIT  = YFIT + PAR(NPOLY)*VALUE
         DYDP(NPOLY) = VALUE
      END IF
C
C     Gaussians
C
      IF(NGAUSS.GT.0) THEN
C     
C     Resolution
C
         K0 = MAXPOLY+1
         IF(RESSPEC) THEN
            RES = PAR(K0)
         ELSE
            RES = 0.
         END IF
         DO I = MAXPOLY+1, MAXPOLY+(8+MAXEPH)*NGAUSS+1
            DYDP(I) = 0.D0
         END DO
         DO J = 1, NSBINT
            IF(NSBINT.GT.1) THEN
               IF(J.EQ.1 .OR. J.EQ.NSBINT) THEN
                  WGT = 0.5/DBLE(NSBINT-1)
               ELSE
                  WGT = 1./DBLE(NSBINT-1)
               END IF
            ELSE
               WGT = 1.
            END IF
            DO I = 1, NGAUSS
               K1 = K0 + (8+MAXEPH)*(I-1) + 1
               K2 = K1 + 1
               K3 = K2 + 1
               K4 = K3 + 1
               K5 = K4 + 1
               K6 = K5 + 1
               K7 = K6 + 1
               K8 = K7 + 1
               IF(NEPH(I).GT.0) THEN
                  BETA  = 1.D0+(PAR(K2)
     &                 -PAR(K5)*COS1P(I,J)+PAR(K6)*SIN1P(I,J)
     &                 -PAR(K7)*COS2P(I,J)+PAR(K8)*SIN2P(I,J))/C
               ELSE
                  BETA  = 1.D0+PAR(K2)/C
               END IF
               FDASH = SQRT(PAR(K3)**2+RES**2)
               RSCAL = PAR(K3)/FDASH
               SMALL = RES/FDASH
               DIFF  = (X-PAR(K1)*BETA)/FDASH
               IF(ABS(DIFF).LT.3.D0) THEN
                  SAVE1 = WGT*RSCAL*EXP(-EFAC*DIFF**2)
                  TEMP  = PAR(K4)*SAVE1
                  YFIT  = YFIT + TEMP
                  SAVE2 = 2.*TEMP*EFAC*DIFF/FDASH
                  SAVE3 = SAVE2*PAR(K1)/C
C
C     Now for partial derivatives.
C
C
C     Resolution (same for all gaussians)
C
                  IF(VARPAR(K0))
     &                 DYDP(K0) = DYDP(K0) + SAVE2*SMALL*DIFF
     &                 - TEMP*SMALL/FDASH
C
C     Central wavelength
C
                  IF(VARPAR(K1))
     &                 DYDP(K1) = DYDP(K1) + SAVE2*BETA
C
C     velocity offset
C
                  IF(VARPAR(K2)) 
     &                 DYDP(K2) = DYDP(K2) + SAVE3
C
C     FWHM
C
                  IF(VARPAR(K3)) 
     &                 DYDP(K3) = DYDP(K3) + DIFF*RSCAL*SAVE2
     &                 + TEMP*SMALL**2/PAR(K3)
C
C     Peak height
C
                  IF(VARPAR(K4))
     &                 DYDP(K4) = DYDP(K4) + SAVE1
C
C     Orbital parameters
C
                  IF(NEPH(I).GT.0) THEN
C
C     Kx
C
                     SAVE4 = SAVE3*COS1P(I,J)
                     IF(VARPAR(K5))
     &                    DYDP(K5) = DYDP(K5) - SAVE4
C
C     Ky
C
                     SAVE5 = SAVE3*SIN1P(I,J)
                     IF(VARPAR(K6))
     &                    DYDP(K6) = DYDP(K6) + SAVE5
C
C     Kx2
C
                     SAVE6 = SAVE3*COS2P(I,J)
                     IF(VARPAR(K7))
     &                    DYDP(K7) = DYDP(K7) - SAVE6
C
C     Ky2
C
                     SAVE7 = SAVE3*SIN2P(I,J)
                     IF(VARPAR(K8))
     &                    DYDP(K8) = DYDP(K8) + SAVE7
C
C     Now for the ephemeris. Since fairly often one will use a fixed
C     ephemeris we make a check here to see if it is worth bothering
C     to compute the derivatives at all.
C     
                     M    = 1
                     VEPH = VARPAR(K8+M)
                     DO WHILE(.NOT.VEPH .AND. M.LT.NEPH(I))
                        M    = M + 1
                        VEPH = VARPAR(K8+M)
                     END DO
                     IF(VEPH) THEN
                        IF(NEPH(I).EQ.2) THEN
C
C     Try to save a bit of time in the common two parameter
C     ephemeris case.
C
                           DEPH = PAR(K8+2)
                        ELSE
                           DEPH  = 0.D0
                           VALUE = 1.D0
                           DO M = 2, NEPH(I)-1
                              DEPH  = DEPH + DBLE(M-1)*PAR(K8+M)*VALUE
                              VALUE = VALUE*PHASE(I,J)
                           END DO
                           DEPH = DEPH + DBLE(NEPH(I)-1)*
     &                          PAR(K8+NEPH(I))*VALUE
                        END IF
                        TEMP = TWOPI*(
     &                       PAR(K5)*SAVE5 + PAR(K6)*SAVE4 +
     &                       2.*(PAR(K7)*SAVE7 + PAR(K8)*SAVE6))/DEPH
                        DO M = 1, NEPH(I)-1
                           DYDP(K8+M) = DYDP(K8+M) - TEMP
                           TEMP = TEMP*PHASE(I,J)
                        END DO
                        DYDP(K8+NEPH(I)) = DYDP(K8+NEPH(I)) - TEMP
                     END IF
                  END IF
               END IF
            END DO
         END DO
      END IF
C
C     All derivatives of y with respect to the parameters have now
C     been computed.  Now multiply dy/dp vector by dp/dv matrix. Try
C     only to compute what is necessary as the matrix will be fairly
C     sparse more often than not.     
C   
      DO K = 1, NVAR
         DYDV(K) = 0.D0
      END DO
      DO J = 1, NPOLY
         IF(VARPAR(J)) THEN
            DO K = 1, NVAR
               IF(DEPAR(K,J)) DYDV(K) = DYDV(K) + DPDV(K,J)*DYDP(J)
            END DO
         END IF
      END DO
      IF(RESSPEC .AND. VARPAR(MAXPOLY+1)) THEN
         J = MAXPOLY + 1
         DO K = 1, NVAR
            IF(DEPAR(K,J)) DYDV(K) = DYDV(K) + DPDV(K,J)*DYDP(J)
         END DO
      END IF
      DO I = 1, NGAUSS
         OFF = MAXPOLY+(8+MAXEPH)*(I-1)+1
         IF(NEPH(I).GT.0) THEN
            N = 8 + NEPH(I)
         ELSE
            N = 4
         END IF
         DO J = OFF+1, OFF+N
            IF(VARPAR(J)) THEN
               DO K = 1, NVAR
                  IF(DEPAR(K,J)) DYDV(K) = DYDV(K) + 
     &                 DPDV(K,J)*DYDP(J)
               END DO
            END IF
         END DO
      END DO
      RETURN
      END

      DOUBLE PRECISION FUNCTION YONLY(X)
C
C     Function computes just the predicted Y and not the derivatives for
C     speed. Should always be kept in line with GSFIT.
C     
      IMPLICIT NONE
      INCLUDE 'molly.coms'
      INCLUDE 'gsfit.inc'
      INTEGER I, J, K
      DOUBLE PRECISION X, VALUE, V, WGT, EFAC, C, DIFF
      DOUBLE PRECISION RES, FDASH
      LOGICAL FIRST
      REAL CGS
      SAVE FIRST, C, EFAC
      DATA FIRST/.TRUE./
C
      IF(FIRST) THEN
         FIRST  = .FALSE.
         C      = DBLE(CGS('C'))/1.D5
         EFAC   = 4.D0*LOG(2.D0)
      END IF
C
C     Polynomial
C
      YONLY = 0.D0
      IF(NPOLY.GT.0) THEN
         DIFF  = X - PIVOT
         VALUE = 1.D0
         DO I  = 1, NPOLY-1
            YONLY = YONLY + PAR(I)*VALUE
            VALUE = VALUE*DIFF
         END DO
         YONLY  = YONLY + PAR(NPOLY)*VALUE
      END IF
C
C     Gaussians
C
      IF(NGAUSS.GT.0) THEN
C     
C     Resolution
C
         IF(RESSPEC) THEN
            RES = PAR(MAXPOLY+1)
         ELSE
            RES = 0.
         END IF
         DO J = 1, NSBINT
            IF(NSBINT.GT.1) THEN
               IF(J.EQ.1 .OR. J.EQ.NSBINT) THEN
                  WGT = 0.5/DBLE(NSBINT-1)
               ELSE
                  WGT = 1./DBLE(NSBINT-1)
               END IF
            ELSE
               WGT = 1.
            END IF
            DO I = 1, NGAUSS
               K     = MAXPOLY+(8+MAXEPH)*(I-1)+1
               IF(NEPH(I).GT.0) THEN
                  V  = PAR(K+2) 
     &                 - PAR(K+5)*COS1P(I,J) + PAR(K+6)*SIN1P(I,J)
     &                 - PAR(K+7)*COS2P(I,J) + PAR(K+8)*SIN2P(I,J)
               ELSE
                  V  = PAR(K+2)
               END IF
               FDASH = SQRT(RES**2+PAR(K+3)**2)
               DIFF   = (X-PAR(K+1)*(1.+V/C))/FDASH
               IF(ABS(DIFF).LT.3.D0) THEN
                  YONLY  = YONLY + WGT*PAR(K+4)*PAR(K+3)/FDASH*
     &                 EXP(-EFAC*DIFF**2)
               END IF
            END DO
         END DO
      END IF
      RETURN
      END
        
      SUBROUTINE SETPARS(SLOT, VAR, NVAR, MXVAR, IFAIL) 
C
C     Set the values of the parameters defining the current model.
C     This requires interpreting the parameter definitions and
C     setting their values using the current values of the variables
C     and header parameters if need be. This routine also computes
C     the phases for every trapezoidal integration step to avoid these
C     being recomputed for every pixel in a spectrum.
C
C     This routine should be run once for every spectrum.
C
      IMPLICIT NONE
      INCLUDE 'gsfit.inc'
      INCLUDE 'molly.coms'
      INTEGER I, J, N, OFF, SLOT, NVAR, MXVAR, IFAIL
      INTEGER NP
      DOUBLE PRECISION HJD, TWOPI, TIME, PRED, PNEW
      DOUBLE PRECISION DERV, POLD, VAR(MXVAR)
      REAL DWELL
      LOGICAL FIRST
      SAVE FIRST, TWOPI
      DATA FIRST/.TRUE./
C     
      IF(FIRST) THEN
         TWOPI = 8.D0*ATAN(1.D0)
         FIRST = .FALSE.
      END IF
      IF(NPOLY.GT.0) THEN
         DO I = 1, NPOLY
            CALL EVALPAR(ACTION(I), VAR, NMVAR, 
     &           NVAR, MXVAR, CON, NMCON, NCON, MAXCON,
     &           NMDOUB(1,SLOT), HDDOUB(1,SLOT), 
     &           NDOUB(SLOT), MXDOUB, PAR(I), IFAIL)
            IF(IFAIL.NE.0) RETURN
         END DO
      END IF           
      IF(RESSPEC) THEN
         CALL EVALPAR(ACTION(MAXPOLY+1), VAR, NMVAR, 
     &        NVAR, MXVAR, CON, NMCON, NCON, MAXCON,
     &        NMDOUB(1,SLOT), HDDOUB(1,SLOT), 
     &        NDOUB(SLOT), MXDOUB, PAR(MAXPOLY+1), IFAIL)
         IF(IFAIL.NE.0) RETURN
      END IF
      IF(NGAUSS.GT.0) THEN         
         IF(EPHEM) 
     &        CALL HGETD('HJD', HJD, SLOT, MXSPEC, 
     &        NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
         IF(NSBINT.GT.1) 
     &        CALL HGETR('DWELL', DWELL, SLOT, MXSPEC, 
     &        NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
         DO I = 1, NGAUSS
            OFF = MAXPOLY+(8+MAXEPH)*(I-1)+1
            IF(NEPH(I).EQ.0) THEN
               NP = 4
            ELSE
               NP = 8 + NEPH(I)
            END IF
            DO J = OFF+1, OFF+NP
               CALL EVALPAR(ACTION(J), VAR, NMVAR, 
     &              NVAR, MXVAR, CON, NMCON, NCON, MAXCON,
     &              NMDOUB(1,SLOT), HDDOUB(1,SLOT), 
     &              NDOUB(SLOT), MXDOUB, PAR(J), IFAIL)
               IF(IFAIL.NE.0) RETURN
            END DO
            IF(NEPH(I).GT.0) THEN
C     
C     If ephemeris being used then precompute phases and cosines and 
C     sines of phase for trapezoidal integration. This avoids doing it 
C     over and over again for every pixel of the spectrum.
C     
               OFF = OFF + 8
               DO N = 1, NSBINT
C     
C     Loop through trapezoidal integration, computing phase
C     
                  IF(NSBINT.EQ.1) THEN
                     TIME = HJD 
                  ELSE
                     TIME = HJD + DWELL/3600./24.*
     &                    (DBLE(N)-DBLE(NSBINT+1)/2.)/DBLE(NSBINT-1)
                  END IF
                  PNEW  = (TIME-PAR(OFF+1))/PAR(OFF+2)
                  IF(NEPH(I).GT.2) THEN
                     POLD  = PNEW + 0.1
                     DO WHILE(ABS(PNEW-POLD).GT.1.D-5)
                        POLD = PNEW
                        PRED = 0.D0
                        DO J = 1, NEPH(I)
                           PRED = PRED + PAR(OFF+J)*(PNEW**(J-1))
                        END DO
                        DERV = 0.D0
                        DO J = 2, NEPH(I)
                           DERV = DERV + DBLE(J-1)*PAR(OFF+J)*
     &                          (PNEW**(J-2))
                        END DO
                        PNEW = POLD + (TIME-PRED)/DERV
                     END DO
                  END IF
                  PHASE(I,N) = PNEW
                  PNEW       = TWOPI*(PNEW - DBLE(NINT(PNEW)))
                  COS1P(I,N) = COS(PNEW)
                  SIN1P(I,N) = SIN(PNEW)
                  COS2P(I,N) = COS(2.*PNEW)
                  SIN2P(I,N) = SIN(2.*PNEW)
               END DO
            END IF
         END DO
      END IF
      IFAIL = 0
      RETURN
      END

      SUBROUTINE SETDPARS(SLOT, VAR, NVAR, MXVAR, IFAIL) 
C
C     Set the derivatives of the parameters defining the current model
C     with respect to the variables. This requires interpreting the 
C     parameter definitions and using the current values of the variables
C     and header parameters if need be.
C
C     This routine should be run once for every spectrum.
C
      IMPLICIT NONE
      INCLUDE 'gsfit.inc'
      INCLUDE 'molly.coms'
      INTEGER I, J, OFF, SLOT, MXVAR, IFAIL, NVAR, NP
      DOUBLE PRECISION VAR(MXVAR)
C     
      IF(NPOLY.GT.0) THEN
         DO I = 1, NPOLY
            CALL EVALDPAR(ACTION(I), VAR, NMVAR, NVAR, 
     &           MXVAR, CON, NMCON, NCON, MAXCON, 
     &           NMDOUB(1,SLOT), HDDOUB(1,SLOT),
     &           NDOUB(SLOT), MXDOUB, DPDV(1,I), 
     &           DEPAR(1,I), IFAIL)
            IF(IFAIL.NE.0) RETURN
         END DO
      END IF        
      IF(RESSPEC) THEN
         CALL EVALDPAR(ACTION(MAXPOLY+1), VAR, NMVAR, 
     &        NVAR, MXVAR, CON, NMCON, NCON, MAXCON,
     &        NMDOUB(1,SLOT), HDDOUB(1,SLOT), 
     &        NDOUB(SLOT), MXDOUB, DPDV(1,MAXPOLY+1), 
     &        DEPAR(1,MAXPOLY+1), IFAIL)
         IF(IFAIL.NE.0) RETURN
      END IF
      IF(NGAUSS.GT.0) THEN         
         DO I = 1, NGAUSS
            OFF = MAXPOLY+(8+MAXEPH)*(I-1)+1
            IF(NEPH(I).EQ.0) THEN
               NP = 4
            ELSE
               NP = 8+NEPH(I)
            END IF
            DO J = OFF+1, OFF+NP
               CALL EVALDPAR(ACTION(J), VAR, NMVAR, NVAR, 
     &              MXVAR, CON, NMCON, NCON, MAXCON, 
     &              NMDOUB(1,SLOT), HDDOUB(1,SLOT),
     &              NDOUB(SLOT), MXDOUB, DPDV(1,J), 
     &              DEPAR(1,J), IFAIL)
               IF(IFAIL.NE.0) RETURN
            END DO
         END DO
      END IF
      IFAIL = 0
      RETURN
      END

      SUBROUTINE EVALUNIT(UNIT, VAR, NMVAR, NVAR, MAXVAR, CON,
     &     NMCON, NCON, MAXCON, NMHEAD, HEAD, NHEAD, MXHEAD, 
     &     VALUE, IFAIL)
C
C     Evaluates the value of a subunit expression such as
C     "4.2e-3*$fwhm/4.6e2*$height/hmult" by substituting the
C     current values of any variables and header items encountered.
C     
      IMPLICIT NONE
      INTEGER NVAR, IFAIL, LENGTH, LENSTR, M, D, I, END
      INTEGER OFF, MAXVAR, NHEAD, MXHEAD, MAXCON, NCON
      DOUBLE PRECISION VAR(MAXVAR), VALUE, CONST
      DOUBLE PRECISION HEAD(MXHEAD), CON(MAXCON)
      CHARACTER*(*) NMVAR(MAXVAR), NMCON(MAXCON)
      CHARACTER*(*) UNIT, NMHEAD(MXHEAD)
      LOGICAL MULT, NOMATCH
C
C     Inside subunits delimiters are * or /
C
      LENGTH = LENSTR(UNIT)
      OFF    = 1
      VALUE  = 1.D0
      MULT   = .TRUE.
      DO WHILE(OFF.LT.LENGTH)
C
C     Identify end of variable or constant
C
         M   = INDEX(UNIT(OFF:),'*')
         D   = INDEX(UNIT(OFF:),'/')
         IF(M.EQ.0 .AND. D.EQ.0) THEN
            END = LENGTH
         ELSE IF(M.EQ.0) THEN
            END = OFF+D-2
         ELSE IF(D.EQ.0) THEN
            END = OFF+M-2
         ELSE 
            END = OFF + MIN(M,D) - 2
         END IF
C
C     Now translate it. If it does not start with a $ it
C     is not a variable. It is then either a number such as
C     2.e-2 or a header parameter such as 'offset'. First
C     we try translating as a number and if this fails we
C     try looking for a header parameter.
C
         IF(UNIT(OFF:OFF).NE.'$') THEN
            READ(UNIT(OFF:END),*,IOSTAT=IFAIL) CONST
            IF(IFAIL.NE.0) THEN
               NOMATCH = .TRUE.
               I = 0
               DO WHILE(NOMATCH .AND. I.LT.NHEAD)
                  I = I + 1
                  NOMATCH = UNIT(OFF:END).NE.
     &                 NMHEAD(I)(:LENSTR(NMHEAD(I)))
               END DO
               IF(NOMATCH) THEN
                  WRITE(*,*) 'Failed to translate [',UNIT(OFF:END),']'
                  IFAIL = 1
                  RETURN
               END IF
               CONST = HEAD(I)
            END IF
         ELSE
C
C     If it starts with a $ it is either a variable or 
C     a constant defined in the same way as a variable.
C     
            NOMATCH = .TRUE.
            I = 0
            DO WHILE(NOMATCH .AND. I.LT.NVAR)
               I = I + 1
               NOMATCH = UNIT(OFF+1:END).NE.
     &              NMVAR(I)(:LENSTR(NMVAR(I)))
            END DO
            IF(NOMATCH) THEN
               I = 0
               DO WHILE(NOMATCH .AND. I.LT.NCON)
                  I = I + 1
                  NOMATCH = UNIT(OFF+1:END).NE.
     &                 NMCON(I)(:LENSTR(NMCON(I)))
               END DO
               IF(NOMATCH) THEN
                  WRITE(*,*) 'Failed to locate variable [',
     &                 UNIT(OFF+1:END),']'
                  IFAIL = 1
                  RETURN
               END IF
               CONST = CON(I)
            ELSE
               CONST = VAR(I)
            END IF
         END IF
C
C     Now multiply or divide in its value
C
         IF(MULT) THEN
            VALUE = VALUE*CONST
         ELSE
            VALUE = VALUE/CONST
         END IF
C
C     Set up for next one
C
         OFF = END + 2
         IF((M.EQ.0 .AND. D.GT.0) .OR. 
     &        (D.GT.0 .AND. D.LT.M)) THEN
            MULT = .FALSE.
         ELSE
            MULT = .TRUE.
         END IF
      END DO
      IFAIL = 0
      RETURN
      END

      SUBROUTINE EVALPAR(STRING, VAR, NMVAR, NVAR, MAXVAR, CON,
     &     NMCON, NCON, MAXCON, NMHEAD, HEAD, NHEAD, MXHEAD, VALUE, 
     &     IFAIL)
C
C     Evaluates the value of a parameter definition. Splits
C     into sub-units and adds up results. Most of work done
C     in EVALUNIT
C
      IMPLICIT NONE
      INTEGER LENSTR, NVAR, IFAIL, LENGTH, OFF, NCON
      INTEGER START, END, MAXVAR, MXHEAD, NHEAD, MAXCON
      DOUBLE PRECISION VAR(MAXVAR), VALUE, TOTAL
      DOUBLE PRECISION HEAD(MXHEAD), CON(MAXCON)
      LOGICAL PLUS
      CHARACTER*(*) STRING, NMVAR(MAXVAR), NMCON(MAXCON)
      CHARACTER*(*) NMHEAD(MXHEAD)
C
      LENGTH = LENSTR(STRING)
      OFF    = 1
      TOTAL  = 0.D0
      DO WHILE(OFF.LT.LENGTH)
         CALL SUBUNIT(STRING(OFF:), START, END, PLUS, IFAIL)
         CALL EVALUNIT(STRING(START+OFF-1:END+OFF-1), 
     &        VAR, NMVAR, NVAR, MAXVAR, CON, NMCON, NCON,
     &        MAXCON, NMHEAD, HEAD, NHEAD, MXHEAD, VALUE, IFAIL)
         IF(PLUS) THEN
            TOTAL = TOTAL + VALUE
         ELSE
            TOTAL = TOTAL - VALUE
         END IF
         OFF   = OFF + END
      END DO
      VALUE = TOTAL
      RETURN
      END

      SUBROUTINE EVALDPAR(STRING, VAR, NMVAR, NVAR, MAXVAR, CON,
     &     NMCON, NCON, MAXCON, NMHEAD, HEAD, NHEAD, MXHEAD, DP, 
     &     LP, IFAIL)
C
C     Evaluates the derivatives of a parameter definition with
C     respect to the variables. It does this by searching for
C     each variable in the string and then substituting it for
C     1 or /V/V depending upon whether it is multiplied or
C     divided into the expression. In the latter case a sign change
C     is also made.
C
C     This routine also returns a logical array to show which variables
C     STRING actually depends on. As often it will only be one or two,
C     this is useful for speed purposes later.
C     
      IMPLICIT NONE
      INTEGER LENSTR, NVAR, IFAIL, LENGTH, OFF, L, FIRST
      INTEGER START, END, LAST, TEMP, N, I, LGT, MAXVAR
      INTEGER NHEAD, MXHEAD, NCON, MAXCON
      DOUBLE PRECISION VAR(MAXVAR), DP(MAXVAR), VALUE
      DOUBLE PRECISION HEAD(MXHEAD), CON(MAXCON)
      LOGICAL LP(MAXVAR), POS, PLUS
      CHARACTER*(*) STRING, NMVAR(MAXVAR), NMHEAD(MXHEAD)
      CHARACTER*(*) NMCON(MAXCON)
      CHARACTER*128 BUFFER
      INTEGER LCTEMP
      PARAMETER (LCTEMP = 20)
      CHARACTER*(LCTEMP) CTEMP
C
      DO I = 1, NVAR
         LGT = LENSTR(NMVAR(I))
         IF (LGT.GE.LCTEMP) THEN
            WRITE (*,*) 'EVALDPAR: CTEMP TOO SHORT TO HOLD NMVAR'
            IFAIL = 1
            RETURN 
         END IF
         CTEMP = '$'//NMVAR(I)(:LGT)
         L   = INDEX(STRING,CTEMP(:LGT+1))
         IF(L.EQ.0) THEN
C
C     No occurrence of variable I in STRING
C
            LP(I) = .FALSE.
         ELSE
C
C     Variable found at least once. Split into sub-units adding
C     up derivatives of each.
C
            LP(I)  = .TRUE.
            DP(I)  = 0.D0
            LENGTH = LENSTR(STRING)
            OFF    = 1
            DO WHILE(OFF.LT.LENGTH)
               CALL SUBUNIT(STRING(OFF:), START, END, PLUS, IFAIL)
               FIRST = START+ OFF - 1
               LAST  = END  + OFF - 1 
               CTEMP = '$'//NMVAR(I)(:LGT)
               N = INDEX(STRING(FIRST:LAST),CTEMP(:1+LGT))
               L = 0
               DO WHILE(N.GT.0)
                  L = N + L
                  IF(L.EQ.1) THEN
                     BUFFER = '1'//STRING(FIRST+LGT+L:LAST)
                     POS = .TRUE.
                  ELSE 
                     TEMP = FIRST+L-2
                     IF(STRING(TEMP:TEMP).EQ.'*') THEN
C
C     If multiplying then just replace by 1
C
                        BUFFER = STRING(FIRST:TEMP)//'1'//
     &                       STRING(FIRST+LGT+L:LAST)
                        POS = .TRUE.
                     ELSE
C
C     If dividing then add another $NMVAR/ after the / sign so that
C     /$fwhm becomes /$fwhm/$fwhm. POS  is to get sign right.
C
                        BUFFER = 
     &                       STRING(FIRST:TEMP)//'$'//
     &                       NMVAR(I)(:LGT)//'/'//
     &                       STRING(TEMP+1:LAST)
                        POS = .FALSE.
                     END IF
                  END IF
C
C     Evaluate modified sub-unit
C
                  CALL EVALUNIT(BUFFER, VAR, NMVAR, NVAR, MAXVAR,
     &                 CON, NMCON, NCON, MAXCON, NMHEAD, HEAD,
     &                 NHEAD, MXHEAD, VALUE, IFAIL)
C     
                  IF(POS.EQV.PLUS) THEN
                     DP(I) = DP(I) + VALUE
                  ELSE
                     DP(I) = DP(I) - VALUE
                  END IF
C     
C     Search for another occurrence of variable in subunit
C     
                  CTEMP = '$'//NMVAR(I)(:LGT)
                  N = INDEX(STRING(FIRST+L:LAST),CTEMP(:1+LGT))
               END DO
               OFF   = OFF + END
            END DO
         END IF
      END DO
      RETURN
      END

      SUBROUTINE SUBUNIT(STRING, START, END, PLUS, IFAIL)
C
C     Returns start and end and sign of first sub-unit of
C     string encountered. Assumes no leading blanks. Sub-units
C     are delimited by +,- or the start and end of the string.
C
      IMPLICIT NONE
      CHARACTER*(*) STRING, C*1, D*1
      INTEGER LENSTR, LENGTH, A, IFAIL, LOC
      INTEGER START, END, OFF, ENDA, ENDS
      LOGICAL PLUS
C
C     String can start with a - or + in which case
C     sub-unit starts at next character. Anything else
C     is an implicit +.
C
      LENGTH = LENSTR(STRING)
      IF(STRING(1:1).EQ.'-') THEN
         PLUS  = .FALSE.
         START = 2
      ELSE IF(STRING(1:1).EQ.'+') THEN
         PLUS  = .TRUE.
         START = 2
      ELSE
         PLUS  = .TRUE.
         START = 1
      END IF
      IF(LENGTH.LT.START) THEN
         WRITE(*,*) 'Invalid subunit; too short.'
         IFAIL = 1
         RETURN
      END IF
C
C     Now to try to locate first valid + as terminator. If 
C     we find one and it has an e, E etc in front of it,
C     it is an exponent unless the character in front it
C     is not a number or a . This allows for expressions such
C     as "$e-2.e-2" to be understood correctly as = $e - 2.e-2 
C
      OFF = START
      A   = INDEX(STRING(OFF:),'+')
      IF(A.EQ.0) THEN
         ENDA = LENGTH
      ELSE
         LOC  = OFF+A-2
         C    = STRING(LOC:LOC)
         IF(LOC.GT.1) THEN
            D = STRING(LOC-1:LOC-1)
            IF(D.NE.'.' .AND. D.NE.'0' .AND. D.NE.'1' 
     &           .AND. D.NE.'2' .AND. D.NE.'3' 
     &           .AND. D.NE.'4' .AND. D.NE.'5'
     &           .AND. D.NE.'6' .AND. D.NE.'7'
     &           .AND. D.NE.'8' .AND. D.NE.'9') C = ' '
         END IF
         ENDA = LOC
         DO WHILE(C.EQ.'e' .OR. C.EQ.'E' .OR. 
     &        C.EQ.'d' .OR. C.EQ.'D')
            OFF = OFF + A
            A   = INDEX(STRING(OFF:),'+')
            IF(A.EQ.0) THEN
               ENDA = LENGTH
               C = ' '
            ELSE
               LOC  = OFF+A-2
               C    = STRING(LOC:LOC)
               D    = STRING(LOC-1:LOC-1)
               IF(D.NE.'.' .AND. D.NE.'0' .AND. D.NE.'1' 
     &              .AND. D.NE.'2' .AND. D.NE.'3' 
     &              .AND. D.NE.'4' .AND. D.NE.'5'
     &              .AND. D.NE.'6' .AND. D.NE.'7'
     &              .AND. D.NE.'8' .AND. D.NE.'9') C = ' '
               ENDA = LOC
            END IF
         END DO
      END IF
C
C     Similarly for -
C
      OFF = START
      A   = INDEX(STRING(OFF:),'-')
      IF(A.EQ.0) THEN
         ENDS = LENGTH
      ELSE
         LOC  = OFF+A-2
         C    = STRING(LOC:LOC)
         IF(LOC.GT.1) THEN
            D = STRING(LOC-1:LOC-1)
            IF(D.NE.'.' .AND. D.NE.'0' .AND. D.NE.'1' 
     &           .AND. D.NE.'2' .AND. D.NE.'3' 
     &           .AND. D.NE.'4' .AND. D.NE.'5'
     &           .AND. D.NE.'6' .AND. D.NE.'7'
     &           .AND. D.NE.'8' .AND. D.NE.'9') C = ' '
         END IF
         ENDS = LOC
         DO WHILE(C.EQ.'e' .OR. C.EQ.'E' .OR. 
     &        C.EQ.'d' .OR. C.EQ.'D')
            OFF = OFF + A
            A   = INDEX(STRING(OFF:),'-')
            IF(A.EQ.0) THEN
               ENDS = LENGTH
               C = ' '
            ELSE
               LOC  = OFF+A-2
               C    = STRING(LOC:LOC)
               D    = STRING(LOC-1:LOC-1)
               IF(D.NE.'.' .AND. D.NE.'0' .AND. D.NE.'1' 
     &              .AND. D.NE.'2' .AND. D.NE.'3' 
     &              .AND. D.NE.'4' .AND. D.NE.'5'
     &              .AND. D.NE.'6' .AND. D.NE.'7'
     &              .AND. D.NE.'8' .AND. D.NE.'9') C = ' '
               ENDS = LOC
            END IF
         END DO
      END IF
C
C     Return whichever is shortest.
C
      END = MIN(ENDA, ENDS)
      IFAIL = 0
      RETURN
      END












