*MLIMS 
* MLIMS -- Types out current MOLLY limits
*
* There are limits on the number of spectra, number of header items
* etc which MLIMS lets you know. Most of these can only be changed
* by changing parameter declarations inside MOLLY, recompiling and
* relinking. This is not difficult to do so see me if you want to
* do so; it depends on the capacity of the machine that you are running 
* on.
*
*MLIMS
      SUBROUTINE MLIMS(MXSPEC, MXARC, MXBUFF, MXWORK, MAXPX, 
     &MXWD, MXWI, MXWL, MXWR, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &MXSLOT, MXSI, MXSR, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
* 
      IMPLICIT NONE
      INTEGER MXSPEC, MXARC, MXBUFF, MXWORK, MAXPX, MXWD, MXWI
      INTEGER MXWL, MXWR, MXCHAR, MXDOUB, MXINTR, MXREAL, MXSLOT
      INTEGER MXSI, MXSR, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL
*
      WRITE(*,*) 'Current MOLLY limits are as follows:'
      WRITE(*,*) ' '
      WRITE(*,*) 'Data arrays:'
      WRITE(*,*) ' '
      WRITE(*,*) ' Absolute maximum number of spectra = ',MXSPEC
      WRITE(*,*) 'Max as fixed by max pixel parameter = ',
     &MIN(MXSPEC,MXBUFF/MAXPX)
      WRITE(*,*) '  Maximum number of pixels/spectrum = ',MAXPX
      WRITE(*,*) '    Available buffer space (pixels) = ',MXBUFF
      WRITE(*,*) ' '
      WRITE(*,*) 'Header arrays:'
      WRITE(*,*) ' '
      WRITE(*,*) '   Max number of char    items/spec = ',MXCHAR
      WRITE(*,*) '   Max number of double  items/spec = ',MXDOUB
      WRITE(*,*) '   Max number of integer items/spec = ',MXINTR
      WRITE(*,*) '   Max number of real    items/spec = ',MXREAL
      WRITE(*,*) ' '           
      WRITE(*,*) ' '
      WRITE(*,*) 'Header search arrays:'
      WRITE(*,*) ' '
      WRITE(*,*) ' Max number of char    search items = ',MXSCHAR
      WRITE(*,*) ' Max number of double  search items = ',MXSDOUB
      WRITE(*,*) ' Max number of integer search items = ',MXSINTR
      WRITE(*,*) ' Max number of real    search items = ',MXSREAL
      WRITE(*,*) ' '           
      WRITE(*,*) 'Work arrays:'
      WRITE(*,*) ' '
      WRITE(*,*) '       Maximum workspace/work array = ',MXWORK
      WRITE(*,*) '      Number of double  work arrays = ',MXWD
      WRITE(*,*) '      Number of integer work arrays = ',MXWI
      WRITE(*,*) '      Number of logical work arrays = ',MXWL
      WRITE(*,*) '      Number of real    work arrays = ',MXWR
      WRITE(*,*) '        Maximum size of slot arrays = ',MXSLOT
      WRITE(*,*) '      Number of integer slot arrays = ',MXSI
      WRITE(*,*) '      Number of real    slot arrays = ',MXSR
*
      RETURN
      END
