*LIGHT
* LIGHT N1 N2 XAXIS YAXIS OUT FOLD MASK -- Plots light curve
*
* Parameters
*
*  N1    -- First slot for light curve
*  N2    -- Last slot for light curve.
*           If N1 = N2 no plot is made but the value will be printed
*           to the terminal.
*  XAXIS -- Name of variable for X axis. Should be the name of a REAL, DOUBLE
*           or INTEGER header parameter, or 'NONE' to get plot versus spectrum
*           number.
*  YAXIS -- Y parameter, 'FLUX', 'EW' or 'MJY' for flux, equivalent width or
*           flux density in mJy.
*  OUT   -- Output. xxxx to a file, !xxxx to the headers where xxxx is a 
*           file name or a header parameter name. If a header parameter is 
*           selected then it will have type real and there will be one called 
*           xxxx_D for the data and another xxxx_E for the errors for each
*           spectrum.
*  FOLD  -- Y or N asccording to whether you want to phase fold light curve
*  MASK  -- Y or N according to whether you want to set the mask or not.
*
* Selection criteria apply.
*LIGHT
      SUBROUTINE LGCURV(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS,
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &     HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &     MXDOUB, MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, 
     &     VSDOUB, NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &     NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &     MXSREAL, X1, X2, Y1, Y2, LW, LABCOL, AXCOL, FONT, 
     &     DSIZE, LSIZE, ASIZE, ASPECT, ERRON, ID, XLABEL, 
     &     YLABEL, TLABEL, CLOSE, SLOTS, MXSLOTS, MASK, PLOT1, 
     &     PLOT2, PLOT3, PLOT4, DWORK, MXWORK, CLOBBER, IFAIL)
*     
*     Master plots light curves.
*     
*     Arguments:
*     
*     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
*     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*     zero in which case defaults are used.
*     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
*     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
*     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
*     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
*     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
*     >  I     MXSPEC           -- Maximum number of spectra allowed by size
*     of header buffers. 
*     >  I     MAXPX            -- Maximum number of pixels/spectrum
*     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
*     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
*     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
*     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
*     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
*     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
*     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
*     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
*     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
*     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
*     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
*     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
*     <  I     NCHAR(MXSPEC)  -- Number of character header items.
*     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
*     <  I     NINTR(MXSPEC)  -- Number of integer items.
*     <  I     NREAL(MXSPEC)  -- Number of real items.
*     >  I     MXCHAR    -- Maximum number of character header items/spec
*     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
*     >  I     MXINTR    -- Maximum number of integer header items/spec
*     >  I     MXREAL    -- Maximum number of real headers items/spec
*     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
*     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
*     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
*     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
*     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
*     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
*     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
*     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
*     >  I     NSCHAR             -- Number of character selection items.
*     >  I     NSDOUB             -- Number of double precsion selection items.
*     >  I     NSINTR             -- Number of integer selection items.
*     >  I     NSREAL             -- Number of real selection items.
*     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
*     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
*     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
*     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*     incremented and returned by routine.
*     >  I     LW                 -- Line width for plot.
*     >  I    LABCOL, AXCOL, FONT
*     R    DSIZE, LSIZE, ASIZE, ASPECT -- character sizes, aspect ratio
*     L    ERRON                -- Plot errors
*     L    ID                   -- Plot identifier
*     >  C*(*) XLABEL, YLABEL, TLABEL -- Plot labels. Defaults used if set to '??'
*     >  L     CLOSE              -- TRUE means plot will be closed before exiting
*     routine
*     >  I     SLOTS(MXSLOTS)       -- List of slots
*     >  I     MXSLOTS             -- Maximum number in list
*     >  L     MASK(MXWORK)       -- Mask work array
*     >  R     PLOT1(MXWORK)      -- Plotting work array
*     >  R     PLOT2(MXWORK)      -- Plotting work array
*     >  R     PLOT3(MXWORK)      -- Plotting work array
*     >  R     PLOT4(MXWORK)      -- Plotting work array
*     >  D     DWORK(MXWORK)
*     >  I     MXWORK             -- Work array dimension
*     >  L     CLOBBER            -- Controls whether files are over written.
*     <  I     IFAIL              -- Error return.
*     
      IMPLICIT NONE

*     
*     Integer parameters
*     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
      LOGICAL CLOSE, CLOBBER
*     
*     Data arrays
*     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*     
*     Numbers of header items
*     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*     
*     Names of header items
*     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*     
*     Values of header items
*     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*     
*     Arc coefficients
*     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
      INTEGER MAXARC
      PARAMETER (MAXARC=20)
*     
*     Command parameters
*     
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*     
*     Search parameters, names then values.
*     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*     
*     Work arrays 
*     
      INTEGER MXWORK 
      LOGICAL MASK(MXWORK)
      REAL PLOT1(MXWORK), PLOT2(MXWORK)
      REAL PLOT3(MXWORK), PLOT4(MXWORK), E
      DOUBLE PRECISION DWORK(MXWORK)
*     
*     Mask arrays
*     
      INTEGER MXMASK, NPMASK, NWMASK, NVMASK
      PARAMETER (MXMASK=50)
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
*     
*     Slot lists
*     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*     
*     Plot parameters
*     
      LOGICAL ERRON, ID, NEW
      INTEGER LW, LABCOL, AXCOL, FONT, OP
      REAL X1, X2, Y1, Y2, DSIZE, LSIZE, ASIZE, ASPECT
      REAL XP1, XP2, YP1, YP2
      CHARACTER*(*) XLABEL, YLABEL, TLABEL
      CHARACTER*100 XLAB, YLAB, TLAB
*     
*     Local variables
*     
      INTEGER I, J,  L,  N,  NOK, L1, L2
      REAL GET_FLX, GET_ERF
      DOUBLE PRECISION  ANGST, VEARTH, DISPA
      REAL   XR1, XR2, YR1, YR2
      REAL  X
      DOUBLE PRECISION DX1, DX2, DX, DSUB
      CHARACTER*64 NAME, HEAD
      INTEGER SLOT1, SLOT2,  IFAIL
      INTEGER  MAXSPEC
      INTEGER  FOUND, SEARC, ISUB
      LOGICAL SELECT, SAME, SAMECI
      LOGICAL   DEFAULT, PMAP, SOME
      REAL VLIGHT, CGS
      CHARACTER*16 XVAR, YVAR, FOLD*5
      DOUBLE PRECISION XVARD, SUM1, SUM2, SUM3
      DOUBLE PRECISION DLAM, WAVE, DNU, DIFF
      REAL XVARR
      INTEGER XVARI, MXYAX
      PARAMETER (MXYAX = 4)
      CHARACTER*10 YAX(MXYAX), SET
*     
*     Functions
*     
      INTEGER LENSTR, ISTSTR
*     
      DATA XVAR, YVAR/'Orbital phase','MJY'/
      DATA YAX/'FLUX','EW','MJY','COUNTS'/
      DATA FOLD/'no'/
      DATA SLOT1, SLOT2/1,1/
*     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot for light curve', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot for light curve', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra for light curve'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
*     
      CALL CHAR_IN('Light curve versus what?', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, XVAR, IFAIL)
*     
      CALL CHAR_IN('Light curve of what?', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, YVAR, IFAIL)
      FOUND = SEARC(YAX, MXYAX, MXYAX, YVAR)
      IF(FOUND.EQ.0) THEN
         WRITE(*,*) YVAR,' is not a valid type'
         WRITE(*,*) 'The following are:'
         WRITE(*,*) ' '
         DO I = 1, MXYAX
            WRITE(*,*) YAX(I)
         END DO
         GOTO 999
      END IF
      YVAR = YAX(FOUND)
      IF(SAMECI(YVAR,'EW')) THEN
         WRITE(*,*) 'The continuum is assumed normalised to 1'
      END IF
      NAME = ' '
      CALL CHAR_IN('O/P? <CR>=just plot, xxx=file, !xxx=headers', 
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, NAME, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NAME.EQ.' ') THEN
         OP = 1
      ELSE IF(SAME('!',NAME)) THEN
         OP = 2
         L = INDEX(NAME,'!')
         L1 = L + ISTSTR(NAME(L+1:))
         L2 = L + LENSTR(NAME(L+1:))
         IF(L2-L1+1.GT.14) THEN
            WRITE(*,*) 'Header name no more than 14 characters'
            WRITE(*,*) 'because of _D and _E'
            GOTO 999
         END IF
      ELSE 
         OP = 3
         IF(CLOBBER) THEN
            OPEN(UNIT=21,FILE=NAME,STATUS='UNKNOWN',IOSTAT=IFAIL)
         ELSE
            OPEN(UNIT=21,FILE=NAME,STATUS='NEW',IOSTAT=IFAIL)
         END IF
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Could not open output file'
            GOTO 999
         END IF
         WRITE(21,'(A)',ERR=998) '#'
         WRITE(21,'(A)',ERR=998) '# Output from LIGHT'
         WRITE(21,'(A)',ERR=998) '#'
         WRITE(21,'(4A)',ERR=998) '# ',XVAR(:LENSTR(XVAR)),' versus ',
     &        YVAR(:LENSTR(YVAR))
      END IF
*     
      CALL CHAR_IN('Phase fold ?', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FOLD, IFAIL)
      IF(SAMECI(FOLD,'YES')) THEN
         PMAP = .TRUE.
      ELSE IF(SAMECI(FOLD,'NO')) THEN
         PMAP = .FALSE.
      ELSE
         WRITE(*,*) 'Invalid reply'
         GOTO 999
      END IF                                
      CALL SMASK(NPMASK, NWMASK, NVMASK, SET)
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SET, IFAIL)
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'Mask regions wanted for light curve'
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &        NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, PLOT1, 
     &        PLOT2, PLOT3, MXWORK, MASK)
      END IF
      CALL SMASK(NPMASK, NWMASK, NVMASK, SET)
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'No mask set'
         GOTO 999
      END IF
*     
*     Check through X values
*     
      DX1 = 1.E30
      DX2 = -1.E30
      N = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
*     
         IF(NPIX(SLOT).GT.0 .AND. 
     &        SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &        HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &        MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &        VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &        VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &        MXSDOUB, MXSINTR, MXSREAL)) THEN
*     
*     Look for X point in order: DOUBLE, REAL, INTEGER (if XVAR = 'NONE'
*     just use point number)
*     
            L = LENSTR(XVAR)
            IFAIL = 0
            IF(SAMECI(XVAR,'NONE')) THEN
               DX = DBLE(N+1)
            ELSE
               CALL HGETD(XVAR(:L),XVARD,SLOT,MXSPEC,NMDOUB,
     &              HDDOUB,NDOUB,MXDOUB,IFAIL)        
               IF(IFAIL.NE.0) THEN
                  CALL HGETR(XVAR(:L),XVARR,SLOT,MXSPEC,NMREAL,
     &                 HDREAL,NREAL,MXREAL,IFAIL)        
                  IF(IFAIL.NE.0) THEN
                     CALL HGETI(XVAR(:L),XVARI,SLOT,MXSPEC,NMINTR,
     &                    HDINTR,NINTR,MXINTR,IFAIL)        
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Either ',XVAR(:L),
     &                       ' is not present in slot ',SLOT
                        WRITE(*,*) 'or there were multiple'//
     &                       ' matches to it.'
                     ELSE
                        DX = DBLE(XVARI)
                     END IF
                  ELSE
                     DX = XVARR
                  END IF
               ELSE
                  DX = XVARD
               END IF
            END IF
            IF(IFAIL.EQ.0) THEN
               N = N + 1
               DX1 = MIN(DX1, DX)
               DX2 = MAX(DX2, DX)
            END IF
         END IF
      END DO
      IF(N.LE.0) THEN
         WRITE(*,*) 'No points to plot'
         RETURN
      END IF      
      IF(DX1+DX2.GT.1.D4*(DX2-DX1)) THEN
         DSUB = DBLE(NINT(DX1-5.D-1))
      ELSE
         DSUB = 0.D0
      END IF
*     
      VLIGHT = CGS('C')/1.E5
      N = 0
      SOME = .FALSE.
      XR1 =  1.E30
      XR2 = -1.E30
      YR1 =  1.E30
      YR2 = -1.E30
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
*     
         IF(NPIX(SLOT).GT.0 .AND. 
     &        SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &        HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &        MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &        VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &        VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &        MXSDOUB, MXSINTR, MXSREAL)) THEN
*     
*     Look for X point in order: DOUBLE, REAL, INTEGER (if XVAR = 'NONE'
*     just use point number)
*     
            L = LENSTR(XVAR)
            IFAIL = 0
            IF(SAMECI(XVAR,'NONE')) THEN
               X = REAL(N+1)
               DWORK(N+1) = X
            ELSE
               CALL HGETD(XVAR(:L),XVARD,SLOT,MXSPEC,NMDOUB,
     &              HDDOUB,NDOUB,MXDOUB,IFAIL)        
               IF(IFAIL.NE.0) THEN
                  CALL HGETR(XVAR(:L),XVARR,SLOT,MXSPEC,NMREAL,
     &                 HDREAL,NREAL,MXREAL,IFAIL)        
                  IF(IFAIL.NE.0) THEN
                     CALL HGETI(XVAR(:L),XVARI,SLOT,MXSPEC,NMINTR,
     &                    HDINTR,NINTR,MXINTR,IFAIL)        
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Either ',XVAR(:L),
     &                       ' is not present in slot ',SLOT
                        WRITE(*,*) 
     &                       'or there were multiple matches to it.'
                     ELSE
                        X = REAL(XVARI - DSUB)
                        DWORK(N+1) = DBLE(XVARI)
                     END IF
                  ELSE
                     X = REAL(XVARR - DSUB)
                     DWORK(N+1) = DBLE(XVARR)
                  END IF
               ELSE
                  X = REAL(XVARD - DSUB)
                  DWORK(N+1) = DBLE(XVARD)
               END IF
            END IF
*     
*     Set mask in heliocentric frame
*     
            IF(IFAIL.EQ.0) THEN
               CALL HGETD('Vearth',VEARTH,SLOT,MXSPEC,NMDOUB,HDDOUB,
     &              NDOUB,MXDOUB,IFAIL)
               IFAIL = 0
               IF(ABS(NARC(SLOT)).GT.MAXARC) THEN
                  WRITE(*,*) 'Arc buffer too small in LGCURV ',MAXARC
                  GOTO 100
               END IF
               CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &              MAXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,
     &              MXMASK,.TRUE.,VEARTH,IFAIL)
               IF(IFAIL.NE.0) GOTO 100
*     
*     Accumulate light curve points
*     
               N = N + 1
               IF(PMAP) X = X - REAL(NINT(X-0.5))
               PLOT1(N) = X
               SUM1 = 0.D0
               SUM2 = 0.D0
               SUM3 = 0.D0
               FOUND = SEARC(YAX, MXYAX, MXYAX, YVAR)
               NOK = 0
               DO J = 1, NPIX(SLOT)
                  IF(MASK(J) .AND. ERRORS(J,SLOT).GT.0.) THEN
                     IF(NARC(SLOT).NE.0) THEN
                        DLAM = REAL(ABS(DISPA(REAL(J), NPIX(SLOT), 
     &                       NARC(SLOT), ARC(1,SLOT), MXARC)))
                        WAVE = REAL(ANGST(REAL(J), NPIX(SLOT), 
     &                       NARC(SLOT), ARC(1,SLOT), MXARC))
                     ELSE
                        DLAM = 1.
                        WAVE = 5000.
                     END IF
                     IF(FOUND.EQ.1) THEN
                        DNU = VLIGHT*1.E-13*DLAM/(WAVE**2-
     &                       (DLAM/2.D0)**2)
                        SUM2 = SUM2 + DNU*GET_FLX(COUNTS(J,SLOT),
     &                       FLUX(J,SLOT))
                        SUM3 = SUM3 + (DNU*GET_ERF(COUNTS(J,SLOT),
     &                       ERRORS(J,SLOT),FLUX(J,SLOT)))**2
                     ELSE IF(FOUND.EQ.2) THEN
                        SUM2 = SUM2 + DLAM*(GET_FLX(COUNTS(J,SLOT),
     &                       FLUX(J,SLOT))-1.)
                        SUM3 = SUM3 + (DLAM*GET_ERF(COUNTS(J,SLOT),
     &                       ERRORS(J,SLOT),FLUX(J,SLOT)))**2
                     ELSE IF(FOUND.EQ.3) THEN
                        DIFF = DLAM/WAVE
                        SUM1 = SUM1 + DIFF
                        SUM2 = SUM2 + DIFF*GET_FLX(COUNTS(J,SLOT),
     &                       FLUX(J,SLOT))
                        SUM3 = SUM3 + (DIFF*GET_ERF(COUNTS(J,SLOT),
     &                       ERRORS(J,SLOT),FLUX(J,SLOT)))**2
                     ELSE IF(FOUND.EQ.4) THEN
                        SUM1 = SUM1 + COUNTS(J,SLOT)
                        SUM2 = SUM2 + ERRORS(J,SLOT)**2
                     END IF
                     NOK = NOK + 1
                  END IF
               END DO        
               IF(NOK.GT.0) THEN
                  SOME = .TRUE.
                  IF(FOUND.EQ.1 .OR. FOUND.EQ.2) THEN
                     PLOT2(N) = REAL(SUM2)
                     E = REAL(SQRT(SUM3))
                  ELSE IF(FOUND.EQ.3) THEN
                     PLOT2(N) = REAL(SUM2/SUM1)
                     E = REAL(SQRT(SUM3)/SUM1)
                  ELSE IF(FOUND.EQ.4) THEN
                     PLOT2(N) = REAL(SUM1)
                     E = REAL(SQRT(SUM2))
                  END IF                
               ELSE
                  PLOT2(N) = 0.
                  E        = 1.
               END IF
               PLOT3(N) = PLOT2(N) - E
               PLOT4(N) = PLOT2(N) + E
               IF(OP.EQ.2) THEN
                  HEAD = NAME(L1:L2)//'_D'
                  CALL HSETR(HEAD, PLOT2(N), SLOT, MXSPEC, 
     &                 NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) 'Failed to store datum in '//
     &                    'header of slot ',SLOT
                     GOTO 999
                  END IF
                  HEAD = NAME(L1:L2)//'_E'
                  CALL HSETR(HEAD, E, SLOT, MXSPEC, NMREAL, 
     &                 HDREAL, NREAL, MXREAL, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) 'Failed to store error in '//
     &                    'header of slot ',SLOT
                     GOTO 999
                  END IF
               ELSE IF(OP.EQ.3) THEN
                  WRITE(21,'(1X,1PG21.14,2(1X,1PG11.4))',ERR=998) 
     &                 DWORK(N), PLOT2(N), E
               END IF
               XR1 = MIN(XR1, X)
               XR2 = MAX(XR2, X)
               IF(PMAP) THEN
                  XR1 = MIN(XR1, X+1.)
                  XR2 = MAX(XR2, X+1.)
               END IF
               YR1 = MIN(YR1, PLOT2(N))
               YR2 = MAX(YR2, PLOT2(N))
            END IF
         END IF
 100     CONTINUE
      END DO
      IF(.NOT.SOME) THEN
         WRITE(*,*) 'No valid points.'
         GOTO 999
      END IF
      IF(N.EQ.1) THEN
         WRITE(*,*) 'One point only: ',DWORK(1),PLOT2(1),
     &        PLOT4(1)-PLOT2(1)
      ELSE
         IF(X1.EQ.X2) THEN
            XP1 = XR1 - (XR2-XR1)/20.
            XP2 = XR2 + (XR2-XR1)/20.
         ELSE
            XP1 = X1
            XP2 = X2
         END IF
         IF(Y1.EQ.Y2) THEN
            YP1 = YR1 - (YR2-YR1)/20.
            YP2 = YR2 + (YR2-YR1)/20.
         ELSE
            YP1 = Y1
            YP2 = Y2
         END IF
         IF(XP1.EQ.XP2) XP2 = XP2 + 1.
         IF(YP1.EQ.YP2) YP2 = YP2 + 1.
         IF(.NOT.DEFAULT) THEN
            CALL SET_LIM(XP1, XP2, YP1, YP2, IFAIL)
            IF(IFAIL.NE.0) RETURN
         END IF
*     
         CALL DEV_OPEN(.TRUE.,NEW,IFAIL)
         IF(IFAIL.NE.0) RETURN
         IF(NEW) THEN
            CALL VPSET(XP1, XP2, YP1, YP2, LW, AXCOL, FONT, 
     &           ASIZE, ASPECT)
*     
            CALL PGSCI(LABCOL)
            CALL PGSCH(LSIZE)
*     
*     Set labels
*     
            IF(XLABEL.EQ.'??') THEN
               IF(XVAR.EQ.'NONE') THEN
                  XLAB = 'Spectrum number'
               ELSE
                  XLAB = XVAR
                  ISUB = NINT(DSUB)
                  IF(ISUB.NE.0) THEN
                     L = LENSTR(XLAB)
                     XLAB(L+2:L+2) = '-'
                     WRITE(XLAB(L+4:),*) ISUB
                  END IF
               END IF
            ELSE
               XLAB = XLABEL
            END IF
            IF(YLABEL.EQ.'??') THEN
               IF(SAMECI(YVAR,'FLUX')) THEN
                  YLAB = 'Flux (ergs cm\\u-2\\d s\\u-1\\d)'
               ELSE IF(SAMECI(YVAR,'EW')) THEN
                  YLAB = 'Equivalent width (\\A)'
               ELSE IF(SAMECI(YVAR,'MJY')) THEN
                  YLAB = 'Flux density (mJy)'
               END IF 
            ELSE
               YLAB = YLABEL
            END IF
            IF(TLABEL.EQ.'??') THEN
               TLAB = 'Spectra 1234 to 1234'
               WRITE(TLAB(9:12), '(I4)') SLOT1
               WRITE(TLAB(17:20),'(I4)') SLOT2
            ELSE
               TLAB = TLABEL
            END IF
            CALL PGLABEL(XLAB, YLAB, TLAB)
            CALL PGSCH(1.)
            CALL PGSCI(1)
            IF(ID) CALL PGIDEN
         ELSE
            CALL VPSET(XP1, XP2, YP1, YP2, LW, AXCOL, FONT, 
     &           ASIZE, ASPECT)
            CALL PGSCI(1)
         END IF
         CALL PGSCH(DSIZE)
         CALL PGPT(N, PLOT1, PLOT2, 17)
         IF(ERRON) CALL PGERRY(N, PLOT1, PLOT3, PLOT4, 0.)
         IF(PMAP) THEN
            DO I = 1, N
               PLOT1(I) = PLOT1(I) + 1.
            END DO
            CALL PGPT(N, PLOT1, PLOT2, 17)
            IF(ERRON) CALL PGERRY(N, PLOT1, PLOT3, PLOT4, 0.)
         END IF
      END IF
      IF(OP.EQ.2) THEN
         WRITE(*,*) 'Results stored in headers'
      ELSE IF(OP.EQ.3) THEN
         CLOSE(UNIT=21)
         WRITE(*,*) 'Results written to ',NAME(:LENSTR(NAME))
      END IF
      IFAIL = 0
      IF(CLOSE) CALL DEV_CLOSE(0,IFAIL)
      RETURN
 999  IFAIL = 1
      RETURN
 998  CLOSE(UNIT=21)
      WRITE(*,*) 'Error writing to ',NAME(:LENSTR(NAME)) 
      RETURN
      END

