*TEMP
* TEMP N1 N2 BOLD BNEW BACK FLAT SENS TRIG -- Corrects HST RUBY data for 
*                                              revised background fits.
* Parameters: 
*     
*  N1    -- Start slot of first group 
*  N2    -- End slot of first group 
*  BOLD  -- Data file containing old background numbers
*  BNEW  -- Data file containing old background numbers
*  BACK  -- Background template spectrum
*  FLAT  -- Flat field in the form of balance factors
*  SENS  -- Sensitivity = conversion from counts to mJy
*  TRIG  -- Trigger. Ripples above this number of sigma are corrected for.
*
*TEMP
      SUBROUTINE TEMP(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &SLOTS, MXSLOTS, BOLD, BNEW, BACK, FLAT, SENS, MXWORK, IFAIL)
*
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    I     SLOTS(MXSLOTS)
*    I     MXSLOTS
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Work arrays
*
      INTEGER MXWORK
      REAL BOLD(MXWORK), BNEW(MXWORK)
      REAL BACK(MXWORK), FLAT(MXWORK)
      REAL SENS(MXWORK)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      INTEGER I, J,  N,  NOFF, NSENS
      INTEGER NFLAT, NBACK,   NOK, NOLD
      INTEGER NNEW, N1, N2, N3, N4, NEG
      REAL  PHOT, T1, T2
      REAL PRED, O, E, RIPP, SRIPP, TRIG
      DOUBLE PRECISION   D, A1, A2, A3, A4
      CHARACTER*64 FBOLD, FBNEW, FSENS, FFLAT, FBACK
      INTEGER SLOT1, SLOT2
      INTEGER  IFAIL
      INTEGER  MAXSPEC,  NCOM
      REAL  DWELL
      LOGICAL    DEFAULT
      INTEGER STORE(10)
*
* Functions
*
*
      DATA SLOT1, SLOT2, TRIG/1,1,7./
      DATA FSENS, FFLAT, FBACK/'MFLUX.SPEC','FLAT.SPEC','BACK.SPEC'/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM  = 0
      IFAIL = 0
      CALL INTR_IN('First spectrum to process', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      IF(SLOT1.EQ.0) SLOT2 = 0
      CALL INTR_IN('Last spectrum to process', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, 
     &    NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to process'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
      NOK = 0
      DO I = 1, NSLOTS
        IF(NPIX(SLOTS(I)).EQ.928) NOK = NOK + 1
      END DO
      WRITE(*,*) NOK,' valid spectra selected'
      IF(NOK.EQ.0) GOTO 999
*
      IF(IFAIL.NE.0) GOTO 999
      CALL CHAR_IN('Old backgrounds', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FBOLD, IFAIL)
*
      OPEN(UNIT=31,FILE=FBOLD,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FBOLD
        GOTO 999
      END IF
      READ(31,*,ERR=999)
      READ(31,*,ERR=999)
      READ(31,*,ERR=999)
      READ(31,*,ERR=999)
      N = 0
100   N = N + 1
      READ(31,*,ERR=999,END=200) I, D, T1, T2, BOLD(N), O, E
      GOTO 100
200   NOLD = N - 1
      CLOSE(UNIT=31)
      IF(NOLD.LT.NOK) THEN
        WRITE(*,*) 'There are too few old background values'
        WRITE(*,*) NOLD,' versus ',NOK,' expected.'
        GOTO 999
      END IF
*
      CALL CHAR_IN('New backgrounds', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FBNEW, IFAIL)
*
      OPEN(UNIT=31,FILE=FBNEW,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FBNEW
        GOTO 999
      END IF
      N = 0
300   N = N + 1
      READ(31,*,ERR=999,END=400) I, BNEW(N)
      GOTO 300
400   NNEW = N - 1
      CLOSE(UNIT=31)
      IF(NNEW.LT.NOK) THEN
        WRITE(*,*) 'There are too few new background values'
        WRITE(*,*) NNEW,' versus ',NOK,' expected.'
        GOTO 999
      END IF
*
      CALL CHAR_IN('Background spectrum', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FBACK, IFAIL)
      OPEN(UNIT=31,FILE=FBACK,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FBACK
        GOTO 999
      END IF
      N = 0
500   N = N + 1
      READ(31,*,ERR=999,END=600) BACK(N)
      GOTO 500
600   NBACK = N - 1
      CLOSE(UNIT=31)
      IF(NBACK.NE.2064) THEN
        WRITE(*,*) 'Expected 2064 points.'
        GOTO 999
      END IF
*
      CALL CHAR_IN('Flat field spectrum', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FFLAT, IFAIL)
      OPEN(UNIT=31,FILE=FFLAT,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FFLAT
        GOTO 999
      END IF
      N = 0
700   N = N + 1
      READ(31,*,ERR=999,END=800) I,FLAT(N)
      GOTO 700
800   NFLAT = N - 1
      CLOSE(UNIT=31)
      IF(NFLAT.NE.2064) THEN
        WRITE(*,*) 'Expected 2064 points.'
        GOTO 999
      END IF
*
      CALL CHAR_IN('Sensitivity spectrum', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FSENS, IFAIL)
      OPEN(UNIT=31,FILE=FSENS,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FSENS
        GOTO 999
      END IF
      N = 0
900   N = N + 1
      READ(31,*,ERR=999,END=1000) SENS(N)
      GOTO 900
1000  NSENS = N - 1
      CLOSE(UNIT=31)
      IF(NSENS.NE.781) THEN
        WRITE(*,*) 'Expected 781 points.'
        GOTO 999
      END IF
*
      DO I = 1, 10
        STORE(I) = 0
      END DO
      NOK = 0
      NOFF = 1137
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF(NPIX(SLOT).EQ.928) THEN
          CALL HGETR('Dwell',DWELL, SLOT, MXSPEC, 
     &    NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Could not find dwell in slot ',SLOT
            GOTO 999
          END IF
          NOK = NOK + 1
          NEG = 1
          DO WHILE(NEG.LE.NPIX(SLOT) .AND. COUNTS(NEG,SLOT).GT.0.)
            NEG = NEG + 1
          END DO
          PRED = -COUNTS(NEG,SLOT)/DWELL/BACK(NOFF+NEG)
*
* Compute ripple
*
          N1 = 0
          A1 = 0.D0
          DO J = 149, 927, 4
            N1 = N1 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*PRED
            A1 = A1 + PHOT
          END DO
          A1 = A1/DBLE(N1)
*
          N2 = 0
          A2 = 0.D0
          DO J = 150, 927, 4
            N2 = N2 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*PRED
            A2 = A2 + PHOT
          END DO
          A2 = A2/DBLE(N2)
*
          N3 = 0
          A3 = 0.D0
          DO J = 151, 927, 4
            N3 = N3 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*PRED
            A3 = A3 + PHOT
          END DO
          A3 = A3/DBLE(N3)
*
          N4 = 0
          A4 = 0.D0
          DO J = 152, 927, 4
            N4 = N4 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*PRED
            A4 = A4 + PHOT
          END DO
          A4 = A4/DBLE(N4)
*
          IF(A1.GT.A2 .AND. A1.GT.A3 .AND. A1.GT.A4) THEN
            RIPP  = (A1-(A2+A3+A4)/3.)/DWELL/4.
            SRIPP = SQRT(A1/DBLE(N1)+(A2/DBLE(N2)+A3/DBLE(N3)+
     &              A4/DBLE(N4))/9.)/DWELL/4.
          ELSE IF(A2.GT.A3 .AND. A2.GT.A4 .AND. A2.GT.A1) THEN
            RIPP = (A2-(A3+A4+A1)/3.)/DWELL/4.
            SRIPP = SQRT(A2/DBLE(N2)+(A3/DBLE(N3)+A4/DBLE(N4)+
     &              A1/DBLE(N1))/9.)/DWELL/4.
          ELSE IF(A3.GT.A4 .AND. A3.GT.A1 .AND. A3.GT.A2) THEN
            RIPP = (A3-(A4+A1+A2)/3.)/DWELL/4.
            SRIPP = SQRT(A3/DBLE(N3)+(A4/DBLE(N4)+A1/DBLE(N1)+
     &              A2/DBLE(N2))/9.)/DWELL/4.
          ELSE 
            RIPP = (A4-(A1+A2+A3)/3.)/DWELL/4.
            SRIPP = SQRT(A4/DBLE(N4)+(A1/DBLE(N1)+A2/DBLE(N2)+
     &              A3/DBLE(N3))/9.)/DWELL/4.
          END IF
          N = MIN(INT(RIPP/SRIPP)+1,10)
          STORE(N) = STORE(N) + 1
        END IF
      END DO
      WRITE(*,*) ' '
      WRITE(*,*) '0-1 1-2 2-3 3-4 4-5 5-6 6-7 7-8 8-9 >9'
      WRITE(*,'(10(1X,I3))') (STORE(I),I=1,10)
      WRITE(*,*) ' '
      CALL REAL_IN('Correction trigger', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, TRIG, 0., 1.E5, IFAIL)
*
      NOK = 0
      NOFF = 1137
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF(NPIX(SLOT).EQ.928) THEN
          CALL HGETR('Dwell',DWELL, SLOT, MXSPEC, 
     &    NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Could not find dwell in slot ',SLOT
            GOTO 999
          END IF
          NOK = NOK + 1
          NEG = 1
          DO WHILE(NEG.LE.NPIX(SLOT) .AND. COUNTS(NEG,SLOT).GT.0.)
            NEG = NEG + 1
          END DO
          PRED = -COUNTS(NEG,SLOT)/DWELL/BACK(NOFF+NEG)
          WRITE(*,*) 'Now working on slot ',SLOT
          IF(ABS(PRED-BOLD(NOK)).GT.1.E-3*ABS(PRED)) THEN
            WRITE(*,*) 'Possible mismatch of old and predicted'
            WRITE(*,*) 'backgrounds. Old value = ',BOLD(NOK)
            WRITE(*,*) 'versus predicted value = ',PRED
            IF(PRED.NE.0.) WRITE(*,*) 'Ratio = ',BOLD(NOK)/PRED
          END IF
*
* Update counts for new background values.
*
          DO J = 1, 927
            COUNTS(J,SLOT) = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*
     *                       (PRED-BNEW(NOK))
          END DO 
*
* Set errors (crudely, better job done by another routine)
*
          DO J = 1, 148
            ERRORS(J,SLOT) = -1.
          END DO
          DO J = 149, 927
            ERRORS(J,SLOT) = SQRT(MAX(0.,COUNTS(J,SLOT))+
     &      DWELL*BACK(NOFF+J)*BNEW(NOK))
          END DO
*
* Compute ripple
*
          N1 = 0
          A1 = 0.D0
          DO J = 149, 927, 4
            N1 = N1 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*BNEW(NOK)
            A1 = A1 + PHOT
          END DO
          A1 = A1/DBLE(N1)
*
          N2 = 0
          A2 = 0.D0
          DO J = 150, 927, 4
            N2 = N2 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*BNEW(NOK)
            A2 = A2 + PHOT
          END DO
          A2 = A2/DBLE(N2)
*
          N3 = 0
          A3 = 0.D0
          DO J = 151, 927, 4
            N3 = N3 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*BNEW(NOK)
            A3 = A3 + PHOT
          END DO
          A3 = A3/DBLE(N3)
*
          N4 = 0
          A4 = 0.D0
          DO J = 152, 927, 4
            N4 = N4 + 1
            PHOT = COUNTS(J,SLOT)+DWELL*BACK(NOFF+J)*BNEW(NOK)
            A4 = A4 + PHOT
          END DO
          A4 = A4/DBLE(N4)
*
          IF(A1.GT.A2 .AND. A1.GT.A3 .AND. A1.GT.A4) THEN
            RIPP  = (A1-(A2+A3+A4)/3.)/DWELL/4.
            SRIPP = SQRT(A1/DBLE(N1)+(A2/DBLE(N2)+A3/DBLE(N3)+
     &              A4/DBLE(N4))/9.)/DWELL/4.
            N = 1
          ELSE IF(A2.GT.A3 .AND. A2.GT.A4 .AND. A2.GT.A1) THEN
            RIPP = (A2-(A3+A4+A1)/3.)/DWELL/4.
            SRIPP = SQRT(A2/DBLE(N2)+(A3/DBLE(N3)+A4/DBLE(N4)+
     &              A1/DBLE(N1))/9.)/DWELL/4.
            N = 2
          ELSE IF(A3.GT.A4 .AND. A3.GT.A1 .AND. A3.GT.A2) THEN
            RIPP = (A3-(A4+A1+A2)/3.)/DWELL/4.
            SRIPP = SQRT(A3/DBLE(N3)+(A4/DBLE(N4)+A1/DBLE(N1)+
     &              A2/DBLE(N2))/9.)/DWELL/4.
            N = 3
          ELSE 
            RIPP = (A4-(A1+A2+A3)/3.)/DWELL/4.
            SRIPP = SQRT(A4/DBLE(N4)+(A1/DBLE(N1)+A2/DBLE(N2)+
     &              A3/DBLE(N3))/9.)/DWELL/4.
            N = 4
          END IF
          WRITE(*,'(1X,A,I4,A,F6.4,A,F6.2,A)') 
     &    'Slot ',SLOT,' ripp = ',RIPP,' cts/s/pix = ',
     &    RIPP/SRIPP,' sig.'
          WRITE(*,*) SNGL(A1),SNGL(A2),SNGL(A3),SNGL(A4)
*
* Correct for excessive ripple
*       
          IF(RIPP.GT.TRIG*SRIPP) THEN
            WRITE(*,*) '*******************'
            WRITE(*,*) 'Correcting ripple in slot ',SLOT
            DO J = 148+N, 927, 4
              COUNTS(J,SLOT) = COUNTS(J,SLOT) - RIPP*DWELL*4.
            END DO
          END IF
*
* Set fluxes 
*
          DO J = 149, 927
            IF(COUNTS(J,SLOT).EQ.0.) THEN
              FLUX(J,SLOT) = SENS(J-147)/DWELL
            ELSE
              FLUX(J,SLOT) = SENS(J-147)/DWELL*
     &                       COUNTS(J,SLOT)
            END IF
          END DO
        END IF
      END DO
      IFAIL = 0
999   CLOSE(UNIT=31)
      RETURN
      END
