*HSTSDF
* HSTSDF Flux Wave Error Header N1 N2 NSTART NX1 NX2 NRUN NPHOTON -- 
*         Reads in HST FOS spectra from sdf files
*
* If you read HST FOS spectra off tape into sdf files you then need to read
* them into molly. This program is supposed to do this.
*
* Parameters:
*
*            Flux   -- name of sdf file with fluxes.
*            Wave   -- name of sdf file with wavelengths.
*            Error  -- name of sdf file with uncertainties.
*            Header -- name of header file listing object name, JD and dwell in columns format.
*                      If this file can't be found, the routine will continue without setting headers. 
*                      In order to read the object name even if it has blanks, the specific format of 
*                      A32,1X,F17.9,1X,F12.5 is followed where A32 is the object name, F17.9 is the JD 
*                      and F12.5 is the dwell in seconds. The lines are assumed to be in the same order
*                      as the spectra stored in the flux, wave and error. Therefore if you want to start 
*                      from the 10th spectrum, the first 9 will be skipped.
*
*            N1     -- First slot to read data into.
*            N2     -- Last slot to read data into.
*            NSTART -- Start spectrum in sdf files.
*            NX1    -- first X pixel to read.
*            NX2    -- last X pixel to read.
*            NRUN   -- First run number to set in spectra.
*            PHOTON -- yes or no. yes to work out the ratio from
*                      flux to photons to get a true count array.
*                      This requires there to be enough spectra
*                      to make it certain that at every pixel there
*                      will be some spectra that only differ by 1 count.
*
*
*HSTSDF
      SUBROUTINE HSTSDF(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, WORK1, WORK2, WORK3, WORK4, RWORK, IWORK, MXWORK, IFAIL)
*
*
*
* Authors:
*         TRM: Tom Marsh (Warwick)
*
* History:
*         22-JAN-1997 TRM
*
*
* Reads HST spectra
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    D     WORK1(MXWORK)
*    D     WORK2(MXWORK)
*    D     WORK2(MXWORK)
*    D     WORK3(MXWORK)
*    D     WORK4(MXWORK)
*    R     RWORK(MXWORK)
*    I     IWORK(MXWORK)
*    I     MXWORK
* IFAIL)
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
      INTEGER MXWORK
      INTEGER IWORK(MXWORK)
      DOUBLE PRECISION WORK1(MXWORK), WORK2(MXWORK)
      DOUBLE PRECISION WORK3(MXWORK), WORK4(MXWORK)
      REAL  RWORK(MXWORK)
*
* Local variables
*
      CHARACTER*64 FLX, WAV, ERR, HEAD
      CHARACTER*100 TEXT, ITEM
      INTEGER SLOT1, SLOT2, NX1, NX2, NX, NY, SLOT
      INTEGER I,  MAXSPEC, FIRST, IFAIL, L
      LOGICAL    DEFAULT, SAMECI, PCORR, FRA, FDEC
      DOUBLE PRECISION RA, DEC, RJD
      REAL DWELL
      CHARACTER*32 OBJECT
      INTEGER  NCOM, NRUN, MXNX
*
* FIGARO variables
*
      INCLUDE 'DYNAMIC_MEMORY'
      INTEGER ADDRESS, SLT1, SLT2, SLT3, STATUS
      INTEGER DIMS(2), NDIMS, DIMS1(2), NDIMS1
      INTEGER FPTR, WPTR, EPTR, DYN_ELEMENT, NELM
      CHARACTER*3 PHOTON
*
      DATA FLX,WAV,ERR,HEAD/'flux','wave','error','header'/
      DATA SLOT1, SLOT2, FIRST, NX1, NX2/1,1,1,1,1000/
      DATA PHOTON/'yes'/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL CHAR_IN('Flux file name', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FLX, IFAIL)
      CALL CHAR_IN('Wavelength file name', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, WAV, IFAIL)
      CALL CHAR_IN('Error file name', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, ERR, IFAIL)
      CALL CHAR_IN('Header file name', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, HEAD, IFAIL)
      CALL INTR_IN('First slot to load into', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 1, MAXSPEC, IFAIL)
      CALL INTR_IN('Last slot to load into', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      CALL INTR_IN('First line to load', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, FIRST, 1, 9999999, IFAIL)
      CALL INTR_IN('First X pixel to load', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NX1, 1, 9999999, IFAIL)
      MXNX = MAXPX + NX1 - 1
      CALL INTR_IN('Last X pixel to load', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NX2, NX1, MXNX, IFAIL)
      NRUN = FIRST
      CALL INTR_IN('First run number', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NRUN, 1, 99999999, IFAIL)
      CALL CHAR_IN('Photon correction [yes or no]', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, PHOTON, IFAIL)
      IF(SAMECI(PHOTON,'yes')) THEN
         PCORR = .TRUE.
      ELSE IF(SAMECI(PHOTON,'no')) THEN
         PCORR = .FALSE.
      ELSE
         WRITE(*,*) 'Must answer yes or no'
         PHOTON = 'yes'
         GOTO 999
      END IF
      IF(IFAIL.NE.0) GOTO 999
*
* Open FIGARO files for reading
*
      STATUS = 0
      CALL DSA_OPEN(STATUS)
      CALL DSA_NAMED_INPUT('FLUX', FLX, STATUS)
      CALL DSA_DATA_SIZE('FLUX',2,NDIMS,DIMS,NELM,STATUS)
      IF(STATUS.NE.0) GOTO 999          
      NX = DIMS(1)
      IF(NDIMS.EQ.1) THEN
         NY = 1
      ELSE
         NY = DIMS(2)
      END IF
      IF(NX2 .GT. NX) THEN
         WRITE(*,*) 'X dimension of files is too small.'
         WRITE(*,*) NX,' compared to requested ',NX2
         GOTO 999
      END IF            
      IF(FIRST + SLOT2 - SLOT1 .GT. NY) THEN
         WRITE(*,*) 'Y dimension of files is too small.'
         WRITE(*,*) NY,' compared to requested ',
     &        FIRST + SLOT2 - SLOT1
         GOTO 999
      END IF
      CALL DSA_NAMED_INPUT('WAVE', WAV, STATUS)
      CALL DSA_DATA_SIZE('WAVE',2,NDIMS1,DIMS1,NELM,STATUS)
      IF(STATUS.NE.0) GOTO 999          
      IF(NDIMS1 .NE. NDIMS) THEN
         WRITE(*,*) 'Flux and wavelength files do not have the same'
         WRITE(*,*) 'number of dimensions.'
         WRITE(*,*) NDIMS,' vs ',NDIMS1
         GOTO 999
      END IF
      DO I = 1, NDIMS
         IF(DIMS1(I) .NE. DIMS(I)) THEN
            WRITE(*,*) 'Flux and wavelength files have different sizes'
            WRITE(*,*) 'for axis ',I
            WRITE(*,*) DIMS(I),' vs ',DIMS1(I)
            GOTO 999
         END IF
      END DO
      CALL DSA_NAMED_INPUT('ERROR', ERR, STATUS)
      CALL DSA_DATA_SIZE('ERROR',2,NDIMS1,DIMS1,NELM,STATUS)
      IF(STATUS.NE.0) GOTO 999          
      IF(NDIMS1 .NE. NDIMS) THEN
         WRITE(*,*) 'Flux and error files do not have the same'
         WRITE(*,*) 'number of dimensions.'
         WRITE(*,*) NDIMS,' vs ',NDIMS1
         GOTO 999
      END IF
      DO I = 1, NDIMS
         IF(DIMS1(I) .NE. DIMS(I)) THEN
            WRITE(*,*) 'Flux and error files have different sizes'
            WRITE(*,*) 'for axis ',I
            WRITE(*,*) DIMS(I),' vs ',DIMS1(I)
            GOTO 999
         END IF
      END DO
*
* Read data, wavelengths and errors
*
      CALL DSA_MAP_DATA('FLUX','READ','FLOAT',ADDRESS,SLT1,STATUS)
      FPTR = DYN_ELEMENT(ADDRESS)
      CALL DSA_MAP_DATA('WAVE','READ','FLOAT',ADDRESS,SLT2,STATUS)
      WPTR = DYN_ELEMENT(ADDRESS)
      CALL DSA_MAP_DATA('ERROR','READ','FLOAT',ADDRESS,SLT3,STATUS)
      EPTR = DYN_ELEMENT(ADDRESS)
      IF(STATUS.NE.0) GOTO 999
*
* Load spectra and fit arcs
*
      CALL LOAD_HST(DYNAMIC_MEM(FPTR), DYNAMIC_MEM(WPTR),
     &     DYNAMIC_MEM(EPTR), NX, NY, SLOT1, SLOT2, FIRST,
     &     NX1, NX2, NPIX, COUNTS, FLUX, ERRORS, MAXPX,
     &     MAXSPEC, ARC, NARC, MXARC, WORK1, WORK2, 
     &     WORK3, WORK4, RWORK, IWORK, MXWORK, PCORR)
*
* Look for header file
*
      OPEN(UNIT=51, FILE=HEAD, ACCESS='SEQUENTIAL', IOSTAT=IFAIL)
      IF(IFAIL.EQ.0) THEN
         WRITE(*,*) 'Header file opened'
         I = 1
         IFAIL = 0
         DO WHILE(I.LE.FIRST-1 .AND. IFAIL.EQ.0)
            READ(51,*,IOSTAT=IFAIL)
            I = I + 1
         END DO
         IF(IFAIL.EQ.0) THEN
            DO SLOT = SLOT1, SLOT2
               READ(51,'(A32,1X,F17.9,1X,F12.5)',IOSTAT=IFAIL) 
     &              OBJECT, RJD, DWELL
               IF(IFAIL.EQ.0) THEN
                  CALL HSETD('RJD',RJD,SLOT,MXSPEC,NMDOUB,
     &              HDDOUB,NDOUB,MXDOUB,IFAIL)
                  CALL HSETR('Dwell',DWELL,SLOT,MXSPEC,NMREAL,
     &                 HDREAL,NREAL,MXREAL,IFAIL)
                  CALL HSETC('Object',OBJECT,SLOT,MXSPEC,NMCHAR,
     &                 HDCHAR,NCHAR,MXCHAR,IFAIL)
               ELSE
                  WRITE(*,*) 'Failed to read header for slot ',SLOT
                  WRITE(*,*) 'IFAIL = ',IFAIL
               END IF
            END DO
         ELSE
            WRITE(*,*) 'Failed while trying to skip first ',FIRST-1,
     &           ' records.'
         END IF
         CLOSE(UNIT=51)
      ELSE
         WRITE(*,*) 'Failed to open header file'
      END IF
*
* Set the run number
*
      DO SLOT = SLOT1, SLOT2
         CALL HSETI('Record',NRUN+SLOT-1,SLOT,MXSPEC,NMINTR,HDINTR,
     &        NINTR,MXINTR,IFAIL)
      END DO
*
* Search through for RA and Dec (should be 170 and 171 but search over a range
* to increase chances of finding them)
*
      ITEM = 'FLUX.MORE.FITS[1,   ]'
      FRA  = .FALSE.
      FDEC = .FALSE.
      I = 160
      DO WHILE(I.LT.181 .AND. (.NOT.FRA .OR. .NOT.FDEC))
         WRITE(ITEM(18:20),'(I3)') I
         CALL DTA_RDVARC(ITEM,1,TEXT,STATUS)
         IF(STATUS.EQ.0) THEN
            IF(.NOT.FRA) THEN
               L  = INDEX(TEXT,'RA_TARG')
               IF(L.GT.0) THEN
                  READ(TEXT(L+9:L+29),*,IOSTAT=IFAIL) RA
                  FRA = IFAIL.EQ.0
                  RA = 24.*RA/360.
               END IF
            END IF
            IF(.NOT.FDEC) THEN
               L  = INDEX(TEXT,'DEC_TARG')
               IF(L.GT.0) THEN
                  READ(TEXT(L+9:L+29),*,IOSTAT=IFAIL) DEC
                  FDEC = IFAIL.EQ.0
               END IF
            END IF
         END IF
         STATUS = 0
         I = I + 1
      END DO
      IF(FRA .AND. FDEC .AND. DEC.GE.-90. .AND. DEC.LE.90. 
     &.AND. RA.GE.0. .AND. RA.LE.24.) THEN
         WRITE(*,*) 'RA = ',RA,', Dec = ',DEC
         DO SLOT = SLOT1, SLOT2
            CALL HSETD('RA',RA,SLOT,MXSPEC,NMDOUB,HDDOUB,NDOUB,
     &           MXDOUB,IFAIL)
            CALL HSETD('Dec',DEC,SLOT,MXSPEC,NMDOUB,HDDOUB,NDOUB,
     &           MXDOUB,IFAIL)
            CALL HSETD('Equinox',2.d3,SLOT,MXSPEC,NMDOUB,HDDOUB,
     &           NDOUB,MXDOUB,IFAIL)
         END DO
      ELSE
         WRITE(*,*) 'Failed to obtain object position'
      END IF
*
      CALL DSA_CLOSE(STATUS)
      IF(STATUS.NE.0) GOTO 999
      IFAIL = 0
*
* Clear up
*
 999  CALL DSA_CLOSE(STATUS)
      RETURN
      END

      SUBROUTINE LOAD_HST(FLX, WAV, ERR, NX, NY, SLOT1, SLOT2,
     &     NSTART, NX1, NX2, NPIX, COUNTS, FLUX, ERRORS,
     &     MAXPX, MAXSPEC, ARC, NARC, MXARC, WORK1, WORK2, WORK3, 
     &     WORK4, RWORK, IWORK, MXWORK, PCORR)

      IMPLICIT NONE
      INTEGER MAXPX, MAXSPEC, MXARC, NX, NY, NPOLY, I, MXWORK
      INTEGER SLOT1, SLOT2, NSTART, NX1, NX2
      INTEGER NPIX(MAXSPEC), NARC(MAXSPEC), NPX
      REAL FLX(NX,NY), WAV(NX,NY), ERR(NX,NY)
      REAL COUNTS(MAXPX,MAXSPEC), FLUX(MAXPX,MAXSPEC)
      REAL ERRORS(MAXPX,MAXSPEC), CGS, VLIGHT, FAC
      DOUBLE PRECISION ARC(MXARC,MAXSPEC), POLY
      DOUBLE PRECISION WORK1(MXWORK), WORK2(MXWORK), WORK3(MXWORK)
      DOUBLE PRECISION WORK4(MXWORK), Z, Z0
      REAL RWORK(MXWORK)
      INTEGER NSORT, IWORK(MXWORK)
      INTEGER NMAX, SLOT, N, J, J1
      LOGICAL PCORR, OK
      PARAMETER (NMAX=20)
      DOUBLE PRECISION XM(NMAX,2*NMAX+3), CHISQ, FRACTION, RMS

*
* Initialise two of the arc fitting arrays
*
      NPX = NX2 - NX1 + 1
      DO I = 1, NPX
         WORK1(I) = DBLE(I)/DBLE(NPX)
         WORK3(I) = 1.
      END DO
*
* Grind through slots (convert from flambda to fnu)
* We assume that counts = mJy at this point.
*
      VLIGHT = CGS('C')/1.E18
      DO SLOT = SLOT1, SLOT2
         NPIX(SLOT) = NPX
         N = NSTART + SLOT - SLOT1
         DO I = 1, NPIX(SLOT)
            J = NX1 + I - 1
            WORK2(I) = WAV(J,N)
            FAC = WAV(J,N)**2/VLIGHT
            Z   = FAC*FLX(J,N)
            COUNTS(I,SLOT) = Z
            IF(COUNTS(I,SLOT).EQ.0.) THEN
               FLUX(I,SLOT)   = 1.
            ELSE
               FLUX(I,SLOT)   = Z
            END IF
            ERRORS(I,SLOT) = FAC*ERR(J,N)
         END DO

* Now deal with arc

         FRACTION = 1.D-2
         DO NPOLY = 2, MIN(NPX, NMAX)
            CALL LEASQ(WORK1, WORK2, WORK3, NX, NPOLY, 
     &           ARC(1,SLOT), CHISQ, XM, 1)
            RMS = 0.D0
            DO I = 1, NPX
               RMS = RMS + (WORK2(I)-POLY(ARC(1,SLOT),
     &              NPOLY,WORK1(I)))**2
            END DO
            RMS = SQRT(RMS/DBLE(MAX(1,NPX-NPOLY)))
            RMS = RMS*DBLE(NPX)/ABS(WORK2(NPX)-WORK2(1))
            IF(RMS.LT.FRACTION) THEN
               IF(MOD(SLOT-SLOT1+1,20).EQ.0) 
     &              WRITE(*,'(A,I4,A,F7.5,A,I2)') 'Slot ',SLOT,
     &              ' acceptable fit, RMS = ',RMS,
     &              ' pixels for NARC = ',NPOLY
               NARC(SLOT) = NPOLY
               GOTO 100
            END IF
         END DO
         WRITE(*,*) 'Slot ',SLOT,
     &        ' ** COULD NOT FIT WAVELENGTH SCALE ** '//
     &        ' Will assume pixel scale instead.'
         NARC(SLOT) = 0
 100     CONTINUE
      END DO
*
* Compute count/mJy factor if requested, otherwise keep = 1. This is not done
* first because of the massive amount of disk access required because of the
* mapping access used by the DSA input routines.
*
      IF(PCORR) THEN
         DO I = 1, NPX

* mJy error **2 = number of photons/(count/mJy)**2

            NSORT = MIN(MXWORK, SLOT2-SLOT1+1)
            DO J = 1, NSORT
               N = SLOT1 + J - 1
               RWORK(J) = ERRORS(I,SLOT1+J-1)**2
            END DO
*
* Sort into ascending order, then determine smallest
* jump excluding possible round-off errors which should
* represent the difference between values differing
* by one photon.
*

            CALL HEAPSORT(NSORT, RWORK, IWORK)
            WORK4(I) = 1.D20
            J1 = 1
            DO WHILE(J1.LT.NSORT)
               Z0 = RWORK(IWORK(J1))
               OK = .TRUE.
               J  = J1 + 1
               DO WHILE(OK .AND. J .LE. NSORT)
                  Z = RWORK(IWORK(J)) - Z0
                  IF(Z.GT.1.D-5) THEN
                     IF(Z .LT. WORK4(I)) WORK4(I) = Z
                     OK = .FALSE.
                  END IF
                  J = J + 1
               END DO
               J1 = J 
            END DO
            WORK4(I) = 1.D0/SQRT(WORK4(I))
            WRITE(*,*) 'Pixel ',NX1+I-1,' counts/mJy = ',WORK4(I)
         END DO
      ELSE
         DO I = 1, NPX
            WORK4(I) = 1.
         END DO
      END IF

* Final pass through arrays to adjust to new counts/mJy ratio

      DO SLOT = SLOT1, SLOT2
         DO I = 1, NPIX(SLOT)
            COUNTS(I,SLOT) = WORK4(I)*COUNTS(I,SLOT)
            ERRORS(I,SLOT) = MAX(0.1,SNGL(WORK4(I))*ERRORS(I,SLOT))
            IF(COUNTS(I,SLOT).EQ.0.) FLUX(I,SLOT)   = 1./WORK4(I)
         END DO
      END DO

      RETURN
      END

