CSHOW
C SHOW N1 N2 File -- Types out one line summary on a slot
C
C Parameters:
C
C      N1  -- First slot that you require information on.
C      N2  -- Last slot that you require information on.
C      File - Name of a file if you want to write information to disk
C
C If you type "SHOW \" rather than taking last arguments, it will
C type information on all filled slots.
CSHOW
CFLIS
C FLIS N1 N2 File Nitem Item1 Item2 Item3 etc -- Types full header information
C
C Parameters:
C
C      N1  -- First slot that you require information on.
C      N2  -- Last slot that you require information on.
C      File - Name of a file if you want to write information to disk
C      Nitem- Number of items to list (up to 10, but 'all' counts as
C             a single item and will cause everything to be listed)
C      Item1- Names of first header item you want to list. Put = all
C             to list everything.
C      Item2- etc. As far as possible the routine will try to list
C             one spectrum per line. The names must be unique otherwise
C             nothing will be listed.
CFLIS
      SUBROUTINE HEDLIS(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &     MXPIX, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, FULL, SLOTS, MXSLOTS, CLOBBER, MUTE, IFAIL)
C     
C     List header information, allowing selection criteria to be applied.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXPIX)    -- Array for spectra in counts 
C     <  R     ERRORS(MXPIX)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXPIX)      -- Equivalent fluxes to COUNTS
C     >  I     MXPIX            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precision selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  L     FULL               -- True for full listing.
C     >  I     SLOTS(MXSLOTS)     -- Work array for slot list
C     >  I     MXSLOTS            -- Size of work array
C     L     CLOBBER            -- Files overwritten on output
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXPIX, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MXPIX), ERRORS(MXPIX), FLUX(MXPIX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
      LOGICAL ALL, FULL, SELECT, ESAMECI, DEFAULT
      LOGICAL CLOBBER, MUTE
C     
C     Local variables
C     
      INTEGER I, J, K, N, NS
      INTEGER NSKIP, NEMP,  NCOM, MXITEM, NITEM
      REAL W1, W2, W3, Z1, Z2, Z3
      CHARACTER*256 STRING
      PARAMETER (MXITEM=10)
      CHARACTER*16 ITEM(MXITEM)
      CHARACTER*64 FILE, PROMPT
      INTEGER SLOT1, SLOT2, IFAIL, LENSTR
      INTEGER   MAXSPEC
      DOUBLE PRECISION ANGST
      CHARACTER*32 CVAL
      DOUBLE PRECISION DVAL
      REAL RVAL
      INTEGER IVAL
C     
      DATA SLOT1, SLOT2, NITEM/1,1,1/
      DATA ITEM/'ALL',' ',' ',' ',' ',' ',' ',' ',' ',' '/ 
C     
      MAXSPEC = MIN(MXPIX/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
      CALL INTR_IN('First slot to list', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NSPLIT.EQ.1 .AND. DEFAULT) THEN
         SLOT1 = 1
         SLOT2 = MAXSPEC      
      END IF
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to list', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 prompts for list'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra'
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
      FILE = ' '
      CALL CHAR_IN('File to dump to (<CR> for terminal only)', 
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      IF(FULL) THEN
         CALL INTR_IN('Number of items to list', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, NITEM, 1, MXITEM, IFAIL)
         IF(IFAIL.NE.0) GOTO 999
         ALL = .FALSE.
         DO I = 1, NITEM
            IF(I.LE.9) THEN
               PROMPT = 'Item [ ]'
               WRITE(PROMPT(7:7),'(I1)') I
            ELSE
               PROMPT = 'Item [  ]'
               WRITE(PROMPT(7:8),'(I2)') I
            END IF
            CALL CHAR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &           DEFAULT, ITEM(I), IFAIL)
            ALL = ALL .OR. ESAMECI(ITEM(I),'ALL')
         END DO
      END IF
C     
      NSKIP = 0
      NEMP  = 0
      IF(FILE.NE.' ') THEN
         IF(CLOBBER) THEN
            OPEN(UNIT=47,FILE=FILE,STATUS='UNKNOWN',IOSTAT=IFAIL)
         ELSE
            OPEN(UNIT=47,FILE=FILE,STATUS='NEW',IOSTAT=IFAIL)
         END IF
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to open ',FILE
            GOTO 999
         END IF
      END IF
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF(NPIX(SLOT).GT.0 .AND. 
     &        SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &        HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &        MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &        VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &        VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &        MXSDOUB, MXSINTR, MXSREAL)) THEN
C     
            IF(NSKIP.EQ.1 .AND. NEMP.EQ.0) THEN
               WRITE(*,*) 'Skipped slot ',SLOT-1
            ELSE IF(NSKIP.EQ.0 .AND. NEMP.EQ.1) THEN
               WRITE(*,*) 'Slot ',SLOT-1,' empty.'
            ELSE IF(NSKIP.EQ.0 .AND. NEMP.GT.1) THEN
               WRITE(*,*) 'Slots ',SLOT-NEMP,' to ',SLOT-1,' empty.'
            ELSE IF(NSKIP.GT.1 .AND. NEMP.EQ.0) THEN
               WRITE(*,*) 'Skipped slots ',SLOT-NSKIP,' to ',SLOT-1
            ELSE IF(NSKIP.GT.0 .AND. NEMP.GT.0) THEN
               WRITE(*,*) NSKIP,' skipped and ',NEMP,' empty slots'
               WRITE(*,*) 'from slots ',SLOT-NSKIP-NEMP,' to ',SLOT-1
            END IF   
            NSKIP = 0
            NEMP = 0
            IF(FULL .AND. ALL) WRITE(*,*) ' ' 
C     
C     Search for standard header items 
C     'OBJECT', 'DWELL', 'UTC', 'YEAR', 'MONTH', 'DAY'
C     
            IF(.NOT.FULL .OR. (FULL .AND. ALL) ) THEN
               CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &              NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &              NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &              MXINTR, MXREAL, STRING, IFAIL)
               IF(.NOT.(FILE.NE.' ' .AND. MUTE)) 
     &              WRITE(*,*) STRING(:LENSTR(STRING))
               IF(FILE.NE.' ') 
     &              WRITE(47,'(1X,A)',ERR=999) STRING(:LENSTR(STRING))
            END IF
C     
            IF(FULL .AND. ALL) THEN
               WRITE(*,*) ' '
               WRITE(*,*) NPIX(SLOT),' pixels. ',NARC(SLOT),
     &              ' arc coefficients.'
               IF(FILE.NE.' ') THEN
                  WRITE(47,*,ERR=999) ' '
                  WRITE(47,*,ERR=999) NPIX(SLOT),' pixels. ',NARC(SLOT),
     &                 ' arc coefficients.'
               END IF
               IF(NARC(SLOT).NE.0) THEN
                  Z1 = 0.5
                  Z3 = REAL(NPIX(SLOT))+0.5
                  Z2 = (Z1+Z3)/2
                  W1 = REAL(ANGST(Z1, NPIX(SLOT), NARC(SLOT), 
     &                 ARC(1,SLOT), MXARC))
                  W2 = REAL(ANGST(Z2, NPIX(SLOT), NARC(SLOT), 
     &                 ARC(1,SLOT), MXARC))
                  W3 = REAL(ANGST(Z3, NPIX(SLOT), NARC(SLOT), 
     &                 ARC(1,SLOT), MXARC))
                  WRITE(*,*) 'Start, middle, end: ',W1,W2,W3
                  WRITE(*,*) 'Mean dispersion ',
     &                 (W3-W1)/REAL(NPIX(SLOT)),' angstroms/pixel.'
                  IF(FILE.NE.' ') THEN
                     WRITE(47,*,ERR=999) 'Start, middle, end: ',W1,W2,W3
                     WRITE(47,*,ERR=999) 'Mean dispersion ',
     &                    (W3-W1)/REAL(NPIX(SLOT)),' angstroms/pixel.'
                  END IF           
               END IF
               DO J = 1, NCHAR(SLOT)
                  WRITE(*,*) 'C: ',NMCHAR(J,SLOT),' ',HDCHAR(J,SLOT)
                  IF(FILE.NE.' ') 
     &                 WRITE(47,'(1X,4A)',ERR=999) 
     &                 'C: ',NMCHAR(J,SLOT),' ',HDCHAR(J,SLOT)
               END DO
               DO J = 1, NDOUB(SLOT)
                  WRITE(*,*) 'D: ',NMDOUB(J,SLOT),' ',HDDOUB(J,SLOT)
                  IF(FILE.NE.' ') 
     &                 WRITE(47,'(1X,3A,G21.14)',ERR=999) 
     &                 'D: ',NMDOUB(J,SLOT),' ',HDDOUB(J,SLOT)
               END DO
               DO J = 1, NINTR(SLOT)
                  WRITE(*,*) 'I: ',NMINTR(J,SLOT),' ',HDINTR(J,SLOT)
                  IF(FILE.NE.' ') 
     &                 WRITE(47,'(1X,3A,I9)',ERR=999) 
     &                 'I: ',NMINTR(J,SLOT),' ',HDINTR(J,SLOT)
               END DO
               DO J = 1, NREAL(SLOT)
                  WRITE(*,*) 'R: ',NMREAL(J,SLOT),' ',HDREAL(J,SLOT)
                  IF(FILE.NE.' ') 
     &                 WRITE(47,'(1X,3A,G14.7)',ERR=999) 
     &                 'R: ',NMREAL(J,SLOT),' ',HDREAL(J,SLOT)
               END DO
            ELSE IF(FULL) THEN
C     
C     Search for specific header items. First check total length needed.
C     
               N = 5
               DO K = 1, NITEM
                  CALL HGETC(ITEM(K), CVAL, SLOT, MXSPEC, NMCHAR, 
     &                 HDCHAR, NCHAR, MXCHAR, IFAIL)
                  IF(IFAIL.EQ.0) N = N + 33
                  CALL HGETD(ITEM(K), DVAL, SLOT, MXSPEC, NMDOUB, 
     &                 HDDOUB, NDOUB, MXDOUB, IFAIL)
                  IF(IFAIL.GT.0) N = N + 24
                  CALL HGETI(ITEM(K), IVAL, SLOT, MXSPEC, NMINTR, 
     &                 HDINTR, NINTR, MXINTR, IFAIL)
                  IF(IFAIL.GT.0) N = N + 13
                  CALL HGETR(ITEM(K), RVAL, SLOT, MXSPEC, NMREAL, 
     &                 HDREAL, NREAL, MXREAL, IFAIL)
                  IF(IFAIL.GT.0) N = N + 16
               END DO
C     
C     Now build strings or output directly
C     
               STRING = ' '
               WRITE(STRING,'(I5)') SLOT
               NS = 5
               DO K = 1, NITEM
                  CALL HGETC(ITEM(K), CVAL, SLOT, MXSPEC, NMCHAR, 
     &                 HDCHAR, NCHAR, MXCHAR, IFAIL)
                  IF(IFAIL.EQ.0) THEN
                     IF(N.GT.79 .AND. (FILE.EQ.' ' .OR. .NOT.MUTE))
     &                    WRITE(*,*) 
     &                    'Slot ',SLOT,', C: ',ITEM(K),' ',CVAL
                     IF(N.GT.256 .AND. FILE.NE.' ')
     &                    WRITE(47,*,ERR=999) 
     &                    'Slot ',SLOT,', C: ',ITEM(K),' ',CVAL
                     IF(N.LE.79 .OR. (FILE.NE.' ' .AND. N.LE.256)) THEN 
                        STRING(NS+1:NS+32) = CVAL
                        NS = NS + 33
                     END IF
                  END IF
C     
                  CALL HGETD(ITEM(K), DVAL, SLOT, MXSPEC, NMDOUB, 
     &                 HDDOUB, NDOUB, MXDOUB, IFAIL)
                  IF(IFAIL.EQ.0) THEN
                     IF(N.GT.79 .AND. (FILE.EQ.' ' .OR. .NOT.MUTE))
     &                    WRITE(*,*) 
     &                    'Slot ',SLOT,', D: ',ITEM(K),' ',DVAL
                     IF(N.GT.256 .AND. FILE.NE.' ')
     &                    WRITE(47,*,ERR=999) 
     &                    'Slot ',SLOT,', D: ',ITEM(K),' ',DVAL
                     IF(N.LE.79 .OR. (FILE.NE.' ' .AND. N.LE.256)) THEN 
                        WRITE(STRING(NS+1:NS+23),'(1PG23.16E2)') 
     &                       DVAL
                        NS = NS + 24
                     END IF
                  END IF
C     
                  CALL HGETI(ITEM(K), IVAL, SLOT, MXSPEC, NMINTR, 
     &                 HDINTR, NINTR, MXINTR, IFAIL)
                  IF(IFAIL.EQ.0) THEN
                     IF(N.GT.79 .AND. (FILE.EQ.' ' .OR. .NOT.MUTE))
     &                    WRITE(*,*) 
     &                    'Slot ',SLOT,', I: ',ITEM(K),' ',IVAL
                     IF(N.GT.256 .AND. FILE.NE.' ')
     &                    WRITE(47,*,ERR=999) 
     &                    'Slot ',SLOT,', I: ',ITEM(K),' ',IVAL
                     IF(N.LE.79 .OR. (FILE.NE.' ' .AND. N.LE.256)) THEN 
                        WRITE(STRING(NS+1:NS+12),'(I12)') 
     &                       IVAL
                        NS = NS + 13
                     END IF
                  END IF
C     
                  CALL HGETR(ITEM(K), RVAL, SLOT, MXSPEC, NMREAL, 
     &                 HDREAL, NREAL, MXREAL, IFAIL)
                  IF(IFAIL.EQ.0) THEN
                     IF(N.GT.79 .AND. (FILE.EQ.' ' .OR. .NOT.MUTE))
     &                    WRITE(*,*) 
     &                    'Slot ',SLOT,', R: ',ITEM(K),' ',RVAL
                     IF(N.GT.256 .AND. FILE.NE.' ')
     &                    WRITE(47,*,ERR=999) 
     &                    'Slot ',SLOT,', R: ',ITEM(K),' ',RVAL
                     IF(N.LE.79 .OR. (FILE.NE.' ' .AND. N.LE.256)) THEN 
                        WRITE(STRING(NS+1:NS+23),'(1PG15.7E2)') 
     &                       RVAL
                        NS = NS + 16
                     END IF
                  END IF
               END DO
               IF(FILE.NE.' ' .AND. N.LE.256) 
     &              WRITE(47,*,ERR=999) STRING(:LENSTR(STRING))
               IF(N.LE.79 .AND. (FILE.EQ.' ' .OR. .NOT.MUTE))
     &              WRITE(*,*) STRING(:LENSTR(STRING))
            END IF
         ELSE IF(NPIX(SLOT).EQ.0) THEN
            NEMP = NEMP + 1
         ELSE
            NSKIP = NSKIP + 1 
         END IF
      END DO
      IF(NSKIP.EQ.1 .AND. NEMP.EQ.0) THEN
         WRITE(*,*) 'Skipped slot ',SLOTS(NSLOTS)
      ELSE IF(NSKIP.EQ.0 .AND. NEMP.EQ.1) THEN
         WRITE(*,*) 'Slot ',SLOTS(NSLOTS),' empty.'
      ELSE IF(NSKIP.EQ.0 .AND. NEMP.GT.1) THEN
         WRITE(*,*) 'Slots ',SLOTS(NSLOTS)-NEMP+1,' to ',
     &        SLOTS(NSLOTS),' empty.'
      ELSE IF(NSKIP.GT.1 .AND. NEMP.EQ.0) THEN
         WRITE(*,*) 'Skipped slots ',SLOTS(NSLOTS)-NSKIP+1,
     &        ' to ',SLOTS(NSLOTS)
      ELSE IF(NSKIP.GT.0 .AND. NEMP.GT.0) THEN
         WRITE(*,*) NSKIP,' skipped and ',NEMP,' empty slots'
         WRITE(*,*) 'from slots ',SLOTS(NSLOTS)-NSKIP-NEMP+1,
     &        ' to ',SLOTS(NSLOTS)
      END IF   
 999  IF(FILE.NE.' ') CLOSE(UNIT=47)
      RETURN
      END





