*EDIT
* EDIT N1 N2 -- Edit the headers of slots.
*
* Parameters
*        N1, N2 -- Slots to edit
*
* Primarily interactive. You can do things like read a file containing
* values of some header item you want to set, or delete a header item
* from the spectra, or input new values from the terminal. It is case
* independent and the full names of items need not be given, but it 
* this means care must be taken to ensure that header items are not
* overwritten because of a match to a different item. e.g. if you specify
* the header name HJ, this would match HJD.
*
* Command FILE allows you to read a fairly specific format and can be useful
* for setting up headers when you first read in spectra in a non-standard
* format. The format of the file as follows:
*
* 1st line: a series of variable names. Enclose in quotes if the names
*           contain blanks or commas.
* 2nd line: series of data types for each variable C=Character,D=Double,
*           I=Integer,R=Real
*
* Remaining lines, values of header parameter for each spectrum. If any
* are character strings with blanks or commas, enclose in quotes.
*
* Example:
*
*          UT            Date          "Hour Angle"
*          D             C              D
*          11.0234       11/04/93       0.567
*          11.1256       11/04/93       0.669
*
* FILE will not accept any discrepant lines.
*
* The command ANY is less severe but can only tackle one column at a go
* and you have first to give the header item's name and type as well as
* the column that you want to read. This option will skip over unsuitable 
* data. It is useful for setting header values from some output file produced 
* by MOLLY such as a light curve file.
*
*EDIT
      SUBROUTINE HEDCHG(SPLIT, NSPLIT, MXSPLIT, MXBUFF, MXSPEC, 
     &MAXPX, NPIX, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &MXDOUB, MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL, SLOTS, MXSLOTS, 
     &MUTE, IFAIL)
*
* Master routine for altering headers either by reading in
* a file or interactively.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*                                incremented and returned by routine.
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER MAXSPEC
      INTEGER NPIX(MXSPEC)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Local variables
*
      INTEGER I, J,  L,  N
      CHARACTER*64 FILENAME, COMMAND
      CHARACTER*256 STRING
      CHARACTER*3 REPLY
      INTEGER MAXVAR
      PARAMETER (MAXVAR=40)
      CHARACTER*16 NAMES(MAXVAR), ITEM, NITEM
      CHARACTER*32 VARS(MAXVAR)
      CHARACTER*1  TYPES(MAXVAR), ITYPE, TYPE
      INTEGER SLOT1, SLOT2, IFAIL, NEW, NCOM
      INTEGER LINE, LUNIT, NSTR, LITEM
      LOGICAL SELECT, DEFAULT, MUTE
      INTEGER IVAL, NCOL
      REAL    RVAL
      DOUBLE PRECISION DVAL
      CHARACTER*32 CVAL
*
* Functions
*
      INTEGER LENSTR
      LOGICAL ESAMECI, SAMECI
      SAVE SLOT1, SLOT2
*
      DATA SLOT1, SLOT2, LUNIT/1,1,28/
      DATA REPLY/'F'/
      DATA FILENAME/'header'/
      DATA ITEM, NITEM, ITYPE, NCOL/'Object', 'New name', 'C', 1/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot to edit', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to edit', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         IFAIL = 1
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to edit'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) THEN
            IFAIL = 1
            GOTO 999
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
*
10    WRITE(*,*) ' '
      WRITE(*,*) 'Commands:'
      WRITE(*,*) ' '
      WRITE(*,*) '  clear  -- Clear headers'
      WRITE(*,*) '  file   -- Read in headers from special file'
      WRITE(*,*) '  any    -- Read in a column from a file'
      WRITE(*,*) '  term   -- Entry from terminal.'
      WRITE(*,*) '  del    -- Delete header item.'
      WRITE(*,*) '  ren    -- Rename header item.'
      WRITE(*,*) '  quit   -- Quit'
20    WRITE(*,*) ' '
      WRITE(*,'(A,$)') 'edit> '
      READ(*,'(A)') COMMAND
*
      IF(SAMECI(COMMAND,'CLEAR')) THEN
        WRITE(*,*) 'Are you sure ? [n] '
        READ(*,'(A)') STRING
        IF(ESAMECI(STRING,'Y')) THEN
          DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            NCHAR(SLOT) = 0
            NDOUB(SLOT) = 0
            NINTR(SLOT) = 0
            NREAL(SLOT) = 0
          END DO
          WRITE(*,*) 'Headers cleared'
          GOTO 20
        ELSE
          GOTO 20
        END IF
      ELSE IF(SAMECI(COMMAND, 'FILE') .OR. 
     &       SAMECI(COMMAND, 'ANY')) THEN
         L = LENSTR(FILENAME)
         WRITE(*,'(A,A,A,$)') 'Enter filename [',FILENAME(:L),']: '
         READ(*,'(A)') STRING
         IF(STRING.NE.' ') FILENAME = STRING
         OPEN(UNIT=LUNIT, FILE=FILENAME, STATUS='OLD', IOSTAT=IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Could not open ',FILENAME
            GOTO 999
         END IF
C     
C     Read first line of variable names
C     
         IF(SAMECI(COMMAND,'ANY')) THEN
            WRITE(*,'(A,A,A,$)') 'Enter name of item to set [',
     &           ITEM(:LENSTR(ITEM)),'] '
            READ(*,'(A)') STRING
            IF(STRING.NE.' ') ITEM = STRING
            LITEM = LENSTR(ITEM)
            WRITE(*,'(A,A,A,$)') 'Enter type (C,D,I,R) [',ITYPE,'] '
            READ(*,'(A)') REPLY
            IF(REPLY.NE.' ' .AND. .NOT.ESAMECI(REPLY,'C') .AND. 
     &           .NOT.ESAMECI(REPLY,'D') .AND. .NOT.ESAMECI(REPLY,'I')
     &           .AND. .NOT.ESAMECI(REPLY,'R')) THEN
               WRITE(*,*) 'Invalid type'                   
               GOTO 20
            END IF
            IF(REPLY.NE.' ') ITYPE = REPLY
            LINE = 0
            WRITE(*,'(A,I3,A,$)') 'Which column to read [',NCOL,'] '
            READ(*,'(A)') STRING
            IF(STRING.NE.' ') READ(STRING,*,ERR=20) NCOL
            IF(NCOL.LT.1) THEN
               WRITE(*,*) 'Invalid column = ',NCOL
               NCOL = 1
               GOTO 20
            END IF
         ELSE
            READ(LUNIT, '(A)',IOSTAT=IFAIL) STRING
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Failed on first line'
               GOTO 999
            END IF
            CALL CSPLIT(STRING, NAMES, NSTR, MAXVAR, IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Failed to split first line'
               GOTO 999
            ELSE IF(NSTR.EQ.0) THEN
               WRITE(*,*) 'No names found in first line'
               GOTO 999
            END IF
C     
C     Read types
C     
            READ(LUNIT, '(A)',IOSTAT=IFAIL) STRING
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Failed to read line 2'
               GOTO 999
            END IF
            L = LEN(STRING)
            N = 0
            DO I = 1, L
               IF(ESAMECI(STRING(I:I),'C')) THEN
                  N = N + 1
                  TYPES(N) = 'C'
               ELSE IF(ESAMECI(STRING(I:I),'D')) THEN
                  N = N + 1
                  TYPES(N) = 'D'
               ELSE IF(ESAMECI(STRING(I:I),'I')) THEN
                  N = N + 1
                  TYPES(N) = 'I'
               ELSE IF(ESAMECI(STRING(I:I),'R')) THEN
                  N = N + 1
                  TYPES(N) = 'R'
               ELSE IF(STRING(I:I).NE.' ' .AND. 
     &                 STRING(I:I).NE.',') THEN
                  WRITE(*,*) 'Could not identify type ',STRING(I:I)
                  GOTO 999
               END IF
               IF(N.EQ.NSTR) GOTO 100
            END DO
 100        CONTINUE
            DO I = 1, NSTR
               WRITE(*,*) 'Variable ',I,' name: ',NAMES(I),
     &              ', type: ',TYPES(I)
            END DO
            LINE = 2
         END IF
C     
C     Read and set values
C     
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
*     
            IF(NPIX(SLOT).LE.0) GOTO 200
            IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &           HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &           MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &           NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &           NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &           MXSINTR, MXSREAL)) GOTO 200
C
 150        READ(LUNIT, '(A)', IOSTAT=IFAIL) STRING
            IF(IFAIL.EQ.0) THEN
               CALL CSPLIT(STRING, VARS, NEW, MAXVAR, IFAIL)
               LINE = LINE + 1
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Failed to split line ',LINE
                  GOTO 999
               END IF
               IF(SAMECI(COMMAND,'ANY')) THEN
                  IF(NEW.LT.NCOL) THEN
                     WRITE(*,*) 'Only ',NEW,
     &                    ' items found on line ',LINE
                     GOTO 999
                  END IF
C
C     Check for clashes
C
                  CALL HCLASH(ITEM, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &                 NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &                 MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, 
     &                 NMREAL, HDREAL, NREAL, MXREAL, TYPE, IFAIL)
                  
                  IF(IFAIL.EQ.2) THEN
                     WRITE(*,*) 
     &                    'Already more than one header item called ',
     &                    ITEM
                     GOTO 999
                  END IF
                  IF(ESAMECI(ITYPE,'C')) THEN
                     IF(IFAIL.EQ.1 .AND. TYPE.NE.'C') THEN
                        WRITE(*,*) 
     &                       'There is already a header item called ',
     &                       ITEM
                        WRITE(*,*) 'but it has type ',TYPE
                        GOTO 999
                     END IF
                     CALL HSETC(ITEM, VARS(NCOL), SLOT, MXSPEC, 
     &                    NMCHAR, HDCHAR, NCHAR, MXCHAR, IFAIL)
                  ELSE IF(ESAMECI(ITYPE,'D')) THEN
                     IF(IFAIL.EQ.1 .AND. TYPE.NE.'D') THEN
                        WRITE(*,*) 
     &                       'There is already a header item called ',
     &                       ITEM
                        WRITE(*,*) 'but it has type ',TYPE
                        GOTO 999
                     END IF
                     READ(VARS(NCOL),*,IOSTAT=IFAIL) DVAL
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Skipped line ',LINE
                        GOTO 150
                     END IF
                     CALL HSETD(ITEM, DVAL, SLOT, MXSPEC, 
     &                    NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
                  ELSE IF(ESAMECI(ITYPE,'I')) THEN
                     IF(IFAIL.EQ.1 .AND. TYPE.NE.'I') THEN
                        WRITE(*,*) 
     &                       'There is already a header item called ',
     &                       ITEM
                        WRITE(*,*) 'but it has type ',TYPE
                        GOTO 999
                     END IF
                     READ(VARS(NCOL),*,IOSTAT=IFAIL) IVAL
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Skipped line ',LINE
                        GOTO 150
                     END IF
                     CALL HSETI(ITEM, IVAL, SLOT, MXSPEC, 
     &                    NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
                  ELSE IF(ESAMECI(ITYPE,'R')) THEN
                     IF(IFAIL.EQ.1 .AND. TYPE.NE.'R') THEN
                        WRITE(*,*) 
     &                       'There is already a header item called ',
     &                       ITEM
                        WRITE(*,*) 'but it has type ',TYPE
                        GOTO 999
                     END IF
                     READ(VARS(NCOL),*,IOSTAT=IFAIL) RVAL
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Skipped line ',LINE
                        GOTO 150
                     END IF
                     CALL HSETR(ITEM, RVAL, SLOT, MXSPEC, 
     &                    NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
                  END IF
                  IF(IFAIL.EQ.1) THEN
                     WRITE(*,*) 'Run out of room in slot ',SLOT
                     WRITE(*,*) ITEM(:LITEM),' not set.'
                  ELSE IF(IFAIL.EQ.2) THEN
                     WRITE(*,*) 'More than one match found for ',
     &                    ITEM(:LITEM)
                     WRITE(*,*) 'Nothing changed in slot ',SLOT
                  END IF
               ELSE 
                  IF(NEW.NE.NSTR) THEN
                     WRITE(*,*) 'Found ',NEW,' items on line ',LINE
                     WRITE(*,*) 'Expecting ',NSTR
                     GOTO 999
                  END IF
C     
C     Set values
C
                  DO J = 1, NEW
C     
C     Check for clashes
C     
                     CALL HCLASH(NAMES(J), SLOT, MXSPEC, NMCHAR, 
     &                    HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, 
     &                    NDOUB, MXDOUB, NMINTR, HDINTR, NINTR, 
     &                    MXINTR, NMREAL, HDREAL, NREAL, MXREAL, 
     &                    TYPE, IFAIL)
                     
                     IF(IFAIL.EQ.2) THEN
                        WRITE(*,*) 
     &                       'Already more than one header'//
     &                       ' item called ',NAMES(J)
                        GOTO 999
                     END IF
                     IF(ESAMECI(TYPES(J),'C')) THEN
                        IF(IFAIL.EQ.1 .AND. TYPE.NE.'C') THEN
                           WRITE(*,*) 
     &                          'There is already a header'//
     &                          ' item called ',NAMES(J)
                           WRITE(*,*) 'but it has type ',TYPE
                           GOTO 999
                        END IF
                        CALL HSETC(NAMES(J), VARS(J), SLOT, MXSPEC, 
     &                       NMCHAR, HDCHAR, NCHAR, MXCHAR, IFAIL)
                     ELSE IF(ESAMECI(TYPES(J),'D')) THEN
                        IF(IFAIL.EQ.1 .AND. TYPE.NE.'D') THEN
                           WRITE(*,*) 
     &                          'There is already a header'//
     &                          ' item called ',NAMES(J)
                           WRITE(*,*) 'but it has type ',TYPE
                           GOTO 999
                        END IF
                        READ(VARS(J),*,IOSTAT=IFAIL) DVAL
                        IF(IFAIL.NE.0) THEN
                           WRITE(*,*) 'Could not translate ',VARS(J)
                           WRITE(*,*) 'as DOUBLE PRECISION, line ',LINE
                           GOTO 999
                        END IF
                        CALL HSETD(NAMES(J), DVAL, SLOT, MXSPEC, 
     &                       NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
                     ELSE IF(ESAMECI(TYPES(J),'I')) THEN
                        IF(IFAIL.EQ.1 .AND. TYPE.NE.'I') THEN
                           WRITE(*,*) 
     &                          'There is already a header'//
     &                          ' item called ',NAMES(J)
                           WRITE(*,*) 'but it has type ',TYPE
                           GOTO 999
                        END IF
                        READ(VARS(J),*,IOSTAT=IFAIL) IVAL
                        IF(IFAIL.NE.0) THEN
                           WRITE(*,*) 'Could not translate ',VARS(J)
                           WRITE(*,*) 'as INTEGER, line ',LINE
                           GOTO 999
                        END IF
                        CALL HSETI(NAMES(J), IVAL, SLOT, MXSPEC, 
     &                       NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
                     ELSE IF(ESAMECI(TYPES(J),'R')) THEN
                        IF(IFAIL.EQ.1 .AND. TYPE.NE.'R') THEN
                           WRITE(*,*) 
     &                          'There is already a header'//
     &                          ' item called ',NAMES(J)
                           WRITE(*,*) 'but it has type ',TYPE
                           GOTO 999
                        END IF
                        READ(VARS(J),*,IOSTAT=IFAIL) RVAL
                        IF(IFAIL.NE.0) THEN
                           WRITE(*,*) 'Could not translate ',VARS(J)
                           WRITE(*,*) 'as REAL, line ',LINE
                           GOTO 999
                        END IF
                        CALL HSETR(NAMES(J), RVAL, SLOT, MXSPEC, 
     &                       NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
                     END IF
                     IF(IFAIL.EQ.1) THEN
                        WRITE(*,*) 'Failed to set item value = ',VARS(J)
                        WRITE(*,*) 'No more room in headers'
                     ELSE IF(IFAIL.EQ.2) THEN
                        LITEM = LENSTR(NAMES(J))
                        WRITE(*,*) 'Failed to set item value = ',VARS(J)
                        WRITE(*,*) 'More than one match to ',
     &                       NAMES(J)(:LITEM)
                     END IF
                  END DO
 200              CONTINUE
               END IF
            ELSE
               GOTO 999
            END IF
         END DO
 999     CLOSE(UNIT=LUNIT)
*     
      ELSE IF(SAMECI(COMMAND,'TERM')) THEN
         WRITE(*,'(A,A,A,$)') 'Enter name of item to change [',
     &        ITEM(:LENSTR(ITEM)),'] '
         READ(*,'(A)') STRING
         IF(STRING.NE.' ') ITEM = STRING
         WRITE(*,'(A,A,A,$)') 'Enter type (C,D,I,R) [',ITYPE,'] '
         READ(*,'(A)') REPLY
         IF(REPLY.NE.' ' .AND. .NOT.ESAMECI(REPLY,'C') .AND. 
     &        .NOT.ESAMECI(REPLY,'D') .AND. .NOT.ESAMECI(REPLY,'I')
     &        .AND. .NOT.ESAMECI(REPLY,'R')) THEN
            WRITE(*,*) 'Invalid type'                   
            GOTO 20
         END IF
         IF(REPLY.NE.' ') ITYPE = REPLY
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
*     
            IF(NPIX(SLOT).LE.0) GOTO 300
            IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &           HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &           MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &           NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &           NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &           MXSINTR, MXSREAL)) GOTO 300
C     
C     Check for clashes
C     
            CALL HCLASH(ITEM, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &           NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &           MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, 
     &           NMREAL, HDREAL, NREAL, MXREAL, TYPE, IFAIL)
          
            IF(IFAIL.EQ.2) THEN
               WRITE(*,*) 
     &              'Already more than one header item called ',
     &              ITEM
               GOTO 999
            END IF
            
            WRITE(*,*) 'Slot ',SLOT
            LITEM = LENSTR(ITEM)
            IF(ESAMECI(ITYPE,'C')) THEN
               IF(IFAIL.EQ.1 .AND. TYPE.NE.'C') THEN
                  WRITE(*,*) 
     &                 'There is already a header item called ',
     &                 ITEM
                  WRITE(*,*) 'but it has type ',TYPE
                  WRITE(*,*) 'Slot will be skipped'
                  GOTO 300
               END IF
               CALL HGETC(ITEM, CVAL, SLOT, MXSPEC, 
     &              NMCHAR, HDCHAR, NCHAR, MXCHAR, IFAIL)
               IF(IFAIL.EQ.0) 
     &              WRITE(*,*) 'Current value of ',ITEM(:LITEM),
     &              ' = [',CVAL(:LENSTR(CVAL)),']'
            ELSE IF(ESAMECI(ITYPE,'D')) THEN
               IF(IFAIL.EQ.1 .AND. TYPE.NE.'D') THEN
                  WRITE(*,*) 
     &                 'There is already a header item called ',
     &                 ITEM
                  WRITE(*,*) 'but it has type ',TYPE
                  WRITE(*,*) 'Slot will be skipped'
                  GOTO 300
               END IF
               CALL HGETD(ITEM, DVAL, SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               IF(IFAIL.EQ.0)
     &              WRITE(*,*) 'Current value of ',ITEM(:LITEM),
     &              ' = ',DVAL
            ELSE IF(ESAMECI(ITYPE,'I')) THEN
               IF(IFAIL.EQ.1 .AND. TYPE.NE.'I') THEN
                  WRITE(*,*) 
     &                 'There is already a header item called ',
     &                 ITEM
                  WRITE(*,*) 'but it has type ',TYPE
                  WRITE(*,*) 'Slot will be skipped'
                  GOTO 300
               END IF
               CALL HGETI(ITEM, IVAL, SLOT, MXSPEC, 
     &              NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
               IF(IFAIL.EQ.0) 
     &              WRITE(*,*) 'Current value of ',ITEM(:LITEM),
     &              ' = ',IVAL
            ELSE IF(ESAMECI(ITYPE,'R')) THEN
               IF(IFAIL.EQ.1 .AND. TYPE.NE.'R') THEN
                  WRITE(*,*) 
     &                 'There is already a header item called ',
     &                 ITEM
                  WRITE(*,*) 'but it has type ',TYPE
                  WRITE(*,*) 'Slot will be skipped'
                  GOTO 300
               END IF
               CALL HGETR(ITEM, RVAL, SLOT, MXSPEC, 
     &              NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
               IF(IFAIL.EQ.0) 
     &              WRITE(*,*) 'Current value of ',ITEM(:LITEM),
     &              ' = ',RVAL
            END IF                                                
            IF(IFAIL.EQ.1) THEN
               WRITE(*,*) ITEM(:LITEM),' not yet set.'
            ELSE IF(IFAIL.EQ.2) THEN
               WRITE(*,*) 'More than one match to ',ITEM(:LITEM)
               WRITE(*,*) 'Slot will be skipped.'
               GOTO 300
            END IF
            WRITE(*,*) 'Enter new value of ',ITEM(:LITEM)
            IF(IFAIL.EQ.0) WRITE(*,*) '<CR> to keep old value.'
            READ(*,'(A)') STRING
            IF(IFAIL.NE.0 .OR. STRING.NE.' ') THEN
               IF(ESAMECI(ITYPE,'C')) THEN
                  CVAL = STRING
                  CALL HSETC(ITEM, CVAL, SLOT, MXSPEC, 
     &                 NMCHAR, HDCHAR, NCHAR, MXCHAR, IFAIL)
               ELSE IF(ESAMECI(ITYPE,'D')) THEN
                  READ(STRING,*,IOSTAT=IFAIL) DVAL
                  IF(IFAIL.EQ.0) 
     &                 CALL HSETD(ITEM, DVAL, SLOT, MXSPEC, 
     &                 NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               ELSE IF(ESAMECI(ITYPE,'I')) THEN
                  READ(STRING,*,IOSTAT=IFAIL) IVAL
                  IF(IFAIL.EQ.0) 
     &                 CALL HSETI(ITEM, IVAL, SLOT, MXSPEC, 
     &                 NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
               ELSE IF(ESAMECI(ITYPE,'R')) THEN
                  READ(STRING,*,IOSTAT=IFAIL) RVAL
                  IF(IFAIL.EQ.0) 
     &                 CALL HSETR(ITEM, RVAL, SLOT, MXSPEC, 
     &                 NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
               END IF                                                
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Could not translate ',
     &                 STRING(:LENSTR(STRING))
                  WRITE(*,*) 'or headers full'
               END IF
            END IF
 300        CONTINUE
         END DO
      ELSE IF(SAMECI(COMMAND,'DEL')) THEN
        WRITE(*,'(A,A,A,$)') 'Enter name of item to delete [',
     &  ITEM(:LENSTR(ITEM)),'] '
        READ(*,'(A)') STRING
        IF(STRING.NE.' ') ITEM = STRING
        WRITE(*,'(A,A,A,$)') 'Enter type (C,D,I,R) [',ITYPE,'] '
        READ(*,'(A)') REPLY
        IF(REPLY.NE.' ' .AND. .NOT.ESAMECI(REPLY,'C') .AND. 
     &  .NOT.ESAMECI(REPLY,'D') .AND. .NOT.ESAMECI(REPLY,'I')
     &  .AND. .NOT.ESAMECI(REPLY,'R')) THEN
          WRITE(*,*) 'Invalid type'                   
          GOTO 20
        END IF
        IF(REPLY.NE.' ') ITYPE = REPLY
        DO I = 1, NSLOTS
          SLOT = SLOTS(I)
*
          IF(SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &    HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &    MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, VSCHAR, 
     &    NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, VSREAL, 
     &    NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &    MXSINTR, MXSREAL)) THEN
*
* Report values
*
            LITEM = LENSTR(ITEM)
            IF(ESAMECI(ITYPE,'C')) THEN
              CALL HDELC(ITEM, SLOT, MXSPEC, 
     &        NMCHAR, HDCHAR, NCHAR, MXCHAR, IFAIL)
            ELSE IF(ESAMECI(ITYPE,'D')) THEN
              CALL HDELD(ITEM, SLOT, MXSPEC, 
     &        NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(ESAMECI(ITYPE,'I')) THEN
              CALL HDELI(ITEM, SLOT, MXSPEC, 
     &        NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
            ELSE IF(ESAMECI(ITYPE,'R')) THEN
              CALL HDELR(ITEM, SLOT, MXSPEC, 
     &        NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
            END IF     
            IF(IFAIL.EQ.0) THEN       
              IF(.NOT.MUTE) 
     &        WRITE(*,*) ITEM(:LITEM),' deleted from slot ',SLOT
            ELSE IF(IFAIL.EQ.1) THEN 
              WRITE(*,*) ITEM(:LITEM),' not present in slot ',SLOT
            ELSE IF(IFAIL.EQ.2) THEN 
              WRITE(*,*) 'More than item matching ',ITEM(:LITEM),
     &        ' found in slot ',SLOT,'. No deletion has occurred.'
            END IF
          ELSE
            WRITE(*,*) 'Slot ',SLOT,' skipped.'
          END IF
        END DO
      ELSE IF(SAMECI(COMMAND,'REN')) THEN
        WRITE(*,'(A,A,A,$)') 'Enter name of item to rename [',
     &  ITEM(:LENSTR(ITEM)),'] '
        READ(*,'(A)') STRING
        IF(STRING.NE.' ') ITEM = STRING
        WRITE(*,'(A,A,A,$)') 'Enter new name of item [',
     &  NITEM(:LENSTR(NITEM)),'] '
        READ(*,'(A)') STRING
        IF(STRING.NE.' ') NITEM = STRING
        DO I = 1, NSLOTS
          SLOT = SLOTS(I)
*
          IF(SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &         HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &         NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &         MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &         NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &         NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &         MXSINTR, MXSREAL)) THEN
*
* Check that NITEM does not already exist, then rename ITEM
*
             CALL HRENAME(ITEM, NITEM, SLOT, MXSPEC, NMCHAR, 
     &            HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, 
     &            NDOUB, MXDOUB, NMINTR, HDINTR, NINTR, 
     &            MXINTR, NMREAL, HDREAL, NREAL, MXREAL, IFAIL)

             IF(IFAIL.EQ.0) THEN    
                IF(.NOT.MUTE) 
     &               WRITE(*,*) ITEM(:LENSTR(ITEM)),' renamed to ',
     &               NITEM(:LENSTR(NITEM)),' in slot ',SLOT 
             ELSE IF(IFAIL.EQ.1) THEN 
                WRITE(*,*) 'Could not find item ',
     &               ITEM(:LENSTR(ITEM)),' in slot ',SLOT
             ELSE IF(IFAIL.EQ.2) THEN
                WRITE(*,*) 'There seem to be multiple version of ',
     &               ITEM(:LENSTR(ITEM)),' in slot ',SLOT
             ELSE IF(IFAIL.EQ.3) THEN
                WRITE(*,*) NITEM(:LENSTR(NITEM)),
     &               ' already present in slot ',SLOT
             END IF
          ELSE
            WRITE(*,*) 'Slot ',SLOT,' skipped.'
          END IF
        END DO
      ELSE IF(SAMECI(COMMAND,'QUIT')) THEN
        IFAIL = 0
        RETURN
      ELSE
        GOTO 10
      END IF
      GOTO 20
      END
