CGSM
C GSM N1 N2 N3 FWHM -- Smooths data with a gaussian
C
C Parameters
C           N1, N2 -- Spectra to smooth
C           N3     -- First output slot
C           FWHM   -- Full width half-maximum of gaussian in pixels
CGSM
      SUBROUTINE GSM(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, SLOTS, MXSLOTS, WORK1, WORK2, WORK3, WORK4,
     &     WORK5, MXWORK, IFAIL)
C     
C     Gaussian convolution of data
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
C     >  I     MXSLOTS             -- Maximum number of entries
C     R     WORK1(MXWORK)
C     R     WORK2(MXWORK)
C     R     WORK3(MXWORK)
C     R     WORK4(MXWORK)
C     R     WORK5(MXWORK)
C     I     MXWORK
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK), WORK3(MXWORK)
      REAL WORK4(MXWORK), WORK5(MXWORK)
C     
C     Local variables
C     
      INTEGER I, J, K,  N, N1, N2
      REAL GET_FLX, GET_ERF, CFRAT
      DOUBLE PRECISION   SUM
      DOUBLE PRECISION SUM1, SUM2
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3,  OUT, LENSTR
      INTEGER IFAIL, NCOM, MAXSPEC,  NSM
      REAL SMAX, RATIO, EFAC, FWHM
      LOGICAL SELECT
      LOGICAL DEFAULT
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA FWHM/2./
C     
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
      CALL INTR_IN('First spectrum to smooth', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT2, SLOT1)
      CALL INTR_IN('Last spectrum to smooth', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) '0,0 only for list option'
         IFAIL = 1
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to smooth'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
C     
      SMAX = REAL(MXWORK)/3.
      CALL REAL_IN('FWHM for smoothing', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FWHM, 0., SMAX, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
C**************************************************************************
C     
C     Now smooth. Compute blurring array first
C     
      NSM = INT(3.*FWHM)+1
      EFAC = 1./2./(FWHM/2.3548)**2
      SUM = 0.D0
      DO J = 1, NSM
         WORK3(J) = EXP(-EFAC*REAL(J-1)**2)
         IF(J.EQ.1) THEN
            SUM = SUM + WORK3(J)
         ELSE
            SUM = SUM + 2.*WORK3(J)
         END IF
      END DO
      DO J = 1, NSM
         WORK3(J) = REAL(WORK3(J)/SUM)
      END DO
      OUT = SLOT3 - 1
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(.NOT.SELECT( SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &           NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &           MXREAL, MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &           NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &           NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &           MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
C     
C     Load work arrays
C     
            DO J = 1, NPIX(SLOT)
               WORK1(J) = GET_FLX(COUNTS(J,SLOT),FLUX(J,SLOT))
               WORK2(J) = GET_ERF(COUNTS(J,SLOT),ERRORS(J,SLOT),
     &              FLUX(J,SLOT))**2
            END DO
C     
C     Loop through pixels
C     
            DO J = 1, NPIX(SLOT)
               N1 = J - NSM + 1
               N2 = J + NSM - 1
               SUM1 = 0.D0
               SUM2 = 0.D0
               DO N = N1, N2
                  K = MAX(1,MIN(N,NPIX(SLOT)))
                  SUM1 = SUM1 + WORK3(ABS(N-J)+1)*WORK1(K)
                  SUM2 = SUM2 + WORK3(ABS(N-J)+1)*WORK2(K)
               END DO
               WORK4(J) = REAL(SUM1)
               WORK5(J) = REAL(SQRT(SUM2))
            END DO
C     
C     Now load results into output slot
C     
            OUT = OUT + 1
            DO J = 1, NPIX(SLOT)
               RATIO = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
               COUNTS(J,OUT) = RATIO*WORK4(J)
               ERRORS(J,OUT) = RATIO*WORK5(J)
               IF(COUNTS(J,OUT).EQ.0) THEN
                  FLUX(J,OUT)   = RATIO
               ELSE
                  FLUX(J,OUT)   = WORK4(J)
               END IF
            END DO
C     
C     Set headers 
C     
            CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &           MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
            CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
      END DO
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END
