CGROUP
C GROUP N1 N2 N3 NBIN METHOD WEIGHTS -- Combines spectra in groups, effectively giving 
C                                       higher signal, lower time resolution data.
C
C GROUP is useful if you have so many spectra that everything is slow and
C plots are so dense that you can't make anything out in them. I added it
C bceause of some HST spectra (12,000 of them).
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to average
C  N2    -- Slot number of last spectrum to average
C  N3    -- Slot in which to start 
C  NBIN  -- Number of spectra per group
C  METHOD - Averaging method. At present supports
C           U  -- Unit weights
C           D  -- Dwell weights
C           R  -- Response weights
C           V  -- Variance weights
C
C  WEIGHTS   -- file of weights. Whatever method is chosen, the weights can
C               be multiplied by individual weights first. <CR> to ignore
C               These can, for example, allow you to weight spectra with
C               a certain spin phase or whatever and provide a more flexible
C               method than straight selection.
C
C
C Response weights are proportional to the local ratio of COUNTS/FLUX
C and thus effectively add the counts together (optimum for photon
C counting data). Variance weights use a single value equal to the
C mean Signal/noise**2 for each spectrum.
C
C This differs slightly from AVERAGE and PBIN in that an attempt is made to 
C simulate the effect of just having made a longer exposure. Thus compared
C to the other methods, the counts and dwell are multiplied by the number
C of spectra in a bin. This works for response weights. The flux arrays
C are the same in any method.
C
C Selection is done. Spectra must have same length.
C
C Related command: AVERAGE, PBIN
C
CGROUP
      SUBROUTINE GROUP(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WORK2, WORK3, WORK4, MXWORK, 
     &     SLOTS, WSLOTS, WEIGHTS, PHASES, MXSLOTS, MUTE, IFAIL)
C     
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.
C     >  R     WORK1(MXWORK) Work arrays
C     >  R     WORK2(MXWORK)
C     >  R     WORK3(MXWORK)
C     >  R     WORK4(MXWORK)
C     >  D     DWORK1(MXWORK)
C     >  I     MXWORK        Size of work arrays
C     >  I     SLOTS(MXSLOTS)   Array for list of slot numbers
C     >  R     WSLOTS(MXSLOTS)  Array for list of weights 
C     >  I     MXSLOTS         Size of list arrays 
C     >  L     MUTE
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT, SLT
      INTEGER SLOTS(MXSLOTS)
      REAL WSLOTS(MXSLOTS), WEIGHTS(MXSLOTS)
      DOUBLE PRECISION PHASES(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J, NVAL, NCOM, NEMPTY, LENSTR
      REAL GET_FLX, GET_ERF, CFRAT, W, VAR, WINIT
      DOUBLE PRECISION  SUM1, SUM2
      REAL WONE
      CHARACTER*64 FILENAME
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3
      INTEGER  IFAIL, NSAME, NASAM, NW, MAXSPEC
      INTEGER  IV, NS, NGROUP, FIRST, LAST
      INTEGER NBIN
      REAL DWELL
      LOGICAL SELECT
      LOGICAL DEFAULT, WARN,  MUTE
      CHARACTER*1 METHOD
C     
      DATA METHOD/'R'/
      DATA SLOT1, SLOT2, SLOT3/1,2,3/
      DATA NGROUP/2/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
      CALL INTR_IN('First spectrum to group', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to group', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to group'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
C     
      CALL INTR_IN('First slot for grouped spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
      CALL INTR_IN('Number of spectra/group', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, NGROUP, 2, NSLOTS, IFAIL)
C     
C     Check spectra
C     
      NSAME = 0
      WARN  = .FALSE.
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).GT.0) THEN
            IF(NPIX(SLOT).GT.MXWORK) THEN
               WRITE(*,*) 'Too many pixels for work array'
               WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT),' pixels.'
               GOTO 999
            END IF
C     
            IF(METHOD.EQ.'D') THEN
               CALL HGETR('DWELL', W, SLOT, MXSPEC, NMREAL,
     &              HDREAL, NREAL, MXREAL, IFAIL)
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'No dwell for slot ',SLOT
                  GOTO 999
               END IF
            END IF 
C     
            IF(NSAME.EQ.0) THEN
               NSAME  = NPIX(SLOT)
               NASAM  = NARC(SLOT)
               IV     = SLOT
            ELSE IF(NSAME.NE.NPIX(SLOT)) THEN
               WRITE(*,*) 'Spectra are not all of the same length.'
               GOTO 999
            ELSE IF(NARC(SLOT).NE.NASAM) THEN
               WARN = .TRUE.
            ELSE
               DO J = 1, ABS(NASAM)
                  WARN = WARN .OR. 
     &                 ABS(ARC(J,SLOT)-ARC(J,IV)).GT.1.D-5*
     &                 ABS(ARC(J,IV))
               END DO
            END IF
         END IF
      END DO
      IF(WARN) THEN
         WRITE(*,*) '** Wavelength scales are not identical.'     
         WRITE(*,*) 'will carry on however.'
      END IF
C     
      CALL CHAR_IN('Averaging method (U,D,R,V)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, METHOD, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL UPPER_CASE(METHOD)
      IF(METHOD.NE.'U' .AND. METHOD.NE.'D' .AND. METHOD.NE.'R'
     &     .AND. METHOD.NE.'V') THEN
         WRITE(*,*) 'Invalid averaging method'
         WRITE(*,*) 'Possibilities are:'
         WRITE(*,*) 'U -- Unit weights.'
         WRITE(*,*) 'D -- Dwell weights.'
         WRITE(*,*) 'R -- Response weights.'
         WRITE(*,*) 'V -- Variance weights.'
         METHOD = 'U'
         GOTO 999
      END IF
      FILENAME = ' '
      CALL CHAR_IN('File of weights', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILENAME, IFAIL)
      IF(FILENAME.NE.' ') THEN
         OPEN(UNIT=47,FILE=FILENAME,STATUS='OLD',IOSTAT=IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to open ',FILENAME
            GOTO 999
         END IF
         IFAIL = 0
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            IF( NPIX(SLOT).GT.0) THEN
               READ(47,*,IOSTAT=IFAIL) WSLOTS(I)
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Failed to read a weight for spectrum ',
     &                 SLOT
                  CLOSE(UNIT=47)
                  GOTO 999
               END IF
            END IF
         END DO
         CLOSE(UNIT=47)
         WRITE(*,*) 'Read weights'
      END IF
C     
C     Now loop through bins.
C     
      LAST = 0
      NBIN = 0
      NS   = 0
      DO WHILE(LAST.LT.NSLOTS)
C     
C     Loop through list
C     
         NBIN = NBIN + 1
         IF(.NOT.MUTE) WRITE(*,*) 'Group: ',NBIN
         FIRST = LAST + 1
         LAST  = MIN(LAST + NGROUP, NSLOTS)
C     
C     Initialise
C     
         DO I = 1, MIN(MXWORK, MAXPX)
            WORK1(I) = 0.
            WORK2(I) = 0.
            WORK3(I) = 0.
            WORK4(I) = 0.
         END DO
         NVAL  = 0
         WONE = -1.
         DO I = FIRST, LAST
            SLOT = SLOTS(I)
            WEIGHTS(I-FIRST+1) = -1.
            IF( NPIX(SLOT).GT.0 .AND.
     &           SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &           HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, 
     &           NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC,
     &           NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &           NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, 
     &           MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
C     
               NVAL = NVAL + 1
C     
C     Compute weight for this spectrum
C     
               IF(FILENAME.NE.' ') THEN
                  WINIT = WSLOTS(I)
               ELSE
                  WINIT = 1.
               END IF
               IF(METHOD.EQ.'U') THEN
                  W = WINIT
               ELSE IF(METHOD.EQ.'D') THEN
                  CALL HGETR('DWELL', W, SLOT, MXSPEC, NMREAL,
     &                 HDREAL, NREAL, MXREAL, IFAIL)
                  W = WINIT*W
               ELSE IF(METHOD.EQ.'V') THEN
                  SUM1 = 0.D0
                  SUM2 = 0.D0
                  DO J = 1, NSAME
                     IF(ERRORS(J,SLOT).GT.0.) THEN
                        SUM1 = SUM1 + GET_FLX(COUNTS(J,SLOT), 
     &                       FLUX(J,SLOT))
                        SUM2 = SUM2 + GET_ERF(COUNTS(J,SLOT), 
     &                       ERRORS(J,SLOT), FLUX(J,SLOT))**2
                     END IF
                  END DO
                  W = REAL(WINIT*SUM1/SUM2)
               END IF
C     
C     Add into work array
C     
               SUM1 = 0.
               NW = 0
               DO J = 1, NSAME
                  IF(ERRORS(J,SLOT).GT.0.) THEN
                     IF(METHOD.EQ.'R') THEN
                        W = WINIT*CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                     END IF
                     SUM1 = SUM1 + W
                     NW = NW + 1
                     WORK1(J) = WORK1(J) + W
                     WORK2(J) = WORK2(J) + W*GET_FLX(COUNTS(J,SLOT), 
     &                    FLUX(J,SLOT))
                     VAR = (W*GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT), 
     &                    FLUX(J,SLOT)))**2
                     WORK3(J) = WORK3(J) + VAR
                     WORK4(J) = WORK4(J) + W/CFRAT(COUNTS(J,SLOT), 
     &                    FLUX(J,SLOT))
                  END IF
               END DO
               IF(NW.GT.0) THEN
                  IF(WONE.LT.0.) WONE = REAL(SUM1/FLOAT(NW))
                  WEIGHTS(I-FIRST+1) = REAL(SUM1/FLOAT(NW)/WONE)
                  IF(.NOT.MUTE) WRITE(*,'(A,I5,A,F8.4,A,F7.5)')
     &                 ' Added in slot ',SLOT,', weight ',
     &                 WEIGHTS(I-FIRST+1)
               ELSE 
                  NVAL = NVAL - 1
               END IF
            END IF
         END DO
         IF(MUTE) WRITE(*,'(1X,I4,A,I4,A,F8.6,A,F8.6)') 
     &        NVAL,' spectra added to group: ',NBIN
         IF(NVAL.LE.0) THEN
            IF(.NOT.MUTE) 
     &           WRITE(*,*) 'No valid spectra for this group '
            NEMPTY = NEMPTY + 1
            GOTO 200
         END IF
         NS = NS + 1
C     
C     Store result in output slot
C     
         SLT = SLOT3 + NS - 1
         DO I = 1, NSAME
            IF(WORK3(I).GT.0.) THEN
               COUNTS(I,SLT) = REAL(NVAL)*WORK2(I)/WORK4(I)
               ERRORS(I,SLT) = REAL(NVAL)*SQRT(WORK3(I))/WORK4(I)
               IF(COUNTS(I,SLT).EQ.0.) THEN
                  FLUX(I,SLT) = WORK1(I)/WORK4(I)
               ELSE
                  FLUX(I,SLT) = WORK2(I)/WORK1(I)
               END IF
            ELSE
               ERRORS(I,SLT) = -1.
            END IF
         END DO
C     
C     Average headers
C     
         CALL HEDAVE(SLT, SLOTS(FIRST), WEIGHTS, LAST-FIRST+1, 
     &        MXSPEC, NPIX, ARC, NARC, MXARC, NMCHAR, NMDOUB, 
     &        NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &        NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &        MXINTR, MXREAL, IFAIL)
C     
C     Multiply up the dwell
C     
         CALL HGETR('Dwell', DWELL, SLT, MXSPEC, NMREAL, HDREAL, 
     &        NREAL, MXREAL, IFAIL)
         DWELL = REAL(NVAL)*DWELL
         CALL HSETR('Dwell', DWELL, SLT, MXSPEC, NMREAL, HDREAL, 
     &        NREAL, MXREAL, IFAIL)
C     
         IF(.NOT.MUTE) THEN
            CALL SL_INF(SLT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) 'Result stored in'
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
C     
 200     CONTINUE
      END DO
C     
C     Give some warnings
C     
      WRITE(*,*) NS,' bins were filled.'
      WRITE(*,*) NEMPTY,' bins were empty.'
C     
 999  RETURN
      END
