CCHISQ
C CHISQ N1 N2 N3 N4 LOG SET -- Computes chisq of one set of spectra
C                          compared to another.
C
C CHISQ is designed for comparison between observed data in slots
C N1 to N2 and a set of model data in slots N3 to N4. Each observed
C spectrum will be compared to every model and the chi**2 computed
C will be reported. The number of degrees of freedom are also
C computed and reported as 'NDF'. For a rather more sophisticated and
C specific routine of comparable nature see 'fitspec'.
C
C CHISQ does nothing to either models or observed spectra so it is
C up to you to make sure that the wavelength scales are the same
C and that any processing has been applied symmetrically to the
C various spectra.
C
C The results can be stored to a file. Since the models may depend
C on a variety of parameters, no attempt is made to print them out.
C You are advised to make the model names useful as in
C 'log T = 4.5, log g = 8.2' because the names of the model spectra
C will be printed out.
C
C  Parameters:
C             N1   -- First of observed spectra 
C             N2   -- Last of observed spectra
C             N3   -- First of model spectra
C             N4   -- Last of model spectra
C             LOG  -- Name of log file. Blank to ignore. The full
C                     32 characters will be used for the model names
C                     (in contrast to the terminal output which uses
C                     shorter names for compactness).
C             SET  -- Yes to mask bad regions from being used to compute
C                     the chi**2. Data flagged with negative error bars
C                      will also be ignored (observed spectra only).
C
C Related commands: FITSPEC, GENSPEC
C
CCHISQ
      SUBROUTINE GOFIT(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     SLOTS1, SLOTS2, MXSLOTS, WORK1, WORK2, WORK3, MASK, MXWORK, 
     &     CLOBBER, IFAIL)
C     
C     Subtracts spectra from each other attempting to optimise the residual
C     or variance of the residual in user defined regions.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     I     SLOTS1(MXSLOTS)
C     I     SLOTS2(MXSLOTS)
C     I     MXSLOTS
C     R     WORK1(MXWORK)
C     R     WORK2(MXWORK)
C     R     WORK3(MXWORK)
C     L     MASK(MXWORK)
C     I     MXWORK
C     L     CLOBBER
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS1, NSLOTS2
      INTEGER SLOTS1(MXSLOTS), SLOTS2(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      SAVE NLIST1, NLIST2, LIST1, LIST2
      INTEGER NLIST1, LIST1(2,MXLIST)
      INTEGER NLIST2, LIST2(2,MXLIST)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Work arrays
C     
      INTEGER MXWORK
      LOGICAL MASK(MXWORK)
      REAL WORK1(MXWORK), WORK2(MXWORK), WORK3(MXWORK)
C     
C     Mask arrays
C     
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C     
      LOGICAL CLOBBER
C     
C     Local variables
C     
      SAVE SLOT1, SLOT2, SLOT3, SLOT4
      INTEGER I, J, K, LENSTR
      REAL GET_FLX, GET_ERF
      CHARACTER*100 STRING, SET*3
      CHARACTER*64 LOGFILE, OBJECT*32
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4
      INTEGER  IFAIL, SL1, SL2
      INTEGER  MAXSPEC,  NCOM, NDF
      REAL OBS, ERR, MODEL
      LOGICAL  SAMECI,   DEFAULT
      DOUBLE PRECISION VEARTH, CHISQ
C     
C     Functions
C     
      DATA SLOT1, SLOT2, SLOT3, SLOT4/1,1,2,2/
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
      DATA SET/'Y'/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      CALL INTR_IN('First observed spectrum', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last observed spectrum', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST1.GT.0) THEN
            CALL SETSLOT(LIST1, NLIST1, MXLIST, SLOTS1, 
     &           NSLOTS1, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of observed spectra'
            CALL GETLIS(LIST1, NLIST1, MXLIST, MAXSPEC, SLOTS1, 
     &           NSLOTS1, MXSLOTS)
         END IF
         IF(NSLOTS1.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST1, NLIST1, MXLIST, SLOTS1, 
     &        NSLOTS1, MXSLOTS)
      END IF
C     
      CALL INTR_IN('First model spectrum', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      SLOT4 = MIN(SLOT3 + SLOT2 - SLOT1, MAXSPEC)
      CALL INTR_IN('Last model spectrum', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT3.EQ.0 .AND. SLOT4.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT3.EQ.0 .AND. SLOT4.EQ.0) THEN
         IF(DEFAULT .AND. NLIST2.NE.0) THEN
            CALL SETSLOT(LIST2, NLIST2, MXLIST, SLOTS2, 
     &           NSLOTS2, MXSLOTS)
         END IF
         IF(.NOT.DEFAULT .OR. NLIST2.EQ.0 .OR. 
     &        (NSLOTS2.NE.1 .AND. NSLOTS1.NE.NSLOTS2)) THEN
            WRITE(*,*) 'Enter list of model spectra'
            CALL GETLIS(LIST2, NLIST2, MXLIST, MAXSPEC, SLOTS2, 
     &           NSLOTS2, MXSLOTS)
         END IF
         IF(NSLOTS2.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT3, SLOT4, LIST2, NLIST2, MXLIST, SLOTS2, 
     &        NSLOTS2, MXSLOTS)
      END IF
C     
      LOGFILE = ' '
      CALL CHAR_IN('Log file? (<CR> for none)', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, LOGFILE, IFAIL)
      
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SET, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'Mask unwanted regions'
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &        NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &        WORK2, WORK3, MXWORK, MASK)
      END IF

C     
      IF(LOGFILE.NE.' ') THEN
         IF(CLOBBER) THEN
            OPEN(UNIT=31, FILE=LOGFILE, STATUS='UNKNOWN',
     &           IOSTAT=IFAIL)
         ELSE
            OPEN(UNIT=31, FILE=LOGFILE, STATUS='NEW',
     &           IOSTAT=IFAIL)
         END IF
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to open ',LOGFILE
            GOTO 999
         END IF
         WRITE(31,*,ERR=998) 
     &        'This file contains output from CHISQ in molly'
      END IF

      DO I = 1, NSLOTS1
         SL1 = SLOTS1(I)
         IF(NPIX(SL1).LE.0) THEN
            WRITE(*,*) 'Observed slot ',SL1,' is empty.'
         ELSE
            CALL SL_INF(SL1, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &           NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &           HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, STRING, IFAIL)
            WRITE(*,*) ' '
            WRITE(*,*) ' '
            WRITE(*,*) STRING(:LENSTR(STRING))
            WRITE(*,*) ' '
            IF(LOGFILE.NE.' ') THEN
               WRITE(31,*,ERR=998) ' '
               WRITE(31,*,ERR=998) ' '
               WRITE(31,*,ERR=998) STRING(:LENSTR(STRING))
               WRITE(31,*,ERR=998) ' '
            END IF
            DO J = 1, NSLOTS2
               SL2 = SLOTS2(J)
               IF(NPIX(SL2).LE.0) THEN
                  WRITE(*,*) 'Model slot ',SL2,' is empty.'
               ELSE IF(NPIX(SL2).NE.NPIX(SL1)) THEN
                  WRITE(*,*) 'Model slot ',SL2,
     &                 ' has different number of'//
     &                 ' pixels than observed slot ',SL1
               ELSE
                  CHISQ = 0.D0
                  NDF   = 0
C     
C     Get mask
C     
                  CALL HGETD('Vearth', VEARTH, SL1, MXSPEC, 
     &                 NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
                  IFAIL = 0
C     
                  CALL APPMASK(MASK,NPIX(SL1),ARC(1,SL1),
     &                 NARC(SL1),MXARC,PMASK,NPMASK,WMASK,NWMASK,
     &                 VMASK,NVMASK,MXMASK,.FALSE.,VEARTH,IFAIL)
C     
C     Load data, errors and template
C     
                  DO K = 1, NPIX(SL1)
                     IF(MASK(K) .AND. ERRORS(K,SL1).GT.0) THEN
                        OBS   = GET_FLX(COUNTS(K,SL1), FLUX(K,SL1))
                        ERR   = GET_ERF(COUNTS(K,SL1), ERRORS(K,SL1), 
     &                       FLUX(K,SL1))
                        MODEL = GET_FLX(COUNTS(K,SL2), FLUX(K,SL2))
                        CHISQ = CHISQ + ((OBS-MODEL)/ERR)**2
                        NDF = NDF + 1
                     END IF
                  END DO
C     
C     Report Chi**2
C     
                  CALL HGETC('Object', OBJECT, SL2, MXSPEC, NMCHAR,
     &                 HDCHAR, NCHAR, MXCHAR, IFAIL)
                  IFAIL = 0
                  WRITE(*,*) 'Model slot ',SL2,', name = ',
     &                 OBJECT(:16),', chi**2 = ',SNGL(CHISQ),
     &                 ', NDF = ',NDF
                  IF(LOGFILE.NE.' ') THEN
                     WRITE(31,*,ERR=998) 'Model slot ',SL2,
     &                    ', name = ',OBJECT,
     &                    ', chi**2 = ',SNGL(CHISQ),', NDF = ',NDF
                  END IF
               END IF
            END DO
         END IF
      END DO
      IF(LOGFILE.NE.' ') THEN
         WRITE(*,*) 'Results written to ',LOGFILE
         CLOSE(UNIT=31)
      END IF
      RETURN
 998  WRITE(*,*) 'Failed to write to ',LOGFILE
      CLOSE(UNIT=31)
 999  RETURN
      END
