      SUBROUTINE HSETC(ITEM, VALUE, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &     NCHAR, MXCHAR, IFAIL)
*
* Sets CHARACTER header called ITEM to value VALUE. Creates new 
* item if it is not already present. If more than one match is 
* found nothing happens.
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  C*(*) VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Values of header items
* <  I     NCHAR(MXSPEC)  -- Number of integer items.
* >  I     MXCHAR    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   OK
*           1   Headers full
*           2   Multiple matches to ITEM
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM, VALUE
*
*     Integer parameters
*
      INTEGER MXSPEC, MXCHAR
*
*     Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
*
*     Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
*
*     Values of header items
*
      CHARACTER*(*) HDCHAR(MXCHAR,MXSPEC)
*
*     Local variables
*
      INTEGER IFAIL, L, FOUND, M
*
*     Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(LENSTR(ITEM), 16)
      M = MIN(32, LEN(VALUE))
      FOUND = ESEARC(NMCHAR(1,SLOT),NCHAR(SLOT),MXCHAR,ITEM(:L))
      IF(FOUND.GT.0) THEN
         HDCHAR(FOUND,SLOT) = VALUE(:M)
         IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
         IFAIL = 2
      ELSE IF(NCHAR(SLOT).LT.MXCHAR) THEN
         NCHAR(SLOT) = NCHAR(SLOT) + 1
         HDCHAR(NCHAR(SLOT),SLOT) = VALUE(:M)
         NMCHAR(NCHAR(SLOT),SLOT) = ITEM(:L)
         IFAIL = 0
      ELSE
         IFAIL = 1
      END IF
      RETURN
      END
      
      SUBROUTINE HSETD(ITEM, VALUE, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
*
* Sets DOUBLE PRECISION header called ITEM to value VALUE. Creates 
* new item if it is not already present. If more than one match is 
* found nothing happens.
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  D     VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of header items.
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Values of header items
* <  I     NDOUB(MXSPEC)  -- Number of items.
* >  I     MXDOUB    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   OK
*           1   Headers full
*           2   Multiple matches to ITEM
*
      IMPLICIT NONE
      DOUBLE PRECISION VALUE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXDOUB
*
* Numbers of header items
*
      INTEGER NDOUB(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
*
* Values of header items
*
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(16, LENSTR(ITEM))
      FOUND = ESEARC(NMDOUB(1,SLOT),NDOUB(SLOT),MXDOUB,ITEM(:L))
      IF(FOUND.GT.0) THEN
        HDDOUB(FOUND,SLOT) = VALUE
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE IF(NDOUB(SLOT).LT.MXDOUB) THEN
        IFAIL = 0
        NDOUB(SLOT) = NDOUB(SLOT) + 1
        HDDOUB(NDOUB(SLOT),SLOT) = VALUE
        NMDOUB(NDOUB(SLOT),SLOT) = ITEM(:L)
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HSETI(ITEM, VALUE, SLOT, MXSPEC, NMINTR, HDINTR, 
     &NINTR, MXINTR, IFAIL)
*
* Sets INTEGER header called ITEM to value VALUE. Creates new item 
* if it is not already present. If more than one match is found 
* nothing happens.
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  I     VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of header items.
* <  I     HDINTR(MXINTR,MXSPEC) -- Values of header items
* <  I     NINTR(MXSPEC)  -- Number of items.
* >  I     MXINTR    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   OK
*           1   Headers full
*           2   Multiple matches to ITEM
*
      IMPLICIT NONE
      INTEGER VALUE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXINTR
*
* Numbers of header items
*
      INTEGER NINTR(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
*
* Values of header items
*
      INTEGER          HDINTR(MXINTR,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(16, LENSTR(ITEM))
      FOUND = ESEARC(NMINTR(1,SLOT),NINTR(SLOT),MXINTR,ITEM(:L))
      IF(FOUND.GT.0) THEN
        HDINTR(FOUND,SLOT) = VALUE
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE IF(NINTR(SLOT).LT.MXINTR) THEN
        NINTR(SLOT) = NINTR(SLOT) + 1
        HDINTR(NINTR(SLOT),SLOT) = VALUE
        NMINTR(NINTR(SLOT),SLOT) = ITEM(:L)
        IFAIL = 0
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HSETR(ITEM, VALUE, SLOT, MXSPEC, NMREAL, HDREAL, 
     &NREAL, MXREAL, IFAIL)
*
* Sets REAL header called ITEM to value VALUE. OK. Creates new item 
* if it is not already present. If more than one match is found 
* nothing happens.
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  R     VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of header items.
* <  R     HDREAL(MXREAL,MXSPEC) -- Values of header items
* <  I     NREAL(MXSPEC)  -- Number of items.
* >  I     MXREAL    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   OK
*           1   Headers full
*           2   Multiple matches to ITEM
*
      IMPLICIT NONE
      REAL VALUE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXREAL
*
* Numbers of header items
*
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      REAL HDREAL(MXREAL,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(16, LENSTR(ITEM))
      FOUND = ESEARC(NMREAL(1,SLOT),NREAL(SLOT),MXREAL,ITEM(:L))
      IF(FOUND.GT.0) THEN
        HDREAL(FOUND,SLOT) = VALUE
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE IF(NREAL(SLOT).LT.MXREAL) THEN
        IFAIL = 0
        NREAL(SLOT) = NREAL(SLOT) + 1
        HDREAL(NREAL(SLOT),SLOT) = VALUE
        NMREAL(NREAL(SLOT),SLOT) = ITEM(:L)
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HGETC(ITEM, VALUE, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &NCHAR, MXCHAR, IFAIL)
*
* Gets CHARACTER header called ITEM to value VALUE. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* <  C*(*) VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot 
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of header items.
* >  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Values of header items
* >  I     NCHAR(MXSPEC)  -- Number of integer items.
* >  I     MXCHAR    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item found
*           1   Nothing found
*           2   Multiple matches to ITEM (Value returned is first found)
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM, VALUE
*
* Integer parameters
*
      INTEGER MXSPEC, MXCHAR
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*) HDCHAR(MXCHAR,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND, M
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = LENSTR(ITEM)
      M = MIN(32, LEN(VALUE))
      FOUND = ESEARC(NMCHAR(1,SLOT),NCHAR(SLOT),MXCHAR,ITEM(:L))
      IF(FOUND.GT.0) THEN
        IFAIL = 0
        VALUE = HDCHAR(FOUND,SLOT)(:M)
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
        VALUE = HDCHAR(-FOUND,SLOT)(:M)
      ELSE
        IFAIL = 1
        VALUE = ' '
      END IF
      RETURN
      END

      SUBROUTINE HGETD(ITEM, VALUE, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &NDOUB, MXDOUB, IFAIL)
*
* Gets DOUBLE PRECISION header called ITEM to value VALUE. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* <  D     VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of header items.
* >  D     HDDOUB(MXDOUB,MXSPEC) -- Values of header items
* >  I     NDOUB(MXSPEC)  -- Number of items.
* >  I     MXDOUB    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item found
*           1   Nothing found
*           2   Multiple matches to ITEM (Value returned is first found)
*
      IMPLICIT NONE
      DOUBLE PRECISION VALUE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXDOUB
*
* Numbers of header items
*
      INTEGER NDOUB(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
*
* Values of header items
*
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = LENSTR(ITEM)
      FOUND = ESEARC(NMDOUB(1,SLOT),NDOUB(SLOT),MXDOUB,ITEM(:L))
      IF(FOUND.GT.0) THEN
        IFAIL = 0
        VALUE = HDDOUB(FOUND,SLOT) 
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
        VALUE = HDDOUB(-FOUND,SLOT) 
      ELSE
        VALUE = 0.D0
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HGETI(ITEM, VALUE, SLOT, MXSPEC, NMINTR, HDINTR, 
     &NINTR, MXINTR, IFAIL)
*
* Gets INTEGER header called ITEM to value VALUE. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* <  I     VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of header items.
* >  I     HDINTR(MXINTR,MXSPEC) -- Values of header items
* >  I     NINTR(MXSPEC)  -- Number of items.
* >  I     MXINTR    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item found
*           1   Nothing found
*           2   Multiple matches to ITEM (Value returned is first found)
*
      IMPLICIT NONE
      INTEGER VALUE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXINTR
*
* Numbers of header items
*
      INTEGER NINTR(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
*
* Values of header items
*
      INTEGER          HDINTR(MXINTR,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = LENSTR(ITEM)
      FOUND = ESEARC(NMINTR(1,SLOT),NINTR(SLOT),MXINTR,ITEM(:L))
      IF(FOUND.GT.0) THEN
        IFAIL = 0
        VALUE = HDINTR(FOUND,SLOT) 
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
        VALUE = HDINTR(-FOUND,SLOT) 
      ELSE
        IFAIL = 1
        VALUE = 0
      END IF
      RETURN
      END

      SUBROUTINE HGETR(ITEM, VALUE, SLOT, MXSPEC, NMREAL, HDREAL, 
     &NREAL, MXREAL, IFAIL)
*
* Gets REAL header called ITEM to value VALUE. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* <  R     VALUE            -- Value of item
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of header items.
* >  R     HDREAL(MXREAL,MXSPEC) -- Values of header items
* >  I     NREAL(MXSPEC)  -- Number of items.
* >  I     MXREAL    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item found
*           1   Nothing found
*           2   Multiple matches to ITEM (Value returned is first found)
*
      IMPLICIT NONE
      REAL VALUE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXREAL
*
* Numbers of header items
*
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      REAL HDREAL(MXREAL,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = LENSTR(ITEM)
      FOUND = ESEARC(NMREAL(1,SLOT),NREAL(SLOT),MXREAL,ITEM(:L))
      IF(FOUND.GT.0) THEN
        IFAIL = 0
        VALUE = HDREAL(FOUND,SLOT) 
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
        VALUE = HDREAL(-FOUND,SLOT) 
      ELSE
        IFAIL = 1
        VALUE = 0.
      END IF
      RETURN
      END

      SUBROUTINE HDELC(ITEM, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &NCHAR, MXCHAR, IFAIL)
*
* Deletes CHARACTER header called ITEM from slot. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to delete
* >  I     SLOT             -- Spectrum slot to modify
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Values of header items
* <  I     NCHAR(MXSPEC)  -- Number of integer items.
* >  I     MXCHAR    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item deleted
*           1   Item not found
*           2   Multiple matches to ITEM, nothing deleted.
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXCHAR
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*) HDCHAR(MXCHAR,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND,  I
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(LENSTR(ITEM), 16)
      FOUND = ESEARC(NMCHAR(1,SLOT),NCHAR(SLOT),MXCHAR,ITEM(:L))
      IF(FOUND.GT.0) THEN
*
* Reduce number of character header items by 1
*
        NCHAR(SLOT) = NCHAR(SLOT) - 1
*
* Move all items after the deleted one up by one
*
        DO I = FOUND, NCHAR(SLOT)
          NMCHAR(I,SLOT) = NMCHAR(I+1,SLOT)
          HDCHAR(I,SLOT) = HDCHAR(I+1,SLOT)
        END DO
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END


      SUBROUTINE HDELD(ITEM, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &NDOUB, MXDOUB, IFAIL)
*
* Deletes DOUBLE PRECISION header called ITEM from header. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of header items.
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Values of header items
* <  I     NDOUB(MXSPEC)  -- Number of items.
* >  I     MXDOUB    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item deleted
*           1   Item not found
*           2   Multiple matches to ITEM, nothing deleted.
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXDOUB
*
* Numbers of header items
*
      INTEGER NDOUB(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
*
* Values of header items
*
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND, I
*
* Functions
*
      INTEGER ESEARC, LENSTR
*
      L = MIN(16, LENSTR(ITEM))
      FOUND = ESEARC(NMDOUB(1,SLOT),NDOUB(SLOT),MXDOUB,ITEM(:L))
      IF(FOUND.GT.0) THEN
*
* Reduce number of items by one
*
        NDOUB(SLOT) = NDOUB(SLOT) - 1
*
* Move all succeeding items up by one
*
        DO I = FOUND, NDOUB(SLOT)
          NMDOUB(I,SLOT) = NMDOUB(I+1,SLOT)
          HDDOUB(I,SLOT) = HDDOUB(I+1,SLOT)
        END DO
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HDELI(ITEM, SLOT, MXSPEC, NMINTR, HDINTR, 
     &NINTR, MXINTR, IFAIL)
*
* Deletes INTEGER header called ITEM from slot. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of header items.
* <  I     HDINTR(MXINTR,MXSPEC) -- Values of header items
* <  I     NINTR(MXSPEC)  -- Number of items.
* >  I     MXINTR    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   Item deleted
*           1   Item not found
*           2   Multiple matches to ITEM, nothing deleted.
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXINTR
*
* Numbers of header items
*
      INTEGER NINTR(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
*
* Values of header items
*
      INTEGER          HDINTR(MXINTR,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND, I
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(16, LENSTR(ITEM))
      FOUND = ESEARC(NMINTR(1,SLOT),NINTR(SLOT),MXINTR,ITEM(:L))
      IF(FOUND.GT.0) THEN
*
* Reduce number of items by one
*
        NINTR(SLOT) = NINTR(SLOT) - 1
*
* Move all succeeding items up by one
*
        DO I = FOUND, NINTR(SLOT)
          NMINTR(I,SLOT) = NMINTR(I+1,SLOT)
          HDINTR(I,SLOT) = HDINTR(I+1,SLOT)
        END DO
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HDELR(ITEM, SLOT, MXSPEC, NMREAL, HDREAL, 
     &NREAL, MXREAL, IFAIL)
*
* Deletes REAL header called ITEM from slot. 
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to set.
* >  I     SLOT             -- Spectrum slot to set
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of header items.
* <  R     HDREAL(MXREAL,MXSPEC) -- Values of header items
* <  I     NREAL(MXSPEC)  -- Number of items.
* >  I     MXREAL    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*
*   IFAIL = 0   Item deleted
*           1   Item not found
*           2   Multiple matches to ITEM, nothing deleted.
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXREAL
*
* Numbers of header items
*
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      REAL HDREAL(MXREAL,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, L, FOUND, I
*
* Functions
*
      INTEGER ESEARC, LENSTR
* 
      L = MIN(16, LENSTR(ITEM))
      FOUND = ESEARC(NMREAL(1,SLOT),NREAL(SLOT),MXREAL,ITEM(:L))
      IF(FOUND.GT.0) THEN
*
* Reduce number of items by one
*
        NREAL(SLOT) = NREAL(SLOT) - 1
*
* Move all succeeding items up by one
*
        DO I = FOUND, NREAL(SLOT)
          NMREAL(I,SLOT) = NMREAL(I+1,SLOT)
          HDREAL(I,SLOT) = HDREAL(I+1,SLOT)
        END DO
        IFAIL = 0
      ELSE IF(FOUND.LT.0) THEN
        IFAIL = 2
      ELSE
        IFAIL = 1
      END IF
      RETURN
      END

      SUBROUTINE HRENAME(OLD, NEW, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, MXDOUB, NMINTR,
     &HDINTR, NINTR, MXINTR, NMREAL, HDREAL, NREAL, MXREAL, IFAIL)
*
* Renames a header item from OLD to NEW.
* 
* Arguments:
*
* >  C*(*) OLD              -- Current name of item
* >  C*(*) NEW              -- New name of item to delete
* >  I     SLOT             -- Spectrum slot to modify
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* >  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Values of character header items
* >  I     NCHAR(MXSPEC)         -- Number of character items.
* >  I     MXCHAR                -- Maximum number of character header items
* >  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double header items.
* >  D     HDDOUB(MXDOUB,MXSPEC) -- Values of double header items
* >  I     NDOUB(MXSPEC)         -- Number of double items.
* >  I     MXDOUB                -- Maximum number of double items/spec
* >  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* >  I     HDINTR(MXINTR,MXSPEC) -- Values of integer header items
* >  I     NINTR(MXSPEC)         -- Number of integer header items.
* >  I     MXINTR                -- Maximum number of integer header items.
* >  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* >  R     HDREAL(MXREAL,MXSPEC) -- Values of real header items
* >  I     NREAL(MXSPEC)         -- Number of real header items.
* >  I     MXREAL    -- Maximum number of header items/spec
* <  I     IFAIL              -- Error return.
*
*   IFAIL = 0   OLD renamed
*           1   OLD not found
*           2   Multiple matches to OLD, no change made.
*           3   NEW clashes with another header item.
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) OLD, NEW
*
* Integer parameters
*
      INTEGER MXSPEC, MXCHAR, MXDOUB, MXINTR, MXREAL
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC), NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC), NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, LOLD, LNEW
      INTEGER FCHAR, FREAL, FDOUB, FINTR
      LOGICAL FOUND
      CHARACTER*1 TYPE
*
* Functions
*
      INTEGER ESEARC, LENSTR
*
* Look for old item. Need to check all items in case there is 
* more than one copy (although there should not be)
*
      FOUND = .FALSE.
      LOLD = MIN(LENSTR(OLD), 16)
*
      FCHAR = ESEARC(NMCHAR(1,SLOT),NCHAR(SLOT),MXCHAR,OLD(:LOLD))
      IF(FCHAR.GT.0) THEN
         FOUND = .TRUE.
      ELSE IF(FCHAR.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
*
      FDOUB = ESEARC(NMDOUB(1,SLOT),NDOUB(SLOT),MXDOUB,OLD(:LOLD))
      IF(FDOUB.GT.0) THEN
         IF(FOUND) THEN
            IFAIL = 2
            RETURN
         END IF
         FOUND = .TRUE.
      ELSE IF(FDOUB.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
*
      FINTR = ESEARC(NMINTR(1,SLOT),NINTR(SLOT),MXINTR,OLD(:LOLD))
      IF(FINTR.GT.0) THEN
         IF(FOUND) THEN
            IFAIL = 2
            RETURN
         END IF
         FOUND = .TRUE.
      ELSE IF(FINTR.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
*
      FREAL = ESEARC(NMREAL(1,SLOT),NREAL(SLOT),MXREAL,OLD(:LOLD))
      IF(FREAL.GT.0) THEN
         IF(FOUND) THEN
            IFAIL = 2
            RETURN
         END IF
         FOUND = .TRUE.
      ELSE IF(FREAL.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF

* OLD not found

      IF(.NOT.FOUND) THEN
         IFAIL = 1
         RETURN
      END IF
*
* Check that new name does not already exist
*
      CALL HCLASH(NEW, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, MXDOUB, NMINTR,
     &HDINTR, NINTR, MXINTR, NMREAL, HDREAL, NREAL, MXREAL, 
     &TYPE, IFAIL)
      IF(IFAIL.NE.0) THEN
         IFAIL = 3
         RETURN
      END IF
*
* Now change item. Only one of the following tests should be true
*

      IFAIL = 0
      LNEW = MIN(LENSTR(NEW), 16)
      IF(FCHAR.GT.0) THEN
         NMCHAR(FCHAR,SLOT) = NEW(:LNEW)
      ELSE IF(FDOUB.GT.0) THEN
         NMDOUB(FDOUB,SLOT) = NEW(:LNEW)
      ELSE IF(FINTR.GT.0) THEN
         NMINTR(FINTR,SLOT) = NEW(:LNEW)
      ELSE IF(FREAL.GT.0) THEN
         NMREAL(FREAL,SLOT) = NEW(:LNEW)
      END IF
      RETURN
      END

      SUBROUTINE HCLASH(ITEM, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, MXDOUB, NMINTR,
     &HDINTR, NINTR, MXINTR, NMREAL, HDREAL, NREAL, MXREAL, 
     &TYPE, IFAIL)
*
* Checks for clashes with an ITEM in all headers
* 
* Arguments:
*
* >  C*(*) ITEM             -- Name of item to check
* >  I     SLOT             -- Spectrum slot to modify
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* >  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Values of character header items
* >  I     NCHAR(MXSPEC)         -- Number of character items.
* >  I     MXCHAR                -- Maximum number of character header items
* >  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double header items.
* >  D     HDDOUB(MXDOUB,MXSPEC) -- Values of double header items
* >  I     NDOUB(MXSPEC)         -- Number of double items.
* >  I     MXDOUB                -- Maximum number of double items/spec
* >  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* >  I     HDINTR(MXINTR,MXSPEC) -- Values of integer header items
* >  I     NINTR(MXSPEC)         -- Number of integer header items.
* >  I     MXINTR                -- Maximum number of integer header items.
* >  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* >  R     HDREAL(MXREAL,MXSPEC) -- Values of real header items
* >  I     NREAL(MXSPEC)         -- Number of real header items.
* >  I     MXREAL                -- Maximum number of header items/spec
*    C*(*) TYPE                  -- Type of header item ('C' etc)
* <  I     IFAIL                 -- Error return.
*
*   IFAIL = 0   no clash found
*           1   one found
*
      IMPLICIT NONE
      INTEGER SLOT
      CHARACTER*(*) ITEM
*
* Integer parameters
*
      INTEGER MXSPEC, MXCHAR, MXDOUB, MXINTR, MXREAL
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC), NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC), NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
      CHARACTER*(*) TYPE
*
* Local variables
*
      INTEGER IFAIL, LITEM, FITEM, TOTAL
*
* Functions
*
      INTEGER ESEARC, LENSTR
*
      TOTAL = 0
      LITEM = MIN(LENSTR(ITEM), 16)
      FITEM = ESEARC(NMCHAR(1,SLOT),NCHAR(SLOT),MXCHAR,ITEM(:LITEM))
      IF(FITEM.GT.0) THEN
         TOTAL = TOTAL + 1
         TYPE = 'C'
      ELSE IF(FITEM.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
      FITEM = ESEARC(NMDOUB(1,SLOT),NDOUB(SLOT),MXDOUB,ITEM(:LITEM))
      IF(FITEM.GT.0) THEN
         TOTAL = TOTAL + 1
         TYPE = 'D'
      ELSE IF(FITEM.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
      FITEM = ESEARC(NMINTR(1,SLOT),NINTR(SLOT),MXINTR,ITEM(:LITEM))
      IF(FITEM.GT.0) THEN
         TOTAL = TOTAL + 1
         TYPE = 'I'
      ELSE IF(FITEM.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
      FITEM = ESEARC(NMREAL(1,SLOT),NREAL(SLOT),MXREAL,ITEM(:LITEM))
      IF(FITEM.GT.0) THEN
         TOTAL = TOTAL + 1
         TYPE = 'R'
      ELSE IF(FITEM.LT.0) THEN
         IFAIL = 2
         RETURN
      END IF
*
      IF(TOTAL.EQ.0) THEN
         IFAIL = 0
      ELSE IF(TOTAL.EQ.1) THEN
         IFAIL = 1
      ELSE IF(TOTAL.GT.1) THEN
         IFAIL = 2
      END IF
      RETURN
      END

      SUBROUTINE HCONV(SLOT, MXSPEC, NMCHAR, HDCHAR, NCHAR, MXCHAR, 
     &NMDOUB, HDDOUB, NDOUB, MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, 
     &NMREAL, HDREAL, NREAL, MXREAL, OLD, IFAIL)
*
* Converts an old style ephemeris to the new one
* 
* Arguments:
*
* >  I     SLOT             -- Spectrum slot to modify
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* >  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Values of character header items
* >  I     NCHAR(MXSPEC)         -- Number of character items.
* >  I     MXCHAR                -- Maximum number of character header items
* >  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double header items.
* >  D     HDDOUB(MXDOUB,MXSPEC) -- Values of double header items
* >  I     NDOUB(MXSPEC)         -- Number of double items.
* >  I     MXDOUB                -- Maximum number of double items/spec
* >  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* >  I     HDINTR(MXINTR,MXSPEC) -- Values of integer header items
* >  I     NINTR(MXSPEC)         -- Number of integer header items.
* >  I     MXINTR                -- Maximum number of integer header items.
* >  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* >  R     HDREAL(MXREAL,MXSPEC) -- Values of real header items
* >  I     NREAL(MXSPEC)         -- Number of real header items.
* >  I     MXREAL    -- Maximum number of header items/spec
* <  L     OLD       -- TRUE if old style ephemeris detected
* <  I     IFAIL              -- Error return.
*
*
      IMPLICIT NONE
      INTEGER SLOT
*
* Integer parameters
*
      INTEGER MXSPEC, MXCHAR, MXDOUB, MXINTR, MXREAL
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC), NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC), NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
      LOGICAL OLD
*
* Local variables
*
      INTEGER IFAIL
*
      OLD = .FALSE.
*
* Use HRENAME to rename any old style header parameters
*
      CALL HRENAME('HJDO', 'ZeroO', SLOT, MXSPEC, NMCHAR, 
     &     HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &     MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, NMREAL, 
     &     HDREAL, NREAL, MXREAL, IFAIL)
      IF(IFAIL.EQ.0) THEN
         OLD = .TRUE.
      ELSE IF(IFAIL.EQ.2) THEN
         WRITE(*,*) 'Error trying to change HJDO; multiple'
         WRITE(*,*) 'matches in slot ',SLOT
      END IF
*     
      CALL HRENAME('HJD0', 'ZeroO', SLOT, MXSPEC, NMCHAR, 
     &     HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &     MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, NMREAL, 
     &     HDREAL, NREAL, MXREAL, IFAIL)
      IF(IFAIL.EQ.0) THEN
         OLD = .TRUE. 
      ELSE IF(IFAIL.EQ.2) THEN
         WRITE(*,*) 'Error trying to change HJD0; multiple'
         WRITE(*,*) 'matches in slot ',SLOT
      END IF
*     
      CALL HRENAME('Period', 'PeriodO', SLOT, MXSPEC, NMCHAR, 
     &     HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &     MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, NMREAL, 
     &     HDREAL, NREAL, MXREAL, IFAIL)
      IF(IFAIL.EQ.0) THEN
         OLD = .TRUE.
      ELSE IF(IFAIL.EQ.2) THEN
         WRITE(*,*) 'Error trying to change Period; multiple'
         WRITE(*,*) 'matches in slot ',SLOT
      END IF
*     
      CALL HRENAME('HJDS', 'ZeroS', SLOT, MXSPEC, NMCHAR, 
     &     HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &     MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, NMREAL, 
     &     HDREAL, NREAL, MXREAL, IFAIL)
      IF(IFAIL.EQ.0) THEN
         OLD = .TRUE.
      ELSE IF(IFAIL.EQ.2) THEN
         WRITE(*,*) 'Error trying to change HJDS; multiple'
         WRITE(*,*) 'matches in slot ',SLOT
      END IF
*
      CALL HRENAME('HJDB', 'ZeroB', SLOT, MXSPEC, NMCHAR, 
     &     HDCHAR, NCHAR, MXCHAR, NMDOUB, HDDOUB, NDOUB, 
     &     MXDOUB, NMINTR, HDINTR, NINTR, MXINTR, NMREAL, 
     &     HDREAL, NREAL, MXREAL, IFAIL)
      IF(IFAIL.EQ.0) THEN
         OLD = .TRUE.
      ELSE IF(IFAIL.EQ.2) THEN
         WRITE(*,*) 'Error trying to change HJDB; multiple'
         WRITE(*,*) 'matches in slot ',SLOT
      END IF
      
      IF(IFAIL.EQ.1) IFAIL = 0
      RETURN
      END
