*HELP
* HELP or (?) Command File -- Gets help on a command.
*
* Parameters:
*            Command -- Name of a command. If left blank then a one line
*                       per command list is typed to screen. If wildcards
*                       (*) are included, only those commands matching the
*                       name will be listed. e.g. help *e* will list
*                       all commands with an `e' in them. If no wildcards 
*                       are used then a search is made for a file containing 
*                       further information.
*
*            File    -- A hidden parameter. If included, the help information
*                       is written to a file of this name if it can be opened. 
*                       Nothing is written to the standard output terminal 
*                       unless something goes wrong. The help returns 
*                       immediately. This is the best way to get hard copy
*                       of the help files.
*
*            As a special case if you specify CLASS as a command you will get
*            a list of classes which can be used to select commands by loose
*            purpose/action. Some commands crop up in more than one class.
*            You can go straight to such a listing with HELP CLASS Classname
*            where, for example, Classname = 'Input' will list commands to do
*            with input.
*HELP
*?
* ? (or HELP) Command File -- Gets help on a command.
*
* Parameters:
*            Command -- Name of a command. If left blank then a one line
*                       per command list is typed to screen. If wildcards
*                       (*) are included, only those commands matching the
*                       name will be listed. e.g. help *e* will list
*                       all commands with an `e' in them. If no wildcards 
*                       are used then a search is made for a file containing 
*                       further information.
*
*            File    -- A hidden parameter. If included, the help information
*                       is written to a file of this name if it can be opened. 
*                       Nothing is written to the standard output terminal 
*                       unless something goes wrong. The help returns 
*                       immediately. This is the best way to get hard copy
*                       of the help files.
*
*            As a special case if you specify CLASS as a command you will get
*            a list of classes which can be used to select commands by loose
*            purpose/action. Some commands crop up in more than one class.
*            You can go straight to such a listing with HELP CLASS Classname
*            where, for example, Classname = 'Input' will list commands to do
*            with input.
*?
      SUBROUTINE GETHELP(SPLIT, NSPLIT, MXSPLIT, COMMS, CINFO, CBUFF,
     &     NCOM, CLASS, NCLASS, WCLASS, MATCH, MXMATCH, CLOBBER, 
     &     KEY, MXKEY, GHELP, HELP_DIR, IFAIL)
C
C     Gets help on commands. Designed for molly but can be used by other
C     programs
C
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL, HUNIT, MXMATCH
      INTEGER N,  NCOM, NFIND
      INTEGER M, I, J, K,  MATCH(MXMATCH), NSTR
      INTEGER LUNIT, NCLASS, MXKEY
      CHARACTER*(*) SPLIT(MXSPLIT), GHELP, HELP_DIR
      CHARACTER*(*) COMMS(NCOM), CINFO(NCOM), CBUFF(NCOM)
      CHARACTER*(*) CLASS(NCLASS)
      INTEGER WCLASS(NCOM)
      CHARACTER*100  STRING
      CHARACTER*64 POINT(2)
      INTEGER   KEY(MXKEY), SEARC, NDIV
      LOGICAL ENTRY, SELECT, OLOG, ESAMECI, CLOBBER
      DATA HUNIT/24/
      DATA LUNIT/25/
*
      IF(MXMATCH.LT.NCOM) THEN
         WRITE(*,*) 'MXMATCH in GETHELP not large enough'
         WRITE(*,*) MXMATCH,NCOM
         IFAIL = 1
         RETURN
      END IF
      IF(NCOM.GT.MXKEY) THEN
         WRITE(*,*) 'MXKEY in GETHELP not large enough'
         WRITE(*,*) MXKEY,' compared to ',NCOM
         IFAIL = 1
         RETURN
      END IF
      ENTRY  = .TRUE.
      SELECT = .FALSE.
      OLOG   = .FALSE.
*     
*     No command parameters means that we go into a listing of all commands.
*     
      IF(NSPLIT.EQ.0) THEN
 49      ENTRY = .FALSE.
*     
*     Sort commands alphabetically 
*     
         IF(SELECT) THEN
            N = NFIND
            DO I = 1, N
               CBUFF(I) = COMMS(MATCH(I))
            END DO
         ELSE
            N = NCOM
            DO I = 1, N
               CBUFF(I) = COMMS(I)
            END DO
         END IF
         CALL CHEAPSORT(N, CBUFF, KEY)
         IF(SELECT) THEN
            DO I = 1, N
               KEY(I) = MATCH(KEY(I))
            END DO
         END IF
         M = 0
        K = 0
 51     IF(M.LE.N-2) THEN
           STRING = CINFO(KEY(M+1))//' '//CINFO(KEY(M+2))
           M = M + 2
           K = K + 1
        ELSE IF(M.EQ.N-1) THEN
           STRING = CINFO(KEY(M+1))
           M = M + 1
           K = K + 1
        END IF
        WRITE(*,*) STRING
        IF(K.EQ.20 .OR. M.EQ.N) THEN
           WRITE(*,*) ' '
           IF(M.LT.N) THEN
              WRITE(*,'(A,$)') 
     &             'Enter name, <CR> for more, or X to exit: '
              READ(*,'(A)') SPLIT(1)
              IF(ESAMECI(SPLIT(1),'X')) THEN
                 GOTO 98
              ELSE IF(SPLIT(1).NE.' ') THEN
*     
*     Branch off to look for help on entered name
*     
                 GOTO 200
              END IF
           ELSE
              WRITE(*,'(A,$)') 
     &             'Enter name, ? for help, or <CR> to quit: '
              READ(*,'(A)') SPLIT(1)
              IF(SPLIT(1).EQ.' ') THEN
                 GOTO 98
              ELSE IF(SPLIT(1).EQ.'?') THEN
*     
*     Re-list commands
*     
                 GOTO 49
              ELSE
*     
*     Branch off to look for help on entered name
*     
                 GOTO 200
              END IF
           END IF
           WRITE(*,*) ' '
           K = 0
        END IF
        GOTO 51
*     
*     If there are command parameters, there are two possibilities.
*     
*     a) SPLIT(1) = 'class' and SPLIT(2) =  a class name or is blank.
*     This allows a clasified listing of commands according to their
*     action.
*     
*     b) SPLIT(1) = a command name and SPLIT(2) = a log file name to write
*     the help to or is blank.
*     
*     
      ELSE IF(NSPLIT.EQ.1 .OR. NSPLIT.EQ.2) THEN
*     
         IF(ESAMECI(SPLIT(1),'CLASS')) THEN
*     
*     List classes and allow user to enter a name.
*     
            IF(NSPLIT.EQ.1) THEN
*     
*     Sort classes alphabetically
*     
 52            CALL CHEAPSORT(NCLASS, CLASS, KEY)        
               WRITE(*,*) ' '
               WRITE(*,*) 'Classes'
               WRITE(*,*) ' '
               DO I = 1, NCLASS/4
                  WRITE(*,'(4(1X,A16))') (CLASS(KEY(J)),J=4*(I-1)+1,4*I)
               END DO
               IF(MOD(NCLASS,4).NE.0) THEN
                  WRITE(*,'(3(1X,A16))') 
     &                 (CLASS(KEY(J)),J=4*(NCLASS/4)+1,NCLASS)
               END IF
               WRITE(*,*) ' '
               WRITE(*,'(A,$)') 'Enter class name or <CR> to quit: '
               READ(*,'(A)') SPLIT(2)
               IF(SPLIT(2).EQ.' ') GOTO 98
            END IF
*     
*     Search for a match between CLASS(NCLASS) and SPLIT(2)
*     
            NFIND = SEARC(CLASS, NCLASS, NCLASS, SPLIT(2))
            IF(NFIND.EQ.0) THEN
               WRITE(*,*) 'No such class name found.'
               GOTO 52
            ELSE IF(NFIND.LT.0) THEN
               WRITE(*,*) 'Ambiguous class name.'
               GOTO 52
            ELSE
*     
*     found class, now find members. A command can be in more than
*     one class. Classes are coded in the integers WCLASS as 
*     CLASS1+100*CLASS2+10000*CLASS3 etc. Thus 99 classes are possible.
*     The code below looks dor a maximum of 4 classes per command.
*     
               N = 0
               DO I = 1, NCOM
                  DO J = 0, 3
                     NDIV = 100**J
                     IF(MOD(WCLASS(I)/NDIV,100).EQ.NFIND) THEN
                        N = N + 1
                        CBUFF(N) = COMMS(I)
                        MATCH(N) = I
                        GOTO 53
                     END IF
                  END DO
 53               CONTINUE
               END DO
               IF(N.EQ.0) THEN 
                  WRITE(*,*) 'Class ',CLASS(NFIND),' is empty.'
                  GOTO 52
               ELSE
                  WRITE(*,*) 'Class ',CLASS(NFIND)
                  WRITE(*,*) ' '
                  CALL CHEAPSORT(N, CBUFF, KEY)
                  DO I = 1, N
                     KEY(I) = MATCH(KEY(I))
                  END DO
                  M = 0
                  K = 0
 54               IF(M.LE.N-2) THEN
                     STRING = CINFO(KEY(M+1))//' '//CINFO(KEY(M+2))
                     M = M + 2
                     K = K + 1
                  ELSE IF(M.EQ.N-1) THEN
                     STRING = CINFO(KEY(M+1))
                     M = M + 1
                     K = K + 1
                  END IF
                  WRITE(*,*) STRING
                  IF(K.EQ.20 .OR. M.EQ.N) THEN
                     WRITE(*,*) ' '
                     IF(M.LT.N) THEN
                        WRITE(*,'(A,$)') 
     &                       'Enter name, <CR> for more, or X to exit: '
                        READ(*,'(A)') SPLIT(1)
                        IF(ESAMECI(SPLIT(1),'X')) THEN
                           GOTO 98
                        ELSE IF(SPLIT(1).NE.' ') THEN
                           GOTO 200
                        END IF
                     ELSE
                        WRITE(*,'(A,$)') 
     &                       'Enter name, ? for classes, '//
     &                       'or <CR> to quit: '
                        READ(*,'(A)') SPLIT(1)
                        IF(SPLIT(1).EQ.' ') THEN
                           GOTO 98
                        ELSE IF(SPLIT(1).EQ.'?') THEN
                           GOTO 52
                        ELSE
                           GOTO 200
                        END IF
                     END IF
                     WRITE(*,*) ' '
                     K = 0
                  END IF
                  GOTO 54
               END IF
            END IF
*
         ELSE
*     
*     Standard command name request
*     
            IF(NSPLIT.EQ.2) THEN
*     
*     Open log file
*     
               IF(CLOBBER) THEN
                  OPEN(UNIT=LUNIT,FILE=SPLIT(2),STATUS='UNKNOWN',
     &                 IOSTAT=IFAIL)
               ELSE
                  OPEN(UNIT=LUNIT,FILE=SPLIT(2),STATUS='NEW',
     &                 IOSTAT=IFAIL)
               END IF
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Could not open ',SPLIT(2)
                  IFAIL = 1
                  RETURN
               END IF
               OLOG = .TRUE.
            END IF
 200        NFIND = SEARC(COMMS, NCOM, NCOM, SPLIT(1))
            IF(NFIND.EQ.0) THEN
*     
*     First try wildcard match
*     
               CALL CWILD(SPLIT(1), COMMS, MATCH, NCOM, NFIND)
               IF(NFIND.EQ.0) THEN
                  WRITE(*,*) 'No matches found for ',SPLIT(1)
                  IF(OLOG) THEN
                     WRITE(LUNIT,*,ERR=99) 
     &                    'No matches found for ',SPLIT(1)
                     GOTO 101
                  END IF
                  SELECT = .FALSE.
                  GOTO 49
               ELSE
                  WRITE(*,*) NFIND,' matches found for ',SPLIT(1)
                  IF(OLOG) THEN 
                     WRITE(LUNIT,*,ERR=99) 
     &                    NFIND,' matches found for ',SPLIT(1)
                     GOTO 101
                  END IF
                  SELECT = .TRUE.
                  GOTO 49
               END IF
            ELSE IF(NFIND.LT.0) THEN
               WRITE(*,*) 'Ambiguous name'
               IF(OLOG) THEN 
                  WRITE(LUNIT,*,ERR=99) 'Ambiguous name'
                  GOTO 101
               END IF
               GOTO 49
            END IF
*     
*     Look for pointer to a help file using environment variable
*     to make it a global search.
*     
            OPEN(UNIT=HUNIT,FILE=GHELP,STATUS='OLD',
     &           IOSTAT=IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Could not open help pointer file ',GHELP
               IF(OLOG) THEN
                  WRITE(LUNIT,*,ERR=99) 
     &                 'Could not open help pointer file ',GHELP
                  GOTO 101
               END IF
               GOTO 49
            END IF        
 100        READ(HUNIT,'(A)',IOSTAT=IFAIL) STRING
            IF(IFAIL.EQ.0) THEN
               CALL CSPLIT(STRING,POINT,NSTR,2,IFAIL)
               IF(IFAIL.NE.0) THEN
                  CLOSE(UNIT=HUNIT)
                  WRITE(*,*) 'Could not understand pointer file entry'
                  WRITE(*,*) STRING
                  IF(OLOG) THEN
                     WRITE(LUNIT,*,ERR=99) 
     &                    'Could not understand pointer file entry'
                     WRITE(LUNIT,*,ERR=99) STRING
                     GOTO 101
                  END IF
                  GOTO 49
               END IF
               IF(NSTR.LT.2 .OR. 
     &              .NOT.ESAMECI(POINT(1),COMMS(NFIND))) GOTO 100
            ELSE
               CLOSE(UNIT=HUNIT)
               WRITE(*,*) 'Sorry, no help file on ',COMMS(NFIND)
               IF(OLOG) THEN
                  WRITE(LUNIT,*,ERR=99) 
     &                 'Sorry, no help file on ',COMMS(NFIND)
                  GOTO 101
               END IF
               GOTO 49
            END IF
*     
*     Open help file as read from pointer file
*     
            STRING = HELP_DIR//POINT(2)
            OPEN(UNIT=HUNIT,FILE=STRING,STATUS='OLD',
     &           IOSTAT=IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Could not open file which '//
     &              'should have had help'
               WRITE(*,*) 'on ',COMMS(NFIND)
               WRITE(*,*) 'File called: ',STRING
               IF(OLOG) THEN
                  WRITE(LUNIT,*,ERR=99) 
     &                 'Could not open file which should have had help'
                  WRITE(LUNIT,*,ERR=99) 'on ',COMMS(NFIND)
                  WRITE(LUNIT,*,ERR=99) 'File called: ',POINT(2)
                  GOTO 101
               END IF
               GOTO 49
            END IF
*     
*     File opened, help part is delimited by *COMMAND at start and end
*     where COMMAND is the name of the particular command and '*' is any
*     single character
*     
 150        READ(HUNIT,'(A)',IOSTAT=IFAIL) STRING
            IF(IFAIL.NE.0) THEN
               CLOSE(UNIT=HUNIT)
               WRITE(*,*) 'No help on ',COMMS(NFIND)
               WRITE(*,*) 'found in ',POINT(2)
               IF(OLOG) THEN
                  WRITE(LUNIT,*,ERR=99) 'No help on ',COMMS(NFIND)
                  WRITE(LUNIT,*,ERR=99) 'found in ',POINT(2)
                  GOTO 101
               END IF
               GOTO 49
            END IF
            IF(.NOT.ESAMECI(STRING(2:),COMMS(NFIND))) GOTO 150
*     
*     Have found right part, now print to screen
*     
            N = 0
            IF(.NOT.OLOG) WRITE(*,*) ' '
 300        CONTINUE
            N = N + 1
            READ(HUNIT,'(A)',IOSTAT=IFAIL) STRING
            IF(IFAIL.NE.0 .OR. ESAMECI(STRING(2:),COMMS(NFIND))) THEN
               CLOSE(UNIT=HUNIT)
               IF(ENTRY) THEN
                  IF(OLOG) THEN
                     GOTO 98
                  ELSE
                     WRITE(*,*) ' '
                  END IF
                  GOTO 98
               END IF
               WRITE(*,*) ' '
               WRITE(*,'(A,$)') 
     &              '<CR> for main help, command name, or Q to quit: '
               READ(*,'(A)') SPLIT(1)
               IF(SPLIT(1).EQ.' ') THEN
                  GOTO 49
               ELSE IF(ESAMECI(SPLIT(1),'Q')) THEN
                  GOTO 98
               ELSE
                  GOTO 200
               END IF
            END IF
            IF(OLOG) THEN
               WRITE(LUNIT,*,ERR=99) STRING(2:)
            ELSE
               WRITE(*,*) STRING(2:)
            END IF
            IF(.NOT.OLOG .AND. N.EQ.20) THEN
               WRITE(*,*) ' '
               WRITE(*,'(A,$)') '<CR> for more, or Q to quit: '
               READ(*,'(A)') SPLIT(1)
               IF(ESAMECI(SPLIT(1),'Q')) THEN
                  CLOSE(UNIT=HUNIT)
                  GOTO 49
               ELSE 
                  N = 0
                  GOTO 300
               END IF
            ELSE
               GOTO 300
            END IF
         END IF
      ELSE 
         WRITE(*,*) 'Too many inputs'
         GOTO 49
      END IF
 98   IFAIL = 0
      CLOSE(UNIT=LUNIT)
      OLOG = .FALSE.
      RETURN
 99   WRITE(*,*) 'Error writing to ',SPLIT(2)
 101  CLOSE(UNIT=LUNIT)
      OLOG = .FALSE.
      IFAIL = 1
      RETURN
      END
