      SUBROUTINE GETCONST(FILE, CONST, IFAIL)
*
* Routine returns the value of a constant each time it is called.
* FILE is either a filename or a constant (written as a character
* string). The routine first tries to open the file, if it fails it
* then tries to translate the string into a double precision constant
* which will then be returned on subsequent calls.
* If it succeeds, it then tries to read the lines of the file which will
* be returned as the constant.
*
* IFAIL = 0 if all ok, = 1 if FILE cannot be translated, 2 if
*         a line of the file cannot be read, 3 if the end of the 
*         file has been reached.
*
* After you have finished calling the routine, you must call it with
* IFAIL = -1 to close down the file and reset the routine for 
* the next time.
*
      CHARACTER*(*) FILE
      DOUBLE PRECISION CONST
      INTEGER IFAIL, IOPEN
      LOGICAL FIRST
      DATA FIRST/.TRUE./
*
      IF(IFAIL.EQ.-1) THEN
        FIRST = .TRUE.
        CLOSE(UNIT=43)
        RETURN
      END IF
      IF(FIRST) THEN
        CLOSE(UNIT=43)
        OPEN(UNIT=43,FILE=FILE,STATUS='OLD',IOSTAT=IOPEN)
        FIRST = .FALSE.
      END IF
      IF(IOPEN.EQ.0) THEN
        READ(43,*,END=999,ERR=997) CONST
      ELSE
        READ(FILE,*,ERR=998) CONST
      END IF
      IFAIL = 0
      RETURN
997   IFAIL = 1
      CLOSE(UNIT=43)
      FIRST = .TRUE.
      RETURN
998   IFAIL = 2
      CLOSE(UNIT=43)
      FIRST = .TRUE.
      RETURN
999   IFAIL = 3
      CLOSE(UNIT=43)
      FIRST = .TRUE.
      RETURN
      END
