      SUBROUTINE CHAR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, VALUE, IFAIL)
*
* Gets or translates character input
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, NCOM
      CHARACTER*(*) PROMPT, VALUE, SPLIT(MXSPLIT)
      CHARACTER*256 INPUT, FGETLINNH
      CHARACTER*256 BPROMPT
      LOGICAL DEFAULT
      INTEGER IFAIL, LENSTR
      LOGICAL CONFRM
      COMMON/INGET/CONFRM
*
      IF(NCOM.LT.0 .OR. NCOM.GT.MXSPLIT-1) THEN
        IFAIL = 1
        RETURN
      END IF
      NCOM = NCOM + 1
      IF(IFAIL.NE.0) RETURN
      IF(NSPLIT.GE.NCOM) THEN
        IF(SPLIT(NCOM).EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(SPLIT(NCOM).EQ.'?') THEN
          GOTO 100
        ELSE
          VALUE   = SPLIT(NCOM)
        END IF
      ELSE IF(.NOT.DEFAULT) THEN
100     CONTINUE
        WRITE(BPROMPT,'(A,'' ['',A,'']: '',$)') PROMPT(:LENSTR(PROMPT)),
     &  VALUE(:MAX(1,LENSTR(VALUE)))
        INPUT = FGETLINNH(BPROMPT)
c        READ(*,'(A)',ERR=999) INPUT
        IF(INPUT.EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INPUT.NE.' ') THEN
          VALUE = INPUT
        END IF
      END IF
      IF(CONFRM) THEN
        WRITE(*,'(1X,A,A,A)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE(:MAX(1,LENSTR(VALUE)))
      END IF
      IFAIL = 0
      RETURN
      IFAIL = 1
      RETURN
      END   

      SUBROUTINE DOUB_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, VALUE, VLO, VHI, IFAIL)
*
* Gets or translates double precision input
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, NCOM, I
      CHARACTER*(*) PROMPT, SPLIT(MXSPLIT)
      CHARACTER*100 INPUT
      DOUBLE PRECISION VALUE, VLO, VHI, VOLD
      DOUBLE PRECISION V1, V2
      LOGICAL DEFAULT
      INTEGER IFAIL, LENSTR
      LOGICAL CONFRM
      COMMON/INGET/CONFRM
*
      IF(NCOM.LT.0 .OR. NCOM.GT.MXSPLIT-1) THEN
        IFAIL = 1
        RETURN
      END IF
      NCOM = NCOM + 1
      IF(IFAIL.NE.0) RETURN
      VOLD = VALUE
      IF(NSPLIT.GE.NCOM) THEN
        IF(SPLIT(NCOM).EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INDEX(SPLIT(NCOM),'?').GT.0) THEN
          GOTO 100
        ELSE
          IF(INDEX(SPLIT(NCOM),'++').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'++')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 + V2
          ELSE IF(INDEX(SPLIT(NCOM),'--').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'--')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 - V2
          ELSE IF(INDEX(SPLIT(NCOM),'**').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'**')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 * V2
          ELSE IF(INDEX(SPLIT(NCOM),'//').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'//')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 / V2
          ELSE
            READ(SPLIT(NCOM),*,ERR=998) VALUE
          END IF 
        END IF
      ELSE IF(.NOT.DEFAULT) THEN
100     WRITE(*,'(A,'' ['',G21.14,'']: '',$)')
     &   PROMPT(:LENSTR(PROMPT)),VALUE
        READ(*,'(A)',ERR=999) INPUT
        IF(INPUT.EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INPUT.EQ.'?') THEN
          WRITE(*,*) 'Input range: ',VLO,' to ',VHI
          GOTO 100
        ELSE IF(INPUT.NE.' ') THEN
          IF(INDEX(INPUT,'++').GT.1) THEN
            I = INDEX(INPUT,'++')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 + V2
          ELSE IF(INDEX(INPUT,'--').GT.1) THEN
            I = INDEX(INPUT,'--')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 - V2
          ELSE IF(INDEX(INPUT,'**').GT.1) THEN
            I = INDEX(INPUT,'**')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 * V2
          ELSE IF(INDEX(INPUT,'//').GT.1) THEN
            I = INDEX(INPUT,'//')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 / V2
          ELSE
            READ(INPUT,*,ERR=998) VALUE
          END IF
        END IF
      END IF
      IF(VALUE.LT.VLO .OR. VALUE.GT.VHI) THEN
        WRITE(*,'(1X,A,A,G21.14)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE
        WRITE(*,*) 'Input out of range ',VLO,' to ',VHI
        GOTO 999
      END IF   
      IF(CONFRM) THEN
        WRITE(*,'(1X,A,A,G21.14)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE
      END IF
      IFAIL = 0
      RETURN
998   WRITE(*,*) 'Can''t understand: ',INPUT(:LENSTR(INPUT))
999   VALUE = VOLD
      IFAIL = 1
      RETURN
      END                      

      SUBROUTINE INTR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, VALUE, VLO, VHI, IFAIL)
*
* Gets or translates integer input
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, NCOM, I
      CHARACTER*(*) PROMPT, SPLIT(MXSPLIT)
      CHARACTER*100 INPUT
      INTEGER VALUE, VLO, VHI, VOLD, V1, V2
      LOGICAL DEFAULT
      INTEGER IFAIL, LENSTR
      LOGICAL CONFRM
      COMMON/INGET/CONFRM
*
      IF(NCOM.LT.0 .OR. NCOM.GT.MXSPLIT-1) THEN
        IFAIL = 1
        RETURN
      END IF
      NCOM = NCOM + 1
      IF(IFAIL.NE.0) RETURN
      VOLD = VALUE
      IF(NSPLIT.GE.NCOM) THEN
        IF(SPLIT(NCOM).EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INDEX(SPLIT(NCOM),'?').GT.0) THEN
          GOTO 100
        ELSE 
          IF(INDEX(SPLIT(NCOM),'++').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'++')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 + V2
          ELSE IF(INDEX(SPLIT(NCOM),'--').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'--')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 - V2
          ELSE IF(INDEX(SPLIT(NCOM),'**').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'**')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 * V2
          ELSE IF(INDEX(SPLIT(NCOM),'//').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'//')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 / V2
          ELSE
            READ(SPLIT(NCOM),*,ERR=998) VALUE
          END IF
        END IF
      ELSE IF(.NOT.DEFAULT) THEN
100     WRITE(*,'(A,'' ['',I8,'']: '',$)') PROMPT(:LENSTR(PROMPT)),
     &  VALUE
        READ(*,'(A)',ERR=999) INPUT
        IF(INPUT.EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INPUT.EQ.'?') THEN
          WRITE(*,*) 'Input range: ',VLO,' to ',VHI
          GOTO 100
        ELSE IF(INPUT.NE.' ') THEN
          IF(INDEX(INPUT,'++').GT.1) THEN
            I = INDEX(INPUT,'++')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 + V2
          ELSE IF(INDEX(INPUT,'--').GT.1) THEN
            I = INDEX(INPUT,'--')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 - V2
          ELSE IF(INDEX(INPUT,'**').GT.1) THEN
            I = INDEX(INPUT,'**')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 * V2
          ELSE IF(INDEX(INPUT,'//').GT.1) THEN
            I = INDEX(INPUT,'//')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 / V2
          ELSE
            READ(INPUT,*,ERR=998) VALUE
          END IF
        END IF
      END IF
      IF(VALUE.LT.VLO .OR. VALUE.GT.VHI) THEN
        WRITE(*,'(1X,A,A,I8)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE
        WRITE(*,*) 'Input out of range ',VLO,' to ',VHI
        GOTO 999
      END IF
      IF(CONFRM) THEN
        WRITE(*,'(1X,A,A,I8)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE
      END IF   
      IFAIL = 0
      RETURN
998   WRITE(*,*) 'Can''t understand: ',INPUT(:LENSTR(INPUT))
999   VALUE = VOLD
      IFAIL = 1
      RETURN
      END                      

      SUBROUTINE REAL_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, VALUE, VLO, VHI, IFAIL)
*
* Gets or translates integer input
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, NCOM, I
      CHARACTER*(*) PROMPT, SPLIT(MXSPLIT)
      CHARACTER*100 INPUT
      REAL VALUE, VLO, VHI, VOLD, V1, V2
      LOGICAL DEFAULT
      INTEGER IFAIL, LENSTR
      LOGICAL CONFRM
      COMMON/INGET/CONFRM
*
      IF(NCOM.LT.0 .OR. NCOM.GT.MXSPLIT-1) THEN
        IFAIL = 1
        RETURN
      END IF
      NCOM = NCOM + 1
      IF(IFAIL.NE.0) RETURN
      VOLD = VALUE
      IF(NSPLIT.GE.NCOM) THEN
        IF(SPLIT(NCOM).EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INDEX(SPLIT(NCOM),'?').GT.0) THEN
          GOTO 100
        ELSE 
          IF(INDEX(SPLIT(NCOM),'++').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'++')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 + V2
          ELSE IF(INDEX(SPLIT(NCOM),'--').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'--')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 - V2
          ELSE IF(INDEX(SPLIT(NCOM),'**').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'**')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 * V2
          ELSE IF(INDEX(SPLIT(NCOM),'//').GT.1) THEN
            I = INDEX(SPLIT(NCOM),'//')
            READ(SPLIT(NCOM)(:I-1),*,ERR=998) V1
            READ(SPLIT(NCOM)(I+2:),*,ERR=998) V2
            VALUE = V1 / V2
          ELSE
            READ(SPLIT(NCOM),*,ERR=998) VALUE
          END IF
        END IF
      ELSE IF(.NOT.DEFAULT) THEN
100     WRITE(*,'(A,'' ['',G13.7,'']: '',$)') 
     &  PROMPT(:LENSTR(PROMPT)),VALUE
        READ(*,'(A)',ERR=999) INPUT
        IF(INPUT.EQ.'\\') THEN
          DEFAULT = .TRUE.
        ELSE IF(INPUT.EQ.'?') THEN
          WRITE(*,*) 'Input range: ',VLO,' to ',VHI
          GOTO 100
        ELSE IF(INPUT.NE.' ') THEN
          IF(INDEX(INPUT,'++').GT.1) THEN
            I = INDEX(INPUT,'++')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 + V2
          ELSE IF(INDEX(INPUT,'--').GT.1) THEN
            I = INDEX(INPUT,'--')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 - V2
          ELSE IF(INDEX(INPUT,'**').GT.1) THEN
            I = INDEX(INPUT,'**')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 * V2
          ELSE IF(INDEX(INPUT,'//').GT.1) THEN
            I = INDEX(INPUT,'//')
            READ(INPUT(:I-1),*,ERR=998) V1
            READ(INPUT(I+2:),*,ERR=998) V2
            VALUE = V1 / V2
          ELSE
            READ(INPUT,*,ERR=998) VALUE
          END IF
        END IF
      END IF
      IF(VALUE.LT.VLO .OR. VALUE.GT.VHI) THEN
        WRITE(*,'(1X,A,A,G13.7)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE
        WRITE(*,*) 'Out of range ',VLO,' to ',VHI
        GOTO 999
      END IF   
      IF(CONFRM) THEN
        WRITE(*,'(1X,A,A,G13.7)') PROMPT(:LENSTR(PROMPT)),' = ',
     &  VALUE
      END IF
      IFAIL = 0
      RETURN
998   WRITE(*,*) 'Can''t understand: ',INPUT(:LENSTR(INPUT))
999   VALUE = VOLD
      IFAIL = 1
      RETURN
      END                      




