*GFIT
* GFIT N1 N2 N3 W0 WIDTH FWHM BACK AREA SW0 SBACK SAREA SFWHM -- Fits gaussians
*
* Parameters
*       N1, N2  -- Range of slots to analyse
*       N3      -- Slot to store fits
*       W0      -- Rest wavelength of line
*       WIDTH   -- Fit width in km/s around rest wavelength
*       FWHM    -- FWHM of gaussian, km/s
*       BACK    -- Continuum background
*       AREA    -- Area under peak
*       SW0     -- Uncertainty in line position (km/s)
*       SBACK   -- Uncertainty in continuum level
*       SAREA   -- Uncertainty in area
*       SFWHM   -- Uncertainty in FWHM               
*
* Set the uncertainty on a parameter = 0 to fix it, otherwise it will be
* fitted.
*GFIT
      SUBROUTINE GASFIT(SPLIT, NSPLIT, MXSPLIT, WORK1, WORK2, WORK3, 
     &MXWORK, COUNTS, ERRORS, FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, 
     &NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &MXSINTR, MXSREAL, SLOTS, MXSLOTS, IFAIL)
*
* Routine for measuring radial velocities by gaussian fitting
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  R     WORK1(MXWORK)    -- Work arrays 
* >  R     WORK2(MXWORK)
* >  R     WORK3(MXWORK)
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*                                incremented and returned by routine.
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Plot parameters
*
      INTEGER MXWORK 
      REAL WORK1(MXWORK), WORK2(MXWORK), WORK3(MXWORK)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Local variables
*
      REAL COREFIT, WINGFIT
      EXTERNAL COREFIT, WINGFIT
      INTEGER I, J, K,  N,  NCOM, NFIT
      REAL GET_FLX, GET_ERF
      DOUBLE PRECISION  ANGST, VEARTH, PIXL, DISPA, CHISQ
      REAL PIXCEN, PIXSIG, DISP,  VERR
      INTEGER SLOT1, SLOT2,  IFAIL,  SLOT3
      INTEGER  MAXSPEC, NLO, NHI, NTOT
      LOGICAL SELECT,   DEFAULT
      REAL VLIGHT, CGS,  WIDTH, FWHM
      REAL AREA, VSHIFT, SIGW, SIGB, SIGA, SIGF, ARE, CON, X0
      REAL WID, SA, SB, SIGX0,  SIGWID, BACK, F, CFR, HG
      DOUBLE PRECISION PHASE, HJD, W0
*
* Functions
*
      INTEGER  CFRAT
*
      DATA SLOT1, SLOT2, SLOT3, WIDTH/ 1, 1, 0, 10000./
      DATA W0, FWHM, AREA, BACK/5.D3, 1000., 1.E-14, 1/
      DATA SIGW, SIGB, SIGA, SIGF/100., 0.1, 1.E-15, 100./
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
*
      CALL INTR_IN('First slot to fit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to fit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to fit'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      CALL INTR_IN('Slot to store fits', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      CALL DOUB_IN('Rest wavelength', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, W0, 0.D0, 1.D6, IFAIL)
      CALL REAL_IN('Fit window (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, WIDTH, 0., 1.E5, IFAIL)
      CALL REAL_IN('Gaussian FWHM (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FWHM, 0., 1.E5, IFAIL)
      CALL REAL_IN('Continuum background', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, BACK, -1.E30, 1.E30, IFAIL)
      CALL REAL_IN('Flux of peak', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &DEFAULT, AREA, -1.E30, 1.E30, IFAIL)
      CALL REAL_IN('Line position sigma (km/s)', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SIGW, 0., 1.E5, IFAIL)
      CALL REAL_IN('Continuum sigma', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SIGB, 0., 1.E30, IFAIL)
      CALL REAL_IN('Flux sigma', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SIGA, 0., 1.E30, IFAIL)
      CALL REAL_IN('FWHM sigma', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SIGF, 0., 1.E5, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
***************************************************************************
*
* Loop through spectra, measuring wavelength.
*
      VLIGHT = CGS('C')/1.E5
      K = SLOT3 - 1
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF(NPIX(SLOT).LE.0) THEN
          WRITE(*,*) 'No spectrum in slot ',SLOT
          GOTO 100
        END IF
        IF(NARC(SLOT).EQ.0) THEN
          WRITE(*,*) 'No arc coefficients in slot ',SLOT
          GOTO 100
        END IF
        IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &    HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &    MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, VSCHAR, 
     &    NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &    NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &    MXSREAL)) THEN
          WRITE(*,*) 'Skipped slot ',SLOT
          GOTO 100
        END IF
*
* Load up arrays
*
        N = 0
        DO J = 1, NPIX(SLOT)
          WORK1(J) = ANGST(REAL(J), NPIX(SLOT), NARC(SLOT), 
     &               ARC(1,SLOT), MXARC)
*
* Load Y array
*
          WORK2(J) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
*
* Load errors array
*
          WORK3(J) = GET_ERF(COUNTS(J,SLOT), 
     &    ERRORS(J,SLOT), FLUX(J,SLOT))
        END DO         
*
        PIXCEN = PIXL(W0, NPIX(SLOT), NARC(SLOT), 
     &           ARC(1,SLOT), MXARC)
        DISP   = DISPA(PIXCEN, NPIX(SLOT), NARC(SLOT), 
     &           ARC(1,SLOT), MXARC)
        PIXSIG = WIDTH/VLIGHT*W0/ABS(DISP)
        NLO    = NINT(PIXCEN - PIXSIG/2.)
        NHI    = NINT(PIXCEN + PIXSIG/2.)
        NLO = MAX(1, MIN(NLO, NPIX(SLOT)))
        NHI = MAX(1, MIN(NHI, NPIX(SLOT)))
        NTOT = NHI-NLO+1
*
        ARE = AREA*1.E13*W0**2/VLIGHT
        CON = BACK
        X0  = W0
        WID = W0*FWHM/VLIGHT/2.35482
        SA  = SIGA*1.E13*W0**2/VLIGHT
        SB  = SIGB
        SIGX0  = W0*SIGW/VLIGHT
        SIGWID = W0*SIGF/VLIGHT/2.35482
*
* Check that there are some points to fit
*
        NFIT = 0
        DO J = NLO, NLO+NTOT-1
           IF(WORK3(J).GT.0.) NFIT = NFIT + 1
        END DO
        IF(NFIT.LE.4) THEN
           WRITE(*,*) 'There are no valid points to fit'//
     &          ' in spectrum ',SLOT
           GOTO 999
        END IF
*
* Fit gaussian
*
	CALL FITGAUSS( NTOT, WORK1(NLO), WORK2(NLO), WORK3(NLO), 
     &  ARE, CON, WID, X0, SA, SB, SIGWID, SIGX0 )
*
* If SLOT3 .GT. 0, store results there.
*
        IF(SLOT3.GT.0) THEN
          K = K + 1
*
* Copy headers
*
          CALL SET_HEAD(K, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &    NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &    HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &    MXREAL, IFAIL)
*
* Initialise spectrum
*
          HG = ARE/WID/SQRT(8.*ATAN(1.))         
          CHISQ = 0.D0
          DO J = 1, NPIX(K)
            CFR = CFRAT(COUNTS(J,SLOT),FLUX(J,SLOT))
            ERRORS(J,K) = 1.E-10
            IF(J.LT.NLO .OR. J.GT.NHI) THEN
              COUNTS(J,K) = 0.
              FLUX(J,K)   = CFR
            ELSE
              F  = CON + HG*EXP(-((WORK1(J)-X0)/WID)**2/2.)
              CHISQ = CHISQ + ((F-WORK2(J))/WORK3(J))**2
              COUNTS(J,K) = CFR*F
              IF(COUNTS(J,K).EQ.0.) THEN
                FLUX(J,K) = CFR
              ELSE
                FLUX(J,K) = F
              END IF
            END IF
          END DO
          WRITE(*,*) 'Chi**2 = ',CHISQ
        END IF
        CALL HGETD('Vearth',VEARTH,SLOT,MXSPEC,NMDOUB,HDDOUB,
     &  NDOUB,MXDOUB,IFAIL)
        IFAIL = 0
        ARE    = VLIGHT*ARE/1.E13/X0**2
        SA     = VLIGHT*SA/1.E13/X0**2
        WID    = 2.35482*VLIGHT*WID/X0
        SIGWID = 2.35482*VLIGHT*SIGWID/X0
        VSHIFT = VLIGHT*(X0-W0)/W0-VEARTH
        VERR   = VLIGHT*SIGX0/X0
        X0     = X0*(1.-VEARTH/VLIGHT)
        WRITE(*,*) '          Flux = ',ARE,'+/-',SA
        WRITE(*,*) '    Background = ',CON,'+/-',SB
        WRITE(*,*) '    Wavelength = ',X0,'+/-',SIGX0
        WRITE(*,*) '         Width = ',WID,'+/-',SIGWID
        WRITE(*,*) 'Velocity shift = ',VSHIFT,'+/-',VERR
        CALL HGETD('Orbital phase', PHASE, SLOT, MXSPEC, NMDOUB, 
     &  HDDOUB, NDOUB, MXDOUB, IFAIL)
        CALL HGETD('HJD', HJD, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &  NDOUB, MXDOUB, IFAIL)
        WRITE(32,*,IOSTAT=IFAIL) HJD, PHASE, VSHIFT, VERR
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not write to unit 32'
        WRITE(32,*,IOSTAT=IFAIL) X0, SIGX0, ARE, SA
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not write to unit 32'
        WRITE(32,*,IOSTAT=IFAIL) CON, SB, WID, SIGWID
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not write to unit 32'
100     CONTINUE
      END DO
      CLOSE(UNIT=32)
      WRITE(*,*) 'Results written to FOR032'
      IFAIL = 0
      RETURN
999   IFAIL = 1
      RETURN
      END
