*FLUX
* FLUX NF NW (WEX FUDGE (NFL NFS SET) or WFAC ) FDAT [BWIDTH] 
*      NSPLINE RLO RHI NREJ FLIN SOFT
*
* Method:
*
* FLUX prepares flux calibration data for later application to objects.
* The object is to get conversion factors so that from a number of
* counts/sec at a particular pixel, the flux can be computed. FLUX does
* this by taking the ratio of an observation of a flux standard to
* tabulated data. The counts are left the same while the flux is adjusted
* to give the same flux as the tabulated data, with the flux/counts ratio
* obtained by spline interpolation of the individual points.
*
* Telluric absorption lines:
*
* With this spectrum one can then flux calibrate spectra with FCAL which
* applies extinction corrections at the same time. Normally FLUX does not 
* need to bother with continuum extinction correction since the latter is 
* smooth with wavelength. However, what if your data is affected by telluric
* absorption lines which are sharp features? The first thing to say is, if 
* you can avoid using such regions, then that is what you should do. In this
* case eliminate any tabulated data points in the region affected, and hope 
* that the spline interpolation can hop over these regions. However, if you are
* desparate AND the tabulated data has been corrected (e.g. with a model
* atmosphere) then FLUX allows you to remove the telluric lines as far as
* possible.
*
*   To use this feature you must have a spectrum of a featureless object, 
* normalised to 1 (and then set exactly equal to 1 to reduce noise) outside 
* the telluric line regions. This is best done by fitting a spline with 
* SFIT. The absorption lines may be saturated and their strength will then 
* not be linearly proportional to airmass in general (in contrast to the 
* continuum absorption). At low and intermediate resolution this can be
* approximately handled by (a) using a power law scaling or (b) trying to
* minimise scatter in a well defined telluric region. The latter can be good 
* if you cover the strong 7600A absorption feature, but are interested in
* fluxes in weaker features (the 7600 region can hardly ever be reliably
* corrected for accurate work). At the moment molly does not include any
* automatic method for correcting high res data (i.e. where the lines are
* well resolved) affected by telluric lines. In such cases the strength
* scales with airmass in a different way for each pixel and probably a
* close by standard is the best method for getting rid of the features.
*
* Tabulated data:
*
* Tabulated data comes in 2 forms. First there are the Oke type tables of
* fluxes measured over short intervals away from absorption lines. These
* trade off statistical noise in favour of reduced systematics since only
* a small fraction of the spectrum is actually used, but it the most
* reliable fraction. If your standards are bright it may be the method you
* want.
*
* Alternatively there is the Fillipenko-Greenstein form where the fluxes
* they give result from a spline fit to the continuum avoiding lines. This
* uses more of the spectrum and is therefore more open to systematic
* effects, but is better for faint standards.
*
* FLUX distinguishes between these according to whether there is a third
* column indicating band-pass (if yes then it is Oke). For Oke type data, 
* counts are measured in the same intervals as tabulated and the ratio of the 
* standard/observed is taken. This is then fitted with a spline to give the 
* flux calibration. 
*
* For Fillipenko data, the table values are interpolated (linearly) onto the 
* same wavelength scale as the observed spectrum. This obviously requires
* the tabulated data to be reasonably finely spaced, although the later
* spline fit will correct for some roughness. The spectrum is then blocked
* ratios are taken and a spline fitted as for Oke data. If the tabulated
* data does not cover the data range input you will be warned and the data
* will not be used.
*
* See below for more about the format of the flux file and how you can 
* interpolate extra points since small numbers of points often cause
* difficulty.
* 
* Parameters:
*
*    NF -- Slot with flux star (wide slit spectrum)
*
*    NW -- Slot with telluric absorption calibrations spectrum (called water
*          for short). 0 if you don't need to correct for it.
*          If you do, to prepare such a star ideally you require an
*          intrinsically featureless spectrum observed with the same width
*          slit as your targets. Divide this through by a spline fit to
*          regions unaffected by telluric absorption and set these regions
*          equal to 1 with CSET. 
*
*    If you need a water star then you also need to specify:
*
*    WEX -- Exponent for scaling telluric absorption spectrum from one airmass 
*           to another according to the equation A' = A*(AM_O/AM_W)**WEX where 
*           A' is the aborption in mags for a target and A is the calibration 
*           data, AM_O and AM_W are the airmasses of object and standard and 
*           WEX is the exponent. If the telluric absorption was linear, WEX 
*           would equal 1, but normally the lines are saturated and WEX=0.6 is 
*           closer to the mark. 
*
*    FUDGE - Rather than using the above scaling, the correction can be made
*            by minimising the scatter in the absorption regions. The scatter 
*            is judged by correcting the spectrum, smoothing a little to account
*            for shifts between standard and target which impose a spurious 
*            scatter (NFS smallscale filter width), and then taking difference 
*            with the same spectrum smoothed alot (NFL largescale width). This 
*            is then iterated to minimise scatter.
*
*     NFS -  Small scale smoothing. Enough to account for shifts between
*            water star and target. Needs to be higher for flux star taken
*            through wide slit as difference of resolution causes artificial
*            scatter.
*
*     NFL -  Large scale smoothing. Larger than typical scale of telluric
*            absorption.
*
*     SET  - You then have set a mask to tell it where telluric lines are. 
*            You don't need to mask them all, just tell it where a few good 
*            ones are (the one near 7600A would be an obvious choice in the
*            near IR).
*
*     WFAC - If you don't wish to fudge, you have the option of specifying a 
*            ratio between the airmass used for the telluric absorption 
*            (``watermass'') and the true airmass. Ideally this should = 1
*            but may not if for example you use a standard from one night for
*            the next night and the vapour content has changed.
*
*    Back to parameters you always need:
*
*     FDAT - Next need a file with flux data which should be columns of form
*            WAVELENGTH (Angstroms), AB magnitudes or mJy fluxes, BANDWIDTH 
*            (Angstroms) for Oke type data only. # and * are comment flags
*            but there should be one line before the data starts to indicate
*            the type of flux being used. The line should be of the form
*            Fluxes=AB or Fluxes=mJy. The tables should increase in
*            wavelength monotonically. I tend to favour AB mags because I
*            think that they interpolate better.
*
*            Often you find that you don't have enough , in which case you can 
*            put entries such as 8300 -100. 40. and then the routine will 
*            interpolate a flux at that wavelength. Obviously you have to be 
*            careful with this, in particular avoid lines. I use this quite
*            extensively because otherwise I find the fit does not follow the
*            true variations. This is particularly the case at high
*            dispersion.
*
*      BWIDTH - If the data is identified as being Fillipenko type you
*            have to enter a width in pixels for forming data points. 
*            1 for high S/N data, but more if you don't have enough
*            photons.
*
*      NSPLINE, RLO, RHI, NREJ -- Parameters for spline fit to flux data, but
*            you will be allowed to adjust the number and positions of spline
*            knots interactively as flux data can often prove difficult for
*            automatic setting of knots. 
*
*      FLIN -- Fit to linear data (else log). Large dynamic
*              range data sometimes better if fitted with log 
*
*      SOFT -- Number to ``soften'' weights for fit. The variances
*              become V' = SOFT*VBAR+(1-SOFT)*V where V are the
*              original variances and VBAR their mean. SOFT = 1
*              gives unit weights
*
* Related command: FCAL
*
*FLUX
      SUBROUTINE FLX_FIT(SPLIT, NSPLIT, MXSPLIT, PLOT1, PLOT2, 
     &PLOT3, PLOT4, PLOT5, PLOT6, PLOT7, MASK, MXPLOT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &WTAB, FLTAB, BTAB, DWORK1, DWORK2, DWORK3, DWORK4, KEY, 
     &MXTAB, IFAIL)
*
* FLX_FIT for fitting flux stars.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  R     PLOT1(MXPLOT)    -- Work arrays for plotting
* >  R     PLOT2(MXPLOT)
* >  R     PLOT3(MXPLOT)
* >  R     PLOT4(MXPLOT)
* >  R     PLOT5(MXPLOT)
* >  R     PLOT6(MXPLOT)
* >  L     MASK(MXPLOT)     -- Mask array
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    R     WTAB(MXTAB)  -- For tabular data
*    R     FLTAB(MXTAB)
*    R     BTAB(MXTAB)
*    D     DWORK1(MXTAB)
*    D     DWORK2(MXTAB)
*    D     DWORK3(MXTAB)
*    D     DWORK4(MXTAB)
*    I     KEY(MXTAB)
*    I     MXTAB
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Plot parameters
*
      INTEGER MXPLOT 
      REAL PLOT1(MXPLOT), PLOT2(MXPLOT), PLOT3(MXPLOT)
      REAL PLOT4(MXPLOT), PLOT5(MXPLOT), PLOT6(MXPLOT)
      REAL PLOT7(MXPLOT)
      LOGICAL MASK(MXPLOT)
*
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)         
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Plot parameters
*
*
* Line list arrays
*
      INTEGER MXTAB, NTAB
      REAL WTAB(MXTAB), FLTAB(MXTAB), BTAB(MXTAB)
      DOUBLE PRECISION DWORK1(MXTAB), DWORK2(MXTAB)
      DOUBLE PRECISION DWORK3(MXTAB), DWORK4(MXTAB)
      INTEGER KEY(MXTAB)
*
* Local variables
*
      INTEGER I, J, K, N, J1, J2,  NCOM, NP
      REAL GET_FLX,   MJY_AB
      DOUBLE PRECISION  ANGST, VEARTH,  AIRMASS
      REAL  X1, X2,  P, FLX, W0, WFAC
      REAL FAIR, WAIR, AIR, Y1, Y2,  P1, P2
      DOUBLE PRECISION SUM1, SUM2,  SUM3,  SUM4, PIXL
      DOUBLE PRECISION W1, W2, WMIN, WMAX
      CHARACTER*100 STRING
      CHARACTER*64 TABLE
      CHARACTER*10  REPLY, CH*1, FLIN*3, FTYPE
      INTEGER SLOT1, SLOT2,  IFAIL,  NREJ, NOK
      INTEGER  MAXSPEC,  NSPLINE, IPOS, BWIDTH, NGREAT
      INTEGER I1, I2, NFL, NFS
      LOGICAL  SAMECI, OKE, DEFAULT, NEW
      REAL DIFF, THRLO, THRHI, WAT, WATER
      REAL STAN, WAVE, X, Y, TOL, SOFT
      REAL RATIO, RLO, RHI
      CHARACTER*3 FUDGE, SET
*
* Functions
*
      INTEGER LENSTR, PGCURSE
*
* Spline parameters
*
      LOGICAL FIX
      INTEGER NCAP7,MAXKNOT
      PARAMETER (MAXKNOT=100)
      DOUBLE PRECISION  XKNOT(MAXKNOT), CSPLINE(MAXKNOT+3)
*
      SAVE SLOT1, SLOT2, BWIDTH, TABLE, WATER, NSPLINE
      SAVE THRLO, THRHI, NREJ, FUDGE, SET, NPMASK, NVMASK
      SAVE NWMASK, NFL, NFS, WFAC, SOFT, FLIN
      DATA SLOT1, SLOT2, BWIDTH/1, 0, 1/
      DATA TABLE/'FLUX.DAT'/
      DATA WATER/0.5/
      DATA NSPLINE, THRLO, THRHI, NREJ/3,-3.,3.,10/
      DATA  FUDGE, SET/'Y', 'Y'/
      DATA NPMASK, NVMASK, NWMASK/0,0,0/
      DATA NFL, NFS, WFAC, SOFT/31, 3, 1., 0./
      DATA FLIN/'y'/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      CALL INTR_IN('Slot containing flux star', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NPIX(SLOT1).LE.0) THEN
        WRITE(*,*) 'Slot ',SLOT1,' empty'
        IFAIL = 1
        GOTO 999
      END IF
      IF(NARC(SLOT1).EQ.0) THEN 
        WRITE(*,*) 'Slot ',SLOT1,' has no wavelength calibration'
        IFAIL = 1
        GOTO 999
      END IF
      CALL HGETD('Airmass', AIRMASS, SLOT1, MXSPEC, NMDOUB, HDDOUB, 
     &NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Flux standard has no airmass'
        GOTO 999
      END IF            
      FAIR = REAL(AIRMASS)
*
* Get wavelength range
*
      W1 = ANGST(0.5, NPIX(SLOT1), NARC(SLOT1), ARC(1,SLOT1), MXARC)
      W2 = ANGST(REAL(NPIX(SLOT1))+0.5, NPIX(SLOT1), NARC(SLOT1), 
     &     ARC(1,SLOT1), MXARC)
      WMIN = MIN(W1, W2)
      WMAX = MAX(W1, W2)
*
      CALL INTR_IN('Slot with water star', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT2.GT.0) THEN
        IF(NPIX(SLOT2).LE.0) THEN
          WRITE(*,*) 'Slot ',SLOT2,' empty'
          IFAIL = 1
          GOTO 999
        END IF
        IF(NARC(SLOT2).EQ.0) THEN 
          WRITE(*,*) 'Slot ',SLOT2,' has no wavelength calibration'
          IFAIL = 1
          GOTO 999
        END IF
        CALL HGETD('Airmass', AIRMASS, SLOT2, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Water standard has no airmass'
          IFAIL = 1
          GOTO 999
        END IF        
        WAIR = REAL(AIRMASS)    
*
        CALL REAL_IN('Water exponent', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, WATER, -1000., 1000., IFAIL)
        CALL CHAR_IN('Fudge watermass?', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, FUDGE, IFAIL)
        CALL UPPER_CASE(FUDGE)
*
        IF(FUDGE.EQ.'Y') THEN
          CALL INTR_IN('Largescale filter width (odd)', SPLIT, 
     &    NSPLIT, MXSPLIT, NCOM, DEFAULT, NFL, 3, 1001, IFAIL)
          NFS = MIN(NFS, NFL-2)
          CALL INTR_IN('Smallscale filter width (odd)', SPLIT, 
     &    NSPLIT, MXSPLIT, NCOM, DEFAULT, NFS, 1, NFL-2, IFAIL)
          IF(IFAIL.NE.0) GOTO 999
*
          CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
          CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, SET, IFAIL)
          IF(SAMECI(SET,'YES')) THEN
            WRITE(*,*) 'Mask regions which show only telluric lines'
            CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &           NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &           NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, PLOT1, 
     &           PLOT2, PLOT3, MXPLOT, MASK)
          END IF
          CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
          IF(SAMECI(SET,'YES')) THEN
            WRITE(*,*) 'No regions masked'
            GOTO 999
          END IF
        ELSE IF(FUDGE.EQ.'N') THEN
          CALL REAL_IN('Ratio water-/air-mass', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, WFAC, 0., 1.E5, IFAIL)
          IF(IFAIL.NE.0) GOTO 999
        ELSE 
          WRITE(*,*) 'Must be either Y or N'
          FUDGE = 'Y'
          GOTO 999
        END IF      
      END IF
*
      CALL CHAR_IN('File containing flux data', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, TABLE, IFAIL)
      OPEN(UNIT=47,FILE=TABLE,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) TABLE(:LENSTR(TABLE)),' not found.'
        GOTO 999
      END IF
*
* Read tabular data but only retaining part near spectrum
* to avoid overflow of buffers.
*
      NTAB = 0
      NGREAT = 0
      OKE   = .TRUE.
      FTYPE = ' '
100   READ(47,'(A)',IOSTAT=IFAIL) STRING
      IF(STRING(1:1).EQ.'#' .OR. STRING(1:1).EQ.'*') GOTO 100
      IF(IFAIL.EQ.0) THEN
        IF(FTYPE.EQ.' ') THEN
          I = INDEX(STRING,'=')
          IF(I.GT.1 .AND. SAMECI(STRING(:I-1),'Fluxes')) THEN
            IF(SAMECI(STRING(I+1:),'MJY')) THEN
              FTYPE = 'MJY'
            ELSE IF(SAMECI(STRING(I+1:),'AB')) THEN
              FTYPE = 'AB'
            ELSE
              WRITE(*,*) 'Could not understand ',STRING(:LENSTR(STRING))
              WRITE(*,*) 'when trying to determine flux type'
              GOTO 999
            END IF
          ELSE
            WRITE(*,*) 'Could not understand ',STRING(:LENSTR(STRING))
            WRITE(*,*) 'when trying to determine flux type'
            GOTO 999
          END IF
          GOTO 100
        END IF
        IF(NTAB.EQ.MXTAB) THEN
           WRITE(*,*) 'Table buffer filled up at ',MXTAB,' points'
           GOTO 999
        END IF
        NTAB = NTAB + 1
*
* Try Oke type data first followed by Fillipenko type
*
        IF(OKE) THEN
          READ(STRING,*,IOSTAT=IFAIL) WTAB(NTAB), FLTAB(NTAB), 
     &    BTAB(NTAB)
          IF(NTAB.EQ.1 .AND. IFAIL.NE.0) OKE = .FALSE.
        END IF
        IF(.NOT.OKE) READ(STRING,*,IOSTAT=IFAIL) WTAB(NTAB), FLTAB(NTAB)
*
        IF(IFAIL.EQ.0) THEN
          IF(WTAB(NTAB).LT.WMIN) THEN
            WTAB(1)  = WTAB(NTAB)
            FLTAB(1) = FLTAB(NTAB)
            IF(OKE) BTAB(1)  = BTAB(NTAB)
            NTAB = 1
          ELSE IF(WTAB(NTAB).GT.WMAX) THEN
            NGREAT = NGREAT + 1
          END IF
          IF(FLTAB(NTAB).GT.-10.) THEN
            KEY(NTAB) = 0
          ELSE 
            KEY(NTAB) = 1
          END IF
          IF(NGREAT.LT.1) THEN
            GOTO 100
          ELSE
            WRITE(*,*) NTAB,' points read'
            CLOSE(UNIT=47)
            IFAIL = 0
          END IF
        ELSE
          WRITE(*,*) 'Failed to translate ',STRING
          GOTO 999
        END IF
      ELSE IF(IFAIL.LT.0) THEN
        WRITE(*,*) NTAB,' points read'
        CLOSE(UNIT=47)
        IF(NTAB.LE.0) THEN
          WRITE(*,*) 'Too few points'
          GOTO 999
        END IF
        IFAIL = 0
      ELSE
        WRITE(*,*) 'Error reading file'
        GOTO 999
      END IF
*
* Interpolate points with mags less then -10.
*
      DO I = 1, NTAB
        IF(FLTAB(I).LT.-10.) THEN
          IF(I.GT.1) THEN
            DO J = I-1,1,-1
              IF(KEY(J).EQ.0) GOTO 10
            END DO
            J  = 0
10          I1 = J
          ELSE
            I1 = 0
          END IF
          IF(I.LT.NTAB) THEN
            DO J = I+1,NTAB
              IF(KEY(J).EQ.0) GOTO 20
            END DO
            J = 0
20          I2 = J
          ELSE
            I2 = 0
          END IF
          IF(I1.EQ.0 .AND. I2.EQ.0) THEN
            WRITE(*,*) 'There are no valid points'
            IFAIL = 1
            GOTO 999
          ELSE IF(I1.EQ.0) THEN
            FLTAB(I) = FLTAB(I2)
          ELSE IF(I2.EQ.0) THEN
            FLTAB(I) = FLTAB(I1)
          ELSE
            FLTAB(I) = (FLTAB(I2)*(WTAB(I)-WTAB(I1))+
     &                  FLTAB(I1)*(WTAB(I2)-WTAB(I)))/
     &                  (WTAB(I2)-WTAB(I1))
          END IF
        END IF
      END DO
      IF(SAMECI(FTYPE,'AB')) THEN
        DO I = 1, NTAB
          FLTAB(I) = MJY_AB(FLTAB(I))
        END DO
      END IF
*
      IF(OKE) THEN
        WRITE(*,*) 'Data is Oke type'
      ELSE
        WRITE(*,*) 'Data is Fillipenko type'
        CALL INTR_IN('Band width (pixels) for forming ratios', 
     &  SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, BWIDTH, 1, 
     &  NPIX(SLOT1), IFAIL)       
      END IF
*
      CALL INTR_IN('Number of splines', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, NSPLINE, 1, 100, IFAIL)
*
* Lower reject threshold
*
      CALL REAL_IN('Lower reject threshold', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, THRLO, -1.E20, 1.E20, IFAIL)
*
* Upper reject threshold
*
      THRHI = MAX(THRLO, THRHI)
      CALL REAL_IN('Upper reject threshold', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, THRHI, THRLO, 1.E20, IFAIL)
*
* Number of reject cycles
*
      CALL INTR_IN('Number of reject cycles', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, NREJ, 0, 100000, IFAIL)
*
* Log or linear fit
*
      CALL CHAR_IN('Linear fit (else log)', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, FLIN, IFAIL)
      IF(.NOT.SAMECI(FLIN,'Y') .AND. .NOT.SAMECI(FLIN,'N')) THEN
        WRITE(*,*) 'Must be either y or n'
        IFAIL = 1
        GOTO 999
      END IF                                                         
*
* Weight factor
*
      CALL REAL_IN('Weight factor (0=no change, 1=unit)', 
     &SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, SOFT, 0., 1., IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
* Start by correcting for telluric absorption in excess of normal
* extinction.
*
      IF(SLOT2.GT.0) THEN
        DO I = 1, NPIX(SLOT2)
          PLOT1(I) = GET_FLX(COUNTS(I,SLOT2), FLUX(I,SLOT2))
        END DO
        CALL REBIN(1, 1, PLOT1, NPIX(SLOT2), PLOT3, 
     &  NPIX(SLOT1), 0., NARC(SLOT2), ARC(1,SLOT2), 
     &  NARC(SLOT1), ARC(1,SLOT1))
        IF(FUDGE.EQ.'N') THEN
          RATIO = (WFAC*FAIR/WAIR)**WATER
        ELSE       
*
* RLO =  0. equivalent to no correction
* RHI =  5. equivalent to over correction (we hope)
* RATIO our best shot
*
          RLO = 0.
          RHI = 10.
          RATIO = (FAIR/WAIR)**WATER
*         
* Get mask
*
          CALL HGETD('Vearth', VEARTH, SLOT1, MXSPEC, 
     &    NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
          IFAIL = 0
          CALL APPMASK(MASK,NPIX(SLOT1),ARC(1,SLOT1),
     &    NARC(SLOT1),MXARC,PMASK,NPMASK,WMASK,NWMASK,
     &    VMASK,NVMASK,MXMASK,.TRUE.,VEARTH,IFAIL)
*
* Find value of ratio which minimises scatter
*
          TOL = 1.E-5
          CALL TEMIN( RLO, RATIO, RHI, TOL, COUNTS(1,SLOT1), 
     &    ERRORS(1,SLOT1), MASK, PLOT3, NPIX(SLOT1), PLOT4, 
     &    PLOT5, PLOT6, NFL, NFS, IFAIL)
          AIR = WAIR*RATIO**(1./WATER)
*
* Report effective airmass found
*
          WRITE(*,*) 'Effective watermass found = ',AIR
          WRITE(*,*) '      compared to airmass = ',FAIR
        END IF
      END IF
*
* Apply to flux spectrum to obtain revised counts and errors
* in PLOT1 and PLOT2
*
      DO J = 1, NPIX(SLOT1)
        WAVE = REAL(ANGST(REAL(J), NPIX(SLOT1), NARC(SLOT1), 
     &         ARC(1,SLOT1), MXARC))
        IF(SLOT2.GT.0) THEN
          IF(PLOT3(J).GT.0.) THEN
            WAT = PLOT3(J)**RATIO
          ELSE
            WAT = 1.
          END IF
        ELSE
          WAT = 1.
        END IF
        PLOT1(J) = COUNTS(J,SLOT1)/WAT
        PLOT2(J) = ERRORS(J,SLOT1)/WAT
      END DO
*
* Bin up flux star into same intervals as in table for Oke data
* or in blocks of BWIDTH pixels for Fillipenko data. 
*
      IF(OKE) THEN
        I1 = 0
        I2 = 0
        N = 0
        DO I = 1, NTAB
          W1 = WTAB(I) - BTAB(I)/2.
          P1 = REAL(PIXL(W1, NPIX(SLOT1), NARC(SLOT1), 
     &         ARC(1,SLOT1), MXARC))
          W2 = WTAB(I) + BTAB(I)/2.
          P2 = REAL(PIXL(W2, NPIX(SLOT1), NARC(SLOT1), 
     &         ARC(1,SLOT1), MXARC))
          IF(P2.LT.P1) THEN
            P  = P2
            P2 = P1
            P1 = P
          END IF
          IF(P2.GT.0.5+(P2-P1)/4. .AND.
     &      P1.LT.REAL(NPIX(SLOT1)+0.5)-(P2-P1)/4.) THEN
*
* Try to account for shift in centre of band
*
            W1 = MAX(WMIN, MIN(WMAX, W1))
            W2 = MAX(WMIN, MIN(WMAX, W2))
            W0 = REAL((W1+W2)/2.)
            IF(W0-WTAB(I).GT.BTAB(I)/20. .AND. I.LT.NTAB) THEN
              FLX = (FLTAB(I+1)*(W0-WTAB(I))+FLTAB(I)*
     &              (WTAB(I+1)-W0))/(WTAB(I+1)-WTAB(I))
            ELSE IF(WTAB(I)-W0.GT.BTAB(I)/20. .AND. I.GT.1) THEN   
              FLX = (FLTAB(I)*(W0-WTAB(I-1))+FLTAB(I-1)*
     &              (WTAB(I)-W0))/(WTAB(I)-WTAB(I-1))
            ELSE
              FLX = FLTAB(I)
            END IF
*  
            J1 = MAX(1, MIN(NINT(P1), NPIX(SLOT1)))
            J2 = MAX(1, MIN(NINT(P2), NPIX(SLOT1)))
            SUM1 = 0.D0
            SUM2 = 0.D0
            SUM3 = 0.D0
            DO J = J1, J2
              IF(ERRORS(J,SLOT1).GT.0.) THEN
                SUM1 = SUM1 +  PLOT1(J)
                SUM2 = SUM2 +  PLOT2(J)**2
                SUM3 = SUM3 +  1.D0
              END IF
            END DO
            IF(SUM3.GT.0.5) THEN
              N = N + 1
              PLOT3(N) = W0
              PLOT4(N) = REAL(FLX/SUM1*SUM3)
              PLOT5(N) = REAL(ABS(PLOT4(N)*SQRT(SUM2)/SUM1))
              PLOT7(N) = PLOT5(N)
            END IF
          END IF
        END DO
      ELSE
*
* Fillipenko type data
*
        N = 0
        DO J = 1, NPIX(SLOT1)/BWIDTH
          I1 = BWIDTH*(J-1)+1
          I2 = BWIDTH*J
          IF(J.EQ.NPIX(SLOT1)/BWIDTH) I2 = NPIX(SLOT1)
          SUM1 = 0.D0
          SUM2 = 0.D0
          SUM3 = 0.D0
          SUM4 = 0.D0
          NOK  = 0
          K = 1
          DO I = I1, I2
            IF(ERRORS(I,SLOT1).GT.0.) THEN
              WAVE = REAL(ANGST(REAL(I), NPIX(SLOT1), 
     &         NARC(SLOT1), ARC(1,SLOT1), MXARC))

C     Locate position of wavelength in table and interpolate a value
C     of the flux standard

              CALL HUNT(WTAB,NTAB,WAVE,K)
              IF(K.EQ.0 .OR. K.EQ.NTAB) THEN
                WRITE(*,*) 'Wavelength ',WAVE,
     &          ' out of tabulation range.'
              ELSE
                STAN = ((WAVE-WTAB(K))*FLTAB(K+1)+
     &          (WTAB(K+1)-WAVE)*FLTAB(K))/(WTAB(K+1)-WTAB(K))
                SUM1 = SUM1 + PLOT1(I)
                SUM2 = SUM2 + PLOT2(I)**2
                SUM3 = SUM3 + STAN
                SUM4 = SUM4 + WAVE
                NOK = NOK + 1
              END IF
            END IF
          END DO
          write(*,*) 'sum1,sum3=',sum1,sum3
          IF(NOK.GE.1) THEN
            N = N + 1
            PLOT3(N)  = REAL(SUM4/REAL(NOK))
            PLOT4(N)  = REAL(SUM3/SUM1)
            PLOT5(N)  = REAL(ABS(PLOT4(N)*SQRT(SUM2)/SUM1))
            PLOT7(N)  = PLOT5(N)
          END IF
        END DO
      END IF
      NP = N
      IF(NP.LT.NSPLINE+1) THEN
        WRITE(*,*) 'Too few points (',NP,') for the number'
        WRITE(*,*) 'of splines specified (',NSPLINE,').'
        GOTO 999
      END IF        
*
* Convert to logarithmic if wanted
*
      IF(SAMECI(FLIN,'N')) THEN
        DO I = 1, NP
          IF(PLOT4(I).GT.0.) THEN
            PLOT5(I) = PLOT5(I)/PLOT4(I)
            PLOT4(I) = LOG(PLOT4(I))
          ELSE
            PLOT5(I) = -1.
            WRITE(*,*) 'Wavelength ',PLOT3(I),' ',PLOT5(I),' neg'
          END IF
          PLOT7(I) = PLOT5(I)
        END DO
      END IF
*
* Soften weights
*
      SUM1 = 0.D0
      N = 0
      DO I = 1, NP
        IF(PLOT5(I).GT.0.) THEN
          SUM1 = SUM1 + PLOT5(I)**2
          N = N + 1
        END IF
      END DO
      SUM1 = SUM1/REAL(N)
      DO I = 1, NP
        IF(PLOT5(I).GT.0.) THEN
          PLOT5(I) = REAL(SQRT(SOFT*SUM1 + (1.-SOFT)*PLOT5(I)**2))
          PLOT7(I) = PLOT5(I)
        END IF
      END DO
*
* Now fit continuum with rejection.
*
* Start with spline part
*
      FIX = .FALSE.
200   N = 0
      X1 = PLOT3(NP)
      X2 = PLOT3(1)
      DO I = 1, NP
        IF(PLOT5(I).GT.0.) THEN
          N = N + 1
          X1 = MIN(X1, PLOT3(I))
          X2 = MAX(X2, PLOT3(I))
        END IF
      END DO
      IF(NP.LT.NSPLINE+1) THEN
        WRITE(*,*) NP,' points is too few for ',NSPLINE,' splines.'
        GOTO 999
      END IF
      WRITE(*,*) 'Fitting ',N,' data points ranging from'
      WRITE(*,*) X1,' to ',X2
      WRITE(*,*) 'Number of splines to be used = ',NSPLINE
*
      CALL SPLMOLA( NP, PLOT3, PLOT4, PLOT5, PLOT1,
     &     NSPLINE, NREJ, THRHI, THRLO, DWORK1, DWORK2, DWORK3,
     &     DWORK4, XKNOT, CSPLINE, NCAP7, MAXKNOT,
     &     MXTAB, FIX, IFAIL )
      IF(IFAIL.EQ.0) THEN
C
C     Evaluate fit on original wavelength scale.
C
        DO J = 1, NPIX(SLOT1)
           PLOT1(J) = REAL(ANGST(REAL(J), NPIX(SLOT1), NARC(SLOT1), 
     &          ARC(1,SLOT1), MXARC))
        END DO
        CALL SPLCALC1(NPIX(SLOT1), PLOT1, XKNOT, CSPLINE, NCAP7,
     +       PLOT2, IFAIL)
*     
        WRITE(*,'(A,$)') 'Plot fit ? [Y] '
        READ(*,'(A)') REPLY
        IF(.NOT.SAMECI(REPLY,'N')) THEN
           CALL DEV_OPEN(.FALSE.,NEW,IFAIL)
           IF(IFAIL.NE.0) RETURN
           X1 = REAL(WMIN)
           X2 = REAL(WMAX)
           X1 = X1 - (X2-X1)/20.
           X2 = X2 + (X2-X1)/20.
           Y1 =  1.E30
           Y2 = -1.E30
           DO J = 1, NP
              Y1 = MIN(PLOT4(J), Y1)
              Y2 = MAX(PLOT4(J), Y2)
           END DO
           Y1 = Y1 - (Y2-Y1)/20.
           Y1 = MIN(0., Y1)
           Y2 = Y2 + (Y2-Y1)/20.
           CALL PGSCI(5)
           CALL PGENV(X1, X2, Y1, Y2, 0, 0)
           CALL PGIDEN
           CALL PGSCI(7)
           IF(SAMECI(FLIN,'Y')) THEN
              CALL PGLAB('Wavelength (\\A)','mJy/counts/pixel',' ')
           ELSE
              CALL PGLAB('Wavelength (\\A)','ln(mJy/counts/pixel)',
     &             ' ')
           END IF
           DO J = 1, NP
              IF(PLOT5(J).GT.0.) THEN
                 CALL PGSCI(1)
                 CALL PGPT(1, PLOT3(J), PLOT4(J), 17)
              ELSE 
                 CALL PGSCI(2)
                 CALL PGPT(1, PLOT3(J), PLOT4(J), 15)
              END IF
           END DO
           CALL PGSCI(1)
           CALL PGLINE(NPIX(SLOT1), PLOT1, PLOT2)
           DO J = 1, NP
              PLOT6(J) = PLOT4(J) + PLOT5(J)
              PLOT1(J) = PLOT4(J) - PLOT5(J)
           END DO
           CALL PGERRY(NP, PLOT3, PLOT6, PLOT1, 0.)
           CALL PGSLS(2)
           CALL PGSCI(3)
           DO I = 5, NSPLINE+3
              X = REAL(XKNOT(I))
              CALL PGMOVE(X, Y1)
              CALL PGDRAW(X, Y2)
           END DO
           CALL PGSCI(1)
           CALL PGSLS(1)
*     
           WRITE(*,'(A,$)') 'Edit knots and refit ? [n] '
           READ(*,'(A)') REPLY
           IF(SAMECI(REPLY,'Y')) THEN
              WRITE(*,*) 'Position cursor near knot and type letter'
              WRITE(*,*) 'according to your choice. Do not extend'
              WRITE(*,*) 'beyond bounds of the data. Dashed lines'
              WRITE(*,*) 'mark positions of movable knots.'
 500          WRITE(*,*) 'A(dd), R(emove), Q(uit)'
              IFAIL = PGCURSE(X, Y, CH)
              IF(IFAIL.EQ.1) THEN
                 WRITE(*,*) 'X = ',X,', Y = ',Y
                 CALL UPPER_CASE(CH)
                 IF(CH.EQ.'A') THEN                
*     
*     Search for position in list of knots
*     
                    DO I = 5, NSPLINE+3
                       IF(XKNOT(I).GT.X) THEN
                          IPOS = I
                          GOTO 510
                       END IF
                    END DO
                    IPOS = NSPLINE+4
*     
*     Make room for new knot and then add in new knot
*     
 510                DO I = NSPLINE+4, IPOS+1, -1
                       XKNOT(I) = XKNOT(I-1)
                    END DO
                    XKNOT(IPOS) = X
                    NSPLINE = NSPLINE + 1
*     
                 ELSE IF(CH.EQ.'R') THEN
*     
*     Search for closest knot
*     
                    IF(NSPLINE.GE.2) THEN
                       IPOS = 0
                       DIFF = 1.E30
                       DO I = 5, NSPLINE+3
                          IF(ABS(SNGL(XKNOT(I))-X).LT.DIFF) THEN
                             DIFF = ABS(SNGL(XKNOT(I))-X)
                             IPOS = I
                          END IF
                       END DO
*     
*     Eliminate knot
*     
                       
                       DO I = IPOS, NSPLINE+3
                          XKNOT(I) = XKNOT(I+1)
                       END DO
                       NSPLINE = NSPLINE - 1
                    ELSE
                       WRITE(*,*) 'No knots to remove.'
                    END IF
*     
                 ELSE IF(CH.EQ.'Q') THEN
                    FIX = .TRUE.
                    CALL DEV_CLOSE(0, IFAIL)
                    DO J = 1, NP
                       PLOT5(J) = PLOT7(J)
                    END DO
                    GOTO 200
                 END IF
                 GOTO 500
              ELSE
                 WRITE(*,*) 'Cursor not available on this device'
              END IF
           END IF
           CALL DEV_CLOSE(0, IFAIL)
        END IF
*
* Store fit in array by computing fluxes. The type 'FLUX' 
* is set in the headers to prevent the flux spectrum itself
* being fluxed later on.
*
        DO J = 1, NPIX(SLOT1)
          IF(COUNTS(J,SLOT1).NE.0.) THEN
            IF(SAMECI(FLIN,'Y')) THEN
              FLUX(J,SLOT1) = COUNTS(J,SLOT1)*PLOT2(J)
            ELSE
              FLUX(J,SLOT1) = COUNTS(J,SLOT1)*EXP(PLOT2(J))
            END IF
          ELSE
            IF(SAMECI(FLIN,'Y')) THEN
              FLUX(J,SLOT1) = PLOT2(J)
            ELSE
              FLUX(J,SLOT1) = EXP(PLOT2(J))
            END IF
          END IF
        END DO
        CALL HSETC('Type', 'FLUX', SLOT1, MXCHAR, NMCHAR, HDCHAR, 
     &  NCHAR, MXCHAR, IFAIL)
      END IF
      IFAIL = 0
999   CLOSE(UNIT=47)
      RETURN
      END
