*FLARE
* FLARE N1 N2 OUT CYCLES WMOD HEAD -- Models spectra as the sum of a constant
*                  spectrum plus variable amount of a flare spectrum. 
*                  Iteratively estimates constant and low state spectra
*                  by minimising chi**2 with restriction that sum of flare 
*                  multipliers = 0 and sum over flare spectrum = 1
*
* Parameters
*
*       N1, N2  -- Spectra to be used.
*       OUT     -- First output slot. Will store constant then final flare
*                  spectrum.
*       CYCLES  -- Number of cycles to go through (10 or so should do)
*       WMOD    -- If the model is accurate and you have low photon
*                  numbers you may want to modify the weights on the
*                  points. This is done by estimating a background count
*                  by taking lowest value in whole of spectrum (suited to
*                  HST), and then estimting variances in counts according to
*                  V(J) = B + R(J)*ABS(L(J)+M(I)*F(J)) where R(J) is the
*                  count/flux ratio, L(J) is the low state spectrum, F(J)
*                  the flare spectrum and M(I) the multipliers. ABS
*                  prevents silly errors. This option only applies for
*                  CYCLES > 3 to get some stability. NB THIS IS A PERMANENT
*                  CHANGE TO THE ERRORS ON THE SELECTED SPECTRA.
*       BACK    -- Estimate background rate in counts/pixel to provide 
*                  softening of weights at low count rates. Only if you
*                  answer yes to WMOD. Note that the FOS on HST has a fairly
*                  constant rate per pixel.
*       HEAD    -- Name of Real type header parameter to store multipliers
*                  in spectra used to form flare. <CR> to ignore. The
*                  parameter will be stored as HEAD_D, and HEAD_E.
*
* Related commands: RMSSPEC
*
*FLARE
      SUBROUTINE FLARE(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, NMDOUB, 
     &NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, SLOTS, MXSLOTS, 
     &LAMBDA, DWORK1, DWORK2, DWORK3, DWORK4, DWORK5, FLAR, EFLAR, 
     &CONS, ECONS, WORK1, KEY, MXWORK, IFAIL)
*
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
*    D     LAMBDA(MXWORK)
*    D     DWORK2(MXWORK)
*    D     DWORK3(MXWORK)
*    D     DWORK4(MXWORK)
*    D     DWORK5(MXWORK)
*    I     MXWORK
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
      INTEGER MXWORK 
      INTEGER KEY(MXWORK)
      REAL FLAR(MXWORK), EFLAR(MXWORK), CONS(MXWORK)
      REAL ECONS(MXWORK), WORK1(MXWORK)
      DOUBLE PRECISION  LAMBDA(MXWORK), DWORK1(MXWORK)
      DOUBLE PRECISION DWORK2(MXWORK), DWORK3(MXWORK)
      DOUBLE PRECISION DWORK4(MXWORK), DWORK5(MXWORK)
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT, OUT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Local variables
*
      INTEGER I, J, K, IFAIL, NCOM, SLOT1, SLOT2
      INTEGER MAXSPEC, CYCLES, NV, NSAME, L, LENSTR
      LOGICAL SAMECI, DEFAULT, OK
      REAL PRED, BACK, MEDN, TEMP, RR, ERR
      REAL CFRAT, GET_FLX, GET_ERF, RATIO, WGT, FLX
      DOUBLE PRECISION SUM1, SUM2, SUM3, SUM4, MU, NORM
      CHARACTER*5 WMOD
      CHARACTER*14 HEAD
*
      DATA SLOT1, SLOT2, CYCLES/1,2,10/
      DATA OUT, WMOD/5,'no'/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
*
      CALL INTR_IN('First slot to model', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to model', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to fit'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      NSAME = 0
      NV = 0
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF(NPIX(SLOT).GT.0) THEN
          NV = NV + 1
          IF(NSAME.EQ.0) THEN
            NSAME = NPIX(SLOT)
          ELSE IF(NSAME.NE.NPIX(SLOT)) THEN
            WRITE(*,*) 'Slots have unequal numbers of pixels'
            GOTO 999
          END IF
          OK = .FALSE.
          J = 1
          DO WHILE(.NOT.OK .AND. J.LE.NSAME)
            OK = ERRORS(J,SLOT).GT.0.
            J = J + 1
          END DO
          IF(.NOT.OK) THEN
            WRITE(*,*) 'No valid pixels in spectrum ',SLOT
            GOTO 999
          END IF
        ELSE
          WRITE(*,*) 'Slot ',SLOT,' is empty.'
          GOTO 999
        END IF
      END DO
      IF(NV.LE.1) THEN
        WRITE(*,*) 'Require at least 2 slots to get anywhere'
        GOTO 999
      END IF
*
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, OUT, 1, MAXSPEC-1, IFAIL)
      CALL INTR_IN('Number of cycles', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, CYCLES, 1, MAXSPEC-OUT, IFAIL)
      IF(CYCLES.GT.3) THEN
        CALL CHAR_IN('Modify weights?', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, WMOD, IFAIL)
        IF(SAMECI(WMOD,'yes')) THEN
          CALL REAL_IN('Background (cts/pix)', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, BACK, 0., 1.E20, IFAIL)
        END IF
      END IF
      HEAD = ' '
      CALL CHAR_IN('Header item to store mutipliers (<CR> to ignore)',
     &SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, HEAD, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
* First compute and sort average values to derive first estimate of
* flare as difference between high and low halfs of spectra, and
* constant spectrum as average of all spectra
*
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        SUM1 = 0.D0
        SUM2 = 0.D0
        DO J = 1, NSAME
          IF(ERRORS(J,SLOT).GT.0.) THEN
            WGT = 1./GET_ERF(COUNTS(J,SLOT),ERRORS(J,SLOT),
     &      FLUX(J,SLOT))**2
            SUM1 = SUM1 + WGT
            SUM2 = SUM2 + WGT*GET_FLX(COUNTS(J,SLOT),FLUX(J,SLOT))
          END IF
        END DO
        WORK1(I) = REAL(SUM2/SUM1)
      END DO
*
* Compute median value
*
      CALL HEAPSORT(NSLOTS, WORK1, KEY)
      IF(MOD(NSLOTS,2).EQ.0) THEN
        MEDN = (WORK1(KEY(NSLOTS/2))+WORK1(KEY(NSLOTS/2+1)))/2.
      ELSE
        MEDN = WORK1(KEY(NSLOTS/2+1))
      END IF
*
* Average spectra to get first estimate of constant spectrum
*
      DO I = 1, NSAME
        SUM1 = 0.D0
        SUM2 = 0.D0
        DO J = 1, NSLOTS
          SLOT = SLOTS(J)
          IF(ERRORS(I,SLOT).GT.0.) THEN
            WGT = 1./GET_ERF(COUNTS(I,SLOT),ERRORS(I,SLOT),
     &      FLUX(I,SLOT))**2
            SUM1 = SUM1 + WGT
            SUM2 = SUM2 + WGT*GET_FLX(COUNTS(I,SLOT),FLUX(I,SLOT))
          END IF
        END DO
        IF(SUM1.GT.0.D0) THEN
          CONS(I) = REAL(SUM2/SUM1)
        ELSE
          CONS(I) = 0.
        END IF
      END DO
*
* Take difference between average high and low spectra to get 
* first estimate of flare spectrum, normalise to unit sum
*
      NORM = 0.D0
      DO I = 1, NSAME
        SUM1 = 0.D0
        SUM2 = 0.D0
        DO J = 1, NSLOTS
          SLOT = SLOTS(J)
          IF(WORK1(J).GT.MEDN .AND. ERRORS(I,SLOT).GT.0.) THEN
            WGT = 1./GET_ERF(COUNTS(I,SLOT),ERRORS(I,SLOT),
     &      FLUX(I,SLOT))**2
            SUM1 = SUM1 + WGT
            SUM2 = SUM2 + WGT*GET_FLX(COUNTS(I,SLOT),FLUX(I,SLOT))
          END IF
        END DO
        SUM3 = 0.D0
        SUM4 = 0.D0
        DO J = 1, NSLOTS
          SLOT = SLOTS(J)
          IF(WORK1(J).LT.MEDN .AND. ERRORS(I,SLOT).GT.0.) THEN
            WGT = 1./GET_ERF(COUNTS(I,SLOT),ERRORS(I,SLOT),
     &      FLUX(I,SLOT))**2
            SUM3 = SUM3 + WGT
            SUM4 = SUM4 + WGT*GET_FLX(COUNTS(I,SLOT),FLUX(I,SLOT))
          END IF
        END DO
        IF(SUM1.GT.0.D0 .AND. SUM3.GT.0.D0) THEN
          FLAR(I) = REAL(SUM2/SUM1-SUM4/SUM3)
        ELSE
          FLAR(I) =  0.
        END IF
        NORM = NORM + FLAR(I)
      END DO
      DO I = 1, NSAME
        FLAR(I) = REAL(FLAR(I)/NORM)
      END DO
*
* Now have initial constant and flare spectra, we start iterating
*
      DO I = 1, CYCLES
*
* First estimate multiplers
*
        SUM3 = 0.D0
        SUM4 = 0.D0
        DO J = 1, NSLOTS
          SLOT = SLOTS(J)
          SUM1 = 0.D0
          SUM2 = 0.D0
          DO K = 1, NSAME
            IF(ERRORS(K,SLOT).GT.0.) THEN
              WGT = 1./GET_ERF(COUNTS(K,SLOT),ERRORS(K,SLOT),
     &                         FLUX(K,SLOT))**2
              FLX = GET_FLX(COUNTS(K,SLOT),FLUX(K,SLOT))
              SUM1 = SUM1 + WGT*FLAR(K)**2
              SUM2 = SUM2 + WGT*(FLX-CONS(K))*FLAR(K)
            END IF
          END DO
          DWORK1(J) = SUM2/SUM1
          DWORK2(J) = 1.D0/SUM1
          SUM3 = SUM3 + DWORK1(J)
          SUM4 = SUM4 + DWORK2(J)
        END DO
*
* Compute lagrangian mutiplier that forces sum over lambda = 0
*
        MU = - SUM3/SUM4
        DO J = 1, NSLOTS
          LAMBDA(J) = DWORK1(J)+MU*DWORK2(J)
        END DO
*
* Now compute new estimates of constant and flare spectra
*
        DO K = 1, NSAME
          DWORK1(K) = 0.D0
          DWORK2(K) = 0.D0
          DWORK3(K) = 0.D0
          DWORK4(K) = 0.D0
          DWORK5(K) = 0.D0
        END DO
        DO J = 1, NSLOTS
          SLOT = SLOTS(J)
          DO K = 1, NSAME
            IF(ERRORS(K,SLOT).GT.0.) THEN
              WGT = 1./GET_ERF(COUNTS(K,SLOT),ERRORS(K,SLOT),
     &                         FLUX(K,SLOT))**2
              FLX = GET_FLX(COUNTS(K,SLOT),FLUX(K,SLOT))
              DWORK1(K) = DWORK1(K) + WGT
              DWORK2(K) = DWORK2(K) + WGT*FLX
              DWORK3(K) = DWORK3(K) + WGT*LAMBDA(J)
              DWORK4(K) = DWORK4(K) + WGT*LAMBDA(J)*FLX
              DWORK5(K) = DWORK5(K) + WGT*LAMBDA(J)**2
            END IF
          END DO
        END DO
*
* Compute lagrange multiplier st sum of flare = 1
*
        SUM1 = 0.D0
        SUM2 = 0.D0
        DO K = 1, NSAME
          IF(DWORK1(K).GT.0.D0) THEN
            SUM1 = SUM1 + (DWORK4(K)-CONS(K)*DWORK3(K))/DWORK5(K)
            SUM2 = SUM2 + 1./DWORK5(K)
          END IF
        END DO
        MU = (1.D0 - SUM1)/SUM2
        DO K = 1, NSAME
          IF(DWORK1(K).GT.0.D0) THEN
            TEMP = REAL((DWORK4(K)-CONS(K)*DWORK3(K)+MU)/DWORK5(K))
            CONS(K) = REAL((DWORK2(K)-DWORK3(K)*FLAR(K))/DWORK1(K))
            FLAR(K) = TEMP
          END IF
        END DO
*
* Modify weights 
*
        IF(I.GT.3 .AND. SAMECI(WMOD,'yes')) THEN
          DO J = 1, NSLOTS
            SLOT = SLOTS(J)
C            BACK = COUNTS(1,SLOT)
C            DO K = 2, NSAME
C              BACK = MIN(BACK, COUNTS(K,SLOT))
C            END DO
C            IF(BACK.GE.0.) 
C     &      WRITE(*,*) 'Slot ',SLOT,', background = ',BACK
C            BACK = ABS(BACK)
            DO K = 1, NSAME
              RATIO = CFRAT(COUNTS(K,SLOT),FLUX(K,SLOT))
              PRED = BACK + RATIO*ABS(CONS(K)+SNGL(LAMBDA(J))
     &        *FLAR(K))
              IF(ERRORS(K,SLOT).GT.0.) THEN
                ERRORS(K,SLOT) = SQRT(PRED)
              ELSE
                ERRORS(K,SLOT) = -SQRT(PRED)
              END IF
            END DO
          END DO
        END IF
*
*
        DO J = 1, NSAME
          IF(DWORK5(J).GT.0.D0) THEN
            EFLAR(J) = REAL(1./SQRT(DWORK5(J)))
          ELSE
            FLAR(J) =   0.
            EFLAR(J) = -1.
          END IF
          IF(DWORK1(J).GT.0.D0) THEN
            ECONS(J) = REAL(1./SQRT(DWORK1(J)))
          ELSE
            CONS(J)  =  0.
            ECONS(J) = -1.
          END IF
        END DO
*
* Calculate Chi**2
*
        SUM1 = -2.D0*DBLE(NSAME)-DBLE(NSLOTS)
        SUM2 = 0.D0
        DO J = 1, NSLOTS
          SLOT = SLOTS(J)
          DO K = 1, NSAME
            IF(ERRORS(K,SLOT).GT.0.) THEN
              WGT = 1./GET_ERF(COUNTS(K,SLOT),ERRORS(K,SLOT),
     &            FLUX(K,SLOT))**2
              FLX = GET_FLX(COUNTS(K,SLOT),FLUX(K,SLOT))
              SUM1 = SUM1 + 1.D0
              SUM2 = SUM2 + WGT*(FLX-CONS(K)-LAMBDA(J)*FLAR(K))**2
            END IF
          END DO
        END DO
        IF(SUM1.GT.0.D0) THEN
          WRITE(*,*) 'End of cycle ',I,', chi**2/N = ',SNGL(SUM2/SUM1)
        ELSE
          WRITE(*,*) 'End of cycle ',I,', chi**2 = ',SNGL(SUM2)
        END IF
      END DO
*
* Store results
*
      SLOT = SLOTS(1)
      DO I = 1, NSAME
        RATIO = CFRAT(COUNTS(I,SLOT),FLUX(I,SLOT))
        COUNTS(I,OUT) = RATIO*CONS(I)
        ERRORS(I,OUT) = RATIO*ECONS(I)
        IF(COUNTS(I,OUT).EQ.0.) THEN
          FLUX(I,OUT) = RATIO
        ELSE
          FLUX(I,OUT) = CONS(I)
        END IF
      END DO
*
      DO I = 1, NSAME
        RATIO = CFRAT(COUNTS(I,SLOT),FLUX(I,SLOT))
        COUNTS(I,OUT+1) = RATIO*FLAR(I)
        ERRORS(I,OUT+1) = RATIO*EFLAR(I)
        IF(COUNTS(I,OUT+1).EQ.0.) THEN
          FLUX(I,OUT+1) = RATIO
        ELSE
          FLUX(I,OUT+1) = FLAR(I)
        END IF
      END DO
*
      CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, IFAIL)
      CALL SET_HEAD(OUT+1, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &MXINTR, MXREAL, IFAIL)
*
* Store multipliers if wanted
*
      IF(HEAD.NE.' ') THEN
        L = LENSTR(HEAD)
        DO I = 1, NSLOTS
          RR = REAL(LAMBDA(I))
          SLOT = SLOTS(I)
          CALL HSETR(HEAD(:L)//'_D', RR, SLOT, MXSPEC, NMREAL, 
     &    HDREAL, NREAL, MXREAL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to store multiplier.'
            GOTO 999
          END IF
*
* Estimate uncertainties in multipliers
*
          SUM1 = 0.D0
          DO K = 1, NSAME
            IF(ERRORS(K,SLOT).GT.0.) THEN
              SUM1 = SUM1 + (FLAR(K)/GET_ERF(COUNTS(K,SLOT),
     &               ERRORS(K,SLOT),FLUX(K,SLOT)))**2
            END IF
          END DO
          ERR = REAL(1./SQRT(SUM1))
          CALL HSETR(HEAD(:L)//'_E', ERR, SLOT, MXSPEC, NMREAL, 
     &    HDREAL, NREAL, MXREAL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to store error on multiplier.'
            GOTO 999
          END IF
        END DO
      END IF
      IFAIL = 0
      RETURN
999   IFAIL = 1
      RETURN
      END
