/*
 * fgetlin -- function for returning a string to a FORTRAN program
 * allowing line editing and return of old commands. Based upon 
 * GNU readline
 *
 * 
 * In the FORTRAN program declare as for example:
 *
 *       CHARACTER*132 COMMAND, FGETLIN
 *
 * and then call as in: 
 *
 *       COMMAND = FGETLIN('prompt>>')
 *
 * where 'prompt>>' is the prompt string. 
 * fgetlin maintains a history of strings so it is very easy to replace
 * standard input which may have been:
 *
 *       WRITE(*,'(A,$)') 'Prompt> '
 *       READ(*,'(A)') COMMAND
 *
 * just by:
 *
 *       COMMAND = FGETLIN('Prompt>>')
 *       
 *
 * Written by T.R.Marsh 25/7/95
 * Adapted for Linux by P.F.L.Maxted 20 Oct 99
 * Adapted for g95 by T.R.Marsh Nov 2006
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <readline/readline.h>
#include <readline/history.h>

void fgetlin_(char *g95_result, long int g95_result_length, char *prompt, long int g95_prompt_length){ 

    /* Copy the prompt to a temporary string character-by-character and add
     * a null character. This avoids problems with g95 passing strings without 
     * a terminating null character, which may not occur, but could do if it is
     * anything like g77
     */
    
    char *cprompt = (char*)malloc(g95_prompt_length+1);
    strncpy(cprompt, prompt, g95_prompt_length);
    *(cprompt + g95_prompt_length) = 0;
    int i;
    for(i=g95_prompt_length-1; i>0; i--)
	if(*(cprompt+i) == ' ' && *(cprompt+i-1) == ' ') 
	    *(cprompt+i) = 0;

    /* Get the prompt */
    char *comm = readline (cprompt);
    if (comm && *comm) add_history(comm);
    
    /* 
     * Transfer to output string and fill out with blanks. This 
     * step is needed because C treats a null character as the end of a string
     * but FORTRAN does not and without it a whole load of junk
     * is left in the string as far as FORTRAN is concerned. Note that
     * 'readline' differs from 'getcomm'  in that it does not return the final
     * carriage return so we do not overwrite it.
     */
    
    strcpy(g95_result, comm);
    int lok = strlen(g95_result);
    for(i=lok; i<g95_result_length; i++){
	*(g95_result+i) = ' ';
    }

    /* Free up memory */
    free(comm);
    free(cprompt);
}

/* this version does not add to the history */

void fgetlinnh_(char *g95_result, long int g95_result_length, char *prompt, long int g95_prompt_length){ 

    /* Copy the prompt to a temporary string character-by-character and add
     * a null character.
     *  This avoids problems with g95 passing strings without a terminating
     * null character, which often happens if the length of the string is
     * a multiple of 8.
     */
    
    char *cprompt = (char*)malloc(g95_prompt_length+1);
    strncpy(cprompt, prompt, g95_prompt_length);
    *(cprompt + g95_prompt_length) = 0;
    int i;
    for(i=g95_prompt_length-1; i>0; i--)
	if(*(cprompt+i) == ' ' && *(cprompt+i-1) == ' ') 
	    *(cprompt+i) = 0;

    /* Get the prompt */
    char *comm = readline (cprompt);
    
    /* 
     * Transfer to output string and fill out with blanks,
     * overwriting the carriage return. This step is needed
     * because C treats a null character as the end of a string
     * but FORTRAN does not and without it a whole load of junk
     * is left in the string as far as FORTRAN is concerned.
     */
    
    strcpy(g95_result, comm);
    int lok = strlen(g95_result);
    for(i=lok; i<g95_result_length; i++){
	*(g95_result+i) = ' ';
    }
    free(comm);
    free(cprompt);
}
