CBFILT
C BFILT N1 N2 N3 LOW1 LOW2 HIGH1 HIGH2 SET -- Band-pass filters spectra
C
C    Parameters
C
C       N1, N2 -- Range of spectra to filter
C       N3     -- First output slot
C       LOW1, LOW2 -- Low pass rises from zero transmission at LOW1 to full
C                     at LOW2. If LOW2<LOW1, no low frequency cutoff applied.
C                     Rises as a cosine between the two limits.
C       HIGH1, HIGH2 -- As for low pass but now starts to cut at HIGH1,
C                     and reaches zero transmission by HIGH2
C       SET    -- If a mask is applied the spectra are linearly interpolated
C                 over masked regions.
C
CBFILT
      SUBROUTINE FFILT(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &     MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     SLOTS, MXSLOTS, MASK, WORK1, WORK2, WORK3, MXWORK, FILT, 
     &     MXFILT, IFAIL)
C     
C     Applies bandpass filter to spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     =  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     =  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     =  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     >  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     I     SLOTS(MXSLOTS)     -- Workspace for list of slots
C     <  I     IFAIL            -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX
      INTEGER MXCHAR, MXDOUB, MXREAL, MXINTR, MXARC
      INTEGER NPIX(MXSPEC), NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Mask arrays
C     
      INTEGER MXMASK, MXWORK, MXFILT
      LOGICAL MASK(MXWORK)
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)      
C     
C     Work arrays
C     
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK)
      REAL FILT(MXFILT)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Local variables
C     
      INTEGER I, J, K
      INTEGER NP,  NFIRST, NLAST, JADD, NFILT
      REAL GET_FLX,  RATIO, CFRAT, PI, F,  FAC
      DOUBLE PRECISION VEARTH
      REAL   LOW1, LOW2, HIGH1, HIGH2
      LOGICAL LOW, HIGH
      CHARACTER*64  SET*3
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, IFAIL
      INTEGER  MAXSPEC, NOUT,  NCOM, LENSTR
      LOGICAL  SAME, DEFAULT
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA SET/'YES'/
      DATA LOW1, LOW2/10., 20./
      DATA HIGH1, HIGH2/100., 200./
C     
C     Check inputs
C     
C     
C***********************************************************************
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      CALL INTR_IN('First slot to filter', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to filter', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to filter'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      DO I = 1, NSLOTS
         IF(NPIX(SLOTS(I)).GT.0) THEN
            NP = NPIX(SLOTS(I))
            GOTO 100
         END IF
      END DO
      WRITE(*,*) 'No valid spectra'
      GOTO 999
 100  CONTINUE
C     
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
C     
      CALL REAL_IN('Start of low cutoff (cycles/spec)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, LOW1, 0., 100000., IFAIL)
      CALL REAL_IN('End of low cutoff (cycles/spec)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, LOW2, 0., 100000., IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      LOW = LOW2.GT.LOW1
      IF(.NOT.LOW) THEN
         WRITE(*,*) 'Upper limit of low cutoff less than lower and'
         WRITE(*,*) 'so no low frequency cutoff will be applied'
      END IF
C     
      CALL REAL_IN('Start of high cutoff (cycles/spec)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, HIGH1, 0., 100000., IFAIL)
      CALL REAL_IN('End of high cutoff (cycles/spec)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, HIGH2, 0., 100000., IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      HIGH = HIGH2.GT.HIGH1
      IF(.NOT.HIGH) THEN
         WRITE(*,*) 'Upper limit of high cutoff less than lower and'
         WRITE(*,*) 'so no high frequency cutoff will be applied'
         IF(.NOT.LOW) THEN
            WRITE(*,*) 'Null operation'
            GOTO 999
         END IF
      END IF
C     
C     Mask
C     
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SET, IFAIL)
      IF(SAME(SET,'YES')) THEN
         WRITE(*,*) 'Mask regions to interpolate over prior to'
         WRITE(*,*) 'filtering.'
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &        NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &        WORK2, WORK3, MXWORK, MASK)
      END IF
C     
C     Now go through spectra
C     
      NOUT = SLOT3 - 1
      PI = 4.*ATAN(1.)
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN 
            WRITE(*,*) 'Slot ',SLOT,' empty.'
         ELSE
C     
C     Load arc
C     
            CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IFAIL = 0
C     
C     Get mask 
C     
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &           MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &           .FALSE.,VEARTH,IFAIL)
C     
C     Load data
C     
            DO J = 1, NPIX(SLOT)
               WORK1(J) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
            END DO
C     
C     Apply mask by interpolating across masked regions
C     compute region containing data.
C     
            CALL REPLACE(WORK1, ERRORS(1,SLOT), MASK, .FALSE., 
     &           NPIX(SLOT), NFIRST, NLAST, IFAIL)
C     
C     Find nearest power of 2 greater than number of pixels
C     add some pixels in to reduce end effects
C     
            NP = NLAST - NFIRST + 1
            IF(NP.LE.0) THEN
               WRITE(*,*) 'No valid pixels, slot ',SLOT
               WRITE(*,*) 'Range: ',NFIRST, NLAST
               GOTO 999
            END IF
            NP = NP + NP/5
            NFILT = 2**(INT(LOG(REAL(NP))/LOG(2.))+1)
            IF(NFILT.GT.MXFILT) THEN
               WRITE(*,*) 'Not enough room to filter slot ',SLOT
               WRITE(*,*) 'Current MXFILT = ',MXFILT,'; need ',NP
               GOTO 999
            END IF
C     
C     Transfer to filter array
C     
            JADD = (NFIRST+NLAST-NFILT)/2
            DO J = 1, NFILT
               FILT(J) = WORK1(MAX(NFIRST,MIN(JADD+J,NLAST)))
            END DO
            CALL REALFT(FILT,NFILT,1)
C     
C     Apply real filter
C     
            DO K = 1, NFILT+1, 2
               F = REAL(K-1)/2.
               IF((LOW .AND. F.LE.LOW1) .OR.
     &              (HIGH .AND. F.GE.HIGH2)) THEN
                  FAC = 0.
               ELSE 
                  FAC = 1.
                  IF(LOW .AND. F.LT.LOW2) THEN
                     FAC = FAC*(1.-COS(PI*(F-LOW1)/(LOW2-LOW1)))/2.
                  END IF
                  IF(HIGH .AND. F.GT.HIGH1) THEN
                     FAC = FAC*(1.+COS(PI*(F-HIGH1)/(HIGH2-HIGH1)))/2.
                  END IF
               END IF
               IF(K.EQ.1) THEN
                  FILT(1) = FAC*FILT(1)
               ELSE IF(K.EQ.NFILT+1) THEN
                  FILT(2) = FAC*FILT(2)
               ELSE
                  FILT(K)   = FAC*FILT(K)
                  FILT(K+1) = FAC*FILT(K+1)
               END IF
            END DO
C     
C     Inverse FFT
C     
            CALL REALFT(FILT,NFILT,-1)
C     
C     Set headers equal to those of input spectrum 
C     
            NOUT = NOUT + 1
            CALL SET_HEAD(NOUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &           MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
C     Store data, leaving masked data untouched 
C     
            DO J = 1, NPIX(NOUT)
               ERRORS(J,NOUT) = ERRORS(J,SLOT)
               IF(.NOT.MASK(J)) THEN
                  COUNTS(J,NOUT) = COUNTS(J,SLOT)
                  FLUX(J,NOUT)   = FLUX(J,SLOT)
               ELSE
                  RATIO = CFRAT(COUNTS(J,SLOT),FLUX(J,SLOT))
                  F = FILT(J-JADD)/REAL(NFILT/2)
                  COUNTS(J,NOUT) = RATIO*F
                  IF(COUNTS(J,NOUT).EQ.0) THEN
                     FLUX(J,NOUT) = RATIO
                  ELSE
                     FLUX(J,NOUT) = F
                  END IF
               END IF
            END DO
C     
            WRITE(*,*) 'Filtered slot ',SLOT,' stored in slot ',NOUT
            CALL SL_INF(NOUT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
      END DO
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END
