*EXTRAPOL
* EXTRAPOL N1 N2 N3 -- Extrapolate spectra in time
*
* Parameters: 
*     
*  N1    -- Slot number of first spectrum to average
*  N2    -- Slot number of last spectrum to average
*  N3    -- Slot in which to put results
*
*  Danny Steeghs @ soton
*  BETA VERSION
*  
* Selection is done. 
*
* The spectra must have equal numbers of pixels, but no other properties
* in common. A warning is given if the wavelength scales differ but
* averaging still goes ahead
*
*
*EXTRAPOL
      SUBROUTINE EXTRAPOL(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WORK2, WORK3, WORK4, MXWORK, SLOTS, 
     &     WSLOTS, MXSLOTS, MUTE, IFAIL)
*
* Extrapolates spectra in time. Intended for extraction of true WD spectrum 
* during ingress/egress
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.
* >  R     WORK1(MXWORK) Work arrays
* >  R     WORK2(MXWORK)
* >  R     WORK3(MXWORK)
* >  R     WORK4(MXWORK)
* >  I     MXWORK        Size of work arrays
* >  I     SLOTS(MXSLOTS)   Array for list of slot numbers
* >  R     WSLOTS(MXSLOTS)  Array for list of weights 
* >  I     MXSLOTS         Size of list arrays 
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Search parameters
*
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      REAL WSLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
! work arrays
      REAL TEMP1(MXSLOTS),TEMP2(MXSLOTS),TEMP3(MXSLOTS),TEMP4(MXSLOTS)
*
* Local variables
*
      INTEGER I, J, K
      INTEGER  NVAL
      REAL GET_FLX, GET_ERF
      INTEGER SLOT1, SLOT2, SLOT3
      INTEGER  IFAIL, NSAME, NASAM
      INTEGER  MAXSPEC,  NCOM, IV
      LOGICAL SELECT,PLOTFIT
      LOGICAL DEFAULT, WARN,  MUTE
*
* Functions
*
*
      DATA SLOT1, SLOT2, SLOT3/1,2,3/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
*
      WRITE(*,*) ' *** BETA VERSION ***'
      CALL INTR_IN('First spectrum to extrapolate', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
*
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to extrapolate', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to average'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
*
      CALL INTR_IN('Slot for extrapolated spectrum', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
*

*
* Initialise work arrays and then average spectra
* Check that spectra are compatible. Only requirements are that they
* have same number of pixels which must be less than MXWORK. Zero pixel
* spectra are skipped. A warning is given if the arc coefficients vary.
* For dwell weights, the dwell must be present.
*
      DO I = 1, MIN(MXWORK, MAXPX)
        WORK1(I) = 0.
        WORK2(I) = 0.
        WORK3(I) = 0.
        WORK4(I) = 0.
      END DO

      NSAME = 0
      NASAM = 0
      NVAL  = 0
      WARN = .FALSE.

! loop over pixels
      DO k=1,NPIX(SLOTS(1))

! loop over slots
      DO I = 1, NSLOTS
        SLOT = SLOTS(I) 
        WSLOTS(I) = - 1.
        IF( NPIX(SLOT).NE. NPIX(SLOTS(1)) ) THEN
          WRITE(*,*) 'Slot ',SLOT,' incorrect size; skipped.'
        ELSE
*
          IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &      HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &      NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &      MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &      VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &      NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
          ELSE
            IF(NSAME.EQ.0) THEN
              NSAME = NPIX(SLOT)
              NASAM = NARC(SLOT)
              IV    = SLOT
              NVAL = NVAL + 1
            ELSE IF(NSAME.NE.NPIX(SLOT)) THEN
              WRITE(*,*) 'Incompatible numbers of pixels'
              WRITE(*,*) 'First valid spectrum has ',NSAME
              WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT)
              GOTO 999
            ELSE IF(NARC(SLOT).NE.NASAM) THEN
              WARN = .TRUE.
              NVAL = NVAL + 1
            ELSE
              DO J = 1, ABS(NASAM)
                WARN = WARN .OR. 
     &          ABS(ARC(J,SLOT)-ARC(J,IV)).GT.1.D-5*ABS(ARC(J,IV))
              END DO
              NVAL = NVAL + 1
            END IF

! copy slots into work array
! work1 contains lightcurve for each wav pixel
! work2 contains phase for each slot
            TEMP1(i)=GET_FLX(COUNTS(k,SLOT),FLUX(k,SLOT))
            TEMP3(i)=GET_ERF(COUNTS(k,SLOT),ERRORS(k,SLOT),FLUX(k,SLOT))
            TEMP2(i)=1.*SLOT
          END IF
        END IF
      END DO
! loop over slots done

! perform poly-fit
      CALL POLMOL(NSLOTS,TEMP2,TEMP1,TEMP3,TEMP4,2,5,4.,-4.,work1,
     &      work2,work3,MXWORK,IFAIL)

! plot
      plotfit=.true.
      if ( plotfit ) then
         if ( mod(k,25) .eq. 0 ) then 
         CALL PGBEGIN(0,'/xs',1,1)
         CALL PGENV(temp2(1),temp2(nslots),0.,8.,0,0)
         CALL PGPOINT(nslots,temp2,temp1,20)
         CALL PGLINE(nslots,temp2,temp4)
         CALL PGEND
         endif
      endif

! store extrapolation in work4
      WORK4(k)=TEMP4(NSLOTS)
      WORK4(k+NPIX(SLOTS(1)))=TEMP4(1)
      write(*,*) 'Fitted value at pixel ',k,' =',work4(k)
! next pixel
      END DO



*
* Store result in output slot
*
      DO I = 1, NSAME
        IF(WORK4(I).GT.0.) THEN
          ERRORS(I,SLOT3) =  0.999
          COUNTS(I,SLOT3) =  WORK4(i)
          FLUX(I,SLOT3)   =  WORK4(i)
          ERRORS(I,SLOT3+1) = 0.999
          COUNTS(I,SLOT3+1) =  WORK4(i+NPIX(SLOTS(1)))
          FLUX(I,SLOT3+1)   =  WORK4(i+NPIX(SLOTS(1)))
        ELSE
          ERRORS(I,SLOT3) =  -1.
          COUNTS(I,SLOT3) =  0.
          FLUX(I,SLOT3)   =  1.
          ERRORS(I,SLOT3+1) = -1.
          COUNTS(I,SLOT3+1) =  0.
          FLUX(I,SLOT3+1)   =  1.
        END IF
      END DO
*
* copy headers
*
      CALL SET_HEAD(SLOT3, SLOT, MXSLOTS, NPIX, ARC, 
     &NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &MXINTR, MXREAL, IFAIL)

      CALL SET_HEAD(SLOT3+1, SLOTS(1), MXSLOTS, NPIX, ARC, 
     &NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &MXINTR, MXREAL, IFAIL)
      WRITE(*,*) 'Result stored in:', SLOT3
*
999   CLOSE(UNIT=47)
      RETURN
      END
