*USER
* USER OPTION [N1 N2] -- Edits/lists user defined commands.
*
* Parameters:
*
*   OPTION      --  Option determines the action to take.
*
*                   Current options are:
*
*                   LIST   -- List the user defined commands.
*                   CLEAR  -- Deletes all the user defined commands.
*                   DELETE -- Deletes a range of commands.
*
*   N1, N2      -- If the 'DELETE' option is specified, then a range of
*                  commands should be given.
*USER
      SUBROUTINE EDUSER(SPLIT, NSPLIT, MXSPLIT, UCOMMS, UDEFS,
     &NUSER, MXUSER, IFAIL)
*
* Edits/lists user defined commands.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  C*(*) UCOMMS(MXUSER)   -- User defined commands.
* >  C*(*) UDEFS(MXUSER)    -- Definitions of user defined commands.
* >  I     NUSER            -- NUmber of user defined commands.
* >  I     MXUSER           -- Maximum number of user defined commands.
* <  I     IFAIL            -- Error return.
*
      IMPLICIT NONE
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, IFAIL, MXUSER, NUSER
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*(*) UDEFS(MXUSER), UCOMMS(MXUSER)
*
* Local variables
*
      INTEGER NCOM, NOPT, I, NCOM1, NCOM2
      LOGICAL DEFAULT
      PARAMETER (NOPT=3)
      CHARACTER*8 OPTIONS(NOPT), OPT
      INTEGER SEARC, LENSTR, IOPT
      DATA OPTIONS/'LIST','CLEAR','DELETE'/
      DATA NCOM1, NCOM2/1, 1/ 
      DATA OPT/'list'/
*
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL CHAR_IN('Option (list,clear,delete)', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, OPT, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IOPT = SEARC(OPTIONS,NOPT,NOPT,OPT)
      IF(IOPT.LE.0) THEN
        IF(IOPT.LT.0) THEN
          WRITE(*,*) 'Ambiguous option. Possibilities are:'
        ELSE
          WRITE(*,*) 'Option not recognised. Possibilities are:'
        END IF
        DO I = 1, NOPT
          WRITE(*,*) OPTIONS(I)
        END DO
        GOTO 999
      END IF
*
* List commands
*
      WRITE(*,*) ' '
      IF(NUSER.EQ.0) THEN
        WRITE(*,*) 'No user defined commands have been defined.'
      ELSE
        WRITE(*,*) 'No.  Command   Definition'
        WRITE(*,*) ' '
        DO I = 1, NUSER
          WRITE(*,'(1X,I3,2X,A8,2X,A)') I,UCOMMS(I),UDEFS(I)
        END DO
        WRITE(*,*) ' '
*
        IF(IOPT.EQ.2) THEN
          WRITE(*,*) 'All user commands deleted'
          NUSER  = 0
        ELSE IF(IOPT.EQ.3) THEN
          CALL INTR_IN('First command to delete', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, NCOM1, 1, NUSER, IFAIL)
          CALL INTR_IN('Last command to delete', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, NCOM1, NCOM2, NUSER, IFAIL)
          IF(IFAIL.NE.0) GOTO 999
          NUSER = NUSER - (NCOM2-NCOM1+1)
          DO I = NCOM1, NUSER
            UCOMMS(I) = UCOMMS(I+NCOM2-NCOM1+1)
            UDEFS(I)  = UCOMMS(I+NCOM2-NCOM1+1)
          END DO
          IF(NUSER.EQ.0) THEN
            WRITE(*,*) 'All user commands deleted'
          ELSE
            WRITE(*,*) 'No.  Command   Definition'
            WRITE(*,*) ' '
            DO I = 1, NUSER
              WRITE(*,'(1X,I3,2X,A8,2X,A)') I,UCOMMS(I),
     &         UDEFS(I)(:LENSTR(UDEFS(I)))
            END DO
          END IF
        END IF
        WRITE(*,*) ' '
      END IF
      IFAIL = 0
999   RETURN
      END
