      SUBROUTINE DEV_OPEN(SAME, NEW, IFAIL)
C
C     Opens a plot device. 
C     IFAIL > 0 implies failure to open a device.
C     
      IMPLICIT NONE
      INCLUDE 'device.inc'
      INTEGER PGOPEN, LENSTR, NCHAR, IFAIL, ID
      CHARACTER*128 DEVOLD
      LOGICAL ESAMECI, SAME, NEW
      SAVE DEVOLD
      DATA DEVOLD/'/xs'/
C
C     Return if a device is already open and user wants to
C     plot to the same one.
C
      IF(SAME .AND. NDID.GT.0) THEN
         NEW   = .FALSE.
         IFAIL = 0
      ELSE IF(NDID.EQ.MAXDID) THEN
         WRITE(*,*) 'Sorry you can only open ',MAXDID,' devices.'
         WRITE(*,*) 'You must close some before proceeding.'
         IFAIL = 3
      ELSE IF(ESAMECI(DEVICE,'PROMPT')) THEN     
 10      WRITE(*,*) ' '
         NCHAR = LENSTR(DEVOLD)
         WRITE(*,'(A,A,A,$)') 'Enter device name [',DEVOLD(:NCHAR),'] '
         READ(*,'(A)') DEVICE
         IF(DEVICE.EQ.' ') DEVICE = DEVOLD
         ID = PGOPEN(DEVICE)
         IF(ID.LT.1) GOTO 10
         NDID      = NDID + 1
         DID(NDID) = ID
         DEVOLD    = DEVICE
         DEVICE    = 'prompt'
         NEW       = .TRUE.
         IFAIL     = 0
      ELSE
         ID = PGOPEN(DEVICE)
         IF(ID.LT.1) THEN
            IFAIL = 1
         ELSE
            NDID      = NDID + 1
            DID(NDID) = ID
            IFAIL = 0
            NEW   = .TRUE.
         END IF
      END IF
      RETURN
      END

      SUBROUTINE DEV_CLOSE(ID, IFAIL)
C
C Closes device with indentifier ID. Set ID=0 to get most
C recently opened or selected device, ID=-1 to close all
C devices. 
C
C The most recently opened device (if there is one) is 
C selected for plotting before returning.
C
C IFAIL = 0 -- All OK
C IFAIL = 1 -- No devices open 
C IFAIL = 2 -- device ID was not open
C
      IMPLICIT NONE
      INTEGER ID, IFAIL, J, I
      LOGICAL MATCH
      INCLUDE 'device.inc'
C
      IF(NDID.LT.1) THEN
         IFAIL = 1
         RETURN
      ELSE IF(ID.EQ.-1) THEN
         DO I = 1, NDID
            CALL PGSLCT(DID(I))
            CALL PGCLOS
         END DO
         NDID  = 0
         IFAIL = 0
         RETURN
      ELSE IF(ID.EQ.0) THEN
         CALL PGCLOS
         NDID = NDID - 1
         IF(NDID.GT.0) CALL PGSLCT(DID(NDID))
         IFAIL = 0
      ELSE
         MATCH = .FALSE.
         I = 1
         DO WHILE(.NOT.MATCH .AND. I.LE.NDID)
            MATCH = ID.EQ.DID(I)
            I = I + 1
         END DO
         IF(MATCH) THEN
            CALL PGSLCT(ID)
            CALL PGCLOS
            DO J = I, NDID
               DID(J-1) = DID(J)
            END DO
            NDID = NDID - 1
            IF(NDID.GT.0) CALL PGSLCT(DID(NDID))
            IFAIL = 0
         ELSE
            IFAIL = 2
         END IF
      END IF
      RETURN
      END


