CRED
C RED N1 N2 N3 E(B-V) R -- Dereddens (or reddens) a series of spectra
C
C Parameters
C            N1, N2 -- Range of spectra to process
C            N3     -- First output slot
C            E(B-V) -- Colour excess. 
C            R      -- Ratio of Extinction at V Av/E(B-V). Use R=3.1 if you
C                      need continuity at 5464A (transition between two of
C                      Howarth's fits).
C
C Uses fits from Seaton 1979 MN 187, 73p and Howarth 1983 203 301
C This is for typical galactic extinction and LMC is quite different.
CRED
      SUBROUTINE DERED(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &     MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     SLOTS, MXSLOTS, IFAIL)
C     
C     Dereddens spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     =  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     =  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     =  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     >  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     I     SLOTS(MXSLOTS)     -- Workspace for list of slots
C     <  I     IFAIL            -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX
      INTEGER MXCHAR, MXDOUB, MXREAL, MXINTR, MXARC
      INTEGER NPIX(MXSPEC), NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J,  N, LENSTR
      REAL GET_FLX,  RATIO
      DOUBLE PRECISION  ANGST
      REAL FLX, WAV, EXT, R, EBV, CFRAT
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2,  IFAIL
      INTEGER   MAXSPEC,  NCOM
      INTEGER    SLOT3
      LOGICAL   DEFAULT
C     
C     Functions
C     
      REAL ISRED
C     
      DATA EBV, R/0., 3.1/
      DATA SLOT1, SLOT2, SLOT3/	1,1,1/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot to deredden', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to deredden', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to deredden'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
      CALL INTR_IN('First slot for output', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NSLOTS+1, IFAIL)
      CALL REAL_IN('E(B-V)', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, EBV, -1000., 1000., IFAIL)
      CALL REAL_IN('R (Av/E(B-V))', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, R, 0., 10., IFAIL)
      IF(IFAIL.NE.0) GOTO 999 
C     
C**************************************************************************
C     
C     Now process spectra, working on fluxes only,
C     but adjusting counts to give same ratio.
C     
      N = SLOT3-1
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NARC(SLOT).EQ.0) THEN
            WRITE(*,*) 'No wavelength scale in slot ',SLOT
         ELSE
            N = N + 1
            DO J = 1, NPIX(SLOT)
               IF(ERRORS(J,SLOT).GT.0.) THEN
                  RATIO = CFRAT(COUNTS(J,SLOT),FLUX(J,SLOT))
                  FLX   = GET_FLX(COUNTS(J,SLOT),FLUX(J,SLOT))
                  WAV   = REAL(ANGST(REAL(J),NPIX(SLOT),NARC(SLOT),
     &                 ARC(1,SLOT),MXARC))
                  EXT = 10.**(ISRED(WAV, EBV, R)/2.5)
                  ERRORS(J,N) = EXT*ERRORS(J,SLOT)
                  COUNTS(J,N) = EXT*COUNTS(J,SLOT)
                  IF(COUNTS(J,N).EQ.0.) THEN
                     FLUX(J,N) = RATIO
                  ELSE
                     FLUX(J,N) = EXT*FLX
                  END IF
               END IF
            END DO
C     
C     Copy headers
C     
            CALL SET_HEAD(N, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &           NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
            WRITE(*,*) 'Slot ',N,' = slot ',SLOT,' dereddened by ',EBV
            CALL SL_INF(N, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
      END DO
 999  RETURN
      END
