CCLEAN
C CLEAN N1 N2 N3 THRLO THRHI SET -- Reject outliers from a series of similar
C                                   spectra.
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to correct
C  N2    -- Slot number of last spectrum to correct
C  N3    -- Slot of first output 
C  THRLO -- Lower reject threshold
C  THRHI -- Upper reject threshold
C  EFAC  -- Factor to multiply errors on rejected points by. e.g. to 
C           reduce their weight in subsequent analysis or -1 to ignore completely
C           (will appear as a gap in a plot)
C  SET   -- Mask regions to be corrected
C
C The spectra should all be of the same length (checked) and have the 
C roughly the same wavelength scale (not checked). The routine first
C normalises each spectrum by its mean over the required region, and then
C compares each pixel of each spectrum with its equivalent in the other
C spectra. If it is too far out, its values is replaced with the value
C predicted from the others. The error bars of the spectra are used to
C scale the deviations but a separate computation is made to compute the
C scatter at each pixel. The error bars are used to the extent that if
C the scatter is very small by chance, it will not cause rejection of
C good points.
CCLEAN
CEMASK
C EMASK N1 N2 N3 CLO CHI ELO EHI SET -- Rejects point with errors or counts outside a given range
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to correct
C  N2    -- Slot number of last spectrum to correct
C  N3    -- Slot of first output 
C  CLO   -- Lowest allowed counts 
C  CHI   -- Highest allowed counts
C  ELO   -- Lowest allowed error (applied to the error as measured in COUNTS)
C  EHI   -- Highest allowed error (applied to the error as measured in COUNTS)
C  SET   -- Mask regions to be corrected
C
C Sometimes one can see that points are rubbish from their errors. This routine
C makes use of this to reject points based upon their uncertainty. If they are outside 
C a particular range, they are made negative which is equivalent to masking them.
C
CEMASK
      SUBROUTINE COS_REJ(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WORK2, WORK3, WORK4, WORK5, 
     &     MASK, KEY, MXWORK, SLOTS, MXSLOTS, CLOSE, COMMAND, IFAIL)
C     
C     Rejects cosmic rays from spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  R     WORK1(MXWORK)      -- Work array
C     >  R     WORK2(MXWORK)      -- Work array
C     >  R     WORK3(MXWORK)      -- Work array
C     >  R     WORK4(MXWORK)      -- Work array
C     >  R     WORK5(MXWORK)      -- Work array
C     >  L     MASK(MXWORK)       -- Mask array
C     >  I     KEY(MXWORK)        -- Integer work array
C     >  I     MXWORK             -- Size of work array
C     >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
C     >  I     MXSLOTS             -- Maximum number of entries
C     >  L     CLOSE              -- Plot will be closed on exit
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Mask arrays
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
      LOGICAL CLOSE
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
      REAL WORK5(MXWORK)
      LOGICAL MASK(MXWORK)
      INTEGER KEY(MXWORK)
C     
C     Local variables
C     
      INTEGER I, J,   OUT, NSAME, LENSTR
      INTEGER IREJ, NV,   NOK
      REAL GET_FLX, GET_ERF, CFRAT, EFAC
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, UPP
      INTEGER  IFAIL, MAXSPEC, NCOM
      LOGICAL SELECT, SAMECI, DEFAULT, OK
      REAL THRLO, THRHI,  WGT, MMOD, DMAX, DEV, REPLACE
      REAL ERR, CNT, RFAC, ELO, EHI, CLO, CHI
      DOUBLE PRECISION VEARTH, SUM1, AVE, SUM2, SUM3
      CHARACTER*3 SET
      CHARACTER*(*) COMMAND
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA ELO, EHI/0.,100./
      DATA CLO, CHI/0.,100./
      DATA THRLO, THRHI, EFAC/-3.,3.,1./
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
C     
C     Factor to account for average of absolute value of
C     a gaussian for robust rejection
C     
      RFAC = SQRT(2.*ATAN(1.))
C     
C     Check inputs
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
C     
C     First slot
C     
      CALL INTR_IN('First spectrum to correct', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
C     Second slot
C     
      SLOT2 = MAX(SLOT2, SLOT1)
      CALL INTR_IN('Last spectrum to correct', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) '0,0 only for list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Pick slots for rat rejection'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
C     First slot for output
C     
      UPP = MAXSPEC-SLOT2+SLOT1
      SLOT3 = MIN(SLOT3, UPP)
      CALL INTR_IN('First slot for corrected spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT3, 1, UPP, IFAIL)
      
      IF(SAMECI(COMMAND, 'CLEAN')) THEN
C     
C     Lower reject threshold
C     
         CALL REAL_IN('Lower reject threshold', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, THRLO, -1.E20, 1.E20, IFAIL)
C     
C     Upper reject threshold
C     
         THRHI = MAX(THRLO, THRHI)
         CALL REAL_IN('Upper reject threshold', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, THRHI, THRLO, 1.E20, IFAIL)
C     
         CALL REAL_IN('Error multiplier', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, EFAC, -1.E20, 1.E20, IFAIL)

      ELSE IF(SAMECI(COMMAND, 'EMASK')) THEN

         CALL REAL_IN('Lower limit on counts/pixel', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, CLO, -1.E20, 1.E20, IFAIL)

         CHI = MAX(CLO, CHI)
         CALL REAL_IN('Upper limit on counts/pixel', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, CHI, CLO, 1.E20, IFAIL)

         CALL REAL_IN('Lower limit on uncertainty', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, ELO, 0., 1.E20, IFAIL)

         EHI = MAX(ELO, EHI)
         CALL REAL_IN('Upper limit on uncertainty', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, EHI, ELO, 1.E20, IFAIL)

      ELSE
         WRITE(*,*) 'Programming error: wroing command sent to cose_rej'
         RETURN
      END IF
      IF(IFAIL.NE.0) GOTO 999
C     
C     Does a mask have to be set
C     
      CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SET, IFAIL)
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'Mask regions to be corrected.'
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, 
     &        MAXPX, NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, 
     &        NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &        HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &        MXDOUB, MXINTR, MXREAL, WORK1, WORK2, WORK3, 
     &        MXWORK, MASK)
         CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
         IF(SAMECI(SET,'YES')) THEN
            WRITE(*,*) 'No regions masked'
            GOTO 999
         END IF
      ELSE
         CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
         IF(SAMECI(SET,'YES')) THEN
            WRITE(*,*) 'No regions masked'
            GOTO 999
         END IF
      END IF
C     
C     Now perform correction
C     First compute means for each spectrum. Must have same numbers
C     of pixels.
C     
      NV = 0      
      NSAME = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NPIX(SLOT).GT.MXWORK) THEN
            WRITE(*,*) 'Too large for work arrays'
         ELSE IF(NARC(SLOT).EQ.0 .AND. (NVMASK.GT.0 .OR.
     &           NWMASK.GT.0)) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no wavelength scale'
            WRITE(*,*) 'to interpret mask and will be skipped'
         ELSE IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &           NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &           MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &           VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &           NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
            IF(NSAME.EQ.0) THEN
               NSAME = NPIX(SLOT)
            ELSE IF(NPIX(SLOT).NE.NSAME) THEN
               WRITE(*,*) 'Spectra must be of same length'
               GOTO 999
            END IF
            IF(NARC(SLOT).NE.0) THEN
C     
C     Search for double precision header item Vearth. If not
C     found, assume = 0
C     
               CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
            END IF
            NV = NV + 1
C     
C     Get mask
C     
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &           MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &           .TRUE.,VEARTH,IFAIL)
C     
            SUM1 = 0.D0
            SUM2 = 0.D0
            DO J = 1, NPIX(SLOT)
               IF(MASK(J) .AND. ERRORS(J,SLOT).GT.0.) THEN
                  SUM1 = SUM1 + 1.
                  SUM2 = SUM2 + GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
               END IF
            END DO
            IF(SUM1.LT.0.5) THEN
               WRITE(*,*) 'Appear to be no suitable'//
     &              ' points in slot ',SLOT
               GOTO 999
            END IF
            WORK1(NV) = REAL(SUM2/SUM1)
            KEY(NV)   = SLOT
         END IF
      END DO
      IF(  (SAMECI(COMMAND, 'CLEAN') .AND. NV.LE.2) .OR.
     &     (SAMECI(COMMAND, 'EMASK') .AND. NV.LT.1)) THEN
         WRITE(*,*) 'Insufficient number of spectra ',command,nv
         
         GOTO 999
      END IF

      CALL APPMASK(MASK,NPIX(KEY(1)),ARC(1,KEY(1)),NARC(KEY(1)),
     &     MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &     .TRUE.,VEARTH,IFAIL)
      
      IF(SAMECI(COMMAND, 'CLEAN')) THEN
C     
C     Now loop through pixels
C     
         DO I = 1, NSAME
            IF(MASK(I)) THEN
               SUM1 = 0.D0
               SUM2 = 0.D0
               NOK  = 0
               DO J = 1, NV
                  WORK3(J) = ERRORS(I,KEY(J))
                  IF(WORK3(J).GT.0.) THEN
                     WORK2(J) = GET_FLX(COUNTS(I,KEY(J)), 
     &                    FLUX(I,KEY(J)))/WORK1(J)
                     WORK4(J) = GET_ERF(COUNTS(I,KEY(J)), 
     &                    ERRORS(I,KEY(J)),FLUX(I,KEY(J)))/ABS(WORK1(J))
                     WORK5(J) = CFRAT(COUNTS(I,KEY(J)), FLUX(I,KEY(J)))
                     WGT  = 1./WORK4(J)**2
                     SUM1 = SUM1 + WGT
                     SUM2 = SUM2 + WGT*WORK2(J)
                     NOK  = NOK + 1
                  END IF
               END DO
               OK = NOK.GT.2
               IF(OK) AVE = SUM2/SUM1
               DO WHILE(OK)
                  SUM1 = 0.D0
                  SUM2 = 0.D0
                  SUM3 = 0.D0
                  NOK  = 0
C     
C     Form average of same pixel of all spectra and mean of absolute
C     deviation scaled by error on value. Absolute value is more robust
C     than sum of squares, but has to be corrected by SQRT(PI/2) later
C     (for gaussian stats)
C     
                  DO J = 1, NV
                     IF(WORK3(J).GT.0.) THEN
                        WGT  = 1./WORK4(J)**2
                        SUM1 = SUM1 + WGT
                        SUM2 = SUM2 + WGT*WORK2(J)
                        SUM3 = SUM3 + ABS(WORK2(J)-AVE)/WORK4(J)
                        NOK  = NOK + 1
                     END IF
                  END DO
                  IF(NOK.GT.2) THEN
                     AVE  = SUM2/SUM1
                     MMOD = REAL(RFAC*SUM3/DBLE(NOK))
                     MMOD = MAX(1., MMOD)
                     DMAX = 1.
                     IREJ = 0
                     DO J = 1, NV
                        IF(WORK3(J).GT.0.) THEN
                           DEV = REAL((WORK2(J)-AVE)/WORK4(J))
                           IF(DEV.GT.DMAX*THRHI*MMOD) THEN
                              DMAX = DEV/THRHI/MMOD
                              IREJ = J
                           ELSE IF(DEV.LT.DMAX*THRLO*MMOD) THEN
                              DMAX = DEV/THRLO/MMOD
                              IREJ = J
                           END IF
                        END IF
                     END DO
                     IF(IREJ.GT.0) THEN
                        DEV = REAL((WORK2(IREJ)-AVE)/WORK4(IREJ))
                        WORK3(IREJ) = -ABS(WORK3(IREJ))
                        WRITE(*,*) 'Pixel ',I,' of spectrum ',KEY(IREJ),
     &                       ' deviated by ',DEV,' sigma.'
                     END IF
                     OK = NOK.GT.2 .AND. IREJ.GT.0
                  ELSE
                     OK = .FALSE.
                  END IF
               END DO
C     
C     Now set output spectra
C     
               DO J = 1, NV
                  OUT = SLOT3 - 1 + J
                  ERR = ERRORS(I,KEY(J))
                  IF(WORK3(J).LT.0. .AND. ERR.GT.0.) THEN
                     REPLACE       = REAL(AVE*WORK1(J))
                     FLUX(I,OUT)   = REPLACE
                     COUNTS(I,OUT) = WORK5(J)*REPLACE
                     IF(COUNTS(I,OUT).EQ.0.) FLUX(I,OUT) = WORK5(J)
                     ERRORS(I,OUT) = EFAC*ERR
                  ELSE
                     FLUX(I,OUT)   = FLUX(I,KEY(J))
                     COUNTS(I,OUT) = COUNTS(I,KEY(J))
                     ERRORS(I,OUT) = ERR
                  END IF
               END DO
            ELSE     
               DO J = 1, NV
                  OUT = SLOT3 - 1 + J
                  FLUX(I,OUT)   = FLUX(I,KEY(J))
                  COUNTS(I,OUT) = COUNTS(I,KEY(J))
                  ERRORS(I,OUT) = ERRORS(I,KEY(J))
               END DO
            END IF
         END DO

      ELSE

         DO J = 1, NV
            OUT = SLOT3 - 1 + J
            DO I = 1, NSAME
               CNT = COUNTS(I,KEY(J))
               FLUX(I,OUT)   = FLUX(I,KEY(J))
               COUNTS(I,OUT) = CNT
               ERR = ERRORS(I,KEY(J))
               IF(MASK(I) .AND. ((ERR.LT.ELO .OR. ERR.GT.EHI) .OR.
     &              (CNT.LT.CLO .OR. CNT.GT.CHI))) THEN
                  ERRORS(I,OUT) = - ABS(ERR)
               ELSE
                  ERRORS(I,OUT) = ERR
               END IF
            END DO
         END DO
         
      END IF

C     
C     Set headers equal to those of input spectrum 
C     
      DO J = 1, NV
         OUT = SLOT3 - 1 + J
         CALL SET_HEAD(OUT, KEY(J), MXSPEC, NPIX, ARC, NARC, MXARC, 
     &        NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &        HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &        MXDOUB, MXINTR, MXREAL, IFAIL)
         CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &        NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &        NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &        MXINTR, MXREAL, STRING, IFAIL)
         WRITE(*,*) STRING(:LENSTR(STRING))
      END DO
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END

