      SUBROUTINE COMINT(COMMAND, COMMS, NCOM, NFIND, SPLIT, NSTR, 
     &MXSTR, IFAIL)
*
* Splits character string COMMAND into series of character strings 
* looking for either a blank or a comma as the delimiter. It makes a
* case independent comparison of the first string with the commands in 
* COMMS and identifies the correct command if unique. Returnsd NFIND
* the address of the command in the array COMMS(NCOM). It returns NFIND
* equal to the negative value of the first match found if the match
* is not unique. Character strings with blanks can be passed if enclosed by 
* " ". e.g. "Tom Marsh". The quotation marks will be stripped off.
*
* Failure if there are too many parameters for the array SPLIT(MXSTR), in
* which case it still ends up filled to MXSTR with NSTR = MXSTR. Two
* double quotes "" also causes failure.
* Unrecognised command does not count as a failure.
*
      IMPLICIT NONE
      INTEGER NSTR, MXSTR, NCOM, NFIND, IFAIL
      INTEGER IS, LENGTH, IE, I
      INTEGER LENSTR
      CHARACTER*(*) COMMAND
      CHARACTER*(*) COMMS(NCOM)
      CHARACTER*(*) SPLIT(MXSTR)
      LOGICAL SAMECI, FIRST
*
      FIRST  = .TRUE.
      LENGTH = MAX(1,LENSTR(COMMAND))
      IS     = 0
      NSTR   = 0
      NFIND  = 0
      IFAIL  = 0
*
* Search for start of string
*
100   CONTINUE
      IS = IS  + 1
*
* Special section for character strings in quotes
*
      IF(IS.LE.LENGTH .AND. COMMAND(IS:IS).EQ.'"') THEN
        IF(NSTR.EQ.MXSTR) GOTO 999
        IE = IS
        IS = IS + 1
150     IE = IE + 1
        IF(IE.LE.LENGTH .AND. COMMAND(IE:IE).NE.'"') GOTO 150
        IF(IE.GT.LENGTH) RETURN
        IE = IE - 1
        IF(FIRST) THEN
          RETURN
        ELSE IF(IS.GT.IE) THEN
          GOTO 999
        END IF
        NSTR = NSTR + 1
        SPLIT(NSTR) = COMMAND(IS:IE)
        IS = IE + 1
        GOTO 100
      END IF
      IF(IS.LE.LENGTH .AND. (COMMAND(IS:IS).EQ.' ' 
     &   .OR. COMMAND(IS:IS).EQ.',')) GOTO 100
      IF(IS.GT.LENGTH) RETURN
*
* Search for end
*
      IE = IS
200   CONTINUE
      IE = IE  + 1
      IF(IE.LE.LENGTH .AND. COMMAND(IE:IE).NE.' ' 
     &   .AND. COMMAND(IE:IE).NE.',') GOTO 200
      IE = IE - 1
*
* If first string, compare with commands before
* locating other parameters. The search is made through
* all commands to see if there is more than one match.
*
      IF(FIRST) THEN
        DO I = 1, NCOM
          IF(SAMECI(COMMAND(IS:IE),COMMS(I))) THEN
            IF(NFIND.GT.1) THEN
              WRITE(*,*) 'Ambiguous command: ',COMMAND(:LENGTH)
              NFIND = - NFIND
              RETURN
            END IF
            NFIND = I
          END IF
        END DO
        IF(NFIND.EQ.0) RETURN
        FIRST = .FALSE.
      ELSE
*
* Store succeeding strings
*
        IF(NSTR.EQ.MXSTR) GOTO 999
        NSTR = NSTR + 1
        SPLIT(NSTR) = COMMAND(IS:IE)
      END IF
      IS = IE
      GOTO 100
999   IFAIL = 1
      RETURN
      END                                                            

      SUBROUTINE CONSEP(COMMAND, SPLIT, NSTR, MXSTR, IFAIL)
*
* Splits character string COMMAND into series of character strings 
* looking for a semicolon (;) as the delimiter. Returns SPLIT(NSTR)
* strings (without the semicolons).
*
* Fails (IFAIL.NE.0) if there are too many strings.
*
      IMPLICIT NONE
      INTEGER NSTR, MXSTR,  NFIND
      INTEGER IS, LENGTH,   L, IFAIL
      INTEGER LENSTR
      CHARACTER*(*) COMMAND
      CHARACTER*(*) SPLIT(MXSTR)
*
      LENGTH = LEN(COMMAND)
      IS     = 1
      NSTR   = 0
      IFAIL  = 0
*
* Search for start of string
*
100   CONTINUE
      NFIND = INDEX(COMMAND(IS:),';')
      IF(NFIND.EQ.1) THEN
        IS = IS  + 1
        IF(IS.LE.LENGTH) GOTO 100
      ELSE IF(NFIND.EQ.0) THEN
        L = LENSTR(COMMAND(IS:))
        IF(L.GT.0) THEN
          NSTR = NSTR + 1
          IF(NSTR.LE.MXSTR) THEN
            SPLIT(NSTR) = COMMAND(IS:IS+L-1)
          ELSE
            NSTR = MXSTR
            GOTO 999
          END IF
        END IF
      ELSE
        L = LENSTR(COMMAND(IS:IS+NFIND-2))        
        IF(L.GT.0) THEN
          NSTR = NSTR + 1
          IF(NSTR.LE.MXSTR) THEN
            SPLIT(NSTR) = COMMAND(IS:IS+L-1)
          ELSE
            NSTR = MXSTR
            GOTO 999
          END IF
        END IF
        IS = IS + NFIND
        IF(IS.LE.LENGTH) GOTO 100
      END IF
      RETURN
999   IFAIL = 1
      RETURN
      END

      SUBROUTINE CSPLIT(COMMAND, SPLIT, NSTR, MXSTR, IFAIL)
*
* Splits up command into strings, looking for commas and blanks as delimiters
* Character strings with blanks can be passed if enclosed by " ". 
* e.g. "Tom Marsh". The quotation marks will be stripped off.
*
* Failures (IFAIL .NE. 0) occur if there are too many strings for the
* returned array SPLIT(MXSTR), or if double quotes "" are found
*
      IMPLICIT NONE
      INTEGER NSTR, MXSTR, IFAIL
      INTEGER IS, LENGTH, IE
      CHARACTER*(*) COMMAND
      CHARACTER*(*) SPLIT(MXSTR)
*
      IFAIL = 0
      LENGTH = LEN(COMMAND)
      IS     = 0
      NSTR   = 0
*
* Search for start of string
*
100   CONTINUE
      IS = IS  + 1
*
* Special section for character strings in quotes
*
      IF(IS.LE.LENGTH .AND. COMMAND(IS:IS).EQ.'"') THEN
        IF(NSTR.EQ.MXSTR) GOTO 999
        IE = IS
        IS = IS + 1
150     IE = IE + 1
        IF(IE.LE.LENGTH .AND. COMMAND(IE:IE).NE.'"') GOTO 150
        IF(IE.GT.LENGTH) RETURN
        IE = IE - 1
        IF(IS.GT.IE) GOTO 999
        NSTR = NSTR + 1
        SPLIT(NSTR) = COMMAND(IS:IE)
        IS = IE + 1
        GOTO 100
      END IF
      IF(IS.LE.LENGTH .AND. (COMMAND(IS:IS).EQ.' ' 
     &   .OR. COMMAND(IS:IS).EQ.',')) GOTO 100
      IF(IS.GT.LENGTH) RETURN
*
* Search for end
*
      IF(NSTR.EQ.MXSTR) GOTO 999
      IE = IS
200   CONTINUE
      IE = IE  + 1
      IF(IE.LE.LENGTH .AND. COMMAND(IE:IE).NE.' ' 
     &   .AND. COMMAND(IE:IE).NE.',') GOTO 200
      IE = IE - 1
      NSTR = NSTR + 1
      SPLIT(NSTR) = COMMAND(IS:IE)
      IS = IE
      GOTO 100
999   IFAIL = 1
      RETURN
      END

      SUBROUTINE CWILD(STRING, WORDS, MATCH, NCOM, NFIND)
*
* Compares STRING with the list of words WORDS(NCOM), comes back with
* a list of indices MATCH(NFIND) of all those which are judged equivalent.
* The wildcard * is a special character so that 'C*' would be equivalent 
* to 'CHAP', 'CAT' etc. Equivalently '*CH*' would be equivalent to ANY
* word with a 'CH' in it. Case independent.
*
      IMPLICIT NONE
      INTEGER NCOM, NFIND, I, N
      CHARACTER*(*) STRING
      CHARACTER*(*) WORDS(NCOM)
      INTEGER MATCH(NCOM)
      LOGICAL WSAMECI
*
      N = 0
      DO I = 1, NCOM
        IF(WSAMECI(STRING,WORDS(I))) THEN
          N = N + 1
          MATCH(N) = I
        END IF
      END DO                     
      NFIND = N
      RETURN    
      END

      LOGICAL FUNCTION WSAMECI( STRING, MASTER )
*
*  Checks strings are the same, but allows for the wildcard *
*  Compares all non-blank characters between two strings STRING and MASTER.
*  STRING can have *s which are taken to match any character or number of
*  characters. Thus '*CH*' is the same as 'CH', 'TTCH', 'HTCHL' etc.
*
*  WSAMECI = .TRUE. if they match.
*  Strings will match if:
*
*      (1) Both STRING and MASTER are blank
*      (2) STRING is shorter than MASTER and all letters match, unless
*          a wildcard was used in which case the specified letters must
*          match precisely.
*
      IMPLICIT NONE
      CHARACTER*(*) STRING, MASTER
      INTEGER L1, M1, L2, M2, N, IM, IS
      LOGICAL WILD, ONCE
*
      WSAMECI = .TRUE.
      WILD  = .FALSE.
      ONCE  = .FALSE.
      L1 = LEN(STRING)
      M1 = LEN(MASTER)
      L2 = 1
      M2 = 1
      N = 0
100   CONTINUE
*
* Find non-blank characters
*
      N = N + 1
200   CONTINUE
      IF(L2.LE.L1 .AND. STRING(L2:L2).EQ.' ') THEN
        L2 = L2 + 1
        GOTO 200
      ELSE IF(L2.LE.L1 .AND. STRING(L2:L2).EQ.'*') THEN
        L2 = L2 + 1
        WILD = .TRUE.
        ONCE = .TRUE.
        GOTO 200
      END IF
      L2 = MIN(L1, L2)
*
300   CONTINUE
      IF(M2.LE.M1 .AND. MASTER(M2:M2).EQ.' ') THEN
        M2 = M2 + 1
        GOTO 300
      ELSE IF(M2.LE.M1 .AND. WILD .AND. 
     &  STRING(L2:L2).NE.' ') THEN
        IS = ICHAR(STRING(L2:L2))
        IF(IS.GE.97 .AND. IS.LE.122) IS = IS - 32
        IM = ICHAR(MASTER(M2:M2))
        IF(IM.GE.97 .AND. IM.LE.122) IM = IM - 32
        IF(IM.NE.IS) THEN
          M2 = M2 + 1
          GOTO 300
        END IF
      END IF
      M2 = MIN(M1, M2)
*
      IF(STRING(L2:L2).NE.' ' .AND. MASTER(M2:M2).NE.' ') THEN
        IS = ICHAR(STRING(L2:L2))
        IF(IS.GE.97 .AND. IS.LE.122) IS = IS - 32
        IM = ICHAR(MASTER(M2:M2))
        IF(IM.GE.97 .AND. IM.LE.122) IM = IM - 32
        IF(IS.NE.IM) THEN
          WSAMECI = .FALSE.
          RETURN
        END IF
      ELSE IF(STRING(L2:L2).EQ.' ') THEN
        IF((ONCE .OR. N.EQ.1) .AND. .NOT.WILD 
     &  .AND. MASTER(M2:M2).NE.' ') WSAMECI = .FALSE.
        RETURN
      ELSE IF(MASTER(M2:M2).EQ.' ' .AND. STRING(L2:L2).NE.' ') THEN
        WSAMECI = .FALSE.
        RETURN
      END IF
*
* Move onto next character
*
      L2 = L2 + 1
      M2 = M2 + 1
      WILD = .FALSE.
      IF(L2.LE.L1 .AND. M2.LE.M1) GOTO 100
*
      IF(M2.GT.M1 .AND. L2.LE.L1) THEN
400     CONTINUE
        IF(L2.LE.L1 .AND. STRING(L2:L2).EQ.' ') THEN
          L2 = L2 + 1
          GOTO 400
        END IF
        L2 = MIN(L2, L1)
        IF(STRING(L2:L2).NE.' ') WSAMECI = .FALSE.
      END IF
      RETURN
      END
