      SUBROUTINE COMDEF(CFILE, COMMS, CINFO, MXCOM, NCOM, CLASS, 
     &     WCLASS, MXCLASS, NCLASS, IFAIL)
C
C     Loads command definitions and classes
C
      IMPLICIT NONE
      INTEGER MXCOM, NCOM, MXCLASS, NCLASS, IFAIL
      CHARACTER*(*) COMMS(MXCOM), CINFO(MXCOM)
      CHARACTER*(*) CLASS(MXCLASS), CFILE
      INTEGER WCLASS(MXCOM)
      INTEGER MXSPLIT, NSPLIT
      PARAMETER (MXSPLIT=10)
      CHARACTER*16 SPLIT(MXSPLIT)
      CHARACTER*132 STRING
      LOGICAL SAMECI
      INTEGER LUNIT, I, L, LENSTR, SEARC, FIND, NC, IC
      DATA LUNIT/51/
C
C     Get name of command definition file
C
      OPEN(UNIT=LUNIT,FILE=CFILE,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
         WRITE(*,*) 'Could not find command definition file = '
         WRITE(*,*) CFILE
         GOTO 999
      END IF
      IFAIL = 0
      NCLASS = 0
      NCOM   = 0
      DO WHILE(IFAIL.EQ.0)
         READ(LUNIT,'(A)',IOSTAT=IFAIL) STRING
         IF(IFAIL.EQ.0 .AND. STRING(1:1).NE.'#') THEN
            L = LENSTR(STRING)
C
C     Load class names
C
            IF(SAMECI('CLASS',STRING)) THEN
               IC = INDEX(STRING,'#')
               IF(IC.EQ.0) THEN
                  IC = L
               ELSE
                  IC = IC-1
               END IF
               DO I = 1, NCLASS
                  IF(SAMECI(STRING(7:IC),CLASS(I))) THEN
                     WRITE(*,*) 'Class name: ',STRING(7:L)
                     WRITE(*,*) 
     &                    'Cannot be distinguished from earlier class'
                     WRITE(*,*) CLASS(I)
                     GOTO 999
                  END IF
               END DO
               IF(NCLASS.EQ.MXCLASS) THEN
                  WRITE(*,*) 'Too many classes for class buffer.'
                  GOTO 999
               END IF
               NCLASS = NCLASS + 1
               CLASS(NCLASS) = STRING(7:IC)
            ELSE
C
C     Load command names
C           
               DO I = 1, NCOM
                  IF(SAMECI(STRING(:8),COMMS(I))) THEN
                     WRITE(*,*) 'Command name: ',STRING(:8)
                     WRITE(*,*) 
     &                    'Cannot be distinguished from earlier name'
                     WRITE(*,*) COMMS(I)
                     GOTO 999
                  END IF
               END DO
               IF(NCOM.EQ.MXCOM) THEN
                  WRITE(*,*) 'Too many commands for buffer.'
                  GOTO 999
               END IF           
               NCOM = NCOM + 1
               COMMS(NCOM) = STRING(:8)
               CINFO(NCOM) = STRING(:40)
C
C     Find classes
C
               IC = INDEX(STRING,'#')
               IF(IC.EQ.0) THEN
                  WRITE(*,*) 'Could not locate # in ',STRING
                  WRITE(*,*) 'Needed to identify classes'
                  GOTO 999
               END IF
               CALL CSPLIT(STRING(IC+1:), SPLIT, NSPLIT, MXSPLIT, IFAIL)
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Could not split ',STRING(IC+1:)
                  WRITE(*,*) 'into class names.'
                  GOTO 999
               END IF
C
C     Search for class names amongst names already loaded, 
C     code into integer
C
               WCLASS(NCOM) = 0
               IF(NSPLIT.GT.0 .AND. NCLASS.GT.0) THEN
                  NC = 1
                  DO I = 1, NSPLIT
                     FIND = SEARC(CLASS, NCLASS, NCLASS, SPLIT(I))
                     IF(FIND.EQ.0) THEN
                        WRITE(*,*) 'No matches found to class ',SPLIT(I)
                        GOTO 999
                     ELSE IF(FIND.LT.0) THEN
                        WRITE(*,*) 'Ambiguous match to class ',SPLIT(I)
                        GOTO 999
                     END IF
                     WCLASS(NCOM) = WCLASS(NCOM) + FIND*NC
                     NC = 100*NC
                  END DO
               ELSE IF(NSPLIT.GT.0 .AND. NCLASS.EQ.0) THEN
                  WRITE(*,*) 'No classes have been defined to match'
                  WRITE(*,*) STRING(:L)
                  GOTO 999
               END IF
            END IF
         END IF
      END DO  
      CLOSE(UNIT=LUNIT)
      IFAIL = 0
      RETURN
 999  WRITE(*,*) 'COMDEF failed'
      CLOSE(UNIT=LUNIT)
      IFAIL = 1
      RETURN
      END    

