*CLIP
* CLIP N1 N2 NB NR -- Clips pixels off ends of spectra.
*
* Parameters
*           N1, N2 -- Range of spectra to treat
*           NB  -- Number to remove from blue end
*           NR  -- Number to remove from red end of spectra
*
* CLIP is useful for cleaning up spectra which often have a few duff
* pixels at either end.
*CLIP
      SUBROUTINE CLIP(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &MXSINTR, MXSREAL, SLOTS, MXSLOTS, IFAIL)
*
* Clips pixels off each end of spectra
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
* >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
* >  I     MXSLOTS             -- Maximum number of entries
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Search parameters
*
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      INTEGER I, J, K
      DOUBLE PRECISION  ANGST, W1, W2
      DOUBLE PRECISION ALPHA, BETA, STORE(100)
      DOUBLE PRECISION SUM, FAC
      INTEGER SLOT1, SLOT2,   IFAIL
      INTEGER  MAXSPEC,  NCOM
      LOGICAL SELECT
      LOGICAL DEFAULT
      INTEGER    NCLIP1, NCLIP2, NMOVE
*
* Functions
*
*
      DATA SLOT1, SLOT2/1,1/
      DATA NCLIP1, NCLIP2/0,0/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
*
* First slot
*
      CALL INTR_IN('First spectrum to clip', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
*
* Second slot
*
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to clip', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) '0,0 only for list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to clip'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      CALL INTR_IN('Number to clip from blue', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, NCLIP1, 0, MAXPX, IFAIL)
      CALL INTR_IN('Number to clip from red', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, NCLIP2, 0, MAXPX, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NCLIP2.EQ.0 .AND. NCLIP1.EQ.0) THEN
        WRITE(*,*) 'Null operation'
        GOTO 999
      END IF
*
***************************************************************************
*
* Loop through spectra
*
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).LE.0) THEN
          WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
        ELSE IF(.NOT.SELECT( SLOT, NMCHAR, NMDOUB, NMINTR, 
     &    NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &    NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &    MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &    VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &    NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
          WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
        ELSE IF(NCLIP1+NCLIP2.GE.NPIX(SLOT)) THEN
          WRITE(*,*) 'Too many pixels to clip'
          WRITE(*,*) NCLIP1+NCLIP2,' compared to ',NPIX(SLOT)
          WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
        ELSE
          IF(NARC(SLOT).NE.0) THEN
*
* Correct ARC scale first
*
            W1 = ANGST(1.,NPIX(SLOT),NARC(SLOT),ARC(1,SLOT),MXARC)
            W2 = ANGST(REAL(NPIX(SLOT)),NPIX(SLOT),NARC(SLOT),
     &      ARC(1,SLOT),MXARC)
            ALPHA = DBLE(NPIX(SLOT)-NCLIP1-NCLIP2)/DBLE(NPIX(SLOT))
            IF(W1.LT.W2) THEN
              BETA  = DBLE(NCLIP1)/DBLE(NPIX(SLOT))
              NMOVE = NCLIP1
            ELSE
              BETA  = DBLE(NCLIP2)/DBLE(NPIX(SLOT))
              NMOVE = NCLIP2
            END IF
            WRITE(*,*) 'Squeeze = ',ALPHA,', shift = ',BETA
            DO J = 1, ABS(NARC(SLOT))
              IF(J.EQ.1) THEN
                FAC = 1.D0
              ELSE
                FAC = ALPHA**(J-1)
              END IF
              SUM = 0.D0
              DO K = J, ABS(NARC(SLOT))
                SUM = SUM + FAC*ARC(K,SLOT)
                FAC = FAC*BETA*DBLE(K)/DBLE(K-J+1)
              END DO
              STORE(J) = SUM
            END DO
            DO J = 1, ABS(NARC(SLOT))
              ARC(J,SLOT) = STORE(J)
            END DO
          ELSE
            NMOVE = NCLIP1
          END IF
*
* Now move data
*
          NPIX(SLOT) = NPIX(SLOT) - NCLIP1 - NCLIP2
          IF(NMOVE.GT.0) THEN
            DO J = 1, NPIX(SLOT)
              K = J + NMOVE 
              FLUX(J,SLOT)   = FLUX(K,SLOT)
              COUNTS(J,SLOT) = COUNTS(K,SLOT)
              ERRORS(J,SLOT) = ERRORS(K,SLOT)
            END DO
          END IF
        END IF
      END DO
999   RETURN
      END
