*CPOL
* CPOL N1 N2 N3 N4 N5 -- Combines polarsisation spectra
*
* Parameters: 
*     
*  N1    -- Start slot of left-hand polarisation components
*  N2    -- End slot of left-hand polarisation components
*  N3    -- Start slot of right-hand polarisation components
*  N4    -- End slot of right-hand polarisation components
*  N5    -- First slot for results 
*  ANGLE -- name of header parameter with waveplate angle
*  TYPE  -- data type of waveplate angle ('D' or 'R')
*  DELTA -- maximum time difference between two exposures to b e combined into
*           a V spectrum (units of days)
*
* CPOL handles the following task: in a circular spectropolarimetry run,
* one will have two spectra per frame, which I call the left and right
* components. During the run the waveplate will switch by 90 degrees, e.g.
* -45 ---> +45 ---> +45 ---> -45 ---> -45 ---> +45. Note that it is not
* always switching to save overheads for example. Each separate pair of
* -45/+45 exposures can be used to derive a measure of the polarisation.
* CPOL handles this combination for you assuming you have two blocks for
* the left and right components in CORRECT TIME ORDER. This is convenient
* because one typically reduces all left-component spectra in one go and
* then the right-components. The routine only combines independent spectra.
* e.g. in a run of -45,+45,-45,+45 the first two and the last two spectra
* will be combined, but not the middle two. From every 4 input spectra, two
* left, two right-side components, 3 spectra will be produced which will
* be Stokes I, Stokes V and the percentage polarisation. 
*
* NB The times 'RJD' are set correctly by this routine BUT ANY OTHER
* TIME RELATED QUANTITIES SHOULD BE RE_COMPUTED, e.g HJD, phase.
*
* This routine is fussy. If anything goes wrong -- incompatible spectrum
* lengths, empty slots etc -- it simply throws in the towel.
*
*CPOL

      SUBROUTINE CIRCPOL(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     SLOTS1, SLOTS2, MXSLOTS, MUTE, IFAIL)
*
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    I     SLOTS1(MXSLOTS)
*    I     SLOTS2(MXSLOTS)
*    I     MXSLOTS
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
*
*     Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
*     Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
*     Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
*     Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
*     Values of header items
*     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
*     Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
*     Slot lists
*
      INTEGER MXSLOTS, NSLOTS1, NSLOTS2
      INTEGER SLOTS1(MXSLOTS), SLOTS2(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST1, LIST1(2,MXLIST)
      INTEGER NLIST2, LIST2(2,MXLIST)
*
*     Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
*     Local variables
*
      INTEGER L, N, NVALID
      REAL CFRAT, GET_FLX, GET_ERF
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4, SLOT5, ISWAP, NOUT
      INTEGER IFAIL, SL1, SL2, SL3, SL4, SL5, RECORD1, RECORD2
      INTEGER MAXSPEC, NCOM, STATUS, STATUS1, STATUS2
      REAL FLX1, FLX2, FLX3, FLX4, RAT1, RATIO, STOKESI, ESTOKESI
      REAL ERR1, ERR2, ERR3, ERR4, ANGLE1, ANGLE2, ANGLE3, ANGLE4
      REAL STOKESV, SET_ERF, SET_FLX, X, FAC, ESTOKESV, PERCENT
      REAL EPERCENT
      LOGICAL DEFAULT, MUTE, NORMAL, NOPAIR, ESAMECI
      DOUBLE PRECISION DTEMP, DELTA, JD1, JD2
      CHARACTER*16 WAVEPLATE, DTYP*1
*
      SAVE SLOT1, SLOT2, SLOT3, SLOT4, SLOT5, WAVEPLATE, DTYP
      SAVE DELTA
      DATA SLOT1, SLOT2, SLOT3, SLOT4, SLOT5/1,2,3,4,5/
      DATA WAVEPLATE/'VLT-FORS1-ANGLE'/
      DATA DTYP/'D'/
      DATA DELTA/0.005/

      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM  = 0
      IFAIL = 0
      CALL INTR_IN('First of the left-hand component spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      IF(SLOT1.EQ.0) SLOT2 = 0
      CALL INTR_IN('Last of the left-hand component spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST1.GT.0) THEN
            CALL SETSLOT(LIST1, NLIST1, MXLIST, SLOTS1, 
     &           NSLOTS1, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of left-hand spectra to process'
            CALL GETLIS(LIST1, NLIST1, MXLIST, MAXSPEC, SLOTS1, 
     &           NSLOTS1, MXSLOTS)
         END IF
         IF(NSLOTS1.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST1, NLIST1, MXLIST, SLOTS1, 
     &        NSLOTS1, MXSLOTS)
      END IF
*     
      CALL INTR_IN('First of the right-hand component spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      SLOT4 = MIN(SLOT3 + SLOT2 - SLOT1, MAXSPEC)
      CALL INTR_IN('Last of the right-hand component spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT3.EQ.0 .AND. SLOT4.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT3.EQ.0 .AND. SLOT4.EQ.0) THEN
         IF(DEFAULT .AND. NLIST2.NE.0) THEN
            CALL SETSLOT(LIST2, NLIST2, MXLIST, SLOTS2, 
     &           NSLOTS2, MXSLOTS)
         END IF
         IF(.NOT.DEFAULT .OR. NLIST2.EQ.0 .OR. 
     &        (NSLOTS2.NE.1 .AND. NSLOTS1.NE.NSLOTS2)) THEN
            WRITE(*,*) 'Enter list of right-hand spectra to process'
            CALL GETLIS(LIST2, NLIST2, MXLIST, MAXSPEC, SLOTS2, 
     &           NSLOTS2, MXSLOTS)
         END IF
         IF(NSLOTS2.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT3, SLOT4, LIST2, NLIST2, MXLIST, SLOTS2, 
     &        NSLOTS2, MXSLOTS)
      END IF
      IF(NSLOTS1.NE.NSLOTS2) THEN
         WRITE(*,*) 'Must have equal numbers of left and right spectra'
         GOTO 999
      END IF
*
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT5, 1, MAXSPEC-NSLOTS1+1, IFAIL)

      CALL CHAR_IN('Name of waveplate angle header item', SPLIT, NSPLIT,
     &     MXSPLIT, NCOM, DEFAULT, WAVEPLATE, IFAIL)

      CALL CHAR_IN('Data type of waveplate angle header item (D or R)',
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, DTYP, IFAIL)

      IF(.NOT.ESAMECI(DTYP,'D') .AND. .NOT.ESAMECI(DTYP,'R')) THEN
         WRITE(*,*) 'Must be either'
         WRITE(*,*) ' D = Double precision'
         WRITE(*,*) ' R = Real'
         DTYP = 'D'
         WAVEPLATE = 'VLT-FORS1-ANGLE'
         GOTO 999
      END IF

      CALL DOUB_IN('Maximum time difference', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, DELTA, 0.D0, 1.D5, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
*     then need to go through spectra finding independent pairs.
*
      N     = 1
      NOUT = 0
      DO WHILE(N .LE. NSLOTS1-1)
*
*     check slots for OK-ness (not empty,
*     same number of pixels, same record number)
*     
         NOPAIR = .TRUE.
         DO WHILE(NOPAIR .AND. N .LE. NSLOTS1-1)
            SL1 = SLOTS1(N)
            SL2 = SLOTS2(N)
            IF( NPIX(SL1).LE.0 .OR. NPIX(SL2).LE.0 .OR.
     &           NPIX(SL1).NE.NPIX(SL2)) THEN
               WRITE(*,*) 'Slot ',SL1,' and/or ',SL2,' empty or '//
     &              'incompatible.'
               GOTO 999
            END IF
            CALL HGETI('Record', RECORD1, SL1, MXSPEC, NMINTR,
     &           HDINTR, NINTR, MXINTR, STATUS1)

            CALL HGETI('Record', RECORD2, SL2, MXSPEC, NMINTR,
     &           HDINTR, NINTR, MXINTR, STATUS2)

            IF(STATUS1.NE.0 .OR. STATUS2.NE.0 .OR. 
     &           RECORD1.NE.RECORD2) THEN
               WRITE(*,*) 'Either failed to find record numbers of'//
     &              ' spectra ',SL1,' and ',SL2,
     &              ' or they were different.'
               GOTO 999
            END IF
*     
*     Get waveplate angle
*     
            IF(ESAMECI(DTYP,'D')) THEN
               CALL HGETD(WAVEPLATE, DTEMP, SL1, MXSPEC, NMDOUB,
     &              HDDOUB, NDOUB, MXDOUB, STATUS)
               ANGLE1 = REAL(DTEMP)
            ELSE
               CALL HGETR(WAVEPLATE, ANGLE1, SL1, MXSPEC, NMREAL,
     &              HDREAL, NREAL, MXREAL, STATUS)
            END IF
            IF(STATUS.NE.0) THEN
               WRITE(*,*) 'Could not find header item ',WAVEPLATE,
     &              ' in spectrum ',SL1
               GOTO 999
            END IF

            IF(ESAMECI(DTYP,'D')) THEN
               CALL HGETD(WAVEPLATE, DTEMP, SL2, MXSPEC, NMDOUB,
     &              HDDOUB, NDOUB, MXDOUB, STATUS)
               ANGLE2 = REAL(DTEMP)
            ELSE
               CALL HGETR(WAVEPLATE, ANGLE2, SL2, MXSPEC, NMREAL,
     &              HDREAL, NREAL, MXREAL, STATUS)
            END IF
            IF(STATUS.NE.0) THEN
               WRITE(*,*) 'Could not find header item ',WAVEPLATE,
     &              ' in spectrum ',SL2
               GOTO 999
            END IF
            
            IF(ANGLE1.NE.ANGLE2) THEN
               WRITE(*,*) 'Waveplate angles of slots ',SL1,' and ',
     &              SL2,' do not match.'
               GOTO 999
            END IF
*
*     Get time
*
            CALL HGETD('RJD', JD1, SL1, MXSPEC, NMDOUB,
     &           HDDOUB, NDOUB, MXDOUB, STATUS)
*     
*     Now for second pair
*     
            N = N + 1

            SL3 = SLOTS1(N)
            SL4 = SLOTS2(N)
            IF( NPIX(SL3).LE.0 .OR. NPIX(SL3).LE.0 .OR.
     &           NPIX(SL3).NE.NPIX(SL4)) THEN
               WRITE(*,*) 'Slot ',SL3,' and/or ',SL4,' empty or '//
     &              'incompatible.'
               GOTO 999
            END IF
            CALL HGETI('Record', RECORD1, SL3, MXSPEC, NMINTR,
     &           HDINTR, NINTR, MXINTR, STATUS1)
            
            CALL HGETI('Record', RECORD2, SL4, MXSPEC, NMINTR,
     &           HDINTR, NINTR, MXINTR, STATUS2)

            IF(STATUS1.NE.0 .OR. STATUS2.NE.0 .OR. 
     &           RECORD1.NE.RECORD2) THEN
               WRITE(*,*) 'Either failed to find record numbers of'//
     &              ' spectra ',SL3,' and ',SL4,
     &              ' or they were different.'
               GOTO 999
            END IF
*     
*     Get waveplate angle
*
            IF(ESAMECI(DTYP,'D')) THEN
               CALL HGETD(WAVEPLATE, DTEMP, SL3, MXSPEC, NMDOUB,
     &              HDDOUB, NDOUB, MXDOUB, STATUS)
               ANGLE3 = REAL(DTEMP)
            ELSE
               CALL HGETR(WAVEPLATE, ANGLE3, SL3, MXSPEC, NMREAL,
     &              HDREAL, NREAL, MXREAL, STATUS)
            END IF
            IF(STATUS.NE.0) THEN
               WRITE(*,*) 'Could not find header item ',WAVEPLATE,
     &              ' in spectrum ',SL3
               GOTO 999
            END IF

            IF(ESAMECI(DTYP,'D')) THEN
               CALL HGETD(WAVEPLATE, DTEMP, SL4, MXSPEC, NMDOUB,
     &              HDDOUB, NDOUB, MXDOUB, STATUS)
               ANGLE4 = REAL(DTEMP)
            ELSE
               CALL HGETR(WAVEPLATE, ANGLE4, SL4, MXSPEC, NMREAL,
     &              HDREAL, NREAL, MXREAL, STATUS)
            END IF
            IF(STATUS.NE.0) THEN
               WRITE(*,*) 'Could not find header item ',WAVEPLATE,
     &              ' in spectrum ',SL4
               GOTO 999
            END IF

            IF(ANGLE3.NE.ANGLE4) THEN
               WRITE(*,*) 'Waveplate angles of slots ',SL3,' and ',
     &              SL4,' do not match.'
               GOTO 999
            END IF

            CALL HGETD('RJD', JD2, SL3, MXSPEC, NMDOUB,
     &           HDDOUB, NDOUB, MXDOUB, STATUS)
*
*     check that waveplate angle differ by about 90 degrees and
*     that times are sufficiently close
*
            IF(ABS(ANGLE1-ANGLE3).GT.80. .AND. 
     &           ABS(ANGLE1-ANGLE3).LT.100. .AND. 
     &           ABS(JD2-JD1).LT.DELTA) THEN
               NOPAIR = .FALSE.
               NORMAL = ANGLE1 .LT. ANGLE2
            END IF

         END DO

         IF(NOPAIR) GOTO 999 
*
*     always have the '-45' angle first
*
         IF(.NOT.NORMAL) THEN
            ISWAP = SL1
            SL1   = SL3
            SL3   = ISWAP
            ISWAP = SL2
            SL2   = SL4
            SL4   = ISWAP
         END IF
*     
*     Slot number of output
*
          SL5  = SLOT5 + NOUT
          NOUT = NOUT + 3
          WRITE(*,*) 'Combining spectra ',SL1,' and ',SL2,
     &         ', waveplate angle = ',ANGLE1,' with spectra ',
     &         SL3,' and ',SL4,' angle = ',ANGLE3
*
*     Set headers of output to headers of first spectrum, but alter
*     times to be the mean of the two times. Remove UTC & Date because
*     they may now be wrong
*
          CALL SET_HEAD(SL5, SL1, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &         NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &         HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &         MXDOUB, MXINTR, MXREAL, IFAIL)
          CALL HSETD('RJD', (JD1+JD2)/2., SL5, MXSPEC, NMDOUB,
     &         HDDOUB, NDOUB, MXDOUB, STATUS)
          CALL HDELD('UTC', SL5, MXSPEC, NMDOUB, HDDOUB, NDOUB, 
     &         MXDOUB, IFAIL)
          CALL HDELD('Orbital phase', SL5, MXSPEC, NMDOUB, HDDOUB, 
     &         NDOUB, MXDOUB, IFAIL)
          CALL HDELI('Day', SL5, MXSPEC, NMINTR, HDINTR, 
     &         NINTR, MXINTR, IFAIL)
          CALL HDELI('Month', SL5, MXSPEC, NMINTR, HDINTR, 
     &         NINTR, MXINTR, IFAIL)
          CALL HDELI('Year', SL5, MXSPEC, NMINTR, HDINTR, 
     &         NINTR, MXINTR, IFAIL)
          CALL HSETC('Stokes', 'I', SL5, MXSPEC, NMCHAR, HDCHAR, 
     &         NCHAR, MXCHAR, IFAIL)
          CALL SET_HEAD(SL5+1, SL1, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &         NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &         HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &         MXDOUB, MXINTR, MXREAL, IFAIL)
          CALL HSETD('RJD', (JD1+JD2)/2., SL5+1, MXSPEC, NMDOUB,
     &         HDDOUB, NDOUB, MXDOUB, STATUS)
          CALL HSETC('Stokes', 'V', SL5+1, MXSPEC, NMCHAR, HDCHAR, 
     &         NCHAR, MXCHAR, IFAIL)
          CALL SET_HEAD(SL5+2, SL1, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &         NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &         HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &         MXDOUB, MXINTR, MXREAL, IFAIL)
          CALL HSETD('RJD', (JD1+JD2)/2., SL5+2, MXSPEC, NMDOUB,
     &         HDDOUB, NDOUB, MXDOUB, STATUS)
          CALL HSETC('Stokes', '%V', SL5+2, MXSPEC, NMCHAR, HDCHAR, 
     &         NCHAR, MXCHAR, IFAIL)
*
*     Finally carry out the computations
*     
          NVALID = 0
          DO L = 1, NPIX(SL1)
             IF(ERRORS(L,SL1).GT.0. .AND. ERRORS(L,SL2).GT.0 .AND.
     &            ERRORS(L,SL3).GT.0. .AND. ERRORS(L,SL4).GT.0 .AND.
     &            COUNTS(L,SL1).GT.0. .AND. COUNTS(L,SL2).GT.0 .AND.
     &            COUNTS(L,SL3).GT.0. .AND. COUNTS(L,SL4).GT.0) THEN

                RAT1 = CFRAT(COUNTS(L,SL1),   FLUX(L,SL1))
                FLX1 = GET_FLX(COUNTS(L,SL1), FLUX(L,SL1))
                ERR1 = GET_ERF(COUNTS(L,SL1), ERRORS(L,SL1), 
     &               FLUX(L,SL1))
                FLX2 = GET_FLX(COUNTS(L,SL2), FLUX(L,SL2))
                ERR2 = GET_ERF(COUNTS(L,SL2), ERRORS(L,SL2),
     &               FLUX(L,SL2))
                FLX3 = GET_FLX(COUNTS(L,SL3), FLUX(L,SL3))
                ERR3 = GET_ERF(COUNTS(L,SL3), ERRORS(L,SL3),
     &               FLUX(L,SL3))
                FLX4 = GET_FLX(COUNTS(L,SL4), FLUX(L,SL4))
                ERR4 = GET_ERF(COUNTS(L,SL4), ERRORS(L,SL4),
     &               FLUX(L,SL4))
*     
                STOKESI  = FLX1+FLX2+FLX3+FLX4
                ESTOKESI = SQRT(ERR1**2+ERR2**2+ERR3**2+ERR4**2)

                COUNTS(L,SL5)   = RAT1*STOKESI
                ERRORS(L,SL5)   = SET_ERF(COUNTS(L,SL5), STOKESI, 
     &               ESTOKESI, RAT1)
                FLUX(L,SL5)     = SET_FLX(COUNTS(L,SL5), STOKESI, 
     &               RAT1)

                RATIO    = SQRT((FLX1/FLX2)/(FLX3/FLX4))
                X        = (RATIO-1.)/(RATIO+1.)
                FAC      = STOKESI*RATIO/(RATIO+1.)**2

                STOKESV  = STOKESI*X
                ESTOKESV = SQRT(
     &               ((X+FAC/FLX1)*ERR1)**2 +
     &               ((X+FAC/FLX2)*ERR2)**2 +
     &               ((X+FAC/FLX3)*ERR3)**2 +
     &               ((X+FAC/FLX4)*ERR4)**2)

                COUNTS(L,SL5+1) = RAT1*STOKESV
                ERRORS(L,SL5+1) = SET_ERF(COUNTS(L,SL5+1), STOKESV, 
     &               ESTOKESV, RAT1)
                FLUX(L,SL5+1)   = SET_FLX(COUNTS(L,SL5+1), STOKESV, 
     &               RAT1)

                PERCENT  = 100*X
                EPERCENT = 100*RATIO/(RATIO+1)**2*SQRT(
     &               (ERR1/FLX1)**2 +
     &               (ERR2/FLX2)**2 +
     &               (ERR3/FLX3)**2 +
     &               (ERR4/FLX4)**2)

                COUNTS(L,SL5+2) = RAT1*PERCENT
                ERRORS(L,SL5+2) = SET_ERF(COUNTS(L,SL5+2), PERCENT, 
     &               EPERCENT, RAT1)
                FLUX(L,SL5+2)   = SET_FLX(COUNTS(L,SL5+2), PERCENT, 
     &               RAT1)

                NVALID = NVALID + 1
             ELSE
                ERRORS(L,SL5)   = -1.
                ERRORS(L,SL5+1) = -1.
                ERRORS(L,SL5+2) = -1.
             END IF
*     
          END DO  
*     
*     Report results
*     
          IF(NVALID.EQ.0) THEN
             WRITE(*,*) 'There were no valid output pixels.'
             WRITE(*,*) 'Spectra not created.'
             NPIX(SL5)   = 0
             NPIX(SL5+1) = 0
             NOUT = NOUT - 2
          ELSE IF(.NOT.MUTE) THEN
             WRITE(*,*) 'Created Stokes I, V  and %V in slots ',SL5,
     &            ', ',SL5+1,' and ',SL5+2

             CALL SL_INF(SL5, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &            NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &            NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &            MXINTR, MXREAL, STRING, IFAIL)        
             WRITE(*,*) STRING
             CALL SL_INF(SL5+1, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &            NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &            NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &            MXINTR, MXREAL, STRING, IFAIL)      
             WRITE(*,*) STRING
             CALL SL_INF(SL5+2, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &            NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &            NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &            MXINTR, MXREAL, STRING, IFAIL) 
             WRITE(*,*) STRING
             
          END IF
      END DO
      WRITE(*,*) 'Finished'
 999  RETURN
      END
