      SUBROUTINE CALENDAR( JD, MONTH, DAY, YEAR, HOUR )
C
C     Find calendar date and time from Julian date.
C     
C     Input:
C     R*8 JD                  = JULIAN DATE
C
C     Output:
C     I   MONTH,DAY,YEAR      =  Calendar date
C     R*8 HOUR                =  Time (hours)
C
C Old version not very good, so have replced with
C slalib routine
C
      IMPLICIT NONE
      DOUBLE PRECISION JD, HOUR
      INTEGER DAY, MONTH, YEAR, STATUS
      CALL SLA_DJCL(JD-2400000.5, YEAR, MONTH, DAY, HOUR, STATUS)
      IF(STATUS.EQ.-1) 
     &     WRITE(*,*) 'CALENDAR: encountered unacceptable date, JD = ',
     &     JD
      HOUR = 24.*HOUR
      RETURN
      END

      SUBROUTINE DATCHEK(YEAR,MONTH,DAY,NY1,NY2,IERR)
*
* SUBROUTINE TO REQUEST A DATE
* STORES PREVIOUS VALUES
* YEAR,MONTH,DAY  RETURNED DATE
* NY1,NY2   LIMITS FOR YEARS ALLOWED INCLUSIVE
* IERR 0 IF ALL OK, 1 OTHERWISE
* NY2 > NY1 > 0
* ANY MISTAKE IS MADE, OLD VALUES WILL BE KEPT
*
      CHARACTER*80 STRING
      INTEGER*4 YEAR,MONTH,DAY,NY1,NY2,IERR,LENG(12)
      INTEGER*4 YR,MH,DY
      DATA LENG/31,28,31,30,31,30,31,31,30,31,30,31/
C
      LENG(2)=28
      IERR=0
      IF(NY1.LE.0 .OR. NY2.LT.NY1) THEN
        IERR=1
        WRITE(*,*) CHAR(7),'** YEAR range invalid **'
        RETURN
      END IF
      GOTO 10
5     WRITE(*,*) CHAR(7),'** Error in date **'
      LENG(2)=28
10    WRITE(*,'(A,$)') 'Input date (YEAR,MONTH,DAY): '
      IF(YR.NE.0) WRITE(*,*) '<CR> for old values ',YR,MH,DY
      READ(*,'(A)') STRING
      IF(YR.NE.0 .AND. STRING.EQ.' ') THEN
        NYEAR = YR
        NMONTH= MH
        NDAY  = DY
      ELSE
        READ(STRING,*,ERR=10) NYEAR,NMONTH,NDAY
      END IF
      IF(NYEAR.LT.NY1 .OR. NYEAR.GT.NY2) THEN
        IERR=1
        WRITE(*,*) CHAR(7),'** Year out of range **'
        RETURN
      END IF
      IF((NYEAR.EQ.0 .AND. YR.EQ.0) .OR.
     $      (NMONTH.LT.0 .OR. NMONTH.GT.12) .OR.
     $      (NMONTH.EQ.0 .AND. MH.EQ.0) .OR.
     $      (NDAY.EQ.0 .AND. DY.EQ.0) .OR.
     $      (NDAY.LT.0)) GOTO 5
C
      NYDUM=NYEAR
      IF(NYEAR.EQ.0) NYDUM=YR
      IF(NYDUM-4*(NYDUM/4).EQ.0) LENG(2)=29
      NMDUM=NMONTH
      IF(NMONTH.EQ.0) NMDUM=MH
      NDDUM=NDAY
      IF(NDAY.EQ.0) NDDUM=DY
      IF(NDDUM.GT. LENG(NMDUM)) GOTO 5
      YR=NYDUM
      MH=NMDUM
      DY=NDDUM
      YEAR=YR
      MONTH=MH
      DAY=DY
      RETURN
      END

      SUBROUTINE DAYADD(YEAR,MONTH,DAY,NUM,IYEAR,IMONTH,IDAY)
C
C YEAR,MONTH,DAY DATE INPUT
C NUM  NUMBER OF DAYS TO BE ADDED
C
C IYEAR,IMONTH,IDAY  RESULTING DATE
C
      INTEGER*4 YEAR,MONTH,DAY,LENG(12)
      DATA LENG/31,28,31,30,31,30,31,31,30,31,30,31/
C
      IMONTH = MONTH
      IYEAR  = YEAR
      IDAY   = DAY + NUM
10    CONTINUE
      IF(IYEAR-4*(IYEAR/4).EQ.0) THEN
        LENG(2)=29
      ELSE
        LENG(2)=28
      END IF
      IF(IDAY.GT.LENG(IMONTH)) THEN
        IDAY  = IDAY - LENG(IMONTH)
        IMONTH= IMONTH + 1
        IF(IMONTH.GT.12) THEN
          IYEAR  = IYEAR + 1
          IMONTH = 1
        END IF
        GOTO 10
      END IF
      IF(IDAY.LT.1) THEN
        IF(IMONTH.EQ.1) THEN
          IMONTH = 12
          IYEAR  = IYEAR - 1
        ELSE
          IMONTH = IMONTH - 1
        END IF
        IDAY = IDAY + LENG(IMONTH)
        GOTO 10
      END IF
      RETURN
      END


      SUBROUTINE TOHMS(TIME,HOUR,MIN,SEC,MSEC)
C
C CONVERTS TIME IN HOURS TO HOURS MINUTES SECONDS MILLISEC
C TIME REAL*8 ACCURATE TO NEAREST MILLISECOND
C
      REAL*8 TIME,WORK
      INTEGER*4 HOUR,MIN,SEC,MSEC
C
      WORK=TIME
      HOUR=INT(WORK)
      WORK=6.D1*(WORK-DBLE(HOUR))
      MIN=INT(WORK)
      WORK=6.D1*(WORK-DBLE(MIN))
      SEC=INT(WORK)
      WORK=1.D3*(WORK-DBLE(SEC))
      MSEC=NINT(WORK)
      RETURN
      END
C
C
      SUBROUTINE FRHMS(TIME,HOUR,MIN,SEC,MSEC)
C
C CONVERTS FROM HOUR,MIN,SEC,MSEC TO TIME IN HOURS
C TIME REAL*8
C
      REAL*8 TIME
      INTEGER*4 HOUR,MIN,SEC,MSEC
C
      TIME=DBLE(HOUR)+(DBLE(MIN)+DBLE(SEC)/6.D1+DBLE(MSEC)/6.D4)/6.D1
      RETURN
      END

      INTEGER FUNCTION JDATE(M,D,Y)
*
*  Computes Julian date at 12 hrs UT
*
      IMPLICIT NONE
      INTEGER M,D,Y,JJ
*
      IF(Y.LT.1801.OR.Y.GT.2099) THEN
        WRITE(*,*) 'Year out of range for JDATE'
        JDATE = 0
        RETURN
      END IF
      IF(M.LT.1.OR.M.GT.12) THEN
        WRITE(*,*) 'Month out of range for JDATE'
        JDATE = 0
        RETURN
      END IF
      IF(D.LT.1.OR.D.GT.31) THEN
        WRITE(*,*) 'Day out of range for JDATE'
        JDATE = 0
        RETURN
      END IF
      JJ=367*Y-(7*(Y+(M+9)/12))/4+(275*M)/9+D+1721014
      IF(100*Y+M.LT.190002.5) JJ=JJ+1
      JDATE=JJ
      RETURN
      END
      SUBROUTINE JDTOJED( EPOCH )
*
* converts julian date from coordinated universal time to ephemeris time
*
* Input:
*       EPOCH   = (REAL*8) Julian date in coordinated universal time
* Output:
*       EPOCH   = (REAL*8) Corresponding Julian ephemeris date
*
* 86 Aug KDH @ STScI -- dummy version
*
      DOUBLE PRECISION EPOCH, DEPARTURE
      LOGICAL FIRSTCALL
      DATA FIRSTCALL/.TRUE./
*
      IF( FIRSTCALL ) THEN
1       WRITE(*,*) 'Enter difference between UTC'//
     &  ' and ET (e.g. 54.2s in 1985)'
        READ(*,*,ERR=1) DEPARTURE
        DEPARTURE = DEPARTURE / 24.D0 / 3600.D0
        FIRSTCALL = .FALSE.
      END IF
      EPOCH = EPOCH + DEPARTURE

      RETURN
      END

      SUBROUTINE NDAY(DAY,MONTH,YEAR,ND,ND1)
C
C CALCULATES NUMBER OF DAYS SINCE BEGINNING OF YEAR (ND),JAN 1st
C COUNTS AS 1,AND THE NUMBER SINCE 1900 (ND1)
C
      INTEGER*4 DAY,MONTH,YEAR,NUM(12),ND,ND1
      DATA NUM/0,31,59,90,120,151,181,212,243,273,304,334/
*
      ND=NUM(MONTH)
      IF(MOD(YEAR,400).NE.0 .AND. MOD(YEAR,4).EQ.0 .AND.
     &MONTH.GT.2) ND=ND+1
      ND  = ND+DAY
      MID = YEAR-1900
      MID1= 365*MID
      MID = MID1+(MID+3)/4
      ND1 = MID +ND
      RETURN
      END

        SUBROUTINE SETDATE(STRING,IFAIL)
C
C     Sets current date in the form 10-OCT-1986
C     Assumes 20th century
C     IFAIL = 1 if string is too short
C
        CHARACTER*(*) STRING
        CHARACTER*8  DATE
        CHARACTER*10 TIME
        CHARACTER*5  ZONE
        INTEGER VALUES(8), IM
        CHARACTER*3 MONTH(12)
        DATA MONTH/'JAN','FEB','MAR','APR','MAY','JUN','JUL',
     &  'AUG','SEP','OCT','NOV','DEC'/
*
*
        IFAIL = 0
        LENGTH = LEN(STRING)
        IF(LENGTH.LT.11) THEN
          IFAIL = 1
          RETURN
        END IF
        CALL DATE_AND_TIME(DATE,TIME,ZONE,VALUES)
        STRING(1:2) = DATE(7:8)
        STRING(3:3) = '-'
        READ(DATE(5:6),'(I2)') IM
        STRING(4:6) = MONTH(IM)
        STRING(7:7) = '-'
        STRING(8:11) = DATE(1:4)
        RETURN
        END

      SUBROUTINE SIDER(YEAR,MONTH,DAY,TIME,STIME)
C
C GIVEN YEAR,MONTH,DAY AND GMT (TIME)
C WILL PRODUCE GST (STIME)
C TAKEN FROM DUFFETT-SMITH
C
      INTEGER IYRANG
      PARAMETER (IYRANG=26)
      INTEGER YEAR,MONTH,DAY,KEYF(IYRANG)
      DOUBLE PRECISION BFAC(IYRANG),A,B,C,D,WORK
C
      DATA BFAC/3.97221D-1,4.13525D-1,3.63611D-1,3.79644D-1,
     &          3.95558D-1,4.11473D-1,3.61678D-1,3.77592D-1,
     &          3.93506D-1,4.09421D-1,3.59625D-1,3.75540D-1,
     &          3.91454D-1,4.07368D-1,3.57573D-1,3.73487D-1,
     &          3.89402D-1,4.05316D-1,3.55521D-1,3.71435D-1,
     &          3.87349D-1,4.03264D-1,3.53468D-1,3.69383D-1,
     &          3.85297D-1,4.01211D-1/
      DATA KEYF/75,76,77,78,79,80,81,82,83,84,85,86,87,88,
     &89,90,91,92,93,94,95,96,97,98,99,100/
      DATA A,C,D/6.5709D-2,1.002743D0,9.97257D-1/
C
C
      CALL NDAY(DAY,MONTH,YEAR,NJAN,NNN)
      ISUB=YEAR
      IF(ISUB.GT.1900) ISUB=ISUB-1900
      IPOS=0
      DO I=1,IYRANG
        IF(KEYF(I).EQ.ISUB) THEN
          IPOS=I
          GOTO 10
        END IF
      END DO
      PRINT *,'YEAR OUT OF RANGE OF ACCURATE VALUES.'
      PRINT *,'B VALUE USED = 17.35'
      B=3.5D-1
10    IF(IPOS.NE.0) B=BFAC(IPOS)
      B=1.7D1+B
      WORK=DBLE(NJAN)*A-B
      WORK=WORK+C*TIME
      IF(WORK.GE.2.4D1) WORK=WORK-2.4D1
      IF(WORK.LT.0.D0) WORK=WORK+2.4D1
      STIME=REAL(WORK)
      RETURN
C
C ENTRY FOR GST TO GMT CONVERSION
C
      ENTRY GMT(YEAR,MONTH,DAY,TIME,STIME)
C
C GIVE STIME, RETURNS TIME
C
      CALL NDAY(DAY,MONTH,YEAR,NJAN,NNN)
      ISUB=YEAR
      IF(ISUB.GT.1900) ISUB=ISUB-1900
      IPOS=0
      DO I=1,IYRANG
        IF(KEYF(I).EQ.ISUB) THEN
          IPOS=I
          GOTO 20
        END IF
      END DO
      PRINT *,'YEAR OUT OF RANGE OF ACCURATE VALUES.'
      PRINT *,'B VALUE USED = 17.35'
      B=3.5D-1
20    IF(IPOS.NE.0) B=BFAC(IPOS)
      B=1.7D1+B
      WORK=DBLE(NJAN)*A-B
      IF(WORK.LT.0.D0) WORK=WORK+2.4D1
      WORK=STIME-WORK
      IF(WORK.LT.0.D0) WORK=WORK+2.4D1
      TIME=REAL(D*WORK)
      END

      SUBROUTINE STRMON(MONTH,NAME)
C
C RETURNS NAME OF MONTH GIVEN NUMBER. FIRST THREE LETTERS
C NAME CHARACTER*3
C
      CHARACTER*3 TRIV(12),NAME
      DATA TRIV/'JAN','FEB','MAR','APR','MAY','JUN','JUL'
     $,'AUG','SEP','OCT','NOV','DEC'/
C
      NAME=TRIV(MONTH)
      RETURN
      END                                           

      DOUBLE PRECISION FUNCTION TIMADD(H,M,S,MS)
*
* Combines time in hours,minutes,seconds and millsecs
* into a REAL*8 number of hours
*
      IMPLICIT NONE
      INTEGER H,M,S,MS
*
      TIMADD = H + (M + (S + 1.D-3*DBLE(MS))/6.D1)/6.D1
      RETURN
      END
      SUBROUTINE DATEQ(IYR,IMO,IDY)
C
C  RETURNS THE VALID CALENDAR DATE
C  OBTAINED FROM THE USER ON THE FIRST CALL.
C
      INTEGER*4 MAXDAY(12)
      DATA ICALL/0/
      DATA MAXDAY/31,28,31,30,31,30,31,31,30,31,30,31/
      ICALL=ICALL+1
C
      IF(ICALL.LE.1) THEN
   10 PRINT 1000
 1000 FORMAT(' UT DATE (Y M D) ',$)
      READ(5,*,ERR=10) KYR,KMO,KDY
C
      IF(KYR.LT.1900) KYR=KYR+1900
C
      IF(KMO.LT.1.OR.KMO.GT.12) THEN
   16 PRINT *,'INVALID REPLY'
      GOTO 10
      END IF
C
      MXDY=MAXDAY(KMO)
      IF(KMO.EQ.2) THEN
      IF(MOD(KYR,  4).EQ.0) MXDY=29
      IF(MOD(KYR,100).EQ.0) MXDY=28
      IF(MOD(KYR,400).EQ.0) MXDY=29
      END IF
      IF(KDY.LT.1.OR.KDY.GT.MXDY) GOTO 16
C
      END IF
C
      IYR=KYR
      IMO=KMO
      IDY=KDY
      RETURN
      END


      SUBROUTINE TSPLIT(T,IH,IM,IS,MS)
C
C  SPLITS THE TIME INTO HOURS,MINUTES,SECONDS AND MILLISECONDS.
C
      DOUBLE PRECISION T,TT
*
      TT=DABS(T)
      IH=INT(TT)
      TT=(TT-IH)*60.
      IM=INT(TT)
      TT=(TT-IM)*60.
      IS=INT(TT)
      MS=INT((TT-IS)*1000.)
C
      IF(T.LT.0.D0) THEN
      IH=-IH
      IM=-IM
      IS=-IS
      MS=-MS
      END IF
C
      RETURN
      END

