*BACK
* BACK N1 N2 PHASE WCEN GAMMA KXLO KXHI NKX KYLO KYHI NKY C1 C2 -- Back 
*                        projects spectra
*
* This computes integrals over sinusoidal paths through the data and plots
* the results as an image in which the intensity at each point is the value 
* of the integral. The integral is carried out NKX*NKY times so it is best
* to start with low values to get an idea of the result. In order to get
* a filtered back-projection you should run BCKFIL first.
*
* Parameters:
*            N1   -- First spectrum
*            N2   -- Last spectrum
*            PHASE-- Name of phase to use
*            WCEN -- Rest wavelength
*            GAMMA-- Systemic velocity
*            KXLO -- Lowest Kx value
*            KXHI -- Highest Kx value
*            NKX  -- Number of Kx values
*            KYLO -- Lowest Ky value
*            KYHI -- Highest Ky value
*            NKY  -- Number of Ky values
*            C1   -- Plot level for lowest colour index
*            C2   -- Plot level for highest colour index
*
*            Set C1=C2 for auto-scaling from lowest to highest
*            values. If C1=C2=0. they will be set to the 
*            autoscaled values on leaving the routine.
*            Otherwise they will be left alone.
*
*
* If you choose NKX and NKY to be large, there may only be enough memory
* to plot the image in sections, in which case the autoscaling option
* only scales on the first chunk to be plotted.
*
* Related commands: BCKFIL, BNDF
*
*BACK                                                                 
*BNDF
* BNDF N1 N2 PHASE WCEN GAMMA VPIX NSIDE FILE -- Back 
*                        projects spectra, dumps to a Doppler NDF file.
*
* This computes integrals over sinusoidal paths through the data and then
* dumps the results as an image in which the intensity at each point is 
* the value of the integral. The integral is carried out NSIDE**2 times 
* so it is best to start with low values to get an idea of the result.
* You should use 'back' first to see a direct plot. In order to get
* a filtered back-projection you should run BCKFIL first.
*
* This routine dumps to NDF files as used by the Doppler programs
* and so has to produce square images centred on zero velocity.
*
* Parameters:
*            N1   -- First spectrum
*            N2   -- Last spectrum
*            PHASE-- Name of phase to use
*            WCEN -- Rest wavelength
*            GAMMA-- Systemic velocity
*            VPIX -- Velocity km/s/pixel
*            NSIDE-- Number of pixels on a side
*            FWHM -- FWHM to set in file which will be picked up by
*                    doppler routines such as comdat. If set to 0.
*                    then a default of 2*VPIX will be used.
*            FILE -- NDF file to dump back-projection to.
*
* Related commands: BCKFIL, BACK
*
*BNDF                                      
      SUBROUTINE BCKPRO(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, NMDOUB, 
     &NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, SLOTS, MXSLOTS, 
     &DWORK1, DWORK2, DWORK3, NWHICH, MXWORK, METHOD, IFAIL)
*
* Cross-correlate spectra
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* =  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* =  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* =  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* >  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    I     SLOTS(MXSLOTS)     -- Workspace for list of slots
*    C     METHOD    -- 'P' plots, 'F' stores in a NDF file
* <  I     IFAIL            -- Error return.
*
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'DAT_PAR'
      INCLUDE 'PRM_PAR'
      INCLUDE 'CNF_PAR'
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX
      INTEGER MXCHAR, MXDOUB, MXREAL, MXINTR, MXARC
      INTEGER NPIX(MXSPEC), NARC(MXSPEC)
      LOGICAL NEW
      REAL WCEN
      CHARACTER*(*) METHOD
*     
*     Data arrays
*     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*     
*     Numbers of header items
*     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Work arrays
*
      INTEGER MXWORK
      DOUBLE PRECISION DWORK1(MXWORK), DWORK2(MXWORK)
      DOUBLE PRECISION DWORK3(MXWORK)
      INTEGER NWHICH(MXWORK)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      INTEGER I, J,  N, STATUS, NSIDE, ISO, IL, IS
      INTEGER ILO, IHI, IX, IY, NGRP, NROW, NCOL
      INTEGER SLOT1, SLOT2, IFAIL, NSPEC, MAXSPEC
      INTEGER NKX, NKY, IND, MXWK, DOPP, PLACE, XPTR
      INTEGER YPTR, LBND(2), UBND(2), DPTR, EL
      REAL GET_FLX, V, VLIGHT, ADD, VPIX, FWHM
      REAL KXLO, KXHI, KX, KYLO, KYHI, KY, GAMMA, C1, C2
      REAL XR1, XR2, YR1, YR2, TR(6), LOW, HIGH, TC1, TC2
      DOUBLE PRECISION  PIXL, SUM, PHI, TWOPI, WAVE, P
      LOGICAL  DEFAULT
      CHARACTER*64 FILE
      CHARACTER*16 PHASE
      CHARACTER*(DAT__SZLOC) LOC
C
C     Functions
C
      REAL CGS
*
      DATA GAMMA, WCEN/0.,5000./
      DATA SLOT1, SLOT2/1,2/
      DATA PHASE/'Orbital phase'/
      DATA KXLO, KXHI, NKX/-500.,500.,100/
      DATA KYLO, KYHI, NKY/-500.,500.,100/
      DATA VPIX, NSIDE, FWHM/50., 100, 0./
      DATA C1, C2/0., 0./
      DATA FILE/'backpro'/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM    = 0
      IFAIL   = 0
*
      CALL INTR_IN('First slot to back-project', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to back-project', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        WRITE(*,*) 'Enter list of spectra to back-project'
        CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &  NSLOTS, MXSLOTS)
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      CALL CHAR_IN('Which phase?', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &DEFAULT, PHASE, IFAIL)
      N = 0
      TWOPI = 8.D0*ATAN(1.D0)
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).GT.0 .AND. NARC(SLOT).NE.0) THEN
          N = N + 1
          IF(N.GT.MXWORK) THEN
            WRITE(*,*) 'Too many spectra for work arrays'
            GOTO 999
          END IF
          NWHICH(N) = SLOT
*
* Search for double precision header items Vearth and phase
*
          CALL HGETD('Vearth', DWORK1(N), SLOT, MXSPEC, NMDOUB, 
     &    HDDOUB, NDOUB, MXDOUB, IFAIL)
          CALL HGETD(PHASE, PHI, SLOT, MXSPEC, NMDOUB, 
     &    HDDOUB, NDOUB, MXDOUB, IFAIL)
          IF(IFAIL.EQ.1) THEN
            WRITE(*,*) 'No ',PHASE,' found in slot ',SLOT
            GOTO 999
          ELSE IF(IFAIL.EQ.2) THEN
            WRITE(*,*) 'More than one match to ',PHASE,
     &      ' found in slot ',SLOT
            GOTO 999
          END IF
          DWORK2(N) = COS(TWOPI*PHI)
          DWORK3(N) = SIN(TWOPI*PHI)
        END IF
      END DO
      NSPEC = N
*
      CALL REAL_IN('Rest wavelength (A)', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, WCEN, 1.E2, 1.E5, IFAIL)
      CALL REAL_IN('Systemic velocity (km/s)', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, GAMMA, -1.E5, 1.E5, IFAIL)
      IF(METHOD.EQ.'P') THEN
        CALL REAL_IN('Lower Kx limit (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, KXLO, -1.E5, 1.E5, IFAIL)
        KXHI = MAX(KXLO, KXHI)
        CALL REAL_IN('Upper Kx limit (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, KXHI, KXLO, 1.E5, IFAIL)
        CALL INTR_IN('Number of steps in Kx', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, NKX, 1, 10000, IFAIL)
        CALL REAL_IN('Lower Ky limit (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, KYLO, -1.E5, 1.E5, IFAIL)
        KYHI = MAX(KYLO, KYHI)
        CALL REAL_IN('Upper Ky limit (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, KYHI, KYLO, 1.E5, IFAIL)
        CALL INTR_IN('Number of steps in Ky', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, NKY, 1, 10000, IFAIL)
        CALL REAL_IN('Lowest colour index level', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, C1, -1.E30, 1.E30, IFAIL)
        CALL REAL_IN('Highest colour index level', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, C2, -1.E30, 1.E30, IFAIL)
        TR(2) = (KXHI-KXLO)/REAL(NKX-1)
        TR(1) = KXLO - TR(2)
        TR(3) = 0.
        TR(5) = 0.
        TR(6) = (KYHI-KYLO)/REAL(NKY-1)
      ELSE IF(METHOD.EQ.'F') THEN
        CALL REAL_IN('Velocity/pixel (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, VPIX, 1.E-2, 1.E4, IFAIL)
        CALL INTR_IN('Number of pixels on a side', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, NSIDE, 1, 10000, IFAIL)      
        CALL REAL_IN('FWHM to set in file (km/s, 0 for 2 pixels)', 
     &  SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FWHM, 0., 2.E4, IFAIL)
        CALL CHAR_IN('NDF file to store result', 
     &  SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      ELSE
         WRITE(*,*) 'Unrecognised method = ',METHOD
         GOTO 999
      END IF
      IF(IFAIL.NE.0) GOTO 999
*
* Now search for work space in data arrays.
*
      IF(METHOD.EQ.'P') THEN
        IS = 0
        MXWK = 0
        DO I = 1, MXSPEC
          IF(IS.EQ.0 .AND. NPIX(I).LE.0) THEN
            IS = I
          ELSE IF(NPIX(I).GT.0) THEN
            IL = I - 1
            IF(MAXPX*(IL-IS+1).GT.MXWK) THEN
              MXWK = MAXPX*(IL-IS+1)
              ISO  = IS
            END IF
            IS = 0
          END IF
        END DO
        IF(IS.EQ.0) THEN
          IL = MXBUFF - MXSPEC*MAXPX
          IF(IL.GT.MXWK) THEN
            MXWK = IL
            ISO  = MXSPEC+1
          END IF
        ELSE
          IL = MXBUFF-MAXPX*(IS-1)-1 
          IF(IL.GT.MXWK) THEN
            MXWK = IL
            ISO  = IS
          END IF
        END IF
        IF(MXWK.LT.NKX) THEN
          WRITE(*,*) 'Can''t find sufficient workspace'
          WRITE(*,*) 'You should clear some spectra'
          GOTO 999
        END IF
        NROW = MIN(MXWK/NKX, NKY)
        NCOL = NKX
        NGRP = NKY/NROW
        IF(NGRP*NROW.LT.NKY) NGRP = NGRP + 1
        WRITE(*,*) 'Map will be plotted in ',NGRP,' groups of ',
     &  NROW,' rows.'
C
C     Open plot device, close any already open.
C
        CALL DEV_OPEN(.FALSE.,NEW,IFAIL)
        IF(IFAIL.NE.0) RETURN
        XR1 = KXLO - TR(2)/2.
        XR2 = KXHI + TR(2)/2.
        YR1 = KYLO - TR(6)/2.
        YR2 = KYHI + TR(6)/2.
        CALL PGWNAD(XR1, XR2, YR1, YR2)
        CALL DEF_COL(IFAIL)
      ELSE IF(METHOD.EQ.'F') THEN
C
C     Open NDF file for writing
C     
        NROW = NSIDE
        NCOL = NSIDE
        NGRP = 1
        STATUS = SAI__OK
        CALL NDF_OPEN(DAT__ROOT,FILE,'WRITE','NEW',DOPP,PLACE,STATUS)
        LBND(1) = 1
        LBND(2) = 1
        UBND(1) = NSIDE
        UBND(2) = NSIDE
        CALL NDF_NEW('_REAL',2,LBND,UBND,PLACE,DOPP,STATUS)
C     
C     Create doppler map extension
C     
        CALL NDF_XNEW(DOPP,'DOPPLER_MAP','Ext',0,0,LOC,STATUS)
        CALL CMP_MOD(LOC, 'VPIX',  '_REAL', 0, 0, STATUS)
        CALL CMP_MOD(LOC, 'FWHM' , '_REAL', 0, 0, STATUS)
        CALL CMP_MOD(LOC, 'GAMMA', '_REAL', 0, 0, STATUS)
        CALL CMP_MOD(LOC, 'WAVE',  '_REAL', 1, 1, STATUS)
        CALL CMP_MOD(LOC, 'NSUB',  '_INTEGER', 0, 0, STATUS)
        CALL CMP_MOD(LOC, 'OFFSET', '_REAL', 0, 0, STATUS)
        CALL CMP_MOD(LOC, 'NDIV', '_INTEGER', 0, 0, STATUS)
        CALL CMP_MOD(LOC, 'USE', '_CHAR*16', 0, 0, STATUS)
C     
C     Set values
C     
        CALL CMP_PUT0R(LOC,'VPIX',VPIX,STATUS)
        IF(FWHM.GT.0.) THEN
           CALL CMP_PUT0R(LOC,'FWHM',FWHM,STATUS)
        ELSE
           CALL CMP_PUT0R(LOC,'FWHM',2.*VPIX,STATUS)
        END IF
        CALL CMP_PUT0R(LOC,'GAMMA',GAMMA,STATUS)
        CALL CMP_PUT0I(LOC,'NSUB',1,STATUS)
        CALL CMP_PUT0R(LOC,'OFFSET',0.,STATUS)
        CALL CMP_PUT0I(LOC,'NDIV',5,STATUS)
        CALL CMP_PUT0C(LOC,'USE','Phases',STATUS)
        CALL CMP_PUT1R(LOC,'WAVE',1,WCEN,STATUS)
        CALL DAT_ANNUL(LOC, STATUS)
C     
C Map data and axis arrays. Set axis labels and units
C
        CALL NDF_MAP(DOPP,'Data','_REAL','WRITE',DPTR,EL,STATUS)
        CALL NDF_AMAP(DOPP,'Centre',1,'_REAL','WRITE',XPTR,EL,STATUS)
        CALL NDF_AMAP(DOPP,'Centre',2,'_REAL','WRITE',YPTR,EL,STATUS)
        CALL NDF_ACPUT('km/s',DOPP,'Units',1,STATUS)
        CALL NDF_ACPUT('km/s',DOPP,'Units',2,STATUS)
        CALL NDF_ACPUT('K\\dX\\u',DOPP,'Label',1,STATUS)
        CALL NDF_ACPUT('K\\dY\\u',DOPP,'Label',2,STATUS)
        CALL SET_AX(%VAL(CNF_PVAL(XPTR)), NSIDE, VPIX, STATUS)
        CALL SET_AX(%VAL(CNF_PVAL(YPTR)), NSIDE, VPIX, STATUS)
      END IF
C              
C Loop through spectra
C
      VLIGHT = CGS('C')/1.E5
      LOW  = 1.E30
      HIGH = -1.E30
      DO N = 1, NGRP
         IF(METHOD.EQ.'P') TR(4) = KYLO + REAL(NROW*(N-1)-1)*TR(6)
         DO IY = 1, NROW
            IF(METHOD.EQ.'P') THEN
               KY = TR(4) + TR(6)*REAL(IY)
            ELSE
               KY = VPIX*(REAL(IY)-REAL(1+NROW)/2.)
            END IF
            DO IX = 1, NCOL
               IF(METHOD.EQ.'P') THEN
                  KX = TR(1) + TR(2)*REAL(IX)
               ELSE
                  KX = VPIX*(REAL(IX)-REAL(1+NCOL)/2.)
               END IF
               SUM = 0.D0
               DO I = 1, NSPEC
                  SLOT = NWHICH(I)
                  V = REAL(GAMMA+DWORK1(I)-KX*DWORK2(I)+KY*DWORK3(I))
                  WAVE = WCEN*(1.+V/VLIGHT)
                  P = PIXL(WAVE,NPIX(SLOT),NARC(SLOT),ARC(1,SLOT),MXARC)
                  IF(P.LT.1.D0) THEN
                     ADD = GET_FLX(COUNTS(1,SLOT),FLUX(1,SLOT))
                  ELSE IF(P.GT.NPIX(SLOT)) THEN
                     ADD = GET_FLX(COUNTS(NPIX(SLOT),SLOT),
     &                    FLUX(NPIX(SLOT),SLOT))
                  ELSE
C
C     Linear interpolation
C
                     ILO = INT(P)
                     IHI = ILO + 1
                     ADD = REAL((REAL(IHI)-P)*GET_FLX(COUNTS(ILO,SLOT),
     &                    FLUX(ILO,SLOT))+(P-REAL(ILO))*
     &                    GET_FLX(COUNTS(IHI,SLOT),FLUX(IHI,SLOT)))
                  END IF
                  SUM = SUM + ADD
               END DO
C
               IF(METHOD.EQ.'P') THEN
C
C     Find correct bit of unused array to store result
C
                  IND = (IY-1)*NKX+IX
                  J = (IND-1)/MAXPX + ISO
                  I = IND - MAXPX*((IND-1)/MAXPX)
                  FLUX(I,J) = REAL(SUM)
                  LOW  = MIN(LOW, SNGL(SUM))
                  HIGH = MAX(HIGH, SNGL(SUM))
               ELSE IF(METHOD.EQ.'F') THEN
C
C     Store in NDF file
C
                  ADD = REAL(SUM)
                  CALL PUTAWY(%VAL(CNF_PVAL(DPTR)),
     :                        NSIDE,NSIDE,IX,IY,ADD,STATUS)
               END IF
            END DO
         END DO
         IF(METHOD.EQ.'P') THEN
            IF(N.EQ.1 .AND. C1.EQ.C2) THEN
               TC1 = LOW
               TC2 = HIGH
               IF(C1.EQ.0.) THEN
                  C1 = LOW
                  C2 = HIGH
               END IF
            ELSE
               TC1 = C1
               TC2 = C2
            END IF
C
C     Plot this bit
C
            CALL PGIMAG(FLUX(1,ISO),NKX,NROW,1,NKX,1,NROW,
     &           TC1,TC2,TR)
         END IF
      END DO
      IF(METHOD.EQ.'P') THEN
         CALL PGBOX('BCNST', 0., 0, 'BCNST', 0., 0)
         CALL PGLAB('K\\dX\\u (km s\\u-1\\d)',
     &        'K\\dY\\u (km s\\u-1\\d)', 'Back-projection')
         CALL DEV_CLOSE(0,IFAIL)
      ELSE IF(METHOD.EQ.'F') THEN
         CALL NDF_ANNUL(DOPP, STATUS)
      END IF
999   RETURN
      END
 
      SUBROUTINE SET_AX(DAT, N, VPIX, STATUS)
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER N, I, STATUS
      REAL DAT(N), VPIX
      IF(STATUS.NE.SAI__OK) RETURN
      DO I = 1, N
        DAT(I) = VPIX*(REAL(I)-REAL(N+1)/2.)
      END DO
      RETURN
      END

      SUBROUTINE PUTAWY(DAT, NX, NY, IX, IY, RESULT, STATUS)
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER NX, NY, IX, IY, STATUS
      REAL DAT(NX,NY), RESULT
      IF(STATUS.NE.SAI__OK) RETURN
      DAT(IX,IY) = RESULT
      RETURN
      END


