      SUBROUTINE SVDFIT(Y,E,NDATA,A,NC,VECT,W1,W2,W3,W4,
     &NP,NV,CHISQ)
*
* Routine to carry out general linear least-squares fit to
* data Y(NDATA) defined at NDATA points with 1-sig uncertainty
* E(NDATA).
* Functions defined by VECT(NP,NV)
* NP > NDATA, NV > NC
* Based on numerical recipes routine of same name
*
* R Y(NDATA)  -- Y data
* R E(NDATA)  -- 1-sig uncertainties
* I NDATA     -- Number of points
* D A(NC)     -- Coefficients
* R VECT(NP, NV) - Functions to fit strengths of
* D W1(NP, NV)  - Work
* D W2(NV, NV)  - Work
* D W3(NV, NV)  - Work
* D W4(NP)
* I NP          - NP > or equal NDATA
* I NV          - NV > or equal NC
* D CHISQ       - Chi**2
*
      IMPLICIT NONE
      INTEGER NDATA, NP, NV, I, J, NC
      REAL Y(NDATA), E(NDATA)
      REAL VECT(NP, NV)
      DOUBLE PRECISION SUM, W1(NP,NV),W2(NV,NV)
      DOUBLE PRECISION W3(NV), W4(NP), TOL, WMAX
      DOUBLE PRECISION THRESH, CHISQ, A(NC)
      PARAMETER (TOL=1.D-5)

*
      DO J = 1, NC
        DO I = 1, NDATA
          W1(I,J) = VECT(I,J)/E(I)
        END DO
      END DO
      DO I = 1, NDATA
        W4(I) = Y(I)/E(I)
      END DO
      CALL SVDCMP(W1, NDATA, NC, NP, NV, W3, W2)
      WMAX = 0.D0
      DO I = 1, NC
        IF(W3(I).GT.WMAX) WMAX = W3(I)
      END DO
      THRESH = TOL*WMAX
      DO I = 1, NC
        IF(W3(I).LT.THRESH) W3(I) = 0.D0
      END DO
      CALL SVBKSB(W1, W3, W2, NDATA, NC, NP, NV, W4, A)
      CHISQ = 0.D0
      DO I = 1, NDATA
        SUM = 0.D0
        DO J = 1, NC
          SUM = SUM + A(J)*VECT(I,J)
        END DO
        CHISQ = CHISQ + ((Y(I)-SUM)/E(I))**2
      END DO
      RETURN
      END

      SUBROUTINE SVDCMP(A,M,N,MP,NP,W,V)
*
* Num recipes routine for singular value decomposition
*
      IMPLICIT NONE
      INTEGER NMAX, M, N, MP, NP, I, L, J, K, ITS, NM
      PARAMETER (NMAX=500)
      DOUBLE PRECISION A(MP,NP),W(NP),V(NP,NP),RV1(NMAX)
      DOUBLE PRECISION G, SCALE, ANORM, S, F, C, Z, Y
      DOUBLE PRECISION X, H
*
      G=0.0
      SCALE=0.0
      ANORM=0.0
      DO I=1,N
        L=I+1
        RV1(I)=SCALE*G
        G=0.0
        S=0.0
        SCALE=0.0
        IF (I.LE.M) THEN
          DO K=I,M
            SCALE=SCALE+ABS(A(K,I))
          END DO
          IF (SCALE.NE.0.0) THEN
            DO K=I,M
              A(K,I)=A(K,I)/SCALE
              S=S+A(K,I)*A(K,I)
            END DO
            F=A(I,I)
            G=-SIGN(SQRT(S),F)
            H=F*G-S
            A(I,I)=F-G
            IF (I.NE.N) THEN
              DO J=L,N
                S=0.0
                DO K=I,M
                  S=S+A(K,I)*A(K,J)
                ENDDO
                F=S/H
                DO K=I,M
                  A(K,J)=A(K,J)+F*A(K,I)
                ENDDO
              ENDDO
            ENDIF
            DO K= I,M
              A(K,I)=SCALE*A(K,I)
            ENDDO
          ENDIF
        ENDIF
        W(I)=SCALE *G
        G=0.0
        S=0.0
        SCALE=0.0
        IF ((I.LE.M).AND.(I.NE.N)) THEN
          DO K=L,N
            SCALE=SCALE+ABS(A(I,K))
          ENDDO
          IF (SCALE.NE.0.0) THEN
            DO K=L,N
              A(I,K)=A(I,K)/SCALE
              S=S+A(I,K)*A(I,K)
            ENDDO
            F=A(I,L)
            G=-SIGN(SQRT(S),F)
            H=F*G-S
            A(I,L)=F-G
            DO K=L,N
              RV1(K)=A(I,K)/H
            ENDDO
            IF (I.NE.M) THEN
              DO J=L,M
                S=0.0
                DO K=L,N
                  S=S+A(J,K)*A(I,K)
                ENDDO
                DO K=L,N
                  A(J,K)=A(J,K)+S*RV1(K)
                ENDDO
              ENDDO
            ENDIF
            DO K=L,N
              A(I,K)=SCALE*A(I,K)
            ENDDO
          ENDIF
        ENDIF
        ANORM=MAX(ANORM,(ABS(W(I))+ABS(RV1(I))))
      ENDDO
      DO I=N,1,-1
        IF (I.LT.N) THEN
          IF (G.NE.0.0) THEN
            DO J=L,N
              V(J,I)=(A(I,J)/A(I,L))/G
            ENDDO
            DO J=L,N
              S=0.0
              DO K=L,N
                S=S+A(I,K)*V(K,J)
              ENDDO
              DO K=L,N
                V(K,J)=V(K,J)+S*V(K,I)
              ENDDO
            ENDDO
          ENDIF
          DO J=L,N
            V(I,J)=0.0
            V(J,I)=0.0
          ENDDO
        ENDIF
        V(I,I)=1.0
        G=RV1(I)
        L=I
      ENDDO
      DO I=N,1,-1
        L=I+1
        G=W(I)
        IF (I.LT.N) THEN
          DO J=L,N
            A(I,J)=0.0
          ENDDO
        ENDIF
        IF (G.NE.0.0) THEN
          G=1.0/G
          IF (I.NE.N) THEN
            DO J=L,N
              S=0.0
              DO K=L,M
                S=S+A(K,I)*A(K,J)
              ENDDO
              F=(S/A(I,I))*G
              DO K=I,M
                A(K,J)=A(K,J)+F*A(K,I)
              ENDDO
            ENDDO
          ENDIF
          DO J=I,M
            A(J,I)=A(J,I)*G
          ENDDO
        ELSE
          DO J= I,M
            A(J,I)=0.0
          ENDDO
        ENDIF
        A(I,I)=A(I,I)+1.0
      ENDDO
      DO K=N,1,-1
        DO ITS=1,30
          DO L=K,1,-1
            NM=L-1
            IF ((ABS(RV1(L))+ANORM).EQ.ANORM)  GO TO 2
            IF ((ABS(W(NM))+ANORM).EQ.ANORM)  GO TO 1
          ENDDO
1         C=0.0
          S=1.0
          DO I=L,K
            F=S*RV1(I)
            IF ((ABS(F)+ANORM).NE.ANORM) THEN
              G=W(I)
              H=SQRT(F*F+G*G)
              W(I)=H
              H=1.0/H
              C= (G*H)
              S=-(F*H)
              DO J=1,M
                Y=A(J,NM)
                Z=A(J,I)
                A(J,NM)=(Y*C)+(Z*S)
                A(J,I)=-(Y*S)+(Z*C)
              ENDDO
            ENDIF
          ENDDO
2         Z=W(K)
          IF (L.EQ.K) THEN
            IF (Z.LT.0.0) THEN
              W(K)=-Z
              DO J=1,N
                V(J,K)=-V(J,K)
              ENDDO
            ENDIF
            GO TO 3
          ENDIF
          IF (ITS.EQ.30) PAUSE 'No convergence in 30 iterations'
          X=W(L)
          NM=K-1
          Y=W(NM)
          G=RV1(NM)
          H=RV1(K)
          F=((Y-Z)*(Y+Z)+(G-H)*(G+H))/(2.0*H*Y)
          G=SQRT(F*F+1.0)
          F=((X-Z)*(X+Z)+H*((Y/(F+SIGN(G,F)))-H))/X
          C=1.0
          S=1.0
          DO J=L,NM
            I=J+1
            G=RV1(I)
            Y=W(I)
            H=S*G
            G=C*G
            Z=SQRT(F*F+H*H)
            RV1(J)=Z
            C=F/Z
            S=H/Z
            F= (X*C)+(G*S)
            G=-(X*S)+(G*C)
            H=Y*S
            Y=Y*C
            DO NM=1,N
              X=V(NM,J)
              Z=V(NM,I)
              V(NM,J)= (X*C)+(Z*S)
              V(NM,I)=-(X*S)+(Z*C)
            ENDDO
            Z=SQRT(F*F+H*H)
            W(J)=Z
            IF (Z.NE.0.0) THEN
              Z=1.0/Z
              C=F*Z
              S=H*Z
            ENDIF
            F= (C*G)+(S*Y)
            X=-(S*G)+(C*Y)
            DO NM=1,M
              Y=A(NM,J)
              Z=A(NM,I)
              A(NM,J)= (Y*C)+(Z*S)
              A(NM,I)=-(Y*S)+(Z*C)
            ENDDO
          ENDDO
          RV1(L)=0.0
          RV1(K)=F
          W(K)=X
        ENDDO
3       CONTINUE
      ENDDO
      RETURN
      END


      SUBROUTINE SVBKSB(U,W,V,M,N,MP,NP,B,X)
*
      IMPLICIT NONE
      INTEGER NMAX, M, N, MP, NP, I, J, JJ
      PARAMETER (NMAX=500)
      DOUBLE PRECISION U(MP,NP),W(NP),V(NP,NP),B(MP),X(NP),TMP(NMAX)
      DOUBLE PRECISION S
*
      DO J=1,N
        S=0.
        IF(W(J).NE.0.)THEN
          DO I=1,M
            S=S+U(I,J)*B(I)
          ENDDO
          S=S/W(J)
        ENDIF
        TMP(J)=S
      ENDDO
      DO J=1,N
        S=0.
        DO JJ=1,N
          S=S+V(J,JJ)*TMP(JJ)
        ENDDO
        X(J)=S
      ENDDO
      RETURN
      END
