      SUBROUTINE SIGFAKE( NPIX, DAT, SIGMA )
*
*  Uses pixel-to-pixel fluctuations in a spectrum
*  to estimate the corresponding error bar spectrum.
*  Assumes that the local variance is proportional to the data number,
*  as it would be for Poisson statistics, but that the constant of
*  proportionality varies slowly along the spectrum,
*  as it would for fluxes if the instrumental response is not uniform.
*
*  Inputs:
*      NPIX      = Number of pixels in the spectrum
*      DAT      = Spectrum data values
*  Outputs:
*      SIGMA      = Local standard deviation spectrum
*
*  Feb 1985 by Keith Horne at IOA
*  Oct 1986 KDH @ STScI - tried spline and poly options
*  Jul 1988 TRM fixed bias in uncertainty estimates, removed
*               unused options
*
      REAL DAT(NPIX), SIGMA(NPIX)
      DOUBLE PRECISION SUM
*
      IF( NPIX.LE.10 ) THEN
        WRITE(*,*) '** TOO FEW PIXELS FOR ERROR BAR ESTIMATION', NPIX
        RETURN
      END IF
*
*  Determine the largest and smallest data number in the spectrum.
*  And the mean fluctuation
*
      DATAMAX = DAT(1)
      DATAMIN = DAT(1)
      DO I=1,NPIX
        DATAMAX = MAX( DATAMAX, DAT(I) )
        DATAMIN = MIN( DATAMIN, DAT(I) )
        SIGMA(I) = 0.
      END DO
*
      IF( DATAMAX .LE. DATAMIN ) THEN
        WRITE(*,*) 'WARNING: DATA HAVE NO FLUCTUATIONS.',DATAMAX,DATAMIN
        RETURN
      END IF
*
*  Estimate the effective DATA NUMBER PER PHOTON from
*  the ratio of the local fluctuation to the square root of
*  the local mean data value.
*  Use a 3-point formula for the local fluctuation amplitude.
*  Augment the local data value by a bit to ensure that it is positive.
*
      EXTRA = MAX(0., -2.*DATAMIN )
      IF(EXTRA.LE.0.) EXTRA = DATAMAX/10.
      IF(EXTRA.GT.0.) THEN
        WRITE(*,*) 'Spectrum data range:', DATAMIN, DATAMAX
        WRITE(*,*) 'Constant added to make data positive:', EXTRA
      END IF
      SUM = 0.
*
* Constant to produce unbiased estimate of the
* standard deviation. (Specifically for median
* filtered case).
*
      ALPHA = 1./(SQRT(1.5)*0.6745)
      DO I=1,NPIX
        IM = MAX(I-1,1)
        IP = MIN(I+1,NPIX)
        FLUCT = ABS( DAT(I) - 0.5*( DAT(IM)+DAT(IP) ) )
        SIGMA(I) = ALPHA*FLUCT/SQRT( DAT(I) + EXTRA )
        SUM = SUM + SIGMA(I)
      END DO
      WRITE(*,*) 'Mean photons per data number:', NPIX/SUM
      MAXWINDOW = 301
      WRITE(*,*) 'Median filtering', NPIX, ' points.'
      CALL MEDFILT( SIGMA, SIGMA, NPIX, MAXWINDOW, IFAIL )
*
*  Loop thru pixels, evaluating error bars
*
      DO I=1,NPIX
        ROOT = SIGMA(I)
        SIGMA(I) = ROOT * SQRT( DAT(I) + EXTRA + ROOT*ROOT )
      END DO
*
      RETURN
      END
