
      REAL FUNCTION SCARGLE(TIME, DATA, WEIGHT, N, FREQ)
*
* Computes Scargle (1982) periodogram function for N data
* points at times TIME, value DATA
* TIME and 1/FREQ should have same units.
* It is advantageous in terms of speed to use this routine on the same
* period to avoid recomputing the sines and cosines
*
* R*8 TIME(N) -- Times of points
* R*4 DATA(N) -- Values of points
* R*4 WEIGHT(N) -- Weights for each point
* I*4 N - Number of points
* R*4 FREQ -- Frequency in cycles/unit time, with unit time being
*             the same unit as used for TIME
*
      DOUBLE PRECISION TIME(N)
      REAL DATA(N), FREQ, WEIGHT(N)
      DOUBLE PRECISION TWOPI
      INTEGER N, MAXPNT
      DOUBLE PRECISION SUM1, SUM2, SUM3, SUM4
      DOUBLE PRECISION OMEGA, PHI, PHI0
      DOUBLE PRECISION WXS, WXC
      DOUBLE PRECISION XC, XS
      PARAMETER (MAXPNT=2000)
      DOUBLE PRECISION SINE(MAXPNT), COSINE(MAXPNT)
      LOGICAL FIRST
      DATA FOLD/-1.D0/
      DATA FIRST/.TRUE./
*
      SCARGLE = 0.
      IF(FIRST) THEN
        FIRST = .FALSE.
        TWOPI = 8.D0*ATAN(1.D0)
      END IF
      OMEGA = TWOPI*FREQ
      IF(N.GT.MAXPNT) THEN
        WRITE(*,*) 'Too many points for SCARGLE'
        RETURN
      END IF
      IF(ABS(FREQ-FOLD).GT.1.E-10) THEN
        DO I = 1, N
          PHI       = OMEGA*TIME(I)
          SINE(I)   = SIN(PHI)
          COSINE(I) = COS(PHI)
        END DO
        FOLD = FREQ
      END IF
*
* Evaluate tau
*
      SUM1 = 0.D0
      SUM2 = 0.D0
      DO I = 1, N
        WGT = WEIGHT(I)
        SUM1 = SUM1 + WGT*(2.*SINE(I)*COSINE(I))
        SUM2 = SUM2 + WGT*(2.*COSINE(I)**2-1.)
      END DO
      PHI0 = ATAN2(SUM1, SUM2)/2.
      S0 = SIN(PHI0)
      C0 = COS(PHI0)
*
      SUM1 = 0.D0
      SUM2 = 0.D0
      SUM3 = 0.D0
      SUM4 = 0.D0
      DO I = 1, N
        XS = SINE(I)*C0-COSINE(I)*S0
        WXS = XS*WEIGHT(I)
        XC = COSINE(I)*C0+SINE(I)*S0
        WXC = XC*WEIGHT(I)
        SUM1 = SUM1 + WXC*XC
        SUM2 = SUM2 + WXS*XS
        SUM3 = SUM3 + WXC*DATA(I)
        SUM4 = SUM4 + WXS*DATA(I)
      END DO
      IF(FREQ.EQ.0.) THEN
        SCARGLE = SUM3*SUM3/SUM1/2.
      ELSE
        SCARGLE = (SUM3*SUM3/SUM1+SUM4*SUM4/SUM2)/2.
      END IF
      RETURN
      END
