      REAL FUNCTION ROTPROF( X, EPSIN, IDER )
*
*  Cumulative rotation profile for a spherical star with limb darkening
*
*  Input:
*      X      = V/Vsin(i)
*      EPSIN  = Limb Darkening Parameter I(MU) = I(0)*(1-EPS+EPS*MU)
*      IDER   = 0 to evaluate profile
*             = -1 to evaluate cumulative profile
*  Output:
*      ROTPROF      = Rotation profile (normalized to unit integral) if IDER=0
*              Cumulative rotation profile (0-1) if IDER = -1
*
*  Nov 1984 by Keith Horne at IOA
*
      IMPLICIT NONE
      INTEGER IDER
      REAL X, EPSIN, EPS, EPSOLD, PI, HALFPI, C1, C2
      REAL C3, C4, X2, ROOT, U
      DATA EPSOLD/1.E30/
      IF( EPSIN.NE.EPSOLD ) THEN
        EPSOLD = EPSIN
        EPS = MAX(0., MIN( 1., EPSIN ) )
        PI = ATAN2(1.,1.)*4.
        HALFPI = PI/2.
        C1 = 6.*(1.-EPS) / (PI*(3.-EPS) )
        C2 = 1.5*EPS / (3.-EPS)
        C3 = C1/2.
        C4 = C2/3.
      END IF
*
*  Calculate cumulative line profile
*
      IF( IDER.LT.0 ) THEN
*
        IF( X.LE.-1. ) THEN
          ROTPROF = 0.
          RETURN
        ELSE IF( X.GE.1. ) THEN
          ROTPROF = 1.
          RETURN
        ELSE
          X2 = X*X
          ROOT = SQRT( 1.-X2 )
          ROTPROF = C3 * ( X * ROOT + ATAN2(X,ROOT) + HALFPI )
     *            + C4 * ( X+X+X - X2*X + 2.)
          RETURN
        END IF
*
*  Calculate line profile
*
      ELSE
*
        IF( X.LE.-1. .OR. X.GE.1. ) THEN
          ROTPROF = 0.
          RETURN
        ELSE
          U = 1.-X*X
          ROOT = SQRT( U )
          ROTPROF = C1 * ROOT + C2 * U
          RETURN
        END IF
*
      END IF
      END
