*med2d
*
* med2d -- program to find centroid of a 2D image using median in interative
*          2D manner.
*
* Works by computed gaussian weighted marginals and applying median to them.
* This is iterated until the position does not change or some maximum number
* of iterations is reached.
*
* R*4 DATA(NX,NY)  -- Image of interest
* I*4 NX, NY       -- Frame dimensions
* I*4 XLO, XHI, YLO, YHI -- Useable region of the frame
* R*4 X, Y         -- On input initial position, refined position on output
* R*4 FWHM         -- FWHM of gaussian
* R*4 WORK1(MXWORK) -- Array for computing marginal sums
* R*4 WORK2(MXWORK) -- Array for storing marginalisation weights
* I*4 MXWORK       -- Must be at least MAX(NX,NY)
* R*4 ACC          -- If position moves less than ACC, iterations cease
* I*4 MXITER       -- Maximum number of iterations.
* I*4 IFAIL        -- 0 = OK, anything else = error.
*
*med2d
      SUBROUTINE MED2D(DATA, NX, NY, XLO, XHI, YLO, YHI, X, Y, FWHM, 
     &WORK1, WORK2, MXWORK, ACC, MXITER, IFAIL)
*
      IMPLICIT NONE
      INTEGER NX, NY, XLO, XHI, YLO, YHI, IFAIL, MXWORK, MXITER
      INTEGER NITS, IX, IY, IPEAK
      REAL DATA(NX,NY), X, Y, FWHM, WORK1(MXWORK), WORK2(MXWORK), ACC
      REAL OLDX, OLDY, WEIGHT, EFAC, CHANGE, RBIN, SIGBIN
      DOUBLE PRECISION SUM
*
      IF(MXWORK.LT.MAX(NX,NY)) THEN
         WRITE(*,*) 'MXWORK too small inside MED2D'
         IFAIL = 1
         GOTO 999
      END IF
*
      EFAC = 4.*LOG(2.)/FWHM**2
      NITS = 0
      CHANGE = ABS(ACC) + 1.
      DO WHILE(NITS.LT.MXITER .AND. CHANGE.GT.ACC)
         NITS = NITS + 1
         OLDX = X
         OLDY = Y
*
* Cycle fitting X and then Y position
*
* Sum in Y direction
*
         DO IX = XLO, XHI
            WORK1(IX) = 0.
         END DO
         DO IY = YLO, YHI
            WEIGHT = EXP(-EFAC*(REAL(IY)-Y)**2)
            DO IX = XLO, XHI
               WORK1(IX) = WORK1(IX) + WEIGHT*DATA(IX,IY)
            END DO
         END DO
*
* Fit new X position
*
         IPEAK = NINT(X)-XLO+1
         CALL MEDIAN(WORK1(XLO),XHI-XLO+1,IPEAK,FWHM,RBIN,SIGBIN,1)
         X = RBIN+REAL(XLO-1)
*
* Now sum in X direction
*
         DO IX = XLO, XHI
            WORK2(IX) = EXP(-EFAC*(REAL(IX)-X)**2)
         END DO
         DO IY = YLO, YHI
            SUM = 0.D0
            DO IX = XLO, XHI
               SUM = SUM + WORK2(IX)*DATA(IX,IY)
            END DO
            WORK1(IY) = SUM
         END DO
*
* Fit new Y position
*
         IPEAK = NINT(Y)-YLO+1
         CALL MEDIAN(WORK1(YLO),YHI-YLO+1,IPEAK,FWHM,RBIN,SIGBIN,1)
         Y = RBIN+REAL(YLO-1)
*
* Evaluate change in position
*
         CHANGE = SQRT((X-OLDX)**2+(Y-OLDY)**2)
      END DO
      IFAIL = 0
 999  RETURN
      END

