 	SUBROUTINE GSTAR(STNAM,IFILE,IEPH,IERR)
C
C SUBROUTINE FOR SELECTING A STAR.
C RETURNED --  STNAM CHARACTER STRING = STAR NAME
C ALL THE REAL*8 ARE RETURNED VIA COMMON BLOCK.
C	REAL*8	EPH(2)  EPHEMERIS -- IF PARABOLIC, THEN FUDGE
C			TO LINEAR
C	 "	RA,DEC  COORDINATES OF STAR DECIMAL HOURS,DEGREES
C	 "	EPOC    EPOCH OF COORDINATES DECIMAL YEARS
C	INTEGER*4 IERR -- ERROR RETURN
C		       IERR=0 ALL PARAMETERS RETURNED
C		       IERR=1 NO EPHEMERIS DATA
C		       IERR=2 NO DATA AT ALL.
C   PASSED: INTEGER*4 IEPH -- SET TO 1 IF YOU DON'T NEED
C					 EPHEMERIS DATA.
C		      IFILE-- SET TO 1 IF YOU DO NOT WANT TO
C			      LOAD NEW STELLAR DATA. IF IT HAS NOT
C			      BEEN LOADED, IFILE IS IGNORED. 
C
C
        IMPLICIT NONE
        INTEGER MXSTAR, IDH, IDM, IH, IM, IS, IMS, I, IMSK
        INTEGER NUMB, ISJ, IMSJ, K, KM, KH, ICALL, ISK
        INTEGER NOLD, NSTAR, JH, JM, IERR, IEPH, IFILE
        REAL SDEC, SEC, SJ, SK
	PARAMETER (MXSTAR=200)		
	CHARACTER*10 STAR(MXSTAR)	
	DOUBLE PRECISION EPHEM(2,MXSTAR), RADEC(2,MXSTAR)		
	DOUBLE PRECISION EPOCH(MXSTAR),RA,DEC,EPOC,EPH
	CHARACTER*(*) STNAM
	COMMON/STINFO/RA,DEC,EPOC,EPH(2)
	CHARACTER*1  REPLY
	CHARACTER*30 FILENAME
        LOGICAL SAMECI
	DATA ICALL,NSTAR/0,0/
C
	IF(IFILE.NE.1 .OR. ICALL.EQ.0) THEN
	  WRITE(*,*) 'Position and ephemeris information is now needed.'
5	  WRITE(*,'(A,$)') 'Do you have a stellar data file on disc ? '
	  READ(*,'(A)') REPLY
	  ICALL=0
	  IF(SAMECI(REPLY,'N')) THEN
	    IF(NSTAR.GT.0) GOTO 7
	    GOTO 35
	  END IF
	  WRITE(*,'(A,$)') 'What name please: ' 
	  READ(*,'(A)') FILENAME
	  NOLD = NSTAR
	  OPEN(UNIT=25,FILE=FILENAME,ACCESS='SEQUENTIAL',
     $    STATUS='OLD',ERR=620)
8	    NSTAR = NSTAR + 1
	    IF(NSTAR.GT.MXSTAR) GOTO 630
	    READ(25,'(A)',END=610,ERR=600) STAR(NSTAR)
	    READ(25,*,END=610,ERR=600) EPOCH(NSTAR), JH, JM, SJ,
     $      KH, KM, SK, (EPHEM(K, NSTAR),K=1,2)
C CONVERT TO DECIMAL RA,DEC
	    ISJ = INT(SJ)
	    IMSJ = INT(1000.*(SJ-REAL(ISJ)))
	    CALL FRHMS( RADEC(1,NSTAR), JH, JM, ISJ, IMSJ)
	    ISK = INT(SK)
	    IMSK = INT(1000.*(SK-REAL(ISK)))
	    CALL FRHMS( RADEC(2,NSTAR), ABS(KH), KM, ISK, IMSK)
	    IF(KH.LT.0) RADEC( 2, NSTAR)=-RADEC( 2, NSTAR)
	    GOTO 8
600	    WRITE(*,*) CHAR(7),'Error while reading file'
	    NSTAR = NOLD
	  CLOSE(UNIT=25)
	  GOTO 5
610	  NSTAR = NSTAR - 1
	  ICALL = 1
	  CLOSE(UNIT=25)
	  GOTO 7
620	  WRITE(*,*) CHAR(7),'File does not exist'
	  GOTO 5
630	  WRITE(*,*) CHAR(7),'** No more space for stellar data.'
	  CLOSE(UNIT=25)
	END IF
7	WRITE(*,*) 'Data stored for these stars:'
	WRITE(*,* ) ' '
10	WRITE(*,*) 'Number      Star name'
20	FORMAT(' ',2X,I2,9X,A10)
	DO I=1,NSTAR
	  WRITE(6,20) I,STAR(I)
	END DO
30	WRITE(*,*) 'Which one do you want (0 for some other star) ?'
	READ(*,*,ERR=30) NUMB
	IF(NUMB.LT.0 .OR. NUMB.GT.NSTAR) GOTO 10
	IF(NUMB.NE.0) THEN
	  STNAM=STAR(NUMB)
	  IF(IEPH.EQ.1) THEN
	    DO I=1,2
	      EPH(I)=0.
	    END DO
	    IERR=1
	  ELSE
	    DO I=1,2
	      EPH(I)=EPHEM(I,NUMB)
	    END DO
	  END IF
	  RA= RADEC(1,NUMB)
	  DEC=RADEC(2,NUMB)
	  EPOC=EPOCH(NUMB)
	  IF(EPH(1).LT.2.D6) IERR=1
	  GOTO 99
	END IF
C
C STAR NAME
35	WRITE(*,*) 'What is star name ? <CR> to abort'
	READ(*,'(A)') STNAM
	IF(STNAM.EQ.' ') THEN
	  IERR=2
	  GOTO 99
	END IF
C
C RA,DEC,EPOCH
40	WRITE(*,'(A,$)') 'Input RA (HOURS,MIN,SEC) : '
	READ(*,*,ERR=40) IH,IM,SEC
	IF(IH.LT.0 .OR. IH.GT.24 .OR.
     $	   IM.LT.0 .OR. IM.GT.60 .OR.
     $	 SEC.LT.0 .OR. SEC.GT.60) GOTO 40
	IS=INT(SEC)
	IMS=NINT(1000.*(SEC-REAL(IS)))
	CALL FRHMS(RA,IH,IM,IS,IMS)
50	WRITE(*,'(A,$)') 'Input DEC (DEG,MIN,SEC) : '
	READ(5,*,ERR=50) IDH,IDM,SDEC
	IDM=ABS(IDM)
	SDEC=ABS(SDEC)
	IF(IDH.LT.-90 .OR. IDH.GT.90 .OR.
     $	   IDM.GT.60 .OR. SDEC.GT.60) GOTO 50
	IS=INT(SDEC)
	IMS=NINT(1000.*(SDEC-REAL(IS)))
	CALL FRHMS(DEC,ABS(IDH),IDM,IS,IMS)
	IF(IDH.LT.0) DEC=-DEC
60	WRITE(*,'(A,$)') 'Input EPOCH of coordinates: '
	READ(*,*,ERR=60) EPOC
	IF(EPOC.LT.1.8D3 .OR. EPOC.GT.2.D3) GOTO 60
C
C EPHEMERIS FOR STAR
	IF(IEPH.EQ.1) GOTO 90
70	WRITE(*,*) 'Input two numbers for EPHEMERIS'
	READ(*,*,ERR=70) EPH(1),EPH(2)
	IF(EPH(1).LT.2.D6 .OR. EPH(1).GT. 3.D6
     $.OR. EPH(2).LT.4.D-2 .OR. EPH(2).GT.3.D2) GOTO 70
C
90	WRITE(*,*) 'Data input is: '
	WRITE(*,*) 'Star name: ',STNAM
	WRITE(*,*) ' '
	PRINT 1040,IH,IM,SEC
	PRINT 1050,IDH,IDM,SDEC
	PRINT 1060,EPOC
	PRINT *,' '
	IF(IEPH.EQ.1) GOTO 100
	PRINT 1070,EPH(1),EPH(2)
	PRINT *,' '
100	WRITE(*,'(A,$)') 'Do you want to store this ? '
	READ(*,'(A)') REPLY
	IF(SAMECI(REPLY,'Y')) THEN
	  NSTAR=MIN(NSTAR+1,MXSTAR)
	  IF(NSTAR.EQ.MXSTAR) 
     &    WRITE(*,*) 'Last star stored has been written over'
	  IF(IEPH.EQ.1) THEN
	    DO I=1,2
	      EPHEM(I,NSTAR)=0.
	    END DO
	    IERR=1
	  ELSE
	    DO I=1,2
	      EPHEM(I,NSTAR)=EPH(I)
	    END DO
	  END IF
	  STAR(NSTAR)=STNAM
	  RADEC(1,NSTAR)=RA
	  RADEC(2,NSTAR)=DEC
	  EPOCH(NSTAR)=EPOC
	ELSE
	 WRITE(*,'(A,$)') 'Are you satisfied ? '
	 READ(*,'(A)') REPLY
	 IF(SAMECI(REPLY,'Y')) GOTO 5
	END IF
99	RETURN
C FORMAT STATEMENTS
1040	FORMAT(' RA: ',I2,' hrs, ',I2,' mins, ',F5.2,' secs.')
1050	FORMAT(' DEC: ',I3,' deg, ',I2,' mins, ',F5.2,' secs.')
1060	FORMAT(' Epoch: ',F7.2)
1070	FORMAT(' Ephemeris: ',F15.7,', ',E14.8)
	END
