        SUBROUTINE GETREST( ANGSTROM )
*
* Acquires rest wavelength of a line (in air)
*
* Output:
*       ANGSTROM        = (REAL*8) ANGSTROM VALUE
*                       = 0 IF ABORTED
*
* Nov 1984 by Keith Horne at IOA
* Aug 1987 KDH @ STScI - more lines and ions
* Sep 1987 KDH @ STScI - improved interaction
*
        REAL*8 ANGSTROM
        PARAMETER (NIONS=9)
        CHARACTER*5 REPLY
        CHARACTER*5 NAME( NIONS )
        LOGICAL PARSE
        PARAMETER (NH = 14)
        REAL*8 ANGH(NH)
        PARAMETER (NHEI = 31)
        REAL*8 ANGHEI(NHEI)
        PARAMETER (NHEII = 17)
        REAL*8 ANGHEII(NHEII)
        PARAMETER (NNAI = 6)
        REAL*8 ANGNAI(NNAI)
        PARAMETER (NCAII = 5)
        REAL*8 ANGCAII(NCAII)
        PARAMETER (NFEII = 20)
        REAL*8 ANGFEII(NFEII)
        PARAMETER (NKI = 2)
        REAL*8 ANGKI(NKI)
        PARAMETER (NOIII = 3)
        REAL*8 ANGOIII(NOIII)
        PARAMETER (NNII = 3)
        REAL*8 ANGNII(NNII)

        DATA NAME /
     &  'HI   ',
     &  'HeI  ',
     &  'HeII ',
     &  'NaI  ',
     &  'CaII ',
     &  'FeII ',
     &  'KI   ',
     &  'OIII ',
     &  'NII  '
     &  /
        DATA LAST/1/

        DATA ANGH /
     &  6562.760 D0,    ! H-alpha
     &  4861.327 D0,    ! H-beta
     &  4340.465 D0,    ! H-gamma
     &  4101.735 D0,    ! H-delta
     &  3970.074 D0,    ! H-epsilon
     &  3889.055 D0,    ! H-zeta
     &  3835.397 D0,    ! H-eta
     &  3797.910 D0,
     &  3770.634 D0,
     &  3750.152 D0,
     &  3734.372 D0,
     &  3721.948 D0,
     &  3711.98  D0,
     &  3703.86  D0
     &  /

        DATA ANGHEI /
     &  5015.675D0, 3964.727D0, 3613.641D0, 
     &  3447.590D0, 3354.550D0, 6678.149D0,
     &  4921.929D0, 4387.928D0, 4143.759D0,    
     &  4009.270D0, 7281.349D0, 5047.736D0,    
     &  4437.549D0, 4168.967D0, 10830.17D0,    
     &  3888.646D0, 5875.618D0, 4471.681D0,    
     &  4026.189D0, 3819.761D0, 3705.003D0,   
     &  7065.188D0, 4713.20 D0,  4120.86D0,    
     &  3867.53D0 ,  3732.94D0,  7816.16D0,
     &  9463.66D0 ,  9516.70D0,  9526.17D0,
     &  9702.66  D0/

* Ionized Helium lines

        DATA ANGHEII /
     1  1640.474 D0,    1215.171 D0,    
     3  4685.750 D0,    3203.14  D0,    
     5  2733.4   D0,    10123.77 D0,    
     7  6559.71  D0,    5411.551 D0,    
     9  4859.3   D0,    4541.7   D0,    
     1  4338.8   D0,    4199.9   D0,    
     3  4100.1   D0,    4025.7   D0,    
     5  3968.5   D0,    3923.6   D0,    
     7  3887.5   D0  /

* Neutral Sodium lines


        DATA ANGNAI /
     &  5889.95  D0,
     &  5895.92  D0,
     &  6154.23  D0,
     &  6160.76  D0,
     &  8183.27  D0,
     &  8194.81  D0
     &  /

* Singly ionised Calcium lines

        DATA ANGCAII /
     &  3933.67  D0,
     &  3968.47  D0,
     &  8498.02  D0,
     &  8542.09  D0,
     &  8662.14  D0
     &  /

* Singly Ionized Iron lines

        DATA ANGFEII /
     &  4923.92  D0, 5018.44  D0,
     &  5030.78  D0, 5136.79  D0,
     &  5169.03  D0, 5197.59  D0,
     &  5275.99  D0, 5284.09  D0,
     &  5303.42  D0, 5316.61  D0,
     &  5362.86  D0, 5534.86  D0,
     &  6446.43  D0, 6516.05  D0,
     &  7222.39  D0, 7224.51  D0,
     &  7307.97  D0, 7320.70  D0,
     &  7462.38  D0, 7711.73  D0
     &  /

* Neutral Potassium lines

        DATA ANGKI /
     &  7664.91  D0,
     &  7698.98  D0
     &  /

* OIII lines

        DATA ANGOIII /
     &  5006.9   D0,
     &  4958.9   D0,
     &  4363.2   D0
     &  /

* NII lines

        DATA ANGNII /
     &  6583.4   D0,
     &  6548.1   D0,
     &  5754.6   D0
     &  /

* Select ion

   10   WRITE(*,*) 'Accurate line wavelengths'//
     &  ' are available for these ions :'
        WRITE(*,'(I3,A,A5,I3,A,A5,I3,A,A5,I3,A,A5,I3,A,A5)')
     &          ( I, '=', NAME(I), I=1,NIONS )
        WRITE(*,'(3A,$)')
     &  'Enter ION name or number (0=', NAME(LAST), ',-1 aborts) ? '
        READ(*,'(A)', ERR=10) REPLY
        CALL UPPER_CASE( REPLY )
      DO IPICK=1,NIONS
        IF( PARSE( REPLY, NAME(IPICK) ) ) GOTO 30
      END DO
        READ( REPLY, *, ERR=10 ) IPICK
        IF( IPICK.LT.0 ) GOTO 999
        IF( IPICK.EQ.0 ) IPICK = LAST
        IF( IPICK.GE.1 .AND. IPICK.LE.NIONS ) GOTO 30
        WRITE(*,*) '** Invalid reply. Please try again.'
        GOTO 10

* Obtain the rest wavelength of a line

   30 IF( IPICK.EQ.1 ) THEN
        CALL PICKLINE( NH, ANGH, ANGSTROM )
      ELSE IF( IPICK.EQ.2 ) THEN
        CALL PICKLINE( NHEI, ANGHEI, ANGSTROM )
      ELSE IF( IPICK.EQ.3 ) THEN
        CALL PICKLINE( NHEII, ANGHEII, ANGSTROM )
      ELSE IF( IPICK.EQ.4 ) THEN
        CALL PICKLINE( NNAI, ANGNAI, ANGSTROM )
      ELSE IF( IPICK.EQ.5 ) THEN
        CALL PICKLINE( NCAII, ANGCAII, ANGSTROM )
      ELSE IF( IPICK.EQ.6 ) THEN
        CALL PICKLINE( NFEII, ANGFEII, ANGSTROM )
      ELSE IF( IPICK.EQ.7 ) THEN
        CALL PICKLINE( NKI, ANGKI, ANGSTROM )
      ELSE IF( IPICK.EQ.8 ) THEN
        CALL PICKLINE( NOIII, ANGOIII, ANGSTROM )
      ELSE IF( IPICK.EQ.9 ) THEN
        CALL PICKLINE( NNII, ANGNII, ANGSTROM )
      ELSE
        CALL PICKLINE( 0, 0.D0, ANGSTROM )
      END IF

* one final check to verify the wavelength

        IF( ANGSTROM.LE.0.D0 ) GOTO 10
        WRITE(*,'(1X,A,F15.3,A,$)') 'Is', ANGSTROM, ' correct ? [Y] '
        READ(*,'(A)') REPLY
        CALL UPPER_CASE( REPLY )
        IF( REPLY.NE.'Y' .AND. REPLY.NE.' ' ) GOTO 10

* save selected ion for next time around

        LAST = IPICK

* normal return

 1000   RETURN

* error return

  999   WRITE(*,*) '** GETREST aborted.'
        ANGSTROM = 0.D0
        RETURN
        END

**************************************************************************
      SUBROUTINE PICKLINE( NLINE, ANGLINE, ANGSTROM )
*
* User selects a rest wavelength from a table
*
* Input:
*       NLINE   = NUMBER OF LINES IN THE TABLE (MAY BE 0)
*       ANGLINE = ANGSTROM VALUE TABLE
* Output:
*       ANGSTROM= ANGSTROM VALUE OF CHOSEN LINE (0 IF NONE CHOSEN )
*
* Nov 84 by Keith Horne at IOA
* Sep 84 KDH @ STScI - allow selection by wavelength or line number.
*
      CHARACTER*24 FMT
      REAL*8 ANGSTROM, ANGOLD, ANGLINE(1)

10    IF( ANGOLD.GT.0.D0) WRITE(*,*) '  0 selects previous line =', ANGOLD
      IF( NLINE.GT.0 ) THEN
        NCOL = MIN( 5, NLINE/6 + 1 )
        NROW = (NLINE-1)/NCOL + 1
      DO I1 = 1, NROW
 11   FORMAT ('(',I2,'(  I4, ''='', F10.3 )) ')
      WRITE(FMT,11)NCOL
        WRITE(*,FMT)
        WRITE(*,FMT) ( I, ANGLINE(I), I = I1,NLINE,NROW )
      END DO
        WRITE(*,'(A,$)') 'Enter WAVELENGTH'//
     &  ' or LINE number (-1 aborts) : '
      ELSE
        WRITE(*,'(A,$)') 'Enter accurate '//
     &  'WAVELENGTH (Angstroms, -1 aborts) : '
      END IF

        READ(*,*,ERR=10) ANGSTROM

* abort

      IF( ANGSTROM.LT.-0.5 ) THEN
        GOTO 999

* previous wavelength selected

      ELSE IF( ANGSTROM.LT.0.5 ) THEN
        ANGSTROM = ANGOLD

* wavelength selected by line number

      ELSE IF( ANGSTROM.LT.NLINE+0.5 ) THEN
        ANGSTROM = ANGLINE( NINT( ANGSTROM ) )

* search list for lines matching requested wavelength

      ELSE
        MINMATCH = NLINE+1
        MAXMATCH = 0
        THRLO = -1.0    ! user may round down to nearest angstrom
        THRHI = 0.5
      DO I=1,NLINE
        TEST = ANGSTROM - ANGLINE( I )
      IF( TEST.GT.THRLO .AND. TEST.LT.THRHI ) THEN
        MINMATCH = MIN( MINMATCH, I )
        MAXMATCH = MAX( MAXMATCH, I )
      END IF
      END DO

* use accurate wavelength from line list

      IF( MINMATCH .EQ. MAXMATCH ) THEN
        ANGSTROM = ANGLINE( MINMATCH )
        WRITE(*,*) 'You have selected line', MINMATCH, '=', ANGSTROM

* report ambiguous selection

      ELSE IF( MAXMATCH.GT.MINMATCH ) THEN
        WRITE(*,*) '** Your selection is ambiguous.'
      DO I=1,NLINE
        TEST = ANGSTROM - ANGLINE( I )
      IF( TEST.GT.THRLO .AND. TEST.LT.THRHI ) THEN
        WRITE(*,*)  MINMATCH, '=',ANGLINE(MINMATCH)
      END IF
      END DO
        WRITE(*,*) 'Please try again.'
        GOTO 10
      END IF
      END IF

* final trap of bad wavelength values (in case junk is entered in tables)

      IF( ANGSTROM.LT.NLINE+0.5 ) THEN
        WRITE(*,*) '** INVALID WAVELENGTH=', ANGSTROM
        WRITE(*,*) '** PLEASE REPORT BUG'//
     &  ' IN SUBROUTINE PICKLINE TO KEITH HORNE.'
        GOTO 999
      END IF

* save selected value for use next time around

        ANGOLD = ANGSTROM

* normal return

 1000   RETURN

* error return

  999   WRITE(*,*) '** PICKLINE aborted.'
        ANGSTROM = 0.D0
        RETURN

        END
