        SUBROUTINE FINDRESP( NDATA, XDATA, YDATA, RESP )
*
*  Estimates the spectral response curve (Counts/mjy)
*  from the fluctuations in a mjy spectrum.
*
*  Input:
*       NDATA   = NUMBER OF SPECTRUM PIXELS
*       XDATA   = ANGSTROM VALUES
*       YDATA   = FLUX SPECTRUM (mjy or whatever)
*
*  Output:
*       RESP    = RESPONSE SPECTRUM (detected counts/sec/mjy)
*
*  November 1984 by Keith Horne at IOA
*
        REAL*4 XDATA(1), YDATA(1), RESP(1)
        PARAMETER ( MAXFIT=1000 )
        REAL*4 XFIT( MAXFIT), YFIT(MAXFIT), SFIT(MAXFIT)
        REAL*8 SUM, SUM2
        CHARACTER*1 REPLY
        LOGICAL SPLINES ! SPLINE(VS POLYNOMIAL) FIT
        PI = ATAN2(1.,1.)*4.
*
      IF( NDATA.LE.3 ) THEN
        PRINT *,'** INSUFFICIENT SPECTRUM DATA', NDATA
  999   PRINT *,'** ''FINDRESP'' ABORTED.'
        RETURN
      END IF
*
*  Introduction
*
        WRITE(*,*) ' '
        WRITE(*,*) 'Fitting spectrum fluctuations'//
     &  ' to estimate spectral response'
*
*  Loop thru spectrum blocks -----------------------------------
*
        NBLOCK = MIN( MAXFIT, NDATA )   ! Number of blocks in the spectrum
        LBLOCK = 1 + (NDATA-1) / NBLOCK ! Number of pixels per block
        PRINT *,'Number of spectrum blocks=', NBLOCK, ' Pixels/block=', 
     &  LBLOCK
        NFIT = 0                        ! Number of blocks used in the fit
      DO IPIX1 = 1, NDATA, LBLOCK
        IPIX2 = MIN( NDATA, IPIX1+LBLOCK-1 )
*
*  Compute average value of (sigma of flux) / (square root of flux)
*
        SUM = 0.D0
        SUM2 = 0.D0
        NSUM = 0
      DO I = IPIX1, IPIX2               ! Loop thru pixels in this block
      IF( YDATA(I).GT.0. ) THEN         ! Skip pixels with negative flux
        IM = MAX( I-1, 1 )
        IP = MIN( I+1, NDATA )
        SIGMAEST = ABS( YDATA(I) - 0.5*( YDATA(IM) + YDATA(IP)) )
      IF( YDATA(I) .GT. 3.*SIGMAEST ) THEN
        SUM = SUM + SIGMAEST / SQRT( YDATA(I) )
        SUM2 = SUM2 + XDATA(I)
        NSUM = NSUM + 1
      END IF
      END IF
      END DO            ! End of loop thru pixel range of each block
*
*  Add block to list used in the fit
*
      IF( SUM.GT.0.D0 .AND. NSUM.GT.0 ) THEN
        NFIT = NFIT + 1
        XFIT( NFIT ) = SUM2 / NSUM
        YFIT( NFIT ) = DLOG( SUM / NSUM )
        SFIT( NFIT ) = SQRT(FLOAT(NSUM))
      END IF
*
      END DO            ! End of loop thru spectrum blocks
        PRINT *,'Number of blocks for response fit=', NFIT
*
*  Fit function to response curve --------------------------------
*
      IF( NFIT.LT.1 ) THEN
        PRINT *,'** INSUFFICIENT DATA FOR FIT', NFIT
        GOTO 999
      END IF
*
*  Spline or Polynomial fit ?
*
        PRINT *,' '
        PRINT '(A)', '$S(pline) or P(olynomial) fit ? '
        READ(*,'(A)') REPLY
        SPLINES = REPLY.EQ.'S'
*
      IF( SPLINES ) THEN
        CALL SPLFITR( NFIT, XFIT, YFIT, SFIT, RESP, IFAIL )
      IF( IFAIL.NE.0 ) THEN
        PRINT *,'** ''SPLFITR'' FAILED.'
        GOTO 999
      END IF
      ELSE
        CALL POLYFITR( NFIT, XFIT, YFIT, SFIT, RESP, IFAIL )
      IF( IFAIL.NE.0 ) THEN
        PRINT *,'** ''POLYFITR'' FAILED.'
        GOTO 999
      END IF
      END IF
*
*  Evaluate response fit on full spectrum ------------------------------
*
      IF( SPLINES ) THEN
      DO I=1,NDATA
        CALL SPLCALC( 1, XDATA(I), RESP(I), IFAIL )
      IF( IFAIL.NE.0 ) THEN
        PRINT *,'** WARNING: ''SPLCALC'' FAILED AT PIXEL', I, XDATA(I)
      END IF
*  Note: 1.5/pi is a fudge factor.
        RESP(I) = 1.5 / ( PI * EXP( 2.*RESP(I) ) )
      END DO
*
      ELSE
*
      DO I=1,NDATA
        CALL POLYCALC( 1, XDATA(I), RESP(I), IFAIL )
      IF( IFAIL.NE.0 ) THEN
        PRINT *,'** WARNING: ''POLYCALC'' FAILED AT PIXEL', I, XDATA(I)
      END IF
*  Note: 1.5/pi is a fudge factor.
        RESP(I) = 1.5 / ( PI * EXP( 2.*RESP(I) ) )
      END DO
*
      END IF
*
        RETURN
        END
