      REAL FUNCTION BLBOD(WAVE,TEMP)
*
* Given temperature, wavelength, blbod is the natural
* log of the specific intensity in
* ergs/s/cm**2/steradian/hertz
* wave in cms, temp in Kelvin. Angle integrated version is
* Pi times larger than this.
*
      REAL WAVE,TEMP
      DATA EFAC,PFAC/1.4387,-35.46189/
C
      TEST=EFAC/TEMP/WAVE
      BLBOD=PFAC-3.*LOG(WAVE)
      IF(TEST.GT.20) THEN
        BLBOD=BLBOD-TEST
        RETURN
      ELSE IF(TEST.LT.1.E-5) THEN
        BLBOD=BLBOD-LOG(TEST)
      ELSE
        BLBOD=BLBOD-LOG( EXP(TEST)-1.)
      END IF
      RETURN
      END
      FUNCTION BNU(W,T)
C
C  COMPUTES THE PLANCK FUNCTION IN CGS UNITS
C
C  T IS IN KELVINS
C  W IS IN ANGSTROMS
C
      DATA C1/1.43883E8/
      DATA C2/1.95722E5/
C
      X=W*T
      IF(X.LE.0.) THEN
      BNU=0.
      RETURN
      END IF
C
      X=C1/X
C
      IF(X.LT.1.E-4) THEN
      FACTOR=2./(X*(X+2.))
      ELSE IF(X.LT.85.) THEN
      FACTOR=1./(EXP(X)-1.)
      ELSE
      FACTOR=0.
      END IF
C
      X=X*T/C2
      BNU=X*X*X*FACTOR
      RETURN
      END
 
      FUNCTION DBNUDT(W,T)
C
C  COMPUTES THE TEMPERATURE DERIVATIVE OF THE PLANCK FUNCTION
C
C  T IS IN KELVINS
C  W IS IN ANGSTROMS
C
      DATA C1/1.43883E8/
      DATA C2/1.95722E5/
C
      X=W*T
      IF(X.LE.0.) THEN
      DBNUDT=0.
      RETURN
      END IF
C
      X=C1/X
C
      IF(X.LT.1.E-4) THEN
      FACTOR=2./(X*(X+2.))
      ELSE IF(X.LT.85.) THEN
      FACTOR=1./(EXP(X)-1.)
      ELSE
      FACTOR=0.
      END IF
C
      A=X*T/C2
      BNU=A*A*A*FACTOR
      IF(X.GT.85.) X=85.
      IF(X.GT.1.E-4) DBNUDT=(BNU/T)*X*EXP(X)*FACTOR
      IF(X.LE.1.E-4) DBNUDT=(BNU/T)/(1.-X)
      RETURN
      END
