        FUNCTION XPOSED(X1,X2,X3,X4,M1,M2,M3,M4,E,Q,NSPLIT)
C
C  COMPUTES THE EXPOSED FRACTION OF A RECTANGULAR AREA WITH
C  VERTICES AT X1,X2,X3,X4
*  Inputs:
*       X1-X4   3-VECTORS GIVING COORDINATES OF VERTICES OF A
*               SURFACE ELEMENT (IN UNITS OF RL1)
*       M1-M4   = 1 IF VERTEX IS OCCULTED
*               = 0 IF VERTEX IS VISIBLE
*       E       = UNIT VECTOR GIVING DIRECTION TOWARD EARTH
*       Q       = BINARY MASS RATIO (MRED/MWD)
*       NSPLIT  = NUMBER OF ITERATIONS FOR EDGE REFINEMENT
*  Output:
*       XPOSED  = FRACTION OF ELEMENT THAT IS EXPOSED
        REAL*4 X1(3),X2(3),X3(3),X4(3),E(3),Q
C
C  COUNT OCCULTED VERTICES
C
        GOTO (10,20,30,40,50) M1+M2+M3+M4+1
C
C  BOX ENTIRELY EXPOSED
C
   10 XPOSED=1.
        RETURN
C
C  ONE OCCULTED VERTEX
C
   20 IF(M1.GT.0) THEN
        CALL EDGE(E,X2,X1,FR1,Q,NSPLIT)
        CALL EDGE(E,X4,X1,FR2,Q,NSPLIT)
      ELSE IF(M2.GT.0) THEN
        CALL EDGE(E,X1,X2,FR1,Q,NSPLIT)
        CALL EDGE(E,X3,X2,FR2,Q,NSPLIT)
      ELSE IF(M3.GT.0) THEN
        CALL EDGE(E,X2,X3,FR1,Q,NSPLIT)
        CALL EDGE(E,X4,X3,FR2,Q,NSPLIT)
      ELSE
        CALL EDGE(E,X1,X4,FR1,Q,NSPLIT)
        CALL EDGE(E,X3,X4,FR2,Q,NSPLIT)
      END IF
        XPOSED=1.-0.5*(1.-FR1)*(1.-FR2)
        RETURN
C
C  TWO OCCULTED VERTICES
C
   30 GOTO (31,36) M1*M3+M2*M4 +1
C
C  REGULAR CASE, TWO ADJACENT OCCULTED VERTICES
C
   31 IF(M1.GT.0.AND.M2.GT.0) THEN
        CALL EDGE(E,X3,X2,FR1,Q,NSPLIT)
        CALL EDGE(E,X4,X1,FR2,Q,NSPLIT)
      ELSE IF(M2.GT.0.AND.M3.GT.0) THEN
        CALL EDGE(E,X1,X2,FR1,Q,NSPLIT)
        CALL EDGE(E,X4,X3,FR2,Q,NSPLIT)
      ELSE IF(M3.GT.0.AND.M4.GT.0) THEN
        CALL EDGE(E,X2,X3,FR1,Q,NSPLIT)
        CALL EDGE(E,X1,X4,FR2,Q,NSPLIT)
      ELSE
        CALL EDGE(E,X2,X1,FR1,Q,NSPLIT)
        CALL EDGE(E,X3,X4,FR2,Q,NSPLIT)
      END IF
        XPOSED=1.-0.5*(FR1+FR2)
        RETURN
C
C  SINGULAR CASE, TWO OPPOSITE OCCULTED VERTICES
C  THIS CASE SHOULD NOT NORMALLY OCCUR.
C
   36 PRINT *,'*** SINGULAR POINT OCCURRED ***'
      IF(M1.GT.0.AND.M3.GT.0) THEN
        CALL EDGE(E,X2,X1,FR1,Q,NSPLIT)
        CALL EDGE(E,X4,X1,FR2,Q,NSPLIT)
        CALL EDGE(E,X2,X3,FR3,Q,NSPLIT)
        CALL EDGE(E,X4,X3,FR4,Q,NSPLIT)
      ELSE
        CALL EDGE(E,X3,X2,FR1,Q,NSPLIT)
        CALL EDGE(E,X1,X2,FR2,Q,NSPLIT)
        CALL EDGE(E,X3,X4,FR3,Q,NSPLIT)
        CALL EDGE(E,X1,X4,FR4,Q,NSPLIT)
      END IF
        XPOSED=0.25*(FR1+FR2+FR3+FR4 + (FR1-FR4)*(FR2-FR3) )
        RETURN
C
C  THREE OCCULTED VERTICES
C
   40 IF(M1.EQ.0) THEN
        CALL EDGE(E,X1,X2,FR1,Q,NSPLIT)
        CALL EDGE(E,X1,X4,FR2,Q,NSPLIT)
      ELSE IF(M2.EQ.0) THEN
        CALL EDGE(E,X2,X1,FR1,Q,NSPLIT)
        CALL EDGE(E,X2,X3,FR2,Q,NSPLIT)
      ELSE IF(M3.EQ.0) THEN
        CALL EDGE(E,X3,X2,FR1,Q,NSPLIT)
        CALL EDGE(E,X3,X4,FR2,Q,NSPLIT)
      ELSE
        CALL EDGE(E,X4,X3,FR1,Q,NSPLIT)
        CALL EDGE(E,X4,X1,FR2,Q,NSPLIT)
      END IF
        XPOSED=0.5*FR1*FR2
        RETURN
C
C  ALL VERTICES OCCULTED
C
   50 XPOSED=0.
        RETURN
C
        END
