      SUBROUTINE WIDTH(RATIO, DELTA, RW, WING)
*
* Computes exact phase width of white dwarf ingress =WING
* given mass ratio, phase width of white dwarf eclipse
* and radius of white dwarf/separation
*
* WING = -100 if routine fails
* Written by T.R. Marsh for accuracy not speed, June 1989
*
      INTEGER NSTEP
      PARAMETER (NSTEP = 100)
      REAL X(3), EARTH(3), XVEC(3), YVEC(3)
      REAL*8 DQ, DX
      LOGICAL BLINK
*
      PI = 4.*ATAN(1.)
*
      CALL FINDDEG(RATIO, ANGLE, DELTA)
      IF(ANGLE.LT.0.) THEN
        WING = -100.
        RETURN
      END IF
      DQ = RATIO
      CALL INLAG(DQ, DX, IFAIL)
      RW1 = RW/DX
      SINI = SIND(ANGLE)
      COSI = COSD(ANGLE)
      EARTH(3) = COSI
*
* Locate phase of first contact.
*
      PHASE1 = -0.2
      PHASE2 =  0.0
      XVEC(3) = 0.
      YVEC(3) = RW1*SINI
100   PHASE  = (PHASE1+PHASE2)/2
      COSP = COSD(360.*PHASE)
      SINP = SIND(360.*PHASE)
      EARTH(1) =   SINI*COSP
      EARTH(2) = - SINI*SINP
      XVEC(1) =   RW1*SINP
      XVEC(2) =   RW1*COSP
      YVEC(1) = - RW1*COSI*COSP
      YVEC(2) =   RW1*COSI*SINP
      DO I = 1, NSTEP
        THETA = PI*(1.0+0.5*REAL(I-1)/REAL(NSTEP-1))
        COST = COS(THETA)
        SINT = SIN(THETA)
        DO J = 1, 3
           X(J) = COST*XVEC(J)+SINT*YVEC(J)
        END DO
        IF(BLINK(X,EARTH,RATIO)) GOTO 200
      END DO
      PHASE1 = PHASE
      IF(ABS(PHASE2-PHASE1).GT.2.E-6) GOTO 100
      GOTO 250
200   PHASE2 = PHASE
      IF(ABS(PHASE2-PHASE1).GT.2.E-6) GOTO 100
250   CONTINUE
      PHASEF = (PHASE1+PHASE2)/2.
*
* Now do same 2nd contact
*
      PHASE1 =  PHASEF
      PHASE2 =  PHASEF + 2.*RW1/PI
300   PHASE  = (PHASE1+PHASE2)/2
      COSP = COSD(360.*PHASE)
      SINP = SIND(360.*PHASE)
      EARTH(1) =   SINI*COSP
      EARTH(2) = - SINI*SINP
      XVEC(1) =   RW1*SINP
      XVEC(2) =   RW1*COSP
      YVEC(1) = - RW1*COSI*COSP
      YVEC(2) =   RW1*COSI*SINP
      DO I = 1, NSTEP
        THETA = PI*(0.5*REAL(I-1)/REAL(NSTEP-1))
        COST = COS(THETA)
        SINT = SIN(THETA)
        DO J = 1, 3
           X(J) = COST*XVEC(J)+SINT*YVEC(J)
        END DO
        IF(.NOT.BLINK(X,EARTH,RATIO)) GOTO 400
      END DO
      PHASE2 = PHASE
      IF(ABS(PHASE2-PHASE1).GT.2.E-6) GOTO 300
400   PHASE1 = PHASE
      IF(ABS(PHASE2-PHASE1).GT.2.E-6) GOTO 300
      WING = (PHASE1+PHASE2)/2.-PHASEF
      RETURN
      END
