        SUBROUTINE STREAM( X, V, Q, TIME, DTIME )
*
*  COMPUTES TRAJECTORY OF GAS IN THE ROCHE POTENTIAL
*
*  Inputs:
*       X(3)    = POSITION VECTOR (UNIT = SEPARATION)
*       V(3)    = VELOCITY VECTOR (UNIT = SEPARATION * OMEGA)
*       Q       = BINARY MASS RATIO MR/MW
*       TIME    = ELAPSED TIME (UNIT = 1/OMEGA = PERIOD/TWOPI)
*       DTIME   = TIME INCREMENT
*  Ouptut:
*       ALL ARE UPDATED EXCEPT Q
* note: all vectors are in rotating frame with origin at wd
*
* 1984? Keith Horne @ IOA
* This uses a simple-minded integration scheme which is not very accurate,
* but suffices for the first part of the stream trajectory.
*
        REAL X(3), V(3)

        A = 1./(1.+Q)
        B = Q*A
        XM = X(1)-1.
        RHOSQ = X(2)*X(2) + X(3)*X(3)
        R1SQ = X(1)*X(1) + RHOSQ
        R2SQ = XM*XM + RHOSQ
        C1 = A/(R1SQ*SQRT(R1SQ))
        C2 = B/(R2SQ*SQRT(R2SQ))
        AX = -X(1)*C1 -XM*C2 + (X(1)-B) + 2*V(2)
        AY = -X(2)*(C1+C2) + X(2) - 2*V(1)
        AZ = -X(3)*(C1+C2)
        X(1) = X(1) + (V(1)+0.5*AX*DTIME)*DTIME
        X(2) = X(2) + (V(2)+0.5*AY*DTIME)*DTIME
        X(3) = X(3) + (V(3)+0.5*AZ*DTIME)*DTIME
        V(1) = V(1) + AX*DTIME
        V(2) = V(2) + AY*DTIME
        V(3) = V(3) + AZ*DTIME
        TIME = TIME + DTIME
        RETURN
        END





