      SUBROUTINE SPOT(METHOD, KW, VSX, VSY, Q, RD, DEL)
*
* Given Kw, amplitude and position of S-wave (VSX, VSY), SPOT
* finds the appropriate mass ratio Q and disc radius RD which
* can fit these values. PHIS measured clockwise from red star.
* DEL measures how close the spot velocity will be fitted in same
* units as KW, VSX, VSY. This should be some factor smaller than
* the uncertainty on VSX, VSY
*
* METHOD = 1 spot assumed to be on the gas stream
* METHOD = 2 spot has keplerian velocity along gas stream
* METHOD = 3 spot has gas stream velocity with no radial cpt.
*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER METHOD
      REAL KW, VSX, VSY, Q, RD, DEL
      REAL X(3), V(3), VUNIT
      REAL*8 DX(3), DV(3), DQ, DSTEP, GACC, DELTA
      REAL*8 X1(3), V1(3), X2(3), V2(3),  DOT
      LOGICAL CAGED, GOOD
*
* rotation coefficients
*
      Q = 0.1
      QLO = 0.
      DLO = 0.
      QHI = 0.
      DHI = 0.
      NCYC = 0
      CAGED = .FALSE.
100   CONTINUE
      GOOD = .FALSE.
      NCYC = NCYC + 1
      VUNIT = KW*(1.+1./Q)
      GACC  = DEL/VUNIT/30.
*
* position of inner Lagrangian point
*
      CALL LAG1( Q, CL1, XL1, IER )
*
* binary center of mass
*
      XCM = Q/(1.+Q)
*
* set initial particle position, velocity and time at the L1 point
*
      X(1) = XL1
      X(2) = 0.
      X(3) = 0.
      V(1) = -.01
      V(2) = 0.
      V(3) = 0.
*
* Convert first point
*
      DO I = 1, 3
        DX(I) = X(I)
        DV(I) = V(I)
        X1(I) = X(I)
        V1(I) = V(I)
      END DO
      DQ = Q
      CALL CONVV(DX,DV,DQ,METHOD,VUNIT,VSX,VSY,R1,RR1,XP1,YP1,D1)
      DSTEP  = 0.01
      NSTEP = 0
200   CONTINUE
*
* Integrate the equations of motion in the Roche potential
*
      CALL GSBS(DX,DV,DQ,DSTEP,GACC,DELTA)
*
* Convert to appropriate coordinates. Evaluate distance D
* from spot in velocity space.
*
      CALL CONVV(DX,DV,DQ,METHOD,VUNIT,VSX,VSY,R,RR,XP,YP,D)
      DT = DOT(DX,DV,DQ,METHOD,R,RR,VSX,VSY,XP,YP,D,AX,AY)
      NSTEP = NSTEP + 1
      IF(NSTEP.GT.50) THEN
        WRITE(*,*) 'NSTEP exceeded 50'
        GOTO 999
      END IF
      IF(GOOD) THEN
        CH = (AX*AXO+AY*AYO)/SQRT((AX*AX+AY*AY)*(AXO*AXO+AYO*AYO))
*
* See if we have stepped too far. If we have
* take the last step again but only half as far.
* Measured by change in direction of acceleration
* which must be less than 60 degrees.
*
        IF(CH.LE.5.D-1) THEN
          DSTEP = DELTA/2.
          DO I = 1, 3
            DX(I) = X1(I)
            DV(I) = V1(I)
          END DO
          GOTO 200
        END IF
      END IF
      DSTEP = MIN(3.D-1, DSTEP)
      AXO = AX
      AYO = AY
      IF(DT.GT.0. .AND. R.LT.0.98) THEN
        DOT1 = DT
        DO I = 1, 3
          X1(I) = DX(I)
          V1(I) = DV(I)
        END DO
        GOOD = .TRUE.
        GOTO 200
      ELSE IF(.NOT.GOOD) THEN
        GOTO 200
      ELSE IF(ABS(DT).LT.0.15) THEN
        GOTO 400
      END IF
*
* We now have two points which bracket the closest point.
* Iterate on the dot product of the acceleration and velocity
* difference vectors which goes through zero at the closest point.
* Store current point as point 2
*
      DOT2 = DT
      DO I = 1, 3
        X2(I) = DX(I)
        V2(I) = DV(I)
      END DO
*
* Interpolate to find fraction of time step needed to get closer to
* spot.
*
300   CONTINUE
      FRAC  = -DOT1/(DOT2-DOT1)
      DSTEP = FRAC*DELTA
*
* Restore old position, integrate by smaller timestep.
*
      DO I = 1, 3
        DX(I) = X1(I)
        DV(I) = V1(I)
      END DO
      DELOLD = DELTA
      CALL GSBS(DX,DV,DQ,DSTEP,GACC,DELTA)
      CALL CONVV(DX,DV,DQ,METHOD,VUNIT,VSX,VSY,R,RR,XP,YP,D)
      DT = DOT(DX,DV,DQ,METHOD,R,RR,VSX,VSY,XP,YP,D,AX,AY)
*
* Only trust DOT once have moved away from L1 point
* where acceleration vector is uncertain.
*
      IF(DT*DOT1 .GE. 0.) THEN
        DO I = 1, 3
          X1(I) = DX(I)
          V1(I) = DV(I)
        END DO
        DOT1 = DT
        DELTA = DELOLD - DELTA
      ELSE
        DOT2 = DT
      END IF
      IF(ABS(DT) .GT. 0.15) GOTO 300
*
* Compute minimum distance and define it so
* that if gas stream runs outside point, DMIN
* is +ve.
*
400   DMIN = SQRT(D)
      IF(DMIN .LT. DEL) GOTO 500
      ZCOM = AX*(VSY-YP)-AY*(VSX-XP)
      DMIN = SIGN(DMIN, ZCOM)
*
* Now select next value of Q
*
      IF(CAGED) THEN
        IF(DMIN.LT.0.) THEN
          QHI = Q
          DHI = DMIN
        ELSE
          QLO = Q
          DLO = DMIN
        END IF
        Q = (QLO+QHI)/2.
      ELSE
        IF(NCYC.EQ.1) THEN
          IF(DMIN.GE.0.) THEN
            QLO = Q
            DLO = DMIN
            Q = 2.*Q
          ELSE
            QHI = Q
            DHI = DMIN
            Q = Q/2.
          END IF
        ELSE
          IF(DMIN.GE.0. .AND. DMOL.GE.0.) THEN
            QLO = Q
            DLO = DMIN
            Q = 2.*Q
          ELSE IF(DMIN.LT.0. .AND. DMOL.LT.0.) THEN
            QHI = Q
            DHI = DMIN
            Q = Q/2.
          ELSE IF(DMIN.GE.0. .AND. DMOL.LT.0.) THEN
            CAGED = .TRUE.
            QLO = Q
            DLO = DMIN
            Q = (QLO+QHI)/2.
          ELSE IF(DMIN.LT.0. .AND. DMOL.GE.0.) THEN
            CAGED = .TRUE.
            QHI = Q
            DHI = DMIN
            Q = (QLO+QHI)/2.
          END IF
        END IF
        DMOL = DMIN
      END IF
      IF(NCYC.GT.50) THEN
        WRITE(*,*) 'NCYC exceeded 50'
        GOTO 999
      END IF
      GOTO 100
500   CONTINUE
      RD = R/XL1
      RETURN
999   Q  = - 1.
      RD = - 1.
      RETURN
      END

      SUBROUTINE CONVV(X,V,Q,METHOD,VUNIT,VSX,VSY,R,RR,XP,YP,D)
*
* Converts coordinates into required numbers for
* different methods
*
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 X(3), V(3), Q, R, RR, XP, YP, D
      REAL VUNIT, VSX, VSY
      INTEGER METHOD
*
      XCM = Q / ( 1. + Q )
      RR = X(1)*X(1) + X(2)*X(2)
      R = SQRT(RR)
*
* Evaluate position in velocity
*
      IF(METHOD.EQ.1) THEN
        XP = VUNIT * ( V(1) - X(2) )
        YP = VUNIT * ( V(2) + X(1) - XCM )
      ELSE IF(METHOD.EQ.2) THEN
        VKEP = VUNIT/SQRT((1.+Q)*R)
        XP = - VKEP*X(2)/R
        YP =   VKEP*X(1)/R - VUNIT*XCM
      ELSE IF(METHOD.EQ.3) THEN
        VRAD = V(1)*X(1)+V(2)*X(2)
        VX = V(1) - VRAD*X(1)/RR
        VY = V(2) - VRAD*X(2)/RR
        XP = VUNIT * ( VX - X(2) )
        YP = VUNIT * ( VY + X(1) - XCM )
      END IF
      D = (VSX-XP)**2 + (VSY-YP)**2
      RETURN
      END

      REAL*8 FUNCTION DOT(X,V,Q,METHOD,R,RR,VSX,VSY,XP,YP,D,AX,AY)
*
* Computes dot product. Crude but avoids repetition of code
*
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 X(3), V(3), A(3), Q
      REAL*8 R, RR, XP, YP, D, AX, AY
      REAL VSX, VSY
      INTEGER METHOD
*
      CALL ROCACC(X,V,Q,A)
      IF(METHOD.EQ.1) THEN
        AX = A(1) - V(2)
        AY = A(2) + V(1)
      ELSE IF(METHOD.EQ.2) THEN
        SR = R*SQRT(R)
        AX = (- V(2) + 3.*X(2)*(X(1)*V(1)+X(2)*V(2))/2./R**2)/SR
        AY = (  V(1) - 3.*X(1)*(X(1)*V(1)+X(2)*V(2))/2./R**2)/SR
      ELSE IF(METHOD.EQ.3) THEN
        VRAD = V(1)*X(1)+V(2)*X(2)
        ARAD = V(1)**2+V(2)**2+X(1)*A(1)+X(2)*A(2)
        AX = A(1) - (ARAD*X(1)+VRAD*(V(1)-VRAD*X(1)/RR))/RR - V(2)
        AY = A(2) - (ARAD*X(2)+VRAD*(V(2)-VRAD*X(2)/RR))/RR + V(1)
      END IF
      DOT = (AX*(VSX-XP)+AY*(VSY-YP))/SQRT(AX*AX+AY*AY)/SQRT(D)
      RETURN
      END
