        SUBROUTINE ROCHMAX(Q, YMAX, IFAIL)
C
C ROCHE LOBE OF SECONDARY STAR IN X,Y,Z COORDINATES
C WITH X ALONG AXIS BETWEEN STARS, Z ALONG ROTATION AXIS
C AND Y PERPENDICULAR TO BOTH.
C THIS SUBROUTINE WILL CALCULATE THE MAXIMUM Y FOR THE
C CRITICAL SURFACE
C
C REAL*8 Q -- MASS RATIO = M2/M1 = MR/MW
C REAL*8 YMAX RETURNED IN UNITS OF SEPARATION
C INTEGER*4 IFAIL = 0 ALL OK
C
        IMPLICIT REAL*8 (A-H,O-Z)
        REAL*8 Q
        REAL*8 A(6), D(5), POLY, YMAX
C
        NMAX = 200
        IFAIL = 1
        IF(Q.LT.0) RETURN
C
C CALCULATE POSITION OF THE INNER LAGRANGIAN POINT
C BY SOLVING A QUINTIC POLYNOMIAL
C SET POLYNOMIAL COEFFICIENTS
C
        A(1) = -1.
        A(2) =  2.
        A(3) = -1.
        A(4) =  1. + 3.*Q
        A(5) = - 2. - 3.*Q
        A(6) =  1. + Q
C SET DERIVATIVES.
        DO I = 2,6
          D(I-1) = REAL(I-1)*A(I)
        END DO
C
C NEWTON-RAPHSON LOOP
C
        N = 0
        GUESS = 1. / (1. + Q)
10      XL = GUESS - POLY(A,6,GUESS)/POLY(D,5,GUESS)
        N = N + 1
        IF(N.GT.NMAX) RETURN
C CALCULATE TO 1 PART IN 10**7
        IF(ABS((GUESS-XL)/XL) .GT. 1.D-7) THEN
          GUESS = XL
          GOTO 10
        END IF
C
C EVALUATE CRITICAL ROCHE POTENTIAL
C
        C1  = 1.D0/(1.D0 + Q)
        C2  =   Q /(1.D0 + Q)
        XCM = C2
        XM = XL - XCM
        CRIT = C1/XL + C2/(1.D0-XL) + XM*XM/2.D0
C
C NOW MUST SOLVE TWO SIMULTANEOUS EQUATIONS
C FIRST THE POINT MUST BE ON THE ROCHE LOBE
C SECOND THE DERIVATIVE OF THE ROCHE POTENTIAL
C WITH RESPECT TO X MUST BE ZERO. THE EQUATIONS
C ARE TO BE SOLVED IN X AND Y
C
C INITIAL GUESS
C
        X = 1.D0
        Y = 1.D0 - XL
        CMAX = 1.D-1*Y
        CMAG = 1.
        NIT = 0
        DO WHILE(NIT.LT.200 .AND. CMAG.GT.1.D-7)
C
C EVALUATE FUNCTIONS TO FIND ZERO OF AND THEIR DERIVATIVES
C
          YY  = Y*Y
          RS1 = X*X + YY
          R1  = SQRT(RS1)
          X2  = X - 1.D0
          RS2 = X2*X2 + YY
          R2  = SQRT(RS2)
          XM  = X - XCM
          S1 = C1/R1
          S2 = C2/R2
C ROCHE POTENTIAL - CRIT
          R   = S1 + S2 + (XM*XM + YY)/2.D0 - CRIT
C DERIVATIVE WRT X
          RX  = - S1*X/RS1 - S2*X2/RS2 + XM
C DERIVATIVE WRT Y
          RY  = (1.D0 - S1/RS1 - S2/RS2)*Y
C 2ND DERIVATIVE WRT X, X
          RXX = S1/RS1*(3.D0*X*X/RS1 - 1.D0) +
     &          S2/RS2*(3.D0*X2*X2/RS2 - 1.D0)  + 1.D0
C 2ND DERIVATIVE WRT X, Y
          RXY = 3.D0*Y*(S1*X/RS1/RS1 + S2*X2/RS2/RS2)
C - DETERMINANT OF NEWTON-RAPHSON MATRIX
          DET = RY*RXX - RX*RXY
C EVALUATE CHANGE IN X, Y. LIMIT STEP VECTOR MAGNITUDE
          IF(DET.EQ.0) RETURN
          CHX = (RXY*R - RY*RX)/DET
          CHY = (RX*RX - R*RXX)/DET
          CMAG = SQRT(CHX*CHX + CHY*CHY)
          IF(CMAG.GT.CMAX) THEN
            CHX = CMAX*CHX/CMAG
            CHY = CMAX*CHY/CMAG
          END IF
          X = X + CHX
          Y = Y + CHY
          NIT = NIT + 1
        END DO
        YMAX = Y
        IF(NIT.LT.200) IFAIL = 0
        RETURN
        END
