      REAL FUNCTION RADEFF(PHASE, Q, ANGLE)
*
* Program computes area of Roche lobe visible in terms
* of a**2 for any phase, mass ratio and inclination
* and then returns radius/a equivalent to this area.
*
* Written by T.R.Marsh for accuracy, not speed
* June 1989 @STSCI
*
      INTEGER MAXSTEP
      PARAMETER (MAXSTEP=400)
      REAL EARTH(3), X(3), X0(3)
      REAL XVEC(3), YVEC(3), RVEC(3)
      REAL*8 SUM, DQ, DX
      LOGICAL BLINK
*
      TWOPI = 8.*ATAN(1.)
      DQ = Q
      CALL INLAG(DQ, DX, IFAIL)
*
* Vector giving direction of Earth in binary coordinates
*
      PHI = TWOPI*PHASE
      COSP = COS(PHI)
      SINP = SIN(PHI)
      THETA = TWOPI*ANGLE/360.
      SINI = SIN(THETA)
      COSI = COS(THETA)
      EARTH(1) =  SINI*COSP
      EARTH(2) = -SINI*SINP
      EARTH(3) =  COSI
*
* Centre of red star projected `a' away from Earth
* Guaranteed to be eclipsed.
*
      X0(1) = 1. - EARTH(1)
      X0(2) =    - EARTH(2)
      X0(3) =    - EARTH(3)
*
* Compute orthogonal unit vectors also perpendicular to
* Earth vector. XVEC defined as cross product of Earth and
* Z vector.
*
      XVEC(1) = SINP
      XVEC(2) = COSP
      XVEC(3) = 0.
*
* YVEC is perpendicular to XVEC and EARTH
*
      YVEC(1) = - COSI*COSP
      YVEC(2) =   COSI*SINP
      YVEC(3) =   SINI
*
* Now compute area on sky by stepping in angle around
* centre, summing R**2/2 * Delta Theta
*
      SUM = 0.D0
      DO I = 1, MAXSTEP
        THETA1 = TWOPI*(I-1)/REAL(MAXSTEP)
        THETA2 = TWOPI*(I  )/REAL(MAXSTEP)
*
* Compute radius vector from centre
*
        IF(I.EQ.1) THEN
          XFAC = COS(THETA1)
          YFAC = SIN(THETA1)
          DO J = 1, 3
            RVEC(J) = XFAC*XVEC(J)+YFAC*YVEC(J)
          END DO
          R1 = 0.
          R2 = 1.
100       R3 = (R1+R2)/2.
          DO J = 1, 3
            X(J) = (X0(J) + R3*RVEC(J))/DX
          END DO
          IF(BLINK(X,EARTH,Q)) THEN
            R1 = R3
          ELSE
            R2 = R3
          END IF
          IF((R2-R1)/R3.GT.5.E-5) GOTO 100
          RADIUS1 = (R1+R2)/2.
        END IF
        XFAC = COS(THETA2)
        YFAC = SIN(THETA2)
        DO J = 1, 3
          RVEC(J) = XFAC*XVEC(J)+YFAC*YVEC(J)
        END DO
        R1 = 0.
        R2 = 1.
200     R3 = (R1+R2)/2.
        DO J = 1, 3
          X(J) = (X0(J) + R3*RVEC(J))/DX
        END DO
        IF(BLINK(X,EARTH,Q)) THEN
          R1 = R3
        ELSE
          R2 = R3
        END IF
        IF((R2-R1)/R3.GT.5.E-5) GOTO 200
        RADIUS2 = (R1+R2)/2.
        SUM = SUM + (RADIUS1+RADIUS2)**2
        RADIUS1 = RADIUS2
      END DO
      TOTAL = SUM*TWOPI/REAL(MAXSTEP)/8.
      RADEFF = SQRT(2.*TOTAL/TWOPI)
      RETURN
      END
