      SUBROUTINE PLOTLOBE(Q,XPLOT,YPLOT,NSTEP)
C
C  PLOTS THE ROCHE LOBES FOR A BINARY OF MASS RATIO Q
C  XPLOT, YPLOT PLOT ARRAYS NSTEP ELEMENTS
      REAL*4 XPLOT(NSTEP),YPLOT(NSTEP)
C
C  COMPUTE LOCATION OF INNER LAGRANGE POINT AND ENDS OF ROCHE LOBES
C
      PI=ATAN2(1.,1.)*4.
      CALL LAG1(Q,CCRIT,XL1,IER)
      BACK1=-XL1
      CALL XEND(Q,CCRIT,BACK1)
      BACK2=2.-XL1
      CALL XEND(Q,CCRIT,BACK2)
C
      DX=(BACK2-BACK1)/(XL1*(NSTEP-1.))
      XPLOT(1)=BACK1/XL1
      YPLOT(1)=0.
      DO 100 I=2,NSTEP-1
        XPLOT(I)=XPLOT(I-1)+DX
        YPLOT(I)=RHO(CCRIT,Q,XPLOT(I)*XL1,PI/2.)/XL1
        IF(XPLOT(I).LE.1.) NBACK=I
  100 END DO
      XPLOT(NSTEP)=BACK2/XL1
      YPLOT(NSTEP)=0.
      CALL PGLINE(NSTEP,XPLOT,YPLOT)    ! TOP HALF OF ROCHE LOBES
      DO 200 I=1,NSTEP
  200 YPLOT(I)=-YPLOT(I)
      CALL PGLINE(NSTEP,XPLOT,YPLOT)    ! BOTTOM HALF OF ROCHE LOBES
C
      CALL PGSCI(2)
      DO 300 I=NBACK+1,NSTEP
        XPLOT(1)=XPLOT(I)
        YPLOT(1)=YPLOT(I)
        XPLOT(2)=XPLOT(I)
        YPLOT(2)=-YPLOT(I)
C       CALL PGLINE(2,XPLOT,YPLOT)      ! PATTERN THROUGH RED STAR
  300 END DO
C
      CALL PGSCI(1)
      CALL PGPOINT(1,0.,0.,'+')         ! WHITE DWARF
      CALL PGPOINT(1,1.,0.,'+')         ! RED STAR
      CALL PGPOINT(1,1./XL1,0.,'+')     ! INNER LAGRANGIAN POINT
      RETURN
      END
