        SUBROUTINE INEG(INCLIN, Q, X, ACC, PHIN, PHEG, IFAIL)
*
* Inputs: INCLIN -- Inclination angle R*4
*         Q      -- R*4 Mass ratio
*         X(3)   -- R*4 Coordinates of point in L1 coords.
*         ACC    -- Accuracy in phase required
*
* Outputs:
*          PHIN  -- Ingress phase of point
*          PHEG  -- Egress phase of point
*          IFAIL -- Not equal to 0, error.
*
        REAL ACC, PHIN, PHEG, X(3), EARTH(3), Q, INCLIN
        REAL*8 DX
        INTEGER*4 IFAIL
        LOGICAL BLINK
*
        IFAIL = 0
        IF(QOLD.NE.Q) THEN
          QOLD = Q
          CALL INLAG(DBLE(Q), DX, IFAIL)
          IF(IFAIL.NE.0) RETURN
        END IF
*
* Approx eclipse centre
*
        CENTRE   = ATAND(X(2)/(1./DX-X(1)))
        EARTH(3) = COSD(INCLIN)
        SINI     = SIND(INCLIN)
*
* Is point eclipsed ?
*
        I = - 3
        DO I = -3, 3
          ANGLE = CENTRE + 2.*REAL(I)
          EARTH(1) =   SINI*COSD(ANGLE)
          EARTH(2) = - SINI*SIND(ANGLE)
          IF(BLINK(X,EARTH,Q)) GOTO 100
        END DO
        IFAIL = 1
        RETURN
100     CENTRE = ANGLE
*
* Search for phase of ingress
* Binary chop: Lower limit = - 90, Upper limit = CENTRE
*
        ANG1 = - 90.
        ANG2 = CENTRE
        NBIN = INT(LOG((ANG2-ANG1)/ACC/360.)/LOG(2.)) + 1
        DO I = 1, NBIN
          ANG3 = (ANG1+ANG2)/2.
          EARTH(1) =   SINI*COSD(ANG3)
          EARTH(2) = - SINI*SIND(ANG3)
          IF(BLINK(X,EARTH,Q)) THEN
            ANG2 = ANG3
          ELSE
            ANG1 = ANG3
          END IF
        END DO
        PHIN = (ANG1+ANG2)/720.
*
* Search for egress phase
* Binary chop: Lower limit = CENTRE, Upper limit = + 90
*
        ANG1 = CENTRE
        ANG2 = 90.
        NBIN = INT(LOG((ANG2-ANG1)/ACC/360.)/LOG(2.)) + 1
        DO I = 1, NBIN
          ANG3 = (ANG1+ANG2)/2.
          EARTH(1) =   SINI*COSD(ANG3)
          EARTH(2) = - SINI*SIND(ANG3)
          IF(BLINK(X,EARTH,Q)) THEN
            ANG1 = ANG3
          ELSE
            ANG2 = ANG3
          END IF
        END DO
        PHEG = (ANG1+ANG2)/720.
        RETURN
        END
