      SUBROUTINE GSNEWBS(X,V,Q,SPIN,ALPHA,BETA,THETA,STEP,ACC,DELTA)
*
* Burlisch-Stoer step with monitoring of local truncation error to
* ensure accuracy and adjust step size.
*
* Computes gas stream in circular orbit binary with additional fling
* off acceleration from rotating magnetic white dwarf assuming that 
* the white dwarf has a dipole filed in the plane of the binary
*
* X(3), V(3) are the position and velocity, updated on exit.
* Q is the mass ratio
* SPIN is the ratio of beat to orbital frequencies
* ALPHA is adjustable parameter measuring strength of spin up force.
* BETA is the angle (degrees) of the pole measured from the axis. 
*      0 = at the poles, 90 = at the equator.
* THETA is the angle of the white dwarf (0-2pi) relative to the red star
* STEP is the step size to attempt, on exit is the suggested next step
* ACC is the accuracy in position wanted
* DELTA is the actual one carried out.
*
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (IMAX=11,SHRINK=0.95,NUSE=7,GROW=1.2)
      REAL*8 X(3), V(3), Y(6), YERR(6), Q, STEP, ACC
      REAL*8 YS(6),  YSEQ(6), DELTA, SPIN, ALPHA, BETA, THETA
      INTEGER NSEQ(IMAX)
      DATA NSEQ/2,4,6,8,12,16,24,32,48,64,96/
*
      H = STEP
      DO I = 1, 3
        YS(I)   = X(I)
        YS(I+3) = V(I)
      END DO
*
1     CONTINUE
      DO I = 1, IMAX
        CALL GSNEWMID(YS,H,NSEQ(I),YSEQ,Q,SPIN,ALPHA,BETA,THETA)
        TEST = (H/NSEQ(I))**2
        CALL GSEXTR(I,TEST,YSEQ,Y,YERR,NUSE)
        ERRMAX = 0.
        DO J = 1, 6
          IF(J.LE.3) THEN
            ERRMAX = MAX(ERRMAX, ABS(YERR(J)))
          ELSE
            ERRMAX = MAX(ERRMAX, H*ABS(YERR(J)))
          END IF
        END DO
        IF(ERRMAX.LT.ACC) THEN
          DELTA = H
          SK = STEP
          IF(I.EQ.NUSE) THEN
            STEP = H*SHRINK
          ELSE IF(I.EQ.NUSE-1) THEN
            STEP = H*GROW
          ELSE
            STEP = (H*NSEQ(NUSE-1))/NSEQ(I)
          END IF
          DO J = 1, 3
            X(J) = Y(J)
            V(J) = Y(J+3)
          END DO
          RETURN
        END IF
      END DO
      H = 0.25*H/2**((IMAX-NUSE)/2)
      WRITE(*,*) 'Possible step size error in GSNEWBS'
      GOTO 1
      END

      SUBROUTINE GSNEWMID(Y,TSTEP,NSTEP,YOUT,Q,SPIN,ALPHA,BETA,THETA)
*
* Modified mid-point method. Advances particle
* from Y to YOUT, with a step of length
* TSTEP divided into NSTEP bits.
* YOUT contains positions and velocities
*
      IMPLICIT NONE
      INTEGER I, NSTEP, N
      DOUBLE PRECISION TSTEP, Q, SPIN, ALPHA, BETA, THETA
      DOUBLE PRECISION Y(6), YOUT(6), YS(6), YN(6), A(6)
      DOUBLE PRECISION H, H2, SWAP
*
      H = TSTEP/DBLE(NSTEP)
      DO I = 1, 3
        A(I) = Y(I+3)
      END DO
      CALL ROCNEWACC(Y,Y(4),Q,SPIN,ALPHA,BETA,THETA,A(4))
      DO I = 1, 6
        YS(I) = Y(I)
        YN(I) = Y(I) + H*A(I)
      END DO
      DO I = 1, 3
        A(I) = YN(I+3)
      END DO
      CALL ROCNEWACC(YN,YN(4),Q,SPIN,ALPHA,BETA,THETA,A(4))
      H2 = 2.*H
      DO N = 2, NSTEP
        DO I = 1, 6
          SWAP = YS(I) + H2*A(I)
          YS(I) = YN(I)
          YN(I) = SWAP
        END DO
        DO I = 1, 3
          A(I) = YN(I+3)
        END DO
        CALL ROCNEWACC(YN,YN(4),Q,SPIN,ALPHA,BETA,THETA,A(4))
      END DO
      DO I = 1, 6
        YOUT(I) = 0.5*(YS(I)+YN(I)+H*A(I))
      END DO
      RETURN
      END

      SUBROUTINE ROCNEWACC(X,V,Q,SPIN,ALPHA,BETA,THETA,A)
*
* Computes acceleration in rotating coordinates in Roche potential
*
* REAL*8 X(3) -- Coordinates (units of a)
* REAL*8 V(3) -- Velocity (units of 2*PI*a/P)
* REAL*8 Q    -- Mass ratio M2/M1
* REAL*8 SPIN -- Ratio of beat/orbital frequencies.
* REAL*8 ALPHA-- Acceleration strength parameter to add in magnetic
*                force in an adjustable manner
* REAL*8 BETA   -- Angle of magnetic axis relative to spin axis
* REAL*8 THETA  -- angle of white dwarf relative to red star.
* REAL*8 A(3) -- Acceleration (units (2*PI/P)**2*A)
*
      IMPLICIT NONE
      DOUBLE PRECISION X(3), V(3), Q, A(3), SPIN, ALPHA, F1, F2
      DOUBLE PRECISION YZSQ, R1SQ, R2SQ, FM1, FM2, FM3, THETA
      DOUBLE PRECISION BX, BY, BZ, COST, SINT, COSB, SINB, VDOTB
      DOUBLE PRECISION PDOTR, MX, MY, MZ, R2, R6, VX, VY, VZ, B2, BETA
      DOUBLE PRECISION BETAOLD, PROP, PX, PY, PZ, TWOPI
      DATA BETAOLD, TWOPI/-1.03E10, 0./
*
      IF(TWOPI .LT. 1) TWOPI = 8.D0*ATAN(1.D0)
      IF(BETA.NE.BETAOLD) THEN
         BETAOLD = BETA
         SINB  = SIN(TWOPI*BETA/360.)
         COSB  = COS(TWOPI*BETA/360.)
      END IF
*
      F1 = 1.D0/(1.D0+Q)
      F2 = F1*Q
*
* Normal Roche part
*
      YZSQ = X(2)**2 + X(3)**2
      R1SQ = X(1)**2 + YZSQ
      R2SQ = (X(1)-1.D0)**2 + YZSQ
      FM1 = F1/(R1SQ*SQRT(R1SQ))
      FM2 = F2/(R2SQ*SQRT(R2SQ))
      FM3 = FM1+FM2
*
* Magnetic part
*
* PX,PY,PZ is the magnetic axis vector in standard coords
* BX,BY,BZ is the magnetic field at the point in question (multiplied by
*          a factor of R**3 because only the direction is needed.)
*
      R2    = X(1)**2 + X(2)**2 + X(3)**2
      R6    = R2**3
      COST  = COS(THETA)
      SINT  = SIN(THETA)
      PX    = SINB*COST
      PY    = SINB*SINT
      PZ    = COSB
      PDOTR = PX*X(1)+PY*X(2)+PZ*X(3)
      BX = PX - 3.D0*PDOTR*X(1)/R2
      BY = PY - 3.D0*PDOTR*X(2)/R2
      BZ = PZ - 3.D0*PDOTR*X(3)/R2
      B2 = BX*BX + BY*BY + BZ*BZ
      VX   = V(1) + SPIN*X(2)
      VY   = V(2) - SPIN*X(1)
      VZ   = V(3)
*
* The force is proportional to V - (V.B)B where B is a unit vector in
* the direction of the field. The normalisation to unit vector is accomplished
* here by dividing by the modulus of B**2.
*
* The proportionality constant is scaled with the strength of the field**2
* (the R**6 factor comes in because we divided out R**3 earlier)
*
      VDOTB = (VX*BX+VY*BY+VZ*BZ)/B2
*
      PROP = -ALPHA*B2/R6
      MX   = PROP*(VX-VDOTB*BX)
      MY   = PROP*(VY-VDOTB*BY)
      MZ   = PROP*(VZ-VDOTB*BZ)
*
      A(1) = - FM3*X(1) + FM2 + 2.*V(2) + (X(1) - F2) + MX
      A(2) = - FM3*X(2)       - 2.*V(1) + X(2)        + MY
      A(3) = - FM3*X(3)                               + MZ
      RETURN
      END


