      SUBROUTINE FINDQ(Q,DEG,DELTA)
*
*  A subroutine to determine the mass ratio Q
*  of a binary system having the required
*  eclipse phase width DELTA at the inclination DEG.
*
*   Q = M2/M1 IS THE MASS RATIO OF THE BINARY SYSTEM.
*   DEG       IS THE INCLINATION IN DEGREES.
*   DELTA     IS THE ECLIPSE PHASE WIDTH.
*
*  COPYRIGHT OCT 1982 BY KEITH HORNE.
*  Modified by TRM @STSCI to use a more efficient method
*
      REAL X(3), EARTH(3)
      LOGICAL BLINK
      DATA NLOOP/12/
      PI=4.*ATAN2(1.,1.)
*
*  Use spherical body approximation and Paczynski formula
*  to guess mass ratio
*
      ANGLE=DEG*PI/180.
      PHASE = PI*DELTA
      SINI=SIN(ANGLE)
      COSI=COS(ANGLE)
      SINP=SIN(PHASE)
      AA=SINP*SINP
      THETA=SQRT((1.-AA)*COSI*COSI+AA)
      Q=10.**((THETA-.38)*5.)
      IF(Q.LT.0.5) THEN
        Q = THETA/.462
        Q = Q*Q*Q
        Q = Q/(1.-Q)
      END IF
*
* Select two values of Q to bracket range
* Q1 selected so that WD not eclipsed
* Q2 selected so that WD is eclipsed
*
      EARTH(1) =  SINI*COS(PHASE)
      EARTH(2) = -SINI*SINP
      EARTH(3) =  COSI
      X(1) = 0.
      X(2) = 0.
      X(3) = 0.
      Q1 = Q
      Q2 = Q
10    Q1 = 0.8*Q
      IF(BLINK(X,EARTH,Q1)) GOTO 10
20    Q2 = 1.2*Q
      IF(.NOT.BLINK(X,EARTH,Q2)) GOTO 20
*
* Refinement loop
*
      DO I = 1, NLOOP
        Q = (Q1+Q2)/2.
        IF(BLINK(X,EARTH,Q)) THEN
          Q2 = Q
        ELSE
          Q1 = Q
        END IF
      END DO
      Q = (Q1+Q2)/2.
      RETURN
      END
