      SUBROUTINE FINDDEG(Q,DEG,DELTA)
*
*  A subroutine to determine the inclination (in degrees)
*  of a binary system having the required mass ratio Q
*  and eclipse phase width DELTA
*
*   Q = M2/M1 IS THE MASS RATIO OF THE BINARY SYSTEM.
*   DEG       IS THE INCLINATION IN DEGREES.
*   DELTA     IS THE ECLIPSE PHASE WIDTH.
*
*  RETURNS DEG=-90. IF DESIRED ECLIPSE WIDTH CANNOT OCCUR.
*
*  Copyright Oct 1982 by Keith Horne.
*  Modified by TRM @ STSCI to speed up.
*
      REAL X(3), EARTH(3)
      LOGICAL BLINK
      DATA NLOOP/13/
*
      PI=4.*ATAN2(1.,1.)
*
*  Check to ensure that eclipse of desired width can occur.
*  First set phase to be just at end of white dwarf eclipse
*
      PI = 4.*ATAN(1.)
      PHASE = PI*DELTA
      COSP = COS(PHASE)
      SINP = SIN(PHASE)
      IF(Q.LE.0.) THEN
        WRITE(*,*) CHAR(7),'Invalid Q in FINDDEG'
        DEG = -90
        RETURN
      END IF
*
* White dwarf is at origin
*
      X(1) = 0.
      X(2) = 0.
      X(3) = 0.
*
* If not eclipsed for 90 inclination
* return
*
      EARTH(1) =  COSP
      EARTH(2) = -SINP
      EARTH(3) = 0.
      IF(.NOT. BLINK(X,EARTH,Q)) THEN
        DEG=-90.
        RETURN
      END IF
*
* Choose two angles (54 and 90 degrees) which bracket the range
* Then execute binary chop NLOOP times.
* Final accuracy = 36./2**NLOOP
* = 0.005 deg at worst. On average 1/2 of this.
*
      ANGLE1 = 0.3*PI
      ANGLE2 = 0.5*PI
      DO I = 1, NLOOP
        ANGLE = (ANGLE1+ANGLE2)/2.
        SINI = SIN(ANGLE)
        EARTH(1) =  COSP*SINI
        EARTH(2) = -SINP*SINI
        EARTH(3) =  COS(ANGLE)
        IF(BLINK(X,EARTH,Q)) THEN
          ANGLE2 = ANGLE
        ELSE
          ANGLE1 = ANGLE
        END IF
      END DO
      DEG = 90.*(ANGLE1+ANGLE2)/PI
      RETURN
      END
